/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.AWTCanvasImplementation;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.DrawableGLES;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.WindowsDisplayPeerInfo;
import org.lwjgl.opengl.WindowsFileVersion;
import org.lwjgl.opengl.WindowsKeyboard;
import org.lwjgl.opengl.WindowsMouse;
import org.lwjgl.opengl.WindowsPbufferPeerInfo;
import org.lwjgl.opengl.WindowsPeerInfo;
import org.lwjgl.opengl.WindowsRegistry;

public final class WindowsDisplay
implements DisplayImplementation {
    private static final int GAMMA_LENGTH = 256;
    private static final int WM_WINDOWPOSCHANGED = 71;
    private static final int WM_MOVE = 3;
    private static final int WM_CANCELMODE = 31;
    private static final int WM_MOUSEMOVE = 512;
    private static final int WM_LBUTTONDOWN = 513;
    private static final int WM_LBUTTONUP = 514;
    private static final int WM_LBUTTONDBLCLK = 515;
    private static final int WM_RBUTTONDOWN = 516;
    private static final int WM_RBUTTONUP = 517;
    private static final int WM_RBUTTONDBLCLK = 518;
    private static final int WM_MBUTTONDOWN = 519;
    private static final int WM_MBUTTONUP = 520;
    private static final int WM_MBUTTONDBLCLK = 521;
    private static final int WM_XBUTTONDOWN = 523;
    private static final int WM_XBUTTONUP = 524;
    private static final int WM_XBUTTONDBLCLK = 525;
    private static final int WM_MOUSEWHEEL = 522;
    private static final int WM_CAPTURECHANGED = 533;
    private static final int WM_MOUSELEAVE = 675;
    private static final int WM_ENTERSIZEMOVE = 561;
    private static final int WM_EXITSIZEMOVE = 562;
    private static final int WM_SIZING = 532;
    private static final int WM_KEYDOWN = 256;
    private static final int WM_KEYUP = 257;
    private static final int WM_SYSKEYUP = 261;
    private static final int WM_SYSKEYDOWN = 260;
    private static final int WM_SYSCHAR = 262;
    private static final int WM_CHAR = 258;
    private static final int WM_GETICON = 127;
    private static final int WM_SETICON = 128;
    private static final int WM_SETCURSOR = 32;
    private static final int WM_MOUSEACTIVATE = 33;
    private static final int WM_QUIT = 18;
    private static final int WM_SYSCOMMAND = 274;
    private static final int WM_PAINT = 15;
    private static final int WM_KILLFOCUS = 8;
    private static final int WM_SETFOCUS = 7;
    private static final int SC_SIZE = 61440;
    private static final int SC_MOVE = 61456;
    private static final int SC_MINIMIZE = 61472;
    private static final int SC_MAXIMIZE = 61488;
    private static final int SC_NEXTWINDOW = 61504;
    private static final int SC_PREVWINDOW = 61520;
    private static final int SC_CLOSE = 61536;
    private static final int SC_VSCROLL = 61552;
    private static final int SC_HSCROLL = 61568;
    private static final int SC_MOUSEMENU = 61584;
    private static final int SC_KEYMENU = 61696;
    private static final int SC_ARRANGE = 61712;
    private static final int SC_RESTORE = 61728;
    private static final int SC_TASKLIST = 61744;
    private static final int SC_SCREENSAVE = 61760;
    private static final int SC_HOTKEY = 61776;
    private static final int SC_DEFAULT = 61792;
    private static final int SC_MONITORPOWER = 61808;
    private static final int SC_CONTEXTHELP = 61824;
    private static final int SC_SEPARATOR = 61455;
    static final int SM_CXCURSOR = 13;
    static final int SM_CYCURSOR = 14;
    static final int SM_CMOUSEBUTTONS = 43;
    static final int SM_MOUSEWHEELPRESENT = 75;
    private static final int SIZE_RESTORED = 0;
    private static final int SIZE_MINIMIZED = 1;
    private static final int SIZE_MAXIMIZED = 2;
    private static final int WM_SIZE = 5;
    private static final int WM_ACTIVATE = 6;
    private static final int WA_INACTIVE = 0;
    private static final int WA_ACTIVE = 1;
    private static final int WA_CLICKACTIVE = 2;
    private static final int SW_NORMAL = 1;
    private static final int SW_SHOWMINNOACTIVE = 7;
    private static final int SW_SHOWDEFAULT = 10;
    private static final int SW_RESTORE = 9;
    private static final int SW_MAXIMIZE = 3;
    private static final int ICON_SMALL = 0;
    private static final int ICON_BIG = 1;
    private static final IntBuffer rect_buffer = BufferUtils.createIntBuffer(4);
    private static final Rect rect = new Rect();
    private static final long HWND_TOP = 0L;
    private static final long HWND_BOTTOM = 1L;
    private static final long HWND_TOPMOST = -1L;
    private static final long HWND_NOTOPMOST = -2L;
    private static final int SWP_NOSIZE = 1;
    private static final int SWP_NOMOVE = 2;
    private static final int SWP_NOZORDER = 4;
    private static final int SWP_FRAMECHANGED = 32;
    private static final int GWL_STYLE = -16;
    private static final int GWL_EXSTYLE = -20;
    private static final int WS_THICKFRAME = 262144;
    private static final int WS_MAXIMIZEBOX = 65536;
    private static final int HTCLIENT = 1;
    private static final int MK_XBUTTON1 = 32;
    private static final int MK_XBUTTON2 = 64;
    private static final int XBUTTON1 = 1;
    private static final int XBUTTON2 = 2;
    private static WindowsDisplay current_display;
    private static boolean cursor_clipped;
    private WindowsDisplayPeerInfo peer_info;
    private Object current_cursor;
    private static boolean hasParent;
    private Canvas parent;
    private long parent_hwnd;
    private FocusAdapter parent_focus_tracker;
    private AtomicBoolean parent_focused;
    private WindowsKeyboard keyboard;
    private WindowsMouse mouse;
    private boolean close_requested;
    private boolean is_dirty;
    private ByteBuffer current_gamma;
    private ByteBuffer saved_gamma;
    private DisplayMode current_mode;
    private boolean mode_set;
    private boolean isMinimized;
    private boolean isFocused;
    private boolean redoMakeContextCurrent;
    private boolean inAppActivate;
    private boolean resized;
    private boolean resizable;
    private int x;
    private int y;
    private int width;
    private int height;
    private long hwnd;
    private long hdc;
    private long small_icon;
    private long large_icon;
    private boolean iconsLoaded;
    private int captureMouse = -1;
    private boolean mouseInside;

    WindowsDisplay() {
        current_display = this;
    }

    public void createWindow(DrawableLWJGL drawableLWJGL, DisplayMode displayMode, Canvas canvas, int n2, int n3) {
        this.parent = canvas;
        hasParent = canvas != null;
        this.parent_hwnd = canvas != null ? WindowsDisplay.getHwnd(canvas) : 0L;
        this.hwnd = WindowsDisplay.nCreateWindow(n2, n3, displayMode.getWidth(), displayMode.getHeight(), Display.isFullscreen() || WindowsDisplay.isUndecorated(), canvas != null, this.parent_hwnd);
        if (Display.isResizable() && canvas == null) {
            this.setResizable(true);
        }
        if (this.hwnd == 0L) {
            throw new LWJGLException("Failed to create window");
        }
        this.hdc = WindowsDisplay.getDC(this.hwnd);
        if (this.hdc == 0L) {
            WindowsDisplay.nDestroyWindow(this.hwnd);
            throw new LWJGLException("Failed to get dc");
        }
        try {
            if (drawableLWJGL instanceof DrawableGL) {
                int n4 = WindowsPeerInfo.choosePixelFormat(this.getHdc(), 0, 0, (PixelFormat)drawableLWJGL.getPixelFormat(), null, true, true, false, true);
                WindowsPeerInfo.setPixelFormat(this.getHdc(), n4);
            } else {
                this.peer_info = new WindowsDisplayPeerInfo(true);
                ((DrawableGLES)drawableLWJGL).initialize(this.hwnd, this.hdc, 4, (org.lwjgl.opengles.PixelFormat)drawableLWJGL.getPixelFormat());
            }
            this.peer_info.initDC(this.getHwnd(), this.getHdc());
            WindowsDisplay.showWindow(this.getHwnd(), 10);
            this.updateWidthAndHeight();
            if (canvas == null) {
                WindowsDisplay.setForegroundWindow(this.getHwnd());
            } else {
                this.parent_focused = new AtomicBoolean(false);
                this.parent_focus_tracker = new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        WindowsDisplay.this.parent_focused.set(true);
                        WindowsDisplay.this.clearAWTFocus();
                    }
                };
                canvas.addFocusListener(this.parent_focus_tracker);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WindowsDisplay.this.clearAWTFocus();
                    }
                });
            }
            this.grabFocus();
        }
        catch (LWJGLException lWJGLException) {
            WindowsDisplay.nReleaseDC(this.hwnd, this.hdc);
            WindowsDisplay.nDestroyWindow(this.hwnd);
            throw lWJGLException;
        }
    }

    private void updateWidthAndHeight() {
        WindowsDisplay.getClientRect(this.hwnd, rect_buffer);
        rect.copyFromBuffer(rect_buffer);
        this.width = WindowsDisplay.rect.right - WindowsDisplay.rect.left;
        this.height = WindowsDisplay.rect.bottom - WindowsDisplay.rect.top;
    }

    private static native long nCreateWindow(int var0, int var1, int var2, int var3, boolean var4, boolean var5, long var6);

    private static boolean isUndecorated() {
        return Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getHwnd(Canvas canvas) {
        AWTCanvasImplementation aWTCanvasImplementation = AWTGLCanvas.createImplementation();
        WindowsPeerInfo windowsPeerInfo = (WindowsPeerInfo)aWTCanvasImplementation.createPeerInfo(canvas, null, null);
        ByteBuffer byteBuffer = windowsPeerInfo.lockAndGetHandle();
        try {
            long l2 = windowsPeerInfo.getHwnd();
            return l2;
        }
        finally {
            windowsPeerInfo.unlock();
        }
    }

    public void destroyWindow() {
        if (this.parent != null) {
            this.parent.removeFocusListener(this.parent_focus_tracker);
            this.parent_focus_tracker = null;
        }
        WindowsDisplay.nReleaseDC(this.hwnd, this.hdc);
        WindowsDisplay.nDestroyWindow(this.hwnd);
        this.freeLargeIcon();
        this.freeSmallIcon();
        WindowsDisplay.resetCursorClipping();
        this.close_requested = false;
        this.is_dirty = false;
        this.isMinimized = false;
        this.isFocused = false;
        this.redoMakeContextCurrent = false;
        this.mouseInside = false;
    }

    private static native void nReleaseDC(long var0, long var2);

    private static native void nDestroyWindow(long var0);

    static void resetCursorClipping() {
        if (cursor_clipped) {
            try {
                WindowsDisplay.clipCursor(null);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to reset cursor clipping: " + lWJGLException);
            }
            cursor_clipped = false;
        }
    }

    private static void getGlobalClientRect(long l2, Rect rect) {
        rect_buffer.put(0, 0).put(1, 0);
        WindowsDisplay.clientToScreen(l2, rect_buffer);
        int n2 = rect_buffer.get(0);
        int n3 = rect_buffer.get(1);
        WindowsDisplay.getClientRect(l2, rect_buffer);
        rect.copyFromBuffer(rect_buffer);
        rect.offset(n2, n3);
    }

    static void setupCursorClipping(long l2) {
        cursor_clipped = true;
        WindowsDisplay.getGlobalClientRect(l2, rect);
        rect.copyToBuffer(rect_buffer);
        WindowsDisplay.clipCursor(rect_buffer);
    }

    private static native void clipCursor(IntBuffer var0);

    public void switchDisplayMode(DisplayMode displayMode) {
        WindowsDisplay.nSwitchDisplayMode(displayMode);
        this.current_mode = displayMode;
        this.mode_set = true;
    }

    private static native void nSwitchDisplayMode(DisplayMode var0);

    private void appActivate(boolean bl2, long l2) {
        if (this.inAppActivate) {
            return;
        }
        this.inAppActivate = true;
        this.isFocused = bl2;
        if (bl2) {
            if (Display.isFullscreen()) {
                this.restoreDisplayMode();
            }
            if (this.parent == null) {
                WindowsDisplay.setForegroundWindow(this.getHwnd());
            }
            WindowsDisplay.setFocus(this.getHwnd());
            this.redoMakeContextCurrent = true;
            if (Display.isFullscreen()) {
                this.updateClipping();
            }
        } else {
            if (this.keyboard != null) {
                this.keyboard.releaseAll(l2);
            }
            if (Display.isFullscreen()) {
                WindowsDisplay.showWindow(this.getHwnd(), 7);
                this.resetDisplayMode();
            } else {
                this.updateClipping();
            }
        }
        this.updateCursor();
        this.inAppActivate = false;
    }

    private static native void showWindow(long var0, int var2);

    private static native void setForegroundWindow(long var0);

    private static native void setFocus(long var0);

    private void clearAWTFocus() {
        this.parent.setFocusable(false);
        this.parent.setFocusable(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
    }

    private void grabFocus() {
        if (this.parent == null) {
            WindowsDisplay.setFocus(this.getHwnd());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowsDisplay.this.parent.requestFocus();
                }
            });
        }
    }

    private void restoreDisplayMode() {
        try {
            this.doSetGammaRamp(this.current_gamma);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to restore gamma: " + lWJGLException.getMessage());
        }
        if (!this.mode_set) {
            this.mode_set = true;
            try {
                WindowsDisplay.nSwitchDisplayMode(this.current_mode);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore display mode: " + lWJGLException.getMessage());
            }
        }
    }

    public void resetDisplayMode() {
        try {
            this.doSetGammaRamp(this.saved_gamma);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to reset gamma ramp: " + lWJGLException.getMessage());
        }
        this.current_gamma = this.saved_gamma;
        if (this.mode_set) {
            this.mode_set = false;
            WindowsDisplay.nResetDisplayMode();
        }
        WindowsDisplay.resetCursorClipping();
    }

    private static native void nResetDisplayMode();

    public int getGammaRampLength() {
        return 256;
    }

    public void setGammaRamp(FloatBuffer floatBuffer) {
        this.doSetGammaRamp(WindowsDisplay.convertToNativeRamp(floatBuffer));
    }

    private static native ByteBuffer convertToNativeRamp(FloatBuffer var0);

    private static native ByteBuffer getCurrentGammaRamp();

    private void doSetGammaRamp(ByteBuffer byteBuffer) {
        WindowsDisplay.nSetGammaRamp(byteBuffer);
        this.current_gamma = byteBuffer;
    }

    private static native void nSetGammaRamp(ByteBuffer var0);

    public String getAdapter() {
        try {
            String string = WindowsRegistry.queryRegistrationKey(3, "HARDWARE\\DeviceMap\\Video", "MaxObjectNumber");
            int n2 = string.charAt(0);
            String string2 = "";
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = WindowsRegistry.queryRegistrationKey(3, "HARDWARE\\DeviceMap\\Video", "\\Device\\Video" + i2);
                String string4 = "\\registry\\machine\\";
                if (!string3.toLowerCase().startsWith(string4)) continue;
                String string5 = WindowsRegistry.queryRegistrationKey(3, string3.substring(string4.length()), "InstalledDisplayDrivers");
                if (string5.toUpperCase().startsWith("VGA")) {
                    string2 = string5;
                    continue;
                }
                if (string5.toUpperCase().startsWith("RDP") || string5.toUpperCase().startsWith("NMNDD")) continue;
                return string5;
            }
            if (!string2.equals("")) {
                return string2;
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while querying registry: " + lWJGLException);
        }
        return null;
    }

    public String getVersion() {
        WindowsFileVersion windowsFileVersion;
        String[] stringArray;
        String string = this.getAdapter();
        if (string != null && (stringArray = string.split(",")).length > 0 && (windowsFileVersion = this.nGetVersion(stringArray[0] + ".dll")) != null) {
            return windowsFileVersion.toString();
        }
        return null;
    }

    private native WindowsFileVersion nGetVersion(String var1);

    public DisplayMode init() {
        this.current_gamma = this.saved_gamma = WindowsDisplay.getCurrentGammaRamp();
        this.current_mode = WindowsDisplay.getCurrentDisplayMode();
        return this.current_mode;
    }

    private static native DisplayMode getCurrentDisplayMode();

    public void setTitle(String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeUTF16(string);
        WindowsDisplay.nSetTitle(this.hwnd, MemoryUtil.getAddress0(byteBuffer));
    }

    private static native void nSetTitle(long var0, long var2);

    public boolean isCloseRequested() {
        boolean bl2 = this.close_requested;
        this.close_requested = false;
        return bl2;
    }

    public boolean isVisible() {
        return !this.isMinimized;
    }

    public boolean isActive() {
        return this.isFocused;
    }

    public boolean isDirty() {
        boolean bl2 = this.is_dirty;
        this.is_dirty = false;
        return bl2;
    }

    public PeerInfo createPeerInfo(PixelFormat pixelFormat, ContextAttribs contextAttribs) {
        this.peer_info = new WindowsDisplayPeerInfo(false);
        return this.peer_info;
    }

    public void update() {
        WindowsDisplay.nUpdate();
        if (!this.isFocused && this.parent != null && this.parent_focused.compareAndSet(true, false)) {
            WindowsDisplay.setFocus(this.getHwnd());
        }
        if (this.redoMakeContextCurrent) {
            this.redoMakeContextCurrent = false;
            try {
                Context context = ((DrawableLWJGL)Display.getDrawable()).getContext();
                if (context != null && context.isCurrent()) {
                    context.makeCurrent();
                }
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Exception occurred while trying to make context current: " + lWJGLException);
            }
        }
    }

    private static native void nUpdate();

    public void reshape(int n2, int n3, int n4, int n5) {
        WindowsDisplay.nReshape(this.getHwnd(), n2, n3, n4, n5, Display.isFullscreen() || WindowsDisplay.isUndecorated(), this.parent != null);
    }

    private static native void nReshape(long var0, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public native DisplayMode[] getAvailableDisplayModes();

    public boolean hasWheel() {
        return this.mouse.hasWheel();
    }

    public int getButtonCount() {
        return this.mouse.getButtonCount();
    }

    public void createMouse() {
        this.mouse = new WindowsMouse(this.getHwnd());
    }

    public void destroyMouse() {
        if (this.mouse != null) {
            this.mouse.destroy();
        }
        this.mouse = null;
    }

    public void pollMouse(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.mouse.poll(intBuffer, byteBuffer, this);
    }

    public void readMouse(ByteBuffer byteBuffer) {
        this.mouse.read(byteBuffer);
    }

    public void grabMouse(boolean bl2) {
        this.mouse.grab(bl2, this.shouldGrab());
        this.updateCursor();
    }

    public int getNativeCursorCapabilities() {
        return 1;
    }

    public void setCursorPosition(int n2, int n3) {
        WindowsDisplay.getGlobalClientRect(this.getHwnd(), rect);
        int n4 = WindowsDisplay.rect.left + n2;
        int n5 = WindowsDisplay.rect.bottom - 1 - n3;
        WindowsDisplay.nSetCursorPosition(n4, n5);
        this.setMousePosition(n2, n3);
    }

    private static native void nSetCursorPosition(int var0, int var1);

    public void setNativeCursor(Object object) {
        this.current_cursor = object;
        this.updateCursor();
    }

    private void updateCursor() {
        try {
            if (this.mouse != null && this.shouldGrab()) {
                WindowsDisplay.nSetNativeCursor(this.getHwnd(), this.mouse.getBlankCursor());
            } else {
                WindowsDisplay.nSetNativeCursor(this.getHwnd(), this.current_cursor);
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to update cursor: " + lWJGLException);
        }
    }

    static native void nSetNativeCursor(long var0, Object var2);

    public int getMinCursorSize() {
        return WindowsDisplay.getSystemMetrics(13);
    }

    public int getMaxCursorSize() {
        return WindowsDisplay.getSystemMetrics(13);
    }

    static native int getSystemMetrics(int var0);

    private static native long getDllInstance();

    private long getHwnd() {
        return this.hwnd;
    }

    private long getHdc() {
        return this.hdc;
    }

    private static native long getDC(long var0);

    private static native long getDesktopWindow();

    private static native long getForegroundWindow();

    static void centerCursor(long l2) {
        if (WindowsDisplay.getForegroundWindow() != l2 && !hasParent) {
            return;
        }
        WindowsDisplay.getGlobalClientRect(l2, rect);
        int n2 = WindowsDisplay.rect.left;
        int n3 = WindowsDisplay.rect.top;
        int n4 = (WindowsDisplay.rect.left + WindowsDisplay.rect.right) / 2;
        int n5 = (WindowsDisplay.rect.top + WindowsDisplay.rect.bottom) / 2;
        WindowsDisplay.nSetCursorPosition(n4, n5);
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (current_display != null) {
            current_display.setMousePosition(n6, WindowsDisplay.transformY(l2, n7));
        }
    }

    private void setMousePosition(int n2, int n3) {
        if (this.mouse != null) {
            this.mouse.setPosition(n2, n3);
        }
    }

    public void createKeyboard() {
        this.keyboard = new WindowsKeyboard();
    }

    public void destroyKeyboard() {
        this.keyboard = null;
    }

    public void pollKeyboard(ByteBuffer byteBuffer) {
        this.keyboard.poll(byteBuffer);
    }

    public void readKeyboard(ByteBuffer byteBuffer) {
        this.keyboard.read(byteBuffer);
    }

    public static native ByteBuffer nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8);

    public Object createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return WindowsDisplay.doCreateCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer2);
    }

    static Object doCreateCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return WindowsDisplay.nCreateCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer.position(), intBuffer2, intBuffer2 != null ? intBuffer2.position() : -1);
    }

    public void destroyCursor(Object object) {
        WindowsDisplay.doDestroyCursor(object);
    }

    static native void doDestroyCursor(Object var0);

    public int getPbufferCapabilities() {
        try {
            return this.nGetPbufferCapabilities(new PixelFormat(0, 0, 0, 0, 0, 0, 0, 0, false));
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while determining pbuffer capabilities: " + lWJGLException);
            return 0;
        }
    }

    private native int nGetPbufferCapabilities(PixelFormat var1);

    public boolean isBufferLost(PeerInfo peerInfo) {
        return ((WindowsPbufferPeerInfo)peerInfo).isBufferLost();
    }

    public PeerInfo createPbuffer(int n2, int n3, PixelFormat pixelFormat, ContextAttribs contextAttribs, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return new WindowsPbufferPeerInfo(n2, n3, pixelFormat, intBuffer, intBuffer2);
    }

    public void setPbufferAttrib(PeerInfo peerInfo, int n2, int n3) {
        ((WindowsPbufferPeerInfo)peerInfo).setPbufferAttrib(n2, n3);
    }

    public void bindTexImageToPbuffer(PeerInfo peerInfo, int n2) {
        ((WindowsPbufferPeerInfo)peerInfo).bindTexImageToPbuffer(n2);
    }

    public void releaseTexImageFromPbuffer(PeerInfo peerInfo, int n2) {
        ((WindowsPbufferPeerInfo)peerInfo).releaseTexImageFromPbuffer(n2);
    }

    private void freeSmallIcon() {
        if (this.small_icon != 0L) {
            WindowsDisplay.destroyIcon(this.small_icon);
            this.small_icon = 0L;
        }
    }

    private void freeLargeIcon() {
        if (this.large_icon != 0L) {
            WindowsDisplay.destroyIcon(this.large_icon);
            this.large_icon = 0L;
        }
    }

    public int setIcon(ByteBuffer[] byteBufferArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 16;
        int n4 = 32;
        block0: for (ByteBuffer byteBuffer : byteBufferArray) {
            long l2;
            int n5 = byteBuffer.limit() / 4;
            if ((int)Math.sqrt(n5) == n3 && !bl2) {
                l2 = WindowsDisplay.createIcon(n3, n3, byteBuffer.asIntBuffer());
                WindowsDisplay.sendMessage(this.hwnd, 128L, 0L, l2);
                this.freeSmallIcon();
                this.small_icon = l2;
                ++n2;
                bl2 = true;
            }
            if ((int)Math.sqrt(n5) != n4 || bl3) continue;
            l2 = WindowsDisplay.createIcon(n4, n4, byteBuffer.asIntBuffer());
            WindowsDisplay.sendMessage(this.hwnd, 128L, 1L, l2);
            this.freeLargeIcon();
            this.large_icon = l2;
            ++n2;
            bl3 = true;
            this.iconsLoaded = false;
            long l3 = System.nanoTime();
            long l4 = 500000000L;
            while (true) {
                WindowsDisplay.nUpdate();
                if (this.iconsLoaded || l4 < System.nanoTime() - l3) continue block0;
                Thread.yield();
            }
        }
        return n2;
    }

    private static native long createIcon(int var0, int var1, IntBuffer var2);

    private static native void destroyIcon(long var0);

    private static native long sendMessage(long var0, long var2, long var4, long var6);

    private static native long setWindowLongPtr(long var0, int var2, long var3);

    private static native long getWindowLongPtr(long var0, int var2);

    private static native boolean setWindowPos(long var0, long var2, int var4, int var5, int var6, int var7, long var8);

    private void handleMouseButton(int n2, int n3, long l2) {
        if (this.mouse != null) {
            this.mouse.handleMouseButton((byte)n2, (byte)n3, l2);
            if (this.captureMouse == -1 && n2 != -1 && n3 == 1) {
                this.captureMouse = n2;
                WindowsDisplay.nSetCapture(this.hwnd);
            }
            if (this.captureMouse != -1 && n2 == this.captureMouse && n3 == 0) {
                this.captureMouse = -1;
                WindowsDisplay.nReleaseCapture();
            }
        }
    }

    private boolean shouldGrab() {
        return !this.isMinimized && this.isFocused && Mouse.isGrabbed();
    }

    private static native long nSetCapture(long var0);

    private static native boolean nReleaseCapture();

    private void handleMouseScrolled(int n2, long l2) {
        if (this.mouse != null) {
            this.mouse.handleMouseScrolled(n2, l2);
        }
    }

    private static native void getClientRect(long var0, IntBuffer var2);

    private void handleChar(long l2, long l3, long l4) {
        boolean bl2;
        byte by2 = (byte)(1L - (l3 >>> 31 & 1L));
        byte by3 = (byte)(l3 >>> 30 & 1L);
        boolean bl3 = bl2 = by2 == by3;
        if (this.keyboard != null) {
            this.keyboard.handleChar((int)(l2 & 0xFFFFL), l4, bl2);
        }
    }

    private void handleKeyButton(long l2, long l3, long l4) {
        if (this.keyboard == null) {
            return;
        }
        byte by2 = (byte)(1L - (l3 >>> 31 & 1L));
        byte by3 = (byte)(l3 >>> 30 & 1L);
        boolean bl2 = by2 == by3;
        byte by4 = (byte)(l3 >>> 24 & 1L);
        int n2 = (int)(l3 >>> 16 & 0xFFL);
        this.keyboard.handleKey((int)l2, n2, by4 != 0, by2, l4, bl2);
    }

    private static int transformY(long l2, int n2) {
        WindowsDisplay.getClientRect(l2, rect_buffer);
        rect.copyFromBuffer(rect_buffer);
        return WindowsDisplay.rect.bottom - WindowsDisplay.rect.top - 1 - n2;
    }

    private static native void clientToScreen(long var0, IntBuffer var2);

    private static native void setWindowProc(Method var0);

    private static long handleMessage(long l2, int n2, long l3, long l4, long l5) {
        if (current_display != null) {
            return current_display.doHandleMessage(l2, n2, l3, l4, l5);
        }
        return WindowsDisplay.defWindowProc(l2, n2, l3, l4);
    }

    private static native long defWindowProc(long var0, int var2, long var3, long var5);

    private void updateClipping() {
        if ((Display.isFullscreen() || this.mouse != null && this.mouse.isGrabbed()) && !this.isMinimized && this.isFocused && (WindowsDisplay.getForegroundWindow() == this.getHwnd() || hasParent)) {
            try {
                WindowsDisplay.setupCursorClipping(this.getHwnd());
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("setupCursorClipping failed: " + lWJGLException.getMessage());
            }
        } else {
            WindowsDisplay.resetCursorClipping();
        }
    }

    private void setMinimized(boolean bl2) {
        if (bl2 != this.isMinimized) {
            this.isMinimized = bl2;
            this.updateClipping();
        }
    }

    private long doHandleMessage(long l2, int n2, long l3, long l4, long l5) {
        if (this.parent != null && !this.isFocused) {
            switch (n2) {
                case 513: 
                case 516: 
                case 519: 
                case 523: {
                    WindowsDisplay.sendMessage(this.parent_hwnd, n2, l3, l4);
                }
            }
        }
        switch (n2) {
            case 6: {
                return 0L;
            }
            case 5: {
                switch ((int)l3) {
                    case 0: 
                    case 2: {
                        this.resized = true;
                        this.updateWidthAndHeight();
                        this.setMinimized(false);
                        break;
                    }
                    case 1: {
                        this.setMinimized(true);
                    }
                }
                break;
            }
            case 532: {
                this.resized = true;
                this.updateWidthAndHeight();
                break;
            }
            case 32: {
                if ((l4 & 0xFFFFL) == 1L) {
                    this.updateCursor();
                    return -1L;
                }
                return WindowsDisplay.defWindowProc(l2, n2, l3, l4);
            }
            case 8: {
                this.appActivate(false, l5);
                return 0L;
            }
            case 7: {
                this.appActivate(true, l5);
                return 0L;
            }
            case 33: {
                if (this.parent == null) break;
                if (!this.isFocused) {
                    this.grabFocus();
                }
                return 3L;
            }
            case 512: {
                if (this.mouse != null) {
                    short s2 = (short)(l4 & 0xFFFFL);
                    int n3 = WindowsDisplay.transformY(this.getHwnd(), (short)(l4 >>> 16));
                    this.mouse.handleMouseMoved(s2, n3, l5);
                }
                if (!this.mouseInside) {
                    this.mouseInside = true;
                    this.updateClipping();
                    this.nTrackMouseEvent(l2);
                }
                return 0L;
            }
            case 522: {
                short s3 = (short)(l3 >> 16 & 0xFFFFL);
                this.handleMouseScrolled(s3, l5);
                return 0L;
            }
            case 513: {
                this.handleMouseButton(0, 1, l5);
                return 0L;
            }
            case 514: {
                this.handleMouseButton(0, 0, l5);
                return 0L;
            }
            case 516: {
                this.handleMouseButton(1, 1, l5);
                return 0L;
            }
            case 517: {
                this.handleMouseButton(1, 0, l5);
                return 0L;
            }
            case 519: {
                this.handleMouseButton(2, 1, l5);
                return 0L;
            }
            case 520: {
                this.handleMouseButton(2, 0, l5);
                return 0L;
            }
            case 524: {
                if (l3 >> 16 == 1L) {
                    this.handleMouseButton(3, 0, l5);
                } else {
                    this.handleMouseButton(4, 0, l5);
                }
                return 1L;
            }
            case 523: {
                if ((l3 & 0xFFL) == 32L) {
                    this.handleMouseButton(3, 1, l5);
                } else {
                    this.handleMouseButton(4, 1, l5);
                }
                return 1L;
            }
            case 258: 
            case 262: {
                this.handleChar(l3, l4, l5);
                return 0L;
            }
            case 261: {
                if (l3 == 18L || l3 == 121L) {
                    this.handleKeyButton(l3, l4, l5);
                    return 0L;
                }
            }
            case 257: {
                if (l3 == 44L && this.keyboard != null && !this.keyboard.isKeyDown(183)) {
                    long l6 = l4 & Integer.MAX_VALUE;
                    this.handleKeyButton(l3, l6 &= 0xFFFFFFFFBFFFFFFFL, l5);
                }
            }
            case 256: 
            case 260: {
                this.handleKeyButton(l3, l4, l5);
                break;
            }
            case 18: {
                this.close_requested = true;
                return 0L;
            }
            case 274: {
                switch ((int)(l3 & 0xFFF0L)) {
                    case 61760: 
                    case 61808: {
                        return 0L;
                    }
                    case 61536: {
                        this.close_requested = true;
                        return 0L;
                    }
                }
                break;
            }
            case 15: {
                this.is_dirty = true;
                break;
            }
            case 675: {
                this.mouseInside = false;
                break;
            }
            case 31: {
                WindowsDisplay.nReleaseCapture();
            }
            case 533: {
                if (this.captureMouse != -1) {
                    this.handleMouseButton(this.captureMouse, 0, l5);
                    this.captureMouse = -1;
                }
                return 0L;
            }
            case 71: {
                if (this.getWindowRect(l2, rect_buffer)) {
                    rect.copyFromBuffer(rect_buffer);
                    this.x = WindowsDisplay.rect.left;
                    this.y = WindowsDisplay.rect.top;
                    break;
                }
                LWJGLUtil.log("WM_WINDOWPOSCHANGED: Unable to get window rect");
                break;
            }
            case 127: {
                this.iconsLoaded = true;
            }
        }
        return WindowsDisplay.defWindowProc(l2, n2, l3, l4);
    }

    private native boolean getWindowRect(long var1, IntBuffer var3);

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private native boolean nTrackMouseEvent(long var1);

    public boolean isInsideWindow() {
        return this.mouseInside;
    }

    public void setResizable(boolean bl2) {
        if (this.resizable == bl2) {
            return;
        }
        this.resized = false;
        this.resizable = bl2;
        int n2 = (int)WindowsDisplay.getWindowLongPtr(this.hwnd, -16);
        int n3 = (int)WindowsDisplay.getWindowLongPtr(this.hwnd, -20);
        n2 = bl2 && !Display.isFullscreen() ? n2 | 0x50000 : n2 & 0xFFFAFFFF;
        WindowsDisplay.setWindowLongPtr(this.hwnd, -16, n2);
        WindowsDisplay.getGlobalClientRect(this.hwnd, rect);
        rect.copyToBuffer(rect_buffer);
        this.adjustWindowRectEx(rect_buffer, n2, false, n3);
        rect.copyFromBuffer(rect_buffer);
        WindowsDisplay.setWindowPos(this.hwnd, 0L, WindowsDisplay.rect.left, WindowsDisplay.rect.top, WindowsDisplay.rect.right - WindowsDisplay.rect.left, WindowsDisplay.rect.bottom - WindowsDisplay.rect.top, 36L);
        this.updateWidthAndHeight();
    }

    private native boolean adjustWindowRectEx(IntBuffer var1, int var2, boolean var3, int var4);

    public boolean wasResized() {
        if (this.resized) {
            this.resized = false;
            return true;
        }
        return false;
    }

    public float getPixelScaleFactor() {
        return 1.0f;
    }

    static {
        try {
            Method method = WindowsDisplay.class.getDeclaredMethod("handleMessage", Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            WindowsDisplay.setWindowProc(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    static final class Rect {
        public int left;
        public int top;
        public int right;
        public int bottom;

        private Rect() {
        }

        public void copyToBuffer(IntBuffer intBuffer) {
            intBuffer.put(0, this.left).put(1, this.top).put(2, this.right).put(3, this.bottom);
        }

        public void copyFromBuffer(IntBuffer intBuffer) {
            this.left = intBuffer.get(0);
            this.top = intBuffer.get(1);
            this.right = intBuffer.get(2);
            this.bottom = intBuffer.get(3);
        }

        public void offset(int n2, int n3) {
            this.left += n2;
            this.top += n3;
            this.right += n2;
            this.bottom += n3;
        }

        public static void intersect(Rect rect, Rect rect2, Rect rect3) {
            rect3.left = Math.max(rect.left, rect2.left);
            rect3.top = Math.max(rect.top, rect2.top);
            rect3.right = Math.min(rect.right, rect2.right);
            rect3.bottom = Math.min(rect.bottom, rect2.bottom);
        }

        public String toString() {
            return "Rect: left = " + this.left + " top = " + this.top + " right = " + this.right + " bottom = " + this.bottom + ", width: " + (this.right - this.left) + ", height: " + (this.bottom - this.top);
        }
    }
}

