/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.ContextImplementation;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.Util;

final class WindowsContextImplementation
implements ContextImplementation {
    WindowsContextImplementation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer create(PeerInfo peerInfo, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = peerInfo.lockAndGetHandle();
        try {
            ByteBuffer byteBuffer3 = WindowsContextImplementation.nCreate(byteBuffer2, intBuffer, byteBuffer);
            return byteBuffer3;
        }
        finally {
            peerInfo.unlock();
        }
    }

    private static native ByteBuffer nCreate(ByteBuffer var0, IntBuffer var1, ByteBuffer var2);

    native long getHGLRC(ByteBuffer var1);

    native long getHDC(ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
            try {
                WindowsContextImplementation.nSwapBuffers(byteBuffer);
            }
            finally {
                peerInfo.unlock();
            }
        }
    }

    private static native void nSwapBuffers(ByteBuffer var0);

    public void releaseDrawable(ByteBuffer byteBuffer) {
    }

    public void update(ByteBuffer byteBuffer) {
    }

    public void releaseCurrentContext() {
        WindowsContextImplementation.nReleaseCurrentContext();
    }

    private static native void nReleaseCurrentContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCurrent(PeerInfo peerInfo, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = peerInfo.lockAndGetHandle();
        try {
            WindowsContextImplementation.nMakeCurrent(byteBuffer2, byteBuffer);
        }
        finally {
            peerInfo.unlock();
        }
    }

    private static native void nMakeCurrent(ByteBuffer var0, ByteBuffer var1);

    public boolean isCurrent(ByteBuffer byteBuffer) {
        boolean bl2 = WindowsContextImplementation.nIsCurrent(byteBuffer);
        return bl2;
    }

    private static native boolean nIsCurrent(ByteBuffer var0);

    public void setSwapInterval(int n2) {
        boolean bl2 = WindowsContextImplementation.nSetSwapInterval(n2);
        if (!bl2) {
            LWJGLUtil.log("Failed to set swap interval");
        }
        Util.checkGLError();
    }

    private static native boolean nSetSwapInterval(int var0);

    public void destroy(PeerInfo peerInfo, ByteBuffer byteBuffer) {
        WindowsContextImplementation.nDestroy(byteBuffer);
    }

    private static native void nDestroy(ByteBuffer var0);
}

