/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.FastIntMap;
import org.lwjgl.opengl.References;
import org.lwjgl.opengl.ReferencesStack;
import org.lwjgl.opengl.StateStack;

final class StateTracker {
    private ReferencesStack references_stack;
    private final StateStack attrib_stack;
    private boolean insideBeginEnd;
    private final FastIntMap<VAOState> vaoMap = new FastIntMap();

    StateTracker() {
        this.attrib_stack = new StateStack(0);
    }

    void init() {
        this.references_stack = new ReferencesStack();
    }

    static void setBeginEnd(ContextCapabilities contextCapabilities, boolean bl2) {
        contextCapabilities.tracker.insideBeginEnd = bl2;
    }

    boolean isBeginEnd() {
        return this.insideBeginEnd;
    }

    static void popAttrib(ContextCapabilities contextCapabilities) {
        contextCapabilities.tracker.doPopAttrib();
    }

    private void doPopAttrib() {
        this.references_stack.popState(this.attrib_stack.popState());
    }

    static void pushAttrib(ContextCapabilities contextCapabilities, int n2) {
        contextCapabilities.tracker.doPushAttrib(n2);
    }

    private void doPushAttrib(int n2) {
        this.attrib_stack.pushState(n2);
        this.references_stack.pushState();
    }

    static References getReferences(ContextCapabilities contextCapabilities) {
        return contextCapabilities.tracker.references_stack.getReferences();
    }

    static void bindBuffer(ContextCapabilities contextCapabilities, int n2, int n3) {
        References references = StateTracker.getReferences(contextCapabilities);
        switch (n2) {
            case 34962: {
                references.arrayBuffer = n3;
                break;
            }
            case 34963: {
                if (references.vertexArrayObject != 0) {
                    contextCapabilities.tracker.vaoMap.get((int)references.vertexArrayObject).elementArrayBuffer = n3;
                    break;
                }
                references.elementArrayBuffer = n3;
                break;
            }
            case 35051: {
                references.pixelPackBuffer = n3;
                break;
            }
            case 35052: {
                references.pixelUnpackBuffer = n3;
                break;
            }
            case 36671: {
                references.indirectBuffer = n3;
            }
        }
    }

    static void bindVAO(ContextCapabilities contextCapabilities, int n2) {
        FastIntMap<VAOState> fastIntMap = contextCapabilities.tracker.vaoMap;
        if (!fastIntMap.containsKey(n2)) {
            fastIntMap.put(n2, new VAOState());
        }
        StateTracker.getReferences((ContextCapabilities)contextCapabilities).vertexArrayObject = n2;
    }

    static void deleteVAO(ContextCapabilities contextCapabilities, IntBuffer intBuffer) {
        for (int i2 = intBuffer.position(); i2 < intBuffer.limit(); ++i2) {
            StateTracker.deleteVAO(contextCapabilities, intBuffer.get(i2));
        }
    }

    static void deleteVAO(ContextCapabilities contextCapabilities, int n2) {
        contextCapabilities.tracker.vaoMap.remove(n2);
        References references = StateTracker.getReferences(contextCapabilities);
        if (references.vertexArrayObject == n2) {
            references.vertexArrayObject = 0;
        }
    }

    static int getElementArrayBufferBound(ContextCapabilities contextCapabilities) {
        References references = StateTracker.getReferences(contextCapabilities);
        if (references.vertexArrayObject == 0) {
            return references.elementArrayBuffer;
        }
        return contextCapabilities.tracker.vaoMap.get((int)references.vertexArrayObject).elementArrayBuffer;
    }

    static class VAOState {
        int elementArrayBuffer;

        private VAOState() {
        }
    }
}

