/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.LongBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.NVGpuShader5;

public final class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;

    private NVShaderBufferLoad() {
    }

    public static void glMakeBufferResidentNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMakeBufferResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        NVShaderBufferLoad.nglMakeBufferResidentNV(n2, n3, l2);
    }

    static native void nglMakeBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeBufferNonResidentNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMakeBufferNonResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        NVShaderBufferLoad.nglMakeBufferNonResidentNV(n2, l2);
    }

    static native void nglMakeBufferNonResidentNV(int var0, long var1);

    public static boolean glIsBufferResidentNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsBufferResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVShaderBufferLoad.nglIsBufferResidentNV(n2, l2);
        return bl2;
    }

    static native boolean nglIsBufferResidentNV(int var0, long var1);

    public static void glMakeNamedBufferResidentNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMakeNamedBufferResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        NVShaderBufferLoad.nglMakeNamedBufferResidentNV(n2, n3, l2);
    }

    static native void nglMakeNamedBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeNamedBufferNonResidentNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMakeNamedBufferNonResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        NVShaderBufferLoad.nglMakeNamedBufferNonResidentNV(n2, l2);
    }

    static native void nglMakeNamedBufferNonResidentNV(int var0, long var1);

    public static boolean glIsNamedBufferResidentNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsNamedBufferResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVShaderBufferLoad.nglIsNamedBufferResidentNV(n2, l2);
        return bl2;
    }

    static native boolean nglIsNamedBufferResidentNV(int var0, long var1);

    public static void glGetBufferParameteruNV(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static long glGetBufferParameterui64NV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glGetNamedBufferParameteruNV(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetNamedBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static long glGetNamedBufferParameterui64NV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glGetIntegeruNV(int n2, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetIntegerui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        NVShaderBufferLoad.nglGetIntegerui64vNV(n2, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetIntegerui64vNV(int var0, long var1, long var3);

    public static long glGetIntegerui64NV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetIntegerui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetIntegerui64vNV(n2, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glUniformui64NV(int n2, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glUniformui64NV;
        BufferChecks.checkFunctionAddress(l3);
        NVShaderBufferLoad.nglUniformui64NV(n2, l2, l3);
    }

    static native void nglUniformui64NV(int var0, long var1, long var3);

    public static void glUniformuNV(int n2, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        NVShaderBufferLoad.nglUniformui64vNV(n2, longBuffer.remaining(), MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglUniformui64vNV(int var0, int var1, long var2, long var4);

    public static void glGetUniformuNV(int n2, int n3, LongBuffer longBuffer) {
        NVGpuShader5.glGetUniformuNV(n2, n3, longBuffer);
    }

    public static void glProgramUniformui64NV(int n2, int n3, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glProgramUniformui64NV;
        BufferChecks.checkFunctionAddress(l3);
        NVShaderBufferLoad.nglProgramUniformui64NV(n2, n3, l2, l3);
    }

    static native void nglProgramUniformui64NV(int var0, int var1, long var2, long var4);

    public static void glProgramUniformuNV(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformui64vNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        NVShaderBufferLoad.nglProgramUniformui64vNV(n2, n3, longBuffer.remaining(), MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglProgramUniformui64vNV(int var0, int var1, int var2, long var3, long var5);
}

