/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public class NVProgram {
    public static final int GL_PROGRAM_TARGET_NV = 34374;
    public static final int GL_PROGRAM_LENGTH_NV = 34343;
    public static final int GL_PROGRAM_RESIDENT_NV = 34375;
    public static final int GL_PROGRAM_STRING_NV = 34344;
    public static final int GL_PROGRAM_ERROR_POSITION_NV = 34379;
    public static final int GL_PROGRAM_ERROR_STRING_NV = 34932;

    public static void glLoadProgramNV(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glLoadProgramNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        NVProgram.nglLoadProgramNV(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglLoadProgramNV(int var0, int var1, int var2, long var3, long var5);

    public static void glLoadProgramNV(int n2, int n3, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glLoadProgramNV;
        BufferChecks.checkFunctionAddress(l2);
        NVProgram.nglLoadProgramNV(n2, n3, charSequence.length(), APIUtil.getBuffer(contextCapabilities, charSequence), l2);
    }

    public static void glBindProgramNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindProgramNV;
        BufferChecks.checkFunctionAddress(l2);
        NVProgram.nglBindProgramNV(n2, n3, l2);
    }

    static native void nglBindProgramNV(int var0, int var1, long var2);

    public static void glDeleteProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVProgram.nglDeleteProgramsNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteProgramsNV(int var0, long var1, long var3);

    public static void glDeleteProgramsNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        NVProgram.nglDeleteProgramsNV(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVProgram.nglGenProgramsNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenProgramsNV(int var0, long var1, long var3);

    public static int glGenProgramsNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVProgram.nglGenProgramsNV(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetProgramNV(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramivNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVProgram.nglGetProgramivNV(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetProgramivNV(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetProgramNV(int n2, int n3) {
        return NVProgram.glGetProgramiNV(n2, n3);
    }

    public static int glGetProgramiNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramivNV;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVProgram.nglGetProgramivNV(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetProgramStringNV(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramStringNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        NVProgram.nglGetProgramStringNV(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetProgramStringNV(int var0, int var1, long var2, long var4);

    public static String glGetProgramStringNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramStringNV;
        BufferChecks.checkFunctionAddress(l2);
        int n4 = NVProgram.glGetProgramiNV(n2, 34343);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        NVProgram.nglGetProgramStringNV(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(n4);
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static boolean glIsProgramNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsProgramNV;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVProgram.nglIsProgramNV(n2, l2);
        return bl2;
    }

    static native boolean nglIsProgramNV(int var0, long var1);

    public static boolean glAreProgramsResidentNV(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glAreProgramsResidentNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        BufferChecks.checkBuffer(byteBuffer, intBuffer.remaining());
        boolean bl2 = NVProgram.nglAreProgramsResidentNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        return bl2;
    }

    static native boolean nglAreProgramsResidentNV(int var0, long var1, long var3, long var5);

    public static void glRequestResidentProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glRequestResidentProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVProgram.nglRequestResidentProgramsNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglRequestResidentProgramsNV(int var0, long var1, long var3);

    public static void glRequestResidentProgramsNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glRequestResidentProgramsNV;
        BufferChecks.checkFunctionAddress(l2);
        NVProgram.nglRequestResidentProgramsNV(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }
}

