/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class NVPixelDataRange {
    public static final int GL_WRITE_PIXEL_DATA_RANGE_NV = 34936;
    public static final int GL_READ_PIXEL_DATA_RANGE_NV = 34937;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 34938;
    public static final int GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 34939;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 34940;
    public static final int GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 34941;

    private NVPixelDataRange() {
    }

    public static void glPixelDataRangeNV(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        NVPixelDataRange.nglPixelDataRangeNV(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glPixelDataRangeNV(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        NVPixelDataRange.nglPixelDataRangeNV(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glPixelDataRangeNV(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        NVPixelDataRange.nglPixelDataRangeNV(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glPixelDataRangeNV(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVPixelDataRange.nglPixelDataRangeNV(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glPixelDataRangeNV(int n2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        NVPixelDataRange.nglPixelDataRangeNV(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglPixelDataRangeNV(int var0, int var1, long var2, long var4);

    public static void glFlushPixelDataRangeNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFlushPixelDataRangeNV;
        BufferChecks.checkFunctionAddress(l2);
        NVPixelDataRange.nglFlushPixelDataRangeNV(n2, l2);
    }

    static native void nglFlushPixelDataRangeNV(int var0, long var1);
}

