/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;

    private NVFence() {
    }

    public static void glGenFencesNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenFencesNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVFence.nglGenFencesNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenFencesNV(int var0, long var1, long var3);

    public static int glGenFencesNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenFencesNV;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVFence.nglGenFencesNV(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glDeleteFencesNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteFencesNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        NVFence.nglDeleteFencesNV(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteFencesNV(int var0, long var1, long var3);

    public static void glDeleteFencesNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteFencesNV;
        BufferChecks.checkFunctionAddress(l2);
        NVFence.nglDeleteFencesNV(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glSetFenceNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glSetFenceNV;
        BufferChecks.checkFunctionAddress(l2);
        NVFence.nglSetFenceNV(n2, n3, l2);
    }

    static native void nglSetFenceNV(int var0, int var1, long var2);

    public static boolean glTestFenceNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTestFenceNV;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVFence.nglTestFenceNV(n2, l2);
        return bl2;
    }

    static native boolean nglTestFenceNV(int var0, long var1);

    public static void glFinishFenceNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFinishFenceNV;
        BufferChecks.checkFunctionAddress(l2);
        NVFence.nglFinishFenceNV(n2, l2);
    }

    static native void nglFinishFenceNV(int var0, long var1);

    public static boolean glIsFenceNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsFenceNV;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVFence.nglIsFenceNV(n2, l2);
        return bl2;
    }

    static native boolean nglIsFenceNV(int var0, long var1);

    public static void glGetFenceivNV(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFenceivNV;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        NVFence.nglGetFenceivNV(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetFenceivNV(int var0, int var1, long var2, long var4);
}

