/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.AWTUtil;
import org.lwjgl.opengl.EventQueue;

class MouseEventQueue
extends EventQueue
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int WHEEL_SCALE = 120;
    public static final int NUM_BUTTONS = 3;
    private final Component component;
    private boolean grabbed;
    private int accum_dx;
    private int accum_dy;
    private int accum_dz;
    private int last_x;
    private int last_y;
    private boolean saved_control_state;
    private final ByteBuffer event = ByteBuffer.allocate(22);
    private final byte[] buttons = new byte[3];

    MouseEventQueue(Component component) {
        super(22);
        this.component = component;
    }

    public synchronized void register() {
        this.resetCursorToCenter();
        if (this.component != null) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
            this.component.addMouseWheelListener(this);
        }
    }

    public synchronized void unregister() {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
            this.component.removeMouseWheelListener(this);
        }
    }

    protected Component getComponent() {
        return this.component;
    }

    public synchronized void setGrabbed(boolean bl2) {
        this.grabbed = bl2;
        this.resetCursorToCenter();
    }

    public synchronized boolean isGrabbed() {
        return this.grabbed;
    }

    protected int transformY(int n2) {
        if (this.component != null) {
            return this.component.getHeight() - 1 - n2;
        }
        return n2;
    }

    protected void resetCursorToCenter() {
        Point point;
        this.clearEvents();
        this.accum_dy = 0;
        this.accum_dx = 0;
        if (this.component != null && (point = AWTUtil.getCursorPosition(this.component)) != null) {
            this.last_x = point.x;
            this.last_y = point.y;
        }
    }

    private void putMouseEvent(byte by2, byte by3, int n2, long l2) {
        if (this.grabbed) {
            this.putMouseEventWithCoords(by2, by3, 0, 0, n2, l2);
        } else {
            this.putMouseEventWithCoords(by2, by3, this.last_x, this.last_y, n2, l2);
        }
    }

    protected void putMouseEventWithCoords(byte by2, byte by3, int n2, int n3, int n4, long l2) {
        this.event.clear();
        this.event.put(by2).put(by3).putInt(n2).putInt(n3).putInt(n4).putLong(l2);
        this.event.flip();
        this.putEvent(this.event);
    }

    public synchronized void poll(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (this.grabbed) {
            intBuffer.put(0, this.accum_dx);
            intBuffer.put(1, this.accum_dy);
        } else {
            intBuffer.put(0, this.last_x);
            intBuffer.put(1, this.last_y);
        }
        intBuffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
        int n2 = byteBuffer.position();
        byteBuffer.put(this.buttons, 0, this.buttons.length);
        byteBuffer.position(n2);
    }

    private void setCursorPos(int n2, int n3, long l2) {
        n3 = this.transformY(n3);
        if (this.grabbed) {
            return;
        }
        int n4 = n2 - this.last_x;
        int n5 = n3 - this.last_y;
        this.addDelta(n4, n5);
        this.last_x = n2;
        this.last_y = n3;
        this.putMouseEventWithCoords((byte)-1, (byte)0, n2, n3, 0, l2);
    }

    protected void addDelta(int n2, int n3) {
        this.accum_dx += n2;
        this.accum_dy += n3;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void handleButton(MouseEvent mouseEvent) {
        byte by2;
        byte by3;
        switch (mouseEvent.getID()) {
            case 501: {
                by3 = 1;
                break;
            }
            case 502: {
                by3 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid event ID: " + mouseEvent.getID());
            }
        }
        switch (mouseEvent.getButton()) {
            case 0: {
                return;
            }
            case 1: {
                if (by3 == 1) {
                    this.saved_control_state = mouseEvent.isControlDown();
                }
                if (this.saved_control_state) {
                    if (this.buttons[1] == by3) {
                        return;
                    }
                    by2 = 1;
                    break;
                }
                by2 = 0;
                break;
            }
            case 2: {
                by2 = 2;
                break;
            }
            case 3: {
                if (this.buttons[1] == by3) {
                    return;
                }
                by2 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid button: " + mouseEvent.getButton());
            }
        }
        this.setButton(by2, by3, mouseEvent.getWhen() * 1000000L);
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.handleButton(mouseEvent);
    }

    private void setButton(byte by2, byte by3, long l2) {
        this.buttons[by2] = by3;
        this.putMouseEvent(by2, by3, 0, l2);
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.handleButton(mouseEvent);
    }

    private void handleMotion(MouseEvent mouseEvent) {
        if (this.grabbed) {
            this.updateDeltas(mouseEvent.getWhen() * 1000000L);
        } else {
            this.setCursorPos(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen() * 1000000L);
        }
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        this.handleMotion(mouseEvent);
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        this.handleMotion(mouseEvent);
    }

    private void handleWheel(int n2, long l2) {
        this.accum_dz += n2;
        this.putMouseEvent((byte)-1, (byte)0, n2, l2);
    }

    protected void updateDeltas(long l2) {
    }

    public synchronized void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = -mouseWheelEvent.getWheelRotation() * 120;
        this.handleWheel(n2, mouseWheelEvent.getWhen() * 1000000L);
    }
}

