/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.MacOSXDisplay;

final class MacOSXNativeMouse
extends EventQueue {
    private static final int WHEEL_SCALE = 120;
    private static final int NUM_BUTTONS = 3;
    private ByteBuffer window_handle;
    private MacOSXDisplay display;
    private boolean grabbed;
    private float accum_dx;
    private float accum_dy;
    private int accum_dz;
    private float last_x;
    private float last_y;
    private boolean saved_control_state;
    private final ByteBuffer event = ByteBuffer.allocate(22);
    private IntBuffer delta_buffer = BufferUtils.createIntBuffer(2);
    private int skip_event;
    private final byte[] buttons = new byte[3];

    MacOSXNativeMouse(MacOSXDisplay macOSXDisplay, ByteBuffer byteBuffer) {
        super(22);
        this.display = macOSXDisplay;
        this.window_handle = byteBuffer;
    }

    private native void nSetCursorPosition(ByteBuffer var1, int var2, int var3);

    public static native void nGrabMouse(boolean var0);

    private native void nRegisterMouseListener(ByteBuffer var1);

    private native void nUnregisterMouseListener(ByteBuffer var1);

    private static native long nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8);

    private static native void nDestroyCursor(long var0);

    private static native void nSetCursor(long var0);

    public synchronized void register() {
        this.nRegisterMouseListener(this.window_handle);
    }

    public static long createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return MacOSXNativeMouse.nCreateCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer.position(), intBuffer2, intBuffer2 != null ? intBuffer2.position() : -1);
    }

    public static void destroyCursor(long l2) {
        MacOSXNativeMouse.nDestroyCursor(l2);
    }

    public static void setCursor(long l2) {
        MacOSXNativeMouse.nSetCursor(l2);
    }

    public synchronized void setCursorPosition(int n2, int n3) {
        this.nSetCursorPosition(this.window_handle, n2, n3);
    }

    public synchronized void unregister() {
        this.nUnregisterMouseListener(this.window_handle);
    }

    public synchronized void setGrabbed(boolean bl2) {
        this.grabbed = bl2;
        MacOSXNativeMouse.nGrabMouse(bl2);
        this.skip_event = 1;
        this.accum_dy = 0.0f;
        this.accum_dx = 0.0f;
    }

    public synchronized boolean isGrabbed() {
        return this.grabbed;
    }

    protected void resetCursorToCenter() {
        this.clearEvents();
        this.accum_dy = 0.0f;
        this.accum_dx = 0.0f;
        if (this.display != null) {
            this.last_x = this.display.getWidth() / 2;
            this.last_y = this.display.getHeight() / 2;
        }
    }

    private void putMouseEvent(byte by2, byte by3, int n2, long l2) {
        if (this.grabbed) {
            this.putMouseEventWithCoords(by2, by3, 0, 0, n2, l2);
        } else {
            this.putMouseEventWithCoords(by2, by3, (int)this.last_x, (int)this.last_y, n2, l2);
        }
    }

    protected void putMouseEventWithCoords(byte by2, byte by3, int n2, int n3, int n4, long l2) {
        this.event.clear();
        this.event.put(by2).put(by3).putInt(n2).putInt(n3).putInt(n4).putLong(l2);
        this.event.flip();
        this.putEvent(this.event);
    }

    public synchronized void poll(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (this.grabbed) {
            intBuffer.put(0, (int)this.accum_dx);
            intBuffer.put(1, (int)this.accum_dy);
        } else {
            intBuffer.put(0, (int)this.last_x);
            intBuffer.put(1, (int)this.last_y);
        }
        intBuffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dx = this.accum_dy = (float)0;
        int n2 = byteBuffer.position();
        byteBuffer.put(this.buttons, 0, this.buttons.length);
        byteBuffer.position(n2);
    }

    private void setCursorPos(float f2, float f3, long l2) {
        if (this.grabbed) {
            return;
        }
        float f4 = f2 - this.last_x;
        float f5 = f3 - this.last_y;
        this.addDelta(f4, f5);
        this.last_x = f2;
        this.last_y = f3;
        this.putMouseEventWithCoords((byte)-1, (byte)0, (int)f2, (int)f3, 0, l2);
    }

    protected void addDelta(float f2, float f3) {
        this.accum_dx += f2;
        this.accum_dy += -f3;
    }

    public synchronized void setButton(int n2, int n3, long l2) {
        this.buttons[n2] = (byte)n3;
        this.putMouseEvent((byte)n2, (byte)n3, 0, l2);
    }

    public synchronized void mouseMoved(float f2, float f3, float f4, float f5, float f6, long l2) {
        if (this.skip_event > 0) {
            --this.skip_event;
            if (this.skip_event == 0) {
                this.last_x = f2;
                this.last_y = f3;
            }
            return;
        }
        if (f6 != 0.0f) {
            if (f5 == 0.0f) {
                f5 = f4;
            }
            int n2 = (int)(f5 * 120.0f);
            this.accum_dz += n2;
            this.putMouseEvent((byte)-1, (byte)0, n2, l2);
        } else if (this.grabbed) {
            if (f4 != 0.0f || f5 != 0.0f) {
                this.putMouseEventWithCoords((byte)-1, (byte)0, (int)f4, (int)(-f5), 0, l2);
                this.addDelta(f4, f5);
            }
        } else {
            this.setCursorPos(f2, f3, l2);
        }
    }
}

