/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.MouseEventQueue;

final class MacOSXMouseEventQueue
extends MouseEventQueue {
    private final IntBuffer delta_buffer = BufferUtils.createIntBuffer(2);
    private boolean skip_event;
    private static boolean is_grabbed;

    MacOSXMouseEventQueue(Component component) {
        super(component);
    }

    public void setGrabbed(boolean bl2) {
        if (is_grabbed != bl2) {
            super.setGrabbed(bl2);
            this.warpCursor();
            MacOSXMouseEventQueue.grabMouse(bl2);
        }
    }

    private static synchronized void grabMouse(boolean bl2) {
        is_grabbed = bl2;
        if (!bl2) {
            MacOSXMouseEventQueue.nGrabMouse(bl2);
        }
    }

    protected void resetCursorToCenter() {
        super.resetCursorToCenter();
        MacOSXMouseEventQueue.getMouseDeltas(this.delta_buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDeltas(long l2) {
        super.updateDeltas(l2);
        MacOSXMouseEventQueue macOSXMouseEventQueue = this;
        synchronized (macOSXMouseEventQueue) {
            MacOSXMouseEventQueue.getMouseDeltas(this.delta_buffer);
            int n2 = this.delta_buffer.get(0);
            int n3 = -this.delta_buffer.get(1);
            if (this.skip_event) {
                this.skip_event = false;
                MacOSXMouseEventQueue.nGrabMouse(this.isGrabbed());
                return;
            }
            if (n2 != 0 || n3 != 0) {
                this.putMouseEventWithCoords((byte)-1, (byte)0, n2, n3, 0, l2);
                this.addDelta(n2, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void warpCursor() {
        Object object = this;
        synchronized (object) {
            this.skip_event = this.isGrabbed();
        }
        if (this.isGrabbed()) {
            object = this.getComponent().getBounds();
            Point point = this.getComponent().getLocationOnScreen();
            int n2 = point.x + ((Rectangle)object).width / 2;
            int n3 = point.y + ((Rectangle)object).height / 2;
            MacOSXMouseEventQueue.nWarpCursor(n2, n3);
        }
    }

    private static native void getMouseDeltas(IntBuffer var0);

    private static native void nWarpCursor(int var0, int var1);

    static native void nGrabMouse(boolean var0);
}

