/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.Robot;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.AWTUtil;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.KeyboardEventQueue;
import org.lwjgl.opengl.MacOSXCanvasPeerInfo;
import org.lwjgl.opengl.MacOSXDisplayPeerInfo;
import org.lwjgl.opengl.MacOSXMouseEventQueue;
import org.lwjgl.opengl.MacOSXNativeKeyboard;
import org.lwjgl.opengl.MacOSXNativeMouse;
import org.lwjgl.opengl.MacOSXPbufferPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;

final class MacOSXDisplay
implements DisplayImplementation {
    private static final int PBUFFER_HANDLE_SIZE = 24;
    private static final int GAMMA_LENGTH = 256;
    private Canvas canvas;
    private Robot robot;
    private MacOSXMouseEventQueue mouse_queue;
    private KeyboardEventQueue keyboard_queue;
    private DisplayMode requested_mode;
    private MacOSXNativeMouse mouse;
    private MacOSXNativeKeyboard keyboard;
    private ByteBuffer window;
    private ByteBuffer context;
    private boolean skipViewportValue = false;
    private static final IntBuffer current_viewport = BufferUtils.createIntBuffer(16);
    private boolean mouseInsideWindow;
    private boolean close_requested;
    private boolean native_mode = true;
    private boolean updateNativeCursor = false;
    private long currentNativeCursor = 0L;
    private boolean enableHighDPI = false;
    private float scaleFactor = 1.0f;

    MacOSXDisplay() {
    }

    private native ByteBuffer nCreateWindow(int var1, int var2, int var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, ByteBuffer var11, ByteBuffer var12);

    private native Object nGetCurrentDisplayMode();

    private native void nGetDisplayModes(Object var1);

    private native boolean nIsMiniaturized(ByteBuffer var1);

    private native boolean nIsFocused(ByteBuffer var1);

    private native void nSetResizable(ByteBuffer var1, boolean var2);

    private native void nResizeWindow(ByteBuffer var1, int var2, int var3, int var4, int var5);

    private native boolean nWasResized(ByteBuffer var1);

    private native int nGetX(ByteBuffer var1);

    private native int nGetY(ByteBuffer var1);

    private native int nGetWidth(ByteBuffer var1);

    private native int nGetHeight(ByteBuffer var1);

    private native boolean nIsNativeMode(ByteBuffer var1);

    private static boolean isUndecorated() {
        return Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated");
    }

    public void createWindow(DrawableLWJGL drawableLWJGL, DisplayMode displayMode, Canvas canvas, int n2, int n3) {
        boolean bl2 = Display.isFullscreen();
        boolean bl3 = Display.isResizable();
        boolean bl4 = canvas != null && !bl2;
        boolean bl5 = LWJGLUtil.isMacOSXEqualsOrBetterThan(10, 7) && canvas == null && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.disableOSXFullscreenModeAPI");
        this.enableHighDPI = LWJGLUtil.isMacOSXEqualsOrBetterThan(10, 7) && canvas == null && (Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.enableHighDPI") || bl2);
        this.canvas = bl4 ? canvas : null;
        this.close_requested = false;
        DrawableGL drawableGL = (DrawableGL)Display.getDrawable();
        PeerInfo peerInfo = drawableGL.peer_info;
        ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
        ByteBuffer byteBuffer2 = bl4 ? ((MacOSXCanvasPeerInfo)peerInfo).window_handle : this.window;
        try {
            this.window = this.nCreateWindow(n2, n3, displayMode.getWidth(), displayMode.getHeight(), bl2, MacOSXDisplay.isUndecorated(), bl3, bl4, bl5, this.enableHighDPI, byteBuffer, byteBuffer2);
            if (bl2) {
                this.skipViewportValue = true;
                current_viewport.put(2, displayMode.getWidth());
                current_viewport.put(3, displayMode.getHeight());
            }
            this.native_mode = this.nIsNativeMode(byteBuffer);
            if (!this.native_mode) {
                this.robot = AWTUtil.createRobot(this.canvas);
            }
        }
        catch (LWJGLException lWJGLException) {
            this.destroyWindow();
            throw lWJGLException;
        }
        finally {
            peerInfo.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleQuit() {
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            this.close_requested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseInsideWindow(boolean bl2) {
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            this.mouseInsideWindow = bl2;
        }
        this.updateNativeCursor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScaleFactor(float f2) {
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            this.scaleFactor = f2;
        }
    }

    public native void nDestroyCALayer(ByteBuffer var1);

    public native void nDestroyWindow(ByteBuffer var1);

    public void destroyWindow() {
        if (!this.native_mode) {
            DrawableGL drawableGL = (DrawableGL)Display.getDrawable();
            PeerInfo peerInfo = drawableGL.peer_info;
            if (peerInfo != null) {
                ByteBuffer byteBuffer = peerInfo.getHandle();
                this.nDestroyCALayer(byteBuffer);
            }
            this.robot = null;
        }
        this.nDestroyWindow(this.window);
    }

    public int getGammaRampLength() {
        return 256;
    }

    public native void setGammaRamp(FloatBuffer var1);

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    private static boolean equals(DisplayMode displayMode, DisplayMode displayMode2) {
        return displayMode.getWidth() == displayMode2.getWidth() && displayMode.getHeight() == displayMode2.getHeight() && displayMode.getBitsPerPixel() == displayMode2.getBitsPerPixel() && displayMode.getFrequency() == displayMode2.getFrequency();
    }

    public void switchDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray;
        for (DisplayMode displayMode2 : displayModeArray = this.getAvailableDisplayModes()) {
            if (!MacOSXDisplay.equals(displayMode2, displayMode)) continue;
            this.requested_mode = displayMode2;
            return;
        }
        throw new LWJGLException(displayMode + " is not supported");
    }

    public void resetDisplayMode() {
        this.requested_mode = null;
        this.restoreGamma();
    }

    private native void restoreGamma();

    public Object createDisplayMode(int n2, int n3, int n4, int n5) {
        return new DisplayMode(n2, n3, n4, n5);
    }

    public DisplayMode init() {
        return (DisplayMode)this.nGetCurrentDisplayMode();
    }

    public void addDisplayMode(Object object, int n2, int n3, int n4, int n5) {
        List list = (List)object;
        DisplayMode displayMode = new DisplayMode(n2, n3, n4, n5);
        list.add(displayMode);
    }

    public DisplayMode[] getAvailableDisplayModes() {
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        this.nGetDisplayModes(arrayList);
        arrayList.add(Display.getDesktopDisplayMode());
        return arrayList.toArray(new DisplayMode[arrayList.size()]);
    }

    private native void nSetTitle(ByteBuffer var1, ByteBuffer var2);

    public void setTitle(String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(string);
        this.nSetTitle(this.window, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCloseRequested() {
        boolean bl2;
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            bl2 = this.close_requested;
            this.close_requested = false;
        }
        return bl2;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isActive() {
        if (this.native_mode) {
            return this.nIsFocused(this.window);
        }
        return Display.getParent().hasFocus();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public boolean isDirty() {
        return false;
    }

    public PeerInfo createPeerInfo(PixelFormat pixelFormat, ContextAttribs contextAttribs) {
        try {
            return new MacOSXDisplayPeerInfo(pixelFormat, contextAttribs, true);
        }
        catch (LWJGLException lWJGLException) {
            return new MacOSXDisplayPeerInfo(pixelFormat, contextAttribs, false);
        }
    }

    public void update() {
        boolean bl2 = true;
        DrawableGL drawableGL = (DrawableGL)Display.getDrawable();
        if (bl2) {
            if (this.skipViewportValue) {
                this.skipViewportValue = false;
            } else {
                GL11.glGetInteger(2978, current_viewport);
            }
            drawableGL.context.update();
            GL11.glViewport(current_viewport.get(0), current_viewport.get(1), current_viewport.get(2), current_viewport.get(3));
        }
        if (this.native_mode && this.updateNativeCursor) {
            this.updateNativeCursor = false;
            try {
                this.setNativeCursor(this.currentNativeCursor);
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
        }
    }

    public void reshape(int n2, int n3, int n4, int n5) {
    }

    public boolean hasWheel() {
        return AWTUtil.hasWheel();
    }

    public int getButtonCount() {
        return AWTUtil.getButtonCount();
    }

    public void createMouse() {
        if (this.native_mode) {
            this.mouse = new MacOSXNativeMouse(this, this.window);
            this.mouse.register();
        } else {
            this.mouse_queue = new MacOSXMouseEventQueue(this.canvas);
            this.mouse_queue.register();
        }
    }

    public void destroyMouse() {
        if (this.native_mode) {
            try {
                MacOSXNativeMouse.setCursor(0L);
            }
            catch (LWJGLException lWJGLException) {
                // empty catch block
            }
            this.grabMouse(false);
            if (this.mouse != null) {
                this.mouse.unregister();
            }
            this.mouse = null;
        } else {
            if (this.mouse_queue != null) {
                MacOSXMouseEventQueue.nGrabMouse(false);
                this.mouse_queue.unregister();
            }
            this.mouse_queue = null;
        }
    }

    public void pollMouse(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (this.native_mode) {
            this.mouse.poll(intBuffer, byteBuffer);
        } else {
            this.mouse_queue.poll(intBuffer, byteBuffer);
        }
    }

    public void readMouse(ByteBuffer byteBuffer) {
        if (this.native_mode) {
            this.mouse.copyEvents(byteBuffer);
        } else {
            this.mouse_queue.copyEvents(byteBuffer);
        }
    }

    public void grabMouse(boolean bl2) {
        if (this.native_mode) {
            this.mouse.setGrabbed(bl2);
        } else {
            this.mouse_queue.setGrabbed(bl2);
        }
    }

    public int getNativeCursorCapabilities() {
        if (this.native_mode) {
            return 7;
        }
        return AWTUtil.getNativeCursorCapabilities();
    }

    public void setCursorPosition(int n2, int n3) {
        if (this.native_mode && this.mouse != null) {
            this.mouse.setCursorPosition(n2, n3);
        }
    }

    public void setNativeCursor(Object object) {
        if (this.native_mode) {
            this.currentNativeCursor = MacOSXDisplay.getCursorHandle(object);
            if (Display.isCreated()) {
                if (this.mouseInsideWindow) {
                    MacOSXNativeMouse.setCursor(this.currentNativeCursor);
                } else {
                    MacOSXNativeMouse.setCursor(0L);
                }
            }
        }
    }

    public int getMinCursorSize() {
        return 1;
    }

    public int getMaxCursorSize() {
        DisplayMode displayMode = Display.getDesktopDisplayMode();
        return Math.min(displayMode.getWidth(), displayMode.getHeight()) / 2;
    }

    public void createKeyboard() {
        if (this.native_mode) {
            this.keyboard = new MacOSXNativeKeyboard(this.window);
            this.keyboard.register();
        } else {
            this.keyboard_queue = new KeyboardEventQueue(this.canvas);
            this.keyboard_queue.register();
        }
    }

    public void destroyKeyboard() {
        if (this.native_mode) {
            if (this.keyboard != null) {
                this.keyboard.unregister();
            }
            this.keyboard = null;
        } else {
            if (this.keyboard_queue != null) {
                this.keyboard_queue.unregister();
            }
            this.keyboard_queue = null;
        }
    }

    public void pollKeyboard(ByteBuffer byteBuffer) {
        if (this.native_mode) {
            this.keyboard.poll(byteBuffer);
        } else {
            this.keyboard_queue.poll(byteBuffer);
        }
    }

    public void readKeyboard(ByteBuffer byteBuffer) {
        if (this.native_mode) {
            this.keyboard.copyEvents(byteBuffer);
        } else {
            this.keyboard_queue.copyEvents(byteBuffer);
        }
    }

    public Object createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (this.native_mode) {
            long l2 = MacOSXNativeMouse.createCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer2);
            return l2;
        }
        return AWTUtil.createCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer2);
    }

    public void destroyCursor(Object object) {
        long l2 = MacOSXDisplay.getCursorHandle(object);
        if (this.currentNativeCursor == l2) {
            this.currentNativeCursor = 0L;
        }
        MacOSXNativeMouse.destroyCursor(l2);
    }

    private static long getCursorHandle(Object object) {
        return object != null ? (Long)object : 0L;
    }

    public int getPbufferCapabilities() {
        return 1;
    }

    public boolean isBufferLost(PeerInfo peerInfo) {
        return false;
    }

    public PeerInfo createPbuffer(int n2, int n3, PixelFormat pixelFormat, ContextAttribs contextAttribs, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return new MacOSXPbufferPeerInfo(n2, n3, pixelFormat, contextAttribs);
    }

    public void setPbufferAttrib(PeerInfo peerInfo, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(PeerInfo peerInfo, int n2) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(PeerInfo peerInfo, int n2) {
        throw new UnsupportedOperationException();
    }

    public int setIcon(ByteBuffer[] byteBufferArray) {
        return 0;
    }

    public int getX() {
        return this.nGetX(this.window);
    }

    public int getY() {
        return this.nGetY(this.window);
    }

    public int getWidth() {
        return this.nGetWidth(this.window);
    }

    public int getHeight() {
        return this.nGetHeight(this.window);
    }

    public boolean isInsideWindow() {
        return this.mouseInsideWindow;
    }

    public void setResizable(boolean bl2) {
        this.nSetResizable(this.window, bl2);
    }

    public boolean wasResized() {
        return this.nWasResized(this.window);
    }

    public float getPixelScaleFactor() {
        return this.enableHighDPI && !Display.isFullscreen() ? this.scaleFactor : 1.0f;
    }
}

