/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.nio.ByteBuffer;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.lwjgl.opengl.AWTSurfaceLock;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.MacOSXPeerInfo;
import org.lwjgl.opengl.PixelFormat;

abstract class MacOSXCanvasPeerInfo
extends MacOSXPeerInfo {
    private final AWTSurfaceLock awt_surface = new AWTSurfaceLock();
    public ByteBuffer window_handle;

    protected MacOSXCanvasPeerInfo(PixelFormat pixelFormat, ContextAttribs contextAttribs, boolean bl2) {
        super(pixelFormat, contextAttribs, true, true, bl2, true);
    }

    protected void initHandle(Canvas canvas) {
        boolean bl2 = true;
        boolean bl3 = true;
        String string = System.getProperty("java.version");
        if (string.startsWith("1.5") || string.startsWith("1.6")) {
            bl2 = false;
        } else if (string.startsWith("1.7")) {
            bl3 = false;
        }
        Insets insets = MacOSXCanvasPeerInfo.getInsets(canvas);
        int n2 = insets != null ? insets.top : 0;
        int n3 = insets != null ? insets.left : 0;
        this.window_handle = MacOSXCanvasPeerInfo.nInitHandle(this.awt_surface.lockAndGetHandle(canvas), this.getHandle(), this.window_handle, bl2, bl3, canvas.getX() - n3, canvas.getY() - n2);
        if (string.startsWith("1.7")) {
            this.addComponentListener(canvas);
            MacOSXCanvasPeerInfo.reSetLayerBounds(canvas, this.getHandle());
        }
    }

    private void addComponentListener(final Canvas canvas) {
        ComponentListener[] componentListenerArray = canvas.getComponentListeners();
        for (int i2 = 0; i2 < componentListenerArray.length; ++i2) {
            ComponentListener componentListener = componentListenerArray[i2];
            if (componentListener.toString() != "CanvasPeerInfoListener") continue;
            return;
        }
        ComponentListener componentListener = new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                MacOSXCanvasPeerInfo.reSetLayerBounds(canvas, MacOSXCanvasPeerInfo.this.getHandle());
            }

            public void componentResized(ComponentEvent componentEvent) {
                MacOSXCanvasPeerInfo.reSetLayerBounds(canvas, MacOSXCanvasPeerInfo.this.getHandle());
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public String toString() {
                return "CanvasPeerInfoListener";
            }
        };
        canvas.addComponentListener(componentListener);
    }

    private static native ByteBuffer nInitHandle(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, boolean var3, boolean var4, int var5, int var6);

    private static native void nSetLayerPosition(ByteBuffer var0, int var1, int var2);

    private static native void nSetLayerBounds(ByteBuffer var0, int var1, int var2, int var3, int var4);

    private static void reSetLayerBounds(Canvas canvas, ByteBuffer byteBuffer) {
        Component component = SwingUtilities.getRoot(canvas);
        Point point = SwingUtilities.convertPoint(canvas.getParent(), canvas.getLocation(), component);
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        Insets insets = MacOSXCanvasPeerInfo.getInsets(canvas);
        int n4 = insets != null ? insets.left : 0;
        n3 -= insets != null ? insets.top : 0;
        n3 = component.getHeight() - n3 - canvas.getHeight();
        MacOSXCanvasPeerInfo.nSetLayerBounds(byteBuffer, n2 -= n4, n3, canvas.getWidth(), canvas.getHeight());
    }

    protected void doUnlock() {
        this.awt_surface.unlock();
    }

    private static Insets getInsets(Canvas canvas) {
        JRootPane jRootPane = SwingUtilities.getRootPane(canvas);
        if (jRootPane != null) {
            return ((Container)jRootPane).getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }
}

