/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.LinuxEvent;

final class LinuxMouse {
    private static final int POINTER_WARP_BORDER = 10;
    private static final int WHEEL_SCALE = 120;
    private int button_count;
    private static final int Button1 = 1;
    private static final int Button2 = 2;
    private static final int Button3 = 3;
    private static final int Button4 = 4;
    private static final int Button5 = 5;
    private static final int Button6 = 6;
    private static final int Button7 = 7;
    private static final int Button8 = 8;
    private static final int Button9 = 9;
    private static final int ButtonPress = 4;
    private static final int ButtonRelease = 5;
    private final long display;
    private final long window;
    private final long input_window;
    private final long warp_atom;
    private final IntBuffer query_pointer_buffer = BufferUtils.createIntBuffer(4);
    private final ByteBuffer event_buffer = ByteBuffer.allocate(22);
    private int last_x;
    private int last_y;
    private int accum_dx;
    private int accum_dy;
    private int accum_dz;
    private byte[] buttons;
    private EventQueue event_queue;
    private long last_event_nanos;

    LinuxMouse(long l2, long l3, long l4) {
        this.display = l2;
        this.window = l3;
        this.input_window = l4;
        this.warp_atom = LinuxDisplay.nInternAtom(l2, "_LWJGL", false);
        this.button_count = LinuxMouse.nGetButtonCount(l2);
        this.buttons = new byte[this.button_count];
        this.reset(false, false);
    }

    private void reset(boolean bl2, boolean bl3) {
        this.event_queue = new EventQueue(this.event_buffer.capacity());
        this.accum_dy = 0;
        this.accum_dx = 0;
        long l2 = LinuxMouse.nQueryPointer(this.display, this.window, this.query_pointer_buffer);
        int n2 = this.query_pointer_buffer.get(0);
        int n3 = this.query_pointer_buffer.get(1);
        int n4 = this.query_pointer_buffer.get(2);
        int n5 = this.query_pointer_buffer.get(3);
        this.last_x = n4;
        this.last_y = this.transformY(n5);
        this.doHandlePointerMotion(bl2, bl3, l2, n2, n3, n4, n5, this.last_event_nanos);
    }

    public void read(ByteBuffer byteBuffer) {
        this.event_queue.copyEvents(byteBuffer);
    }

    public void poll(boolean bl2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (bl2) {
            intBuffer.put(0, this.accum_dx);
            intBuffer.put(1, this.accum_dy);
        } else {
            intBuffer.put(0, this.last_x);
            intBuffer.put(1, this.last_y);
        }
        intBuffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
        for (int i2 = 0; i2 < this.buttons.length; ++i2) {
            byteBuffer.put(i2, this.buttons[i2]);
        }
    }

    private void putMouseEventWithCoords(byte by2, byte by3, int n2, int n3, int n4, long l2) {
        this.event_buffer.clear();
        this.event_buffer.put(by2).put(by3).putInt(n2).putInt(n3).putInt(n4).putLong(l2);
        this.event_buffer.flip();
        this.event_queue.putEvent(this.event_buffer);
        this.last_event_nanos = l2;
    }

    private void setCursorPos(boolean bl2, int n2, int n3, long l2) {
        n3 = this.transformY(n3);
        int n4 = n2 - this.last_x;
        int n5 = n3 - this.last_y;
        if (n4 != 0 || n5 != 0) {
            this.accum_dx += n4;
            this.accum_dy += n5;
            this.last_x = n2;
            this.last_y = n3;
            if (bl2) {
                this.putMouseEventWithCoords((byte)-1, (byte)0, n4, n5, 0, l2);
            } else {
                this.putMouseEventWithCoords((byte)-1, (byte)0, n2, n3, 0, l2);
            }
        }
    }

    private void doWarpPointer(int n2, int n3) {
        LinuxMouse.nSendWarpEvent(this.display, this.input_window, this.warp_atom, n2, n3);
        LinuxMouse.nWarpCursor(this.display, this.window, n2, n3);
    }

    private static native void nSendWarpEvent(long var0, long var2, long var4, int var6, int var7);

    private void doHandlePointerMotion(boolean bl2, boolean bl3, long l2, int n2, int n3, int n4, int n5, long l3) {
        boolean bl4;
        this.setCursorPos(bl2, n4, n5, l3);
        if (!bl3) {
            return;
        }
        int n6 = LinuxMouse.nGetWindowHeight(this.display, l2);
        int n7 = LinuxMouse.nGetWindowWidth(this.display, l2);
        int n8 = LinuxMouse.nGetWindowHeight(this.display, this.window);
        int n9 = LinuxMouse.nGetWindowWidth(this.display, this.window);
        int n10 = n2 - n4;
        int n11 = n3 - n5;
        int n12 = n10 + n9;
        int n13 = n11 + n8;
        int n14 = Math.max(0, n10);
        int n15 = Math.max(0, n11);
        int n16 = Math.min(n7, n12);
        int n17 = Math.min(n6, n13);
        boolean bl5 = bl4 = n2 < n14 + 10 || n3 < n15 + 10 || n2 > n16 - 10 || n3 > n17 - 10;
        if (bl4) {
            int n18 = (n16 - n14) / 2;
            int n19 = (n17 - n15) / 2;
            this.doWarpPointer(n18, n19);
        }
    }

    public void changeGrabbed(boolean bl2, boolean bl3) {
        this.reset(bl2, bl3);
    }

    public int getButtonCount() {
        return this.buttons.length;
    }

    private int transformY(int n2) {
        return LinuxMouse.nGetWindowHeight(this.display, this.window) - 1 - n2;
    }

    private static native int nGetWindowHeight(long var0, long var2);

    private static native int nGetWindowWidth(long var0, long var2);

    private static native int nGetButtonCount(long var0);

    private static native long nQueryPointer(long var0, long var2, IntBuffer var4);

    public void setCursorPosition(int n2, int n3) {
        LinuxMouse.nWarpCursor(this.display, this.window, n2, this.transformY(n3));
    }

    private static native void nWarpCursor(long var0, long var2, int var4, int var5);

    private void handlePointerMotion(boolean bl2, boolean bl3, long l2, long l3, int n2, int n3, int n4, int n5) {
        this.doHandlePointerMotion(bl2, bl3, l3, n2, n3, n4, n5, l2 * 1000000L);
    }

    private void handleButton(boolean bl2, int n2, byte by2, long l2) {
        byte by3;
        switch (n2) {
            case 1: {
                by3 = 0;
                break;
            }
            case 2: {
                by3 = 2;
                break;
            }
            case 3: {
                by3 = 1;
                break;
            }
            case 6: {
                by3 = 5;
                break;
            }
            case 7: {
                by3 = 6;
                break;
            }
            case 8: {
                by3 = 3;
                break;
            }
            case 9: {
                by3 = 4;
                break;
            }
            default: {
                if (n2 > 9 && n2 <= this.button_count) {
                    by3 = (byte)(n2 - 1);
                    break;
                }
                return;
            }
        }
        this.buttons[by3] = by2;
        this.putMouseEvent(bl2, by3, by2, 0, l2);
    }

    private void putMouseEvent(boolean bl2, byte by2, byte by3, int n2, long l2) {
        if (bl2) {
            this.putMouseEventWithCoords(by2, by3, 0, 0, n2, l2);
        } else {
            this.putMouseEventWithCoords(by2, by3, this.last_x, this.last_y, n2, l2);
        }
    }

    private void handleButtonPress(boolean bl2, byte by2, long l2) {
        int n2 = 0;
        switch (by2) {
            case 4: {
                n2 = 120;
                this.putMouseEvent(bl2, (byte)-1, (byte)0, n2, l2);
                this.accum_dz += n2;
                break;
            }
            case 5: {
                n2 = -120;
                this.putMouseEvent(bl2, (byte)-1, (byte)0, n2, l2);
                this.accum_dz += n2;
                break;
            }
            default: {
                this.handleButton(bl2, by2, (byte)1, l2);
            }
        }
    }

    private void handleButtonEvent(boolean bl2, long l2, int n2, byte by2) {
        long l3 = l2 * 1000000L;
        switch (n2) {
            case 5: {
                this.handleButton(bl2, by2, (byte)0, l3);
                break;
            }
            case 4: {
                this.handleButtonPress(bl2, by2, l3);
                break;
            }
        }
    }

    private void resetCursor(int n2, int n3) {
        this.last_x = n2;
        this.last_y = this.transformY(n3);
    }

    private void handleWarpEvent(int n2, int n3) {
        this.resetCursor(n2, n3);
    }

    public boolean filterEvent(boolean bl2, boolean bl3, LinuxEvent linuxEvent) {
        switch (linuxEvent.getType()) {
            case 33: {
                if (linuxEvent.getClientMessageType() != this.warp_atom) break;
                this.handleWarpEvent(linuxEvent.getClientData(0), linuxEvent.getClientData(1));
                return true;
            }
            case 4: 
            case 5: {
                this.handleButtonEvent(bl2, linuxEvent.getButtonTime(), linuxEvent.getButtonType(), (byte)linuxEvent.getButtonButton());
                return true;
            }
            case 6: {
                this.handlePointerMotion(bl2, bl3, linuxEvent.getButtonTime(), linuxEvent.getButtonRoot(), linuxEvent.getButtonXRoot(), linuxEvent.getButtonYRoot(), linuxEvent.getButtonX(), linuxEvent.getButtonY());
                return true;
            }
        }
        return false;
    }
}

