/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.LinuxEvent;
import org.lwjgl.opengl.LinuxKeycodes;

final class LinuxKeyboard {
    private static final int LockMapIndex = 1;
    private static final long NoSymbol = 0L;
    private static final long ShiftMask = 1L;
    private static final long LockMask = 2L;
    private static final int XLookupChars = 2;
    private static final int XLookupBoth = 4;
    private static final int KEYBOARD_BUFFER_SIZE = 50;
    private final long xim;
    private final long xic;
    private final int numlock_mask;
    private final int modeswitch_mask;
    private final int caps_lock_mask;
    private final int shift_lock_mask;
    private final ByteBuffer compose_status;
    private final byte[] key_down_buffer = new byte[256];
    private final EventQueue event_queue = new EventQueue(18);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(18);
    private final int[] temp_translation_buffer = new int[50];
    private final ByteBuffer native_translation_buffer = BufferUtils.createByteBuffer(50);
    private final CharsetDecoder utf8_decoder = Charset.forName("UTF-8").newDecoder();
    private final CharBuffer char_buffer = CharBuffer.allocate(50);
    private boolean has_deferred_event;
    private int deferred_keycode;
    private int deferred_event_keycode;
    private long deferred_nanos;
    private byte deferred_key_state;

    LinuxKeyboard(long l2, long l3) {
        long l4 = LinuxKeyboard.getModifierMapping(l2);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (l4 != 0L) {
            int n6 = LinuxKeyboard.getMaxKeyPerMod(l4);
            for (int i2 = 0; i2 < 8; ++i2) {
                block7: for (int i3 = 0; i3 < n6; ++i3) {
                    int n7 = LinuxKeyboard.lookupModifierMap(l4, i2 * n6 + i3);
                    int n8 = (int)LinuxKeyboard.keycodeToKeySym(l2, n7);
                    int n9 = 1 << i2;
                    switch (n8) {
                        case 65407: {
                            n2 |= n9;
                            continue block7;
                        }
                        case 65406: {
                            n3 |= n9;
                            continue block7;
                        }
                        case 65509: {
                            if (i2 != 1) continue block7;
                            n4 = n9;
                            n5 = 0;
                            continue block7;
                        }
                        case 65510: {
                            if (i2 != 1 || n4 != 0) continue block7;
                            n5 = n9;
                            continue block7;
                        }
                    }
                }
            }
            LinuxKeyboard.freeModifierMapping(l4);
        }
        this.numlock_mask = n2;
        this.modeswitch_mask = n3;
        this.caps_lock_mask = n4;
        this.shift_lock_mask = n5;
        LinuxKeyboard.setDetectableKeyRepeat(l2, true);
        this.xim = LinuxKeyboard.openIM(l2);
        if (this.xim != 0L) {
            this.xic = LinuxKeyboard.createIC(this.xim, l3);
            if (this.xic != 0L) {
                LinuxKeyboard.setupIMEventMask(l2, l3, this.xic);
            } else {
                this.destroy(l2);
            }
        } else {
            this.xic = 0L;
        }
        this.compose_status = LinuxKeyboard.allocateComposeStatus();
    }

    private static native long getModifierMapping(long var0);

    private static native void freeModifierMapping(long var0);

    private static native int getMaxKeyPerMod(long var0);

    private static native int lookupModifierMap(long var0, int var2);

    private static native long keycodeToKeySym(long var0, int var2);

    private static native long openIM(long var0);

    private static native long createIC(long var0, long var2);

    private static native void setupIMEventMask(long var0, long var2, long var4);

    private static native ByteBuffer allocateComposeStatus();

    private static void setDetectableKeyRepeat(long l2, boolean bl2) {
        boolean bl3 = LinuxKeyboard.nSetDetectableKeyRepeat(l2, bl2);
        if (!bl3) {
            LWJGLUtil.log("Failed to set detectable key repeat to " + bl2);
        }
    }

    private static native boolean nSetDetectableKeyRepeat(long var0, boolean var2);

    public void destroy(long l2) {
        if (this.xic != 0L) {
            LinuxKeyboard.destroyIC(this.xic);
        }
        if (this.xim != 0L) {
            LinuxKeyboard.closeIM(this.xim);
        }
        LinuxKeyboard.setDetectableKeyRepeat(l2, false);
    }

    private static native void destroyIC(long var0);

    private static native void closeIM(long var0);

    public void read(ByteBuffer byteBuffer) {
        this.flushDeferredEvent();
        this.event_queue.copyEvents(byteBuffer);
    }

    public void poll(ByteBuffer byteBuffer) {
        this.flushDeferredEvent();
        int n2 = byteBuffer.position();
        byteBuffer.put(this.key_down_buffer);
        byteBuffer.position(n2);
    }

    private void putKeyboardEvent(int n2, byte by2, int n3, long l2, boolean bl2) {
        this.tmp_event.clear();
        this.tmp_event.putInt(n2).put(by2).putInt(n3).putLong(l2).put(bl2 ? (byte)1 : 0);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
    }

    private int lookupStringISO88591(long l2, int[] nArray) {
        int n2 = LinuxKeyboard.lookupString(l2, this.native_translation_buffer, this.compose_status);
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.native_translation_buffer.get(i2) & 0xFF;
        }
        return n2;
    }

    private static native int lookupString(long var0, ByteBuffer var2, ByteBuffer var3);

    private int lookupStringUnicode(long l2, int[] nArray) {
        int n2 = LinuxKeyboard.utf8LookupString(this.xic, l2, this.native_translation_buffer, this.native_translation_buffer.position(), this.native_translation_buffer.remaining());
        if (n2 != 2 && n2 != 4) {
            return 0;
        }
        this.native_translation_buffer.flip();
        this.utf8_decoder.decode(this.native_translation_buffer, this.char_buffer, true);
        this.native_translation_buffer.compact();
        this.char_buffer.flip();
        int n3 = 0;
        while (this.char_buffer.hasRemaining() && n3 < nArray.length) {
            nArray[n3++] = this.char_buffer.get();
        }
        this.char_buffer.compact();
        return n3;
    }

    private static native int utf8LookupString(long var0, long var2, ByteBuffer var4, int var5, int var6);

    private int lookupString(long l2, int[] nArray) {
        if (this.xic != 0L) {
            return this.lookupStringUnicode(l2, nArray);
        }
        return this.lookupStringISO88591(l2, nArray);
    }

    private void translateEvent(long l2, int n2, byte by2, long l3, boolean bl2) {
        int n3 = this.lookupString(l2, this.temp_translation_buffer);
        if (n3 > 0) {
            int n4 = this.temp_translation_buffer[0];
            this.putKeyboardEvent(n2, by2, n4, l3, bl2);
            for (int i2 = 1; i2 < n3; ++i2) {
                n4 = this.temp_translation_buffer[i2];
                this.putKeyboardEvent(0, (byte)0, n4, l3, bl2);
            }
        } else {
            this.putKeyboardEvent(n2, by2, 0, l3, bl2);
        }
    }

    private static boolean isKeypadKeysym(long l2) {
        return 65408L <= l2 && l2 <= 65469L || 0x11000000L <= l2 && l2 <= 0x1100FFFFL;
    }

    private static boolean isNoSymbolOrVendorSpecific(long l2) {
        return l2 == 0L || (l2 & 0x10000000L) != 0L;
    }

    private static long getKeySym(long l2, int n2, int n3) {
        long l3 = LinuxKeyboard.lookupKeysym(l2, n2 * 2 + n3);
        if (LinuxKeyboard.isNoSymbolOrVendorSpecific(l3) && n3 == 1) {
            l3 = LinuxKeyboard.lookupKeysym(l2, n2 * 2 + 0);
        }
        if (LinuxKeyboard.isNoSymbolOrVendorSpecific(l3) && n2 == 1) {
            l3 = LinuxKeyboard.getKeySym(l2, 0, n3);
        }
        return l3;
    }

    private static native long lookupKeysym(long var0, int var2);

    private static native long toUpper(long var0);

    private long mapEventToKeySym(long l2, int n2) {
        long l3;
        int n3 = (n2 & this.modeswitch_mask) != 0 ? 1 : 0;
        if ((n2 & this.numlock_mask) != 0 && LinuxKeyboard.isKeypadKeysym(l3 = LinuxKeyboard.getKeySym(l2, n3, 1))) {
            if (((long)n2 & (1L | (long)this.shift_lock_mask)) != 0L) {
                return LinuxKeyboard.getKeySym(l2, n3, 0);
            }
            return l3;
        }
        if (((long)n2 & 3L) == 0L) {
            return LinuxKeyboard.getKeySym(l2, n3, 0);
        }
        if (((long)n2 & 1L) == 0L) {
            l3 = LinuxKeyboard.getKeySym(l2, n3, 0);
            if ((n2 & this.caps_lock_mask) != 0) {
                l3 = LinuxKeyboard.toUpper(l3);
            }
            return l3;
        }
        l3 = LinuxKeyboard.getKeySym(l2, n3, 1);
        if ((n2 & this.caps_lock_mask) != 0) {
            l3 = LinuxKeyboard.toUpper(l3);
        }
        return l3;
    }

    private int getKeycode(long l2, int n2) {
        long l3 = this.mapEventToKeySym(l2, n2);
        int n3 = LinuxKeycodes.mapKeySymToLWJGLKeyCode(l3);
        if (n3 == 0) {
            l3 = LinuxKeyboard.lookupKeysym(l2, 0);
            n3 = LinuxKeycodes.mapKeySymToLWJGLKeyCode(l3);
        }
        return n3;
    }

    private static byte getKeyState(int n2) {
        switch (n2) {
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unknown event_type: " + n2);
    }

    void releaseAll() {
        for (int i2 = 0; i2 < this.key_down_buffer.length; ++i2) {
            if (this.key_down_buffer[i2] == 0) continue;
            this.key_down_buffer[i2] = 0;
            this.putKeyboardEvent(i2, (byte)0, 0, 0L, false);
        }
    }

    private void handleKeyEvent(long l2, long l3, int n2, int n3, int n4) {
        boolean bl2;
        int n5 = this.getKeycode(l2, n4);
        byte by2 = LinuxKeyboard.getKeyState(n2);
        boolean bl3 = bl2 = by2 == this.key_down_buffer[n5];
        if (bl2 && n2 == 3) {
            return;
        }
        this.key_down_buffer[n5] = by2;
        long l4 = l3 * 1000000L;
        if (n2 == 2) {
            if (this.has_deferred_event) {
                if (l4 == this.deferred_nanos && n3 == this.deferred_event_keycode) {
                    this.has_deferred_event = false;
                    bl2 = true;
                } else {
                    this.flushDeferredEvent();
                }
            }
            this.translateEvent(l2, n5, by2, l4, bl2);
        } else {
            this.flushDeferredEvent();
            this.has_deferred_event = true;
            this.deferred_keycode = n5;
            this.deferred_event_keycode = n3;
            this.deferred_nanos = l4;
            this.deferred_key_state = by2;
        }
    }

    private void flushDeferredEvent() {
        if (this.has_deferred_event) {
            this.putKeyboardEvent(this.deferred_keycode, this.deferred_key_state, 0, this.deferred_nanos, false);
            this.has_deferred_event = false;
        }
    }

    public boolean filterEvent(LinuxEvent linuxEvent) {
        switch (linuxEvent.getType()) {
            case 2: 
            case 3: {
                this.handleKeyEvent(linuxEvent.getKeyAddress(), linuxEvent.getKeyTime(), linuxEvent.getKeyType(), linuxEvent.getKeyKeyCode(), linuxEvent.getKeyState());
                return true;
            }
        }
        return false;
    }
}

