/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.AWTCanvasImplementation;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.DrawableGLES;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.GlobalLock;
import org.lwjgl.opengl.LinuxDisplayPeerInfo;
import org.lwjgl.opengl.LinuxEvent;
import org.lwjgl.opengl.LinuxKeyboard;
import org.lwjgl.opengl.LinuxMouse;
import org.lwjgl.opengl.LinuxPbufferPeerInfo;
import org.lwjgl.opengl.LinuxPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.XRandR;
import org.lwjgl.opengles.GLContext;
import org.lwjgl.opengles.PixelFormat;

final class LinuxDisplay
implements DisplayImplementation {
    public static final int CurrentTime = 0;
    public static final int GrabSuccess = 0;
    public static final int AutoRepeatModeOff = 0;
    public static final int AutoRepeatModeOn = 1;
    public static final int AutoRepeatModeDefault = 2;
    public static final int None = 0;
    private static final int KeyPressMask = 1;
    private static final int KeyReleaseMask = 2;
    private static final int ButtonPressMask = 4;
    private static final int ButtonReleaseMask = 8;
    private static final int NotifyAncestor = 0;
    private static final int NotifyNonlinear = 3;
    private static final int NotifyPointer = 5;
    private static final int NotifyPointerRoot = 6;
    private static final int NotifyDetailNone = 7;
    private static final int SetModeInsert = 0;
    private static final int SaveSetRoot = 1;
    private static final int SaveSetUnmap = 1;
    private static final int X_SetInputFocus = 42;
    private static final int FULLSCREEN_LEGACY = 1;
    private static final int FULLSCREEN_NETWM = 2;
    private static final int WINDOWED = 3;
    private static int current_window_mode = 3;
    private static final int XRANDR = 10;
    private static final int XF86VIDMODE = 11;
    private static final int NONE = 12;
    private static long display;
    private static long current_window;
    private static long saved_error_handler;
    private static int display_connection_usage_count;
    private final LinuxEvent event_buffer = new LinuxEvent();
    private final LinuxEvent tmp_event_buffer = new LinuxEvent();
    private int current_displaymode_extension = 12;
    private long delete_atom;
    private PeerInfo peer_info;
    private ByteBuffer saved_gamma;
    private ByteBuffer current_gamma;
    private DisplayMode saved_mode;
    private DisplayMode current_mode;
    private boolean keyboard_grabbed;
    private boolean pointer_grabbed;
    private boolean input_released;
    private boolean grab;
    private boolean focused;
    private boolean minimized;
    private boolean dirty;
    private boolean close_requested;
    private long current_cursor;
    private long blank_cursor;
    private boolean mouseInside = true;
    private boolean resizable;
    private boolean resized;
    private int window_x;
    private int window_y;
    private int window_width;
    private int window_height;
    private Canvas parent;
    private long parent_window;
    private static boolean xembedded;
    private long parent_proxy_focus_window;
    private boolean parent_focused;
    private boolean parent_focus_changed;
    private long last_window_focus = 0L;
    private LinuxKeyboard keyboard;
    private LinuxMouse mouse;
    private String wm_class;
    private final FocusListener focus_listener = new FocusListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusGained(FocusEvent focusEvent) {
            Object object = GlobalLock.lock;
            synchronized (object) {
                LinuxDisplay.this.parent_focused = true;
                LinuxDisplay.this.parent_focus_changed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusLost(FocusEvent focusEvent) {
            Object object = GlobalLock.lock;
            synchronized (object) {
                LinuxDisplay.this.parent_focused = false;
                LinuxDisplay.this.parent_focus_changed = true;
            }
        }
    };

    LinuxDisplay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getCurrentGammaRamp() {
        LinuxDisplay.lockAWT();
        try {
            block8: {
                ByteBuffer byteBuffer;
                LinuxDisplay.incDisplay();
                try {
                    if (!LinuxDisplay.isXF86VidModeSupported()) break block8;
                    byteBuffer = LinuxDisplay.nGetCurrentGammaRamp(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
                }
                catch (Throwable throwable) {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                LinuxDisplay.decDisplay();
                return byteBuffer;
            }
            ByteBuffer byteBuffer = null;
            LinuxDisplay.decDisplay();
            return byteBuffer;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nGetCurrentGammaRamp(long var0, int var2);

    private static int getBestDisplayModeExtension() {
        int n2;
        if (LinuxDisplay.isXrandrSupported()) {
            LWJGLUtil.log("Using Xrandr for display mode switching");
            n2 = 10;
        } else if (LinuxDisplay.isXF86VidModeSupported()) {
            LWJGLUtil.log("Using XF86VidMode for display mode switching");
            n2 = 11;
        } else {
            LWJGLUtil.log("No display mode extensions available");
            n2 = 12;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXrandrSupported() {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_XRANDR")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl2;
            LinuxDisplay.incDisplay();
            try {
                bl2 = LinuxDisplay.nIsXrandrSupported(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying Xrandr support: " + lWJGLException);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            LinuxDisplay.decDisplay();
            return bl2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXrandrSupported(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXF86VidModeSupported() {
        LinuxDisplay.lockAWT();
        try {
            boolean bl2;
            LinuxDisplay.incDisplay();
            try {
                bl2 = LinuxDisplay.nIsXF86VidModeSupported(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying XF86VM support: " + lWJGLException);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            LinuxDisplay.decDisplay();
            return bl2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXF86VidModeSupported(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNetWMFullscreenSupported() {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_NETWM")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl2;
            LinuxDisplay.incDisplay();
            try {
                bl2 = LinuxDisplay.nIsNetWMFullscreenSupported(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying NetWM support: " + lWJGLException);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            LinuxDisplay.decDisplay();
            return bl2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsNetWMFullscreenSupported(long var0, int var2);

    static void lockAWT() {
        try {
            LinuxDisplay.nLockAWT();
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while locking AWT: " + lWJGLException);
        }
    }

    private static native void nLockAWT();

    static void unlockAWT() {
        try {
            LinuxDisplay.nUnlockAWT();
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while unlocking AWT: " + lWJGLException);
        }
    }

    private static native void nUnlockAWT();

    static void incDisplay() {
        if (display_connection_usage_count == 0) {
            try {
                org.lwjgl.opengl.GLContext.loadOpenGLLibrary();
                GLContext.loadOpenGLLibrary();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            saved_error_handler = LinuxDisplay.setErrorHandler();
            display = LinuxDisplay.openDisplay();
        }
        ++display_connection_usage_count;
    }

    private static native int callErrorHandler(long var0, long var2, long var4);

    private static native long setErrorHandler();

    private static native long resetErrorHandler(long var0);

    private static native void synchronize(long var0, boolean var2);

    private static int globalErrorHandler(long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        if (xembedded && l7 == 42L) {
            return 0;
        }
        if (l2 == LinuxDisplay.getDisplay()) {
            String string = LinuxDisplay.getErrorText(l2, l6);
            throw new LWJGLException("X Error - disp: 0x" + Long.toHexString(l4) + " serial: " + l5 + " error: " + string + " request_code: " + l7 + " minor_code: " + l8);
        }
        if (saved_error_handler != 0L) {
            return LinuxDisplay.callErrorHandler(saved_error_handler, l2, l3);
        }
        return 0;
    }

    private static native String getErrorText(long var0, long var2);

    static void decDisplay() {
    }

    static native long openDisplay();

    static native void closeDisplay(long var0);

    private int getWindowMode(boolean bl2) {
        if (bl2) {
            if (this.current_displaymode_extension == 10 && LinuxDisplay.isNetWMFullscreenSupported()) {
                LWJGLUtil.log("Using NetWM for fullscreen window");
                return 2;
            }
            LWJGLUtil.log("Using legacy mode for fullscreen window");
            return 1;
        }
        return 3;
    }

    static long getDisplay() {
        if (display_connection_usage_count <= 0) {
            throw new InternalError("display_connection_usage_count = " + display_connection_usage_count);
        }
        return display;
    }

    static int getDefaultScreen() {
        return LinuxDisplay.nGetDefaultScreen(LinuxDisplay.getDisplay());
    }

    static native int nGetDefaultScreen(long var0);

    static long getWindow() {
        return current_window;
    }

    private void ungrabKeyboard() {
        if (this.keyboard_grabbed) {
            LinuxDisplay.nUngrabKeyboard(LinuxDisplay.getDisplay());
            this.keyboard_grabbed = false;
        }
    }

    static native int nUngrabKeyboard(long var0);

    private void grabKeyboard() {
        int n2;
        if (!this.keyboard_grabbed && (n2 = LinuxDisplay.nGrabKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow())) == 0) {
            this.keyboard_grabbed = true;
        }
    }

    static native int nGrabKeyboard(long var0, long var2);

    private void grabPointer() {
        int n2;
        if (!this.pointer_grabbed && (n2 = LinuxDisplay.nGrabPointer(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), 0L)) == 0) {
            this.pointer_grabbed = true;
            if (LinuxDisplay.isLegacyFullscreen()) {
                LinuxDisplay.nSetViewPort(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getDefaultScreen());
            }
        }
    }

    static native int nGrabPointer(long var0, long var2, long var4);

    private static native void nSetViewPort(long var0, long var2, int var4);

    private void ungrabPointer() {
        if (this.pointer_grabbed) {
            this.pointer_grabbed = false;
            LinuxDisplay.nUngrabPointer(LinuxDisplay.getDisplay());
        }
    }

    static native int nUngrabPointer(long var0);

    private static boolean isFullscreen() {
        return current_window_mode == 1 || current_window_mode == 2;
    }

    private boolean shouldGrab() {
        return !this.input_released && this.grab && this.mouse != null;
    }

    private void updatePointerGrab() {
        if (LinuxDisplay.isFullscreen() || this.shouldGrab()) {
            this.grabPointer();
        } else {
            this.ungrabPointer();
        }
        this.updateCursor();
    }

    private void updateCursor() {
        long l2 = this.shouldGrab() ? this.blank_cursor : this.current_cursor;
        LinuxDisplay.nDefineCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), l2);
    }

    private static native void nDefineCursor(long var0, long var2, long var4);

    private static boolean isLegacyFullscreen() {
        return current_window_mode == 1;
    }

    private void updateKeyboardGrab() {
        if (LinuxDisplay.isLegacyFullscreen()) {
            this.grabKeyboard();
        } else {
            this.ungrabKeyboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWindow(DrawableLWJGL drawableLWJGL, DisplayMode displayMode, Canvas canvas, int n2, int n3) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                if (drawableLWJGL instanceof DrawableGLES) {
                    this.peer_info = new LinuxDisplayPeerInfo();
                }
                ByteBuffer byteBuffer = this.peer_info.lockAndGetHandle();
                try {
                    current_window_mode = this.getWindowMode(Display.isFullscreen());
                    if (current_window_mode != 3) {
                        Compiz.setLegacyFullscreenSupport(true);
                    }
                    boolean bl2 = Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated") || current_window_mode != 3 && Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated_fs");
                    this.parent = canvas;
                    this.parent_window = canvas != null ? LinuxDisplay.getHandle(canvas) : LinuxDisplay.getRootWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
                    this.resizable = Display.isResizable();
                    this.resized = false;
                    this.window_x = n2;
                    this.window_y = n3;
                    this.window_width = displayMode.getWidth();
                    this.window_height = displayMode.getHeight();
                    if (displayMode.isFullscreenCapable() && this.current_displaymode_extension == 10) {
                        XRandR.Screen screen = XRandR.DisplayModetoScreen(Display.getDisplayMode());
                        n2 = screen.xPos;
                        n3 = screen.yPos;
                    }
                    current_window = LinuxDisplay.nCreateWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), byteBuffer, displayMode, current_window_mode, n2, n3, bl2, this.parent_window, this.resizable);
                    this.wm_class = Display.getPrivilegedString("LWJGL_WM_CLASS");
                    if (this.wm_class == null) {
                        this.wm_class = Display.getTitle();
                    }
                    this.setClassHint(Display.getTitle(), this.wm_class);
                    LinuxDisplay.mapRaised(LinuxDisplay.getDisplay(), current_window);
                    xembedded = canvas != null && LinuxDisplay.isAncestorXEmbedded(this.parent_window);
                    this.blank_cursor = LinuxDisplay.createBlankCursor();
                    this.current_cursor = 0L;
                    this.focused = false;
                    this.input_released = false;
                    this.pointer_grabbed = false;
                    this.keyboard_grabbed = false;
                    this.close_requested = false;
                    this.grab = false;
                    this.minimized = false;
                    this.dirty = true;
                    if (drawableLWJGL instanceof DrawableGLES) {
                        ((DrawableGLES)drawableLWJGL).initialize(current_window, LinuxDisplay.getDisplay(), 4, (PixelFormat)drawableLWJGL.getPixelFormat());
                    }
                    if (canvas != null) {
                        canvas.addFocusListener(this.focus_listener);
                        this.parent_focused = canvas.isFocusOwner();
                        this.parent_focus_changed = true;
                    }
                }
                finally {
                    this.peer_info.unlock();
                }
            }
            catch (LWJGLException lWJGLException) {
                LinuxDisplay.decDisplay();
                throw lWJGLException;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native long nCreateWindow(long var0, int var2, ByteBuffer var3, DisplayMode var4, int var5, int var6, int var7, boolean var8, long var9, boolean var11);

    private static native long getRootWindow(long var0, int var2);

    private static native boolean hasProperty(long var0, long var2, long var4);

    private static native long getParentWindow(long var0, long var2);

    private static native int getChildCount(long var0, long var2);

    private static native void mapRaised(long var0, long var2);

    private static native void reparentWindow(long var0, long var2, long var4, int var6, int var7);

    private static native long nGetInputFocus(long var0);

    private static native void nSetInputFocus(long var0, long var2, long var4);

    private static native void nSetWindowSize(long var0, long var2, int var4, int var5, boolean var6);

    private static native int nGetX(long var0, long var2);

    private static native int nGetY(long var0, long var2);

    private static native int nGetWidth(long var0, long var2);

    private static native int nGetHeight(long var0, long var2);

    private static boolean isAncestorXEmbedded(long l2) {
        long l3 = LinuxDisplay.internAtom("_XEMBED_INFO", true);
        if (l3 != 0L) {
            long l4 = l2;
            while (l4 != 0L) {
                if (LinuxDisplay.hasProperty(LinuxDisplay.getDisplay(), l4, l3)) {
                    return true;
                }
                l4 = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), l4);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getHandle(Canvas canvas) {
        AWTCanvasImplementation aWTCanvasImplementation = AWTGLCanvas.createImplementation();
        LinuxPeerInfo linuxPeerInfo = (LinuxPeerInfo)aWTCanvasImplementation.createPeerInfo(canvas, null, null);
        ByteBuffer byteBuffer = linuxPeerInfo.lockAndGetHandle();
        try {
            long l2 = linuxPeerInfo.getDrawable();
            return l2;
        }
        finally {
            linuxPeerInfo.unlock();
        }
    }

    private void updateInputGrab() {
        this.updatePointerGrab();
        this.updateKeyboardGrab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyWindow() {
        LinuxDisplay.lockAWT();
        try {
            if (this.parent != null) {
                this.parent.removeFocusListener(this.focus_listener);
            }
            try {
                this.setNativeCursor(null);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to reset cursor: " + lWJGLException.getMessage());
            }
            LinuxDisplay.nDestroyCursor(LinuxDisplay.getDisplay(), this.blank_cursor);
            this.blank_cursor = 0L;
            this.ungrabKeyboard();
            LinuxDisplay.nDestroyWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            LinuxDisplay.decDisplay();
            if (current_window_mode != 3) {
                Compiz.setLegacyFullscreenSupport(false);
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    static native void nDestroyWindow(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchDisplayMode(DisplayMode displayMode) {
        LinuxDisplay.lockAWT();
        try {
            this.switchDisplayModeOnTmpDisplay(displayMode);
            this.current_mode = displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchDisplayModeOnTmpDisplay(DisplayMode displayMode) {
        if (this.current_displaymode_extension == 10) {
            XRandR.setConfiguration(false, XRandR.DisplayModetoScreen(displayMode));
        } else {
            LinuxDisplay.incDisplay();
            try {
                LinuxDisplay.nSwitchDisplayMode(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.current_displaymode_extension, displayMode);
            }
            finally {
                LinuxDisplay.decDisplay();
            }
        }
    }

    private static native void nSwitchDisplayMode(long var0, int var2, int var3, DisplayMode var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long internAtom(String string, boolean bl2) {
        LinuxDisplay.incDisplay();
        try {
            long l2 = LinuxDisplay.nInternAtom(LinuxDisplay.getDisplay(), string, bl2);
            return l2;
        }
        finally {
            LinuxDisplay.decDisplay();
        }
    }

    static native long nInternAtom(long var0, String var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDisplayMode() {
        LinuxDisplay.lockAWT();
        try {
            if (this.current_displaymode_extension == 10) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        XRandR.restoreConfiguration();
                        return null;
                    }
                });
            } else {
                this.switchDisplayMode(this.saved_mode);
            }
            if (LinuxDisplay.isXF86VidModeSupported()) {
                this.doSetGamma(this.saved_gamma);
            }
            Compiz.setLegacyFullscreenSupport(false);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while resetting mode: " + lWJGLException);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getGammaRampLength() {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            return 0;
        }
        LinuxDisplay.lockAWT();
        try {
            int n2;
            LinuxDisplay.incDisplay();
            try {
                n2 = LinuxDisplay.nGetGammaRampLength(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Got exception while querying gamma length: " + lWJGLException);
                int n3 = 0;
                LinuxDisplay.decDisplay();
                LinuxDisplay.unlockAWT();
                return n3;
                {
                    catch (Throwable throwable) {
                        try {
                            LinuxDisplay.decDisplay();
                            throw throwable;
                        }
                        catch (LWJGLException lWJGLException2) {
                            LWJGLUtil.log("Failed to get gamma ramp length: " + lWJGLException2);
                            int n4 = 0;
                            return n4;
                        }
                    }
                }
            }
            LinuxDisplay.decDisplay();
            return n2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetGammaRampLength(long var0, int var2);

    public void setGammaRamp(FloatBuffer floatBuffer) {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            throw new LWJGLException("No gamma ramp support (Missing XF86VM extension)");
        }
        this.doSetGamma(LinuxDisplay.convertToNativeRamp(floatBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetGamma(ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.setGammaRampOnTmpDisplay(byteBuffer);
            this.current_gamma = byteBuffer;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setGammaRampOnTmpDisplay(ByteBuffer byteBuffer) {
        LinuxDisplay.incDisplay();
        try {
            LinuxDisplay.nSetGammaRamp(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), byteBuffer);
        }
        finally {
            LinuxDisplay.decDisplay();
        }
    }

    private static native void nSetGammaRamp(long var0, int var2, ByteBuffer var3);

    private static ByteBuffer convertToNativeRamp(FloatBuffer floatBuffer) {
        return LinuxDisplay.nConvertToNativeRamp(floatBuffer, floatBuffer.position(), floatBuffer.remaining());
    }

    private static native ByteBuffer nConvertToNativeRamp(FloatBuffer var0, int var1, int var2);

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode init() {
        LinuxDisplay.lockAWT();
        try {
            Compiz.init();
            this.delete_atom = LinuxDisplay.internAtom("WM_DELETE_WINDOW", false);
            this.current_displaymode_extension = LinuxDisplay.getBestDisplayModeExtension();
            if (this.current_displaymode_extension == 12) {
                throw new LWJGLException("No display mode extension is available");
            }
            DisplayMode[] displayModeArray = this.getAvailableDisplayModes();
            if (displayModeArray == null || displayModeArray.length == 0) {
                throw new LWJGLException("No modes available");
            }
            switch (this.current_displaymode_extension) {
                case 10: {
                    this.saved_mode = AccessController.doPrivileged(new PrivilegedAction<DisplayMode>(){

                        @Override
                        public DisplayMode run() {
                            XRandR.saveConfiguration();
                            return XRandR.ScreentoDisplayMode(XRandR.getConfiguration());
                        }
                    });
                    break;
                }
                case 11: {
                    this.saved_mode = displayModeArray[0];
                    break;
                }
                default: {
                    throw new LWJGLException("Unknown display mode extension: " + this.current_displaymode_extension);
                }
            }
            this.current_mode = this.saved_mode;
            this.current_gamma = this.saved_gamma = LinuxDisplay.getCurrentGammaRamp();
            DisplayMode displayMode = this.saved_mode;
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DisplayMode getCurrentXRandrMode() {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode displayMode;
            LinuxDisplay.incDisplay();
            try {
                displayMode = LinuxDisplay.nGetCurrentXRandrMode(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode nGetCurrentXRandrMode(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String string) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(string);
            LinuxDisplay.nSetTitle(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining() - 1);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetTitle(long var0, long var2, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassHint(String string, String string2) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(string);
            ByteBuffer byteBuffer2 = MemoryUtil.encodeUTF8(string2);
            LinuxDisplay.nSetClassHint(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2));
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetClassHint(long var0, long var2, long var4, long var6);

    public boolean isCloseRequested() {
        boolean bl2 = this.close_requested;
        this.close_requested = false;
        return bl2;
    }

    public boolean isVisible() {
        return !this.minimized;
    }

    public boolean isActive() {
        return this.focused || LinuxDisplay.isLegacyFullscreen();
    }

    public boolean isDirty() {
        boolean bl2 = this.dirty;
        this.dirty = false;
        return bl2;
    }

    public PeerInfo createPeerInfo(org.lwjgl.opengl.PixelFormat pixelFormat, ContextAttribs contextAttribs) {
        this.peer_info = new LinuxDisplayPeerInfo(pixelFormat);
        return this.peer_info;
    }

    private void relayEventToParent(LinuxEvent linuxEvent, int n2) {
        this.tmp_event_buffer.copyFrom(linuxEvent);
        this.tmp_event_buffer.setWindow(this.parent_window);
        this.tmp_event_buffer.sendEvent(LinuxDisplay.getDisplay(), this.parent_window, true, n2);
    }

    private void relayEventToParent(LinuxEvent linuxEvent) {
        if (this.parent == null) {
            return;
        }
        switch (linuxEvent.getType()) {
            case 2: {
                this.relayEventToParent(linuxEvent, 1);
                break;
            }
            case 3: {
                this.relayEventToParent(linuxEvent, 1);
                break;
            }
            case 4: {
                if (!xembedded && this.focused) break;
                this.relayEventToParent(linuxEvent, 1);
                break;
            }
            case 5: {
                if (!xembedded && this.focused) break;
                this.relayEventToParent(linuxEvent, 1);
                break;
            }
        }
    }

    private void processEvents() {
        while (LinuxEvent.getPending(LinuxDisplay.getDisplay()) > 0) {
            this.event_buffer.nextEvent(LinuxDisplay.getDisplay());
            long l2 = this.event_buffer.getWindow();
            this.relayEventToParent(this.event_buffer);
            if (l2 != LinuxDisplay.getWindow() || this.event_buffer.filterEvent(l2) || this.mouse != null && this.mouse.filterEvent(this.grab, this.shouldWarpPointer(), this.event_buffer) || this.keyboard != null && this.keyboard.filterEvent(this.event_buffer)) continue;
            switch (this.event_buffer.getType()) {
                case 9: {
                    this.setFocused(true, this.event_buffer.getFocusDetail());
                    break;
                }
                case 10: {
                    this.setFocused(false, this.event_buffer.getFocusDetail());
                    break;
                }
                case 33: {
                    if (this.event_buffer.getClientFormat() != 32 || (long)this.event_buffer.getClientData(0) != this.delete_atom) break;
                    this.close_requested = true;
                    break;
                }
                case 19: {
                    this.dirty = true;
                    this.minimized = false;
                    break;
                }
                case 18: {
                    this.dirty = true;
                    this.minimized = true;
                    break;
                }
                case 12: {
                    this.dirty = true;
                    break;
                }
                case 22: {
                    int n2 = LinuxDisplay.nGetX(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n3 = LinuxDisplay.nGetY(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n4 = LinuxDisplay.nGetWidth(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n5 = LinuxDisplay.nGetHeight(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    this.window_x = n2;
                    this.window_y = n3;
                    if (this.window_width == n4 && this.window_height == n5) break;
                    this.resized = true;
                    this.window_width = n4;
                    this.window_height = n5;
                    break;
                }
                case 7: {
                    this.mouseInside = true;
                    break;
                }
                case 8: {
                    this.mouseInside = false;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        LinuxDisplay.lockAWT();
        try {
            this.processEvents();
            this.checkInput();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int n2, int n3, int n4, int n5) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nReshape(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), n2, n3, n4, n5);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nReshape(long var0, long var2, int var4, int var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getAvailableDisplayModes() {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode[] displayModeArray;
            LinuxDisplay.incDisplay();
            if (this.current_displaymode_extension == 10) {
                DisplayMode[] displayModeArray2 = LinuxDisplay.nGetAvailableDisplayModes(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.current_displaymode_extension);
                int n2 = 24;
                if (displayModeArray2.length > 0) {
                    n2 = displayModeArray2[0].getBitsPerPixel();
                }
                XRandR.Screen[] screenArray = XRandR.getResolutions(XRandR.getScreenNames()[0]);
                DisplayMode[] displayModeArray3 = new DisplayMode[screenArray.length];
                for (int i2 = 0; i2 < displayModeArray3.length; ++i2) {
                    displayModeArray3[i2] = new DisplayMode(screenArray[i2].width, screenArray[i2].height, n2, screenArray[i2].freq);
                }
                DisplayMode[] displayModeArray4 = displayModeArray3;
                return displayModeArray4;
            }
            try {
                DisplayMode[] displayModeArray5;
                displayModeArray = displayModeArray5 = LinuxDisplay.nGetAvailableDisplayModes(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.current_displaymode_extension);
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayModeArray;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode[] nGetAvailableDisplayModes(long var0, int var2, int var3);

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return this.mouse.getButtonCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMouse() {
        LinuxDisplay.lockAWT();
        try {
            this.mouse = new LinuxMouse(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    public void destroyMouse() {
        this.mouse = null;
        this.updateInputGrab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollMouse(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.poll(this.grab, intBuffer, byteBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMouse(ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.read(byteBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorPosition(int n2, int n3) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.setCursorPosition(n2, n3);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void checkInput() {
        if (this.parent == null) {
            return;
        }
        if (xembedded) {
            long l2 = 0L;
            if (this.last_window_focus != l2 || this.parent_focused != this.focused) {
                if (this.isParentWindowActive(l2)) {
                    if (this.parent_focused) {
                        LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), current_window, 0L);
                        this.last_window_focus = current_window;
                        this.focused = true;
                    } else {
                        LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), this.parent_proxy_focus_window, 0L);
                        this.last_window_focus = this.parent_proxy_focus_window;
                        this.focused = false;
                    }
                } else {
                    this.last_window_focus = l2;
                    this.focused = false;
                }
            }
        } else if (this.parent_focus_changed && this.parent_focused) {
            this.setInputFocusUnsafe(LinuxDisplay.getWindow());
            this.parent_focus_changed = false;
        }
    }

    private void setInputFocusUnsafe(long l2) {
        try {
            LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), l2, 0L);
            LinuxDisplay.nSync(LinuxDisplay.getDisplay(), false);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Got exception while trying to focus: " + lWJGLException);
        }
    }

    private static native void nSync(long var0, boolean var2);

    private boolean isParentWindowActive(long l2) {
        try {
            if (l2 == current_window) {
                return true;
            }
            if (LinuxDisplay.getChildCount(LinuxDisplay.getDisplay(), l2) != 0) {
                return false;
            }
            long l3 = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), l2);
            if (l3 == 0L) {
                return false;
            }
            long l4 = current_window;
            while (l4 != 0L) {
                l4 = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), l4);
                if (l4 != l3) continue;
                this.parent_proxy_focus_window = l2;
                return true;
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to detect if parent window is active: " + lWJGLException.getMessage());
            return true;
        }
        return false;
    }

    private void setFocused(boolean bl2, int n2) {
        if (this.focused == bl2 || n2 == 7 || n2 == 5 || n2 == 6 || xembedded) {
            return;
        }
        this.focused = bl2;
        if (this.focused) {
            this.acquireInput();
        } else {
            this.releaseInput();
        }
    }

    private void releaseInput() {
        if (LinuxDisplay.isLegacyFullscreen() || this.input_released) {
            return;
        }
        if (this.keyboard != null) {
            this.keyboard.releaseAll();
        }
        this.input_released = true;
        this.updateInputGrab();
        if (current_window_mode == 2) {
            LinuxDisplay.nIconifyWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getDefaultScreen());
            try {
                if (this.current_displaymode_extension == 10) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            XRandR.restoreConfiguration();
                            return null;
                        }
                    });
                } else {
                    this.switchDisplayModeOnTmpDisplay(this.saved_mode);
                }
                LinuxDisplay.setGammaRampOnTmpDisplay(this.saved_gamma);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore saved mode: " + lWJGLException.getMessage());
            }
        }
    }

    private static native void nIconifyWindow(long var0, long var2, int var4);

    private void acquireInput() {
        if (LinuxDisplay.isLegacyFullscreen() || !this.input_released) {
            return;
        }
        this.input_released = false;
        this.updateInputGrab();
        if (current_window_mode == 2) {
            try {
                this.switchDisplayModeOnTmpDisplay(this.current_mode);
                LinuxDisplay.setGammaRampOnTmpDisplay(this.current_gamma);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore mode: " + lWJGLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grabMouse(boolean bl2) {
        LinuxDisplay.lockAWT();
        try {
            if (bl2 != this.grab) {
                this.grab = bl2;
                this.updateInputGrab();
                this.mouse.changeGrabbed(this.grab, this.shouldWarpPointer());
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private boolean shouldWarpPointer() {
        return this.pointer_grabbed && this.shouldGrab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNativeCursorCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n2;
            LinuxDisplay.incDisplay();
            try {
                n2 = LinuxDisplay.nGetNativeCursorCapabilities(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    throw new RuntimeException(lWJGLException);
                }
            }
            LinuxDisplay.decDisplay();
            return n2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetNativeCursorCapabilities(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNativeCursor(Object object) {
        this.current_cursor = LinuxDisplay.getCursorHandle(object);
        LinuxDisplay.lockAWT();
        try {
            this.updateCursor();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n2;
            LinuxDisplay.incDisplay();
            try {
                n2 = LinuxDisplay.nGetMinCursorSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getMinCursorSize: " + lWJGLException);
                    int n3 = 0;
                    return n3;
                }
            }
            LinuxDisplay.decDisplay();
            return n2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMinCursorSize(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n2;
            LinuxDisplay.incDisplay();
            try {
                n2 = LinuxDisplay.nGetMaxCursorSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getMaxCursorSize: " + lWJGLException);
                    int n3 = 0;
                    return n3;
                }
            }
            LinuxDisplay.decDisplay();
            return n2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMaxCursorSize(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyboard() {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard = new LinuxKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKeyboard() {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.destroy(LinuxDisplay.getDisplay());
            this.keyboard = null;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollKeyboard(ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.poll(byteBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readKeyboard(ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.read(byteBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native long nCreateCursor(long var0, int var2, int var3, int var4, int var5, int var6, IntBuffer var7, int var8, IntBuffer var9, int var10);

    private static long createBlankCursor() {
        return LinuxDisplay.nCreateBlankCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
    }

    static native long nCreateBlankCursor(long var0, long var2);

    public Object createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                long l2 = LinuxDisplay.nCreateCursor(LinuxDisplay.getDisplay(), n2, n3, n4, n5, n6, intBuffer, intBuffer.position(), intBuffer2, intBuffer2 != null ? intBuffer2.position() : -1);
                Long l3 = l2;
                return l3;
            }
            catch (LWJGLException lWJGLException) {
                LinuxDisplay.decDisplay();
                throw lWJGLException;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static long getCursorHandle(Object object) {
        return object != null ? (Long)object : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCursor(Object object) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nDestroyCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getCursorHandle(object));
            LinuxDisplay.decDisplay();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    static native void nDestroyCursor(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPbufferCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n2;
            LinuxDisplay.incDisplay();
            try {
                n2 = LinuxDisplay.nGetPbufferCapabilities(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getPbufferCapabilities: " + lWJGLException);
                    int n3 = 0;
                    return n3;
                }
            }
            LinuxDisplay.decDisplay();
            return n2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetPbufferCapabilities(long var0, int var2);

    public boolean isBufferLost(PeerInfo peerInfo) {
        return false;
    }

    public PeerInfo createPbuffer(int n2, int n3, org.lwjgl.opengl.PixelFormat pixelFormat, ContextAttribs contextAttribs, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return new LinuxPbufferPeerInfo(n2, n3, pixelFormat);
    }

    public void setPbufferAttrib(PeerInfo peerInfo, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(PeerInfo peerInfo, int n2) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(PeerInfo peerInfo, int n2) {
        throw new UnsupportedOperationException();
    }

    private static ByteBuffer convertIcons(ByteBuffer[] byteBufferArray) {
        int n2;
        int n3 = 0;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            int n4 = byteBuffer.limit() / 4;
            n2 = (int)Math.sqrt(n4);
            if (n2 <= 0) continue;
            n3 += 8;
            n3 += n2 * n2 * 4;
        }
        if (n3 == 0) {
            return null;
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n3);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        for (ByteBuffer byteBuffer2 : byteBufferArray) {
            n2 = byteBuffer2.limit() / 4;
            int n5 = (int)Math.sqrt(n2);
            byteBuffer.putInt(n5);
            byteBuffer.putInt(n5);
            for (int i2 = 0; i2 < n5; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    byte by2 = byteBuffer2.get(i3 * 4 + i2 * n5 * 4);
                    byte by3 = byteBuffer2.get(i3 * 4 + i2 * n5 * 4 + 1);
                    byte by4 = byteBuffer2.get(i3 * 4 + i2 * n5 * 4 + 2);
                    byte by5 = byteBuffer2.get(i3 * 4 + i2 * n5 * 4 + 3);
                    byteBuffer.put(by5);
                    byteBuffer.put(by2);
                    byteBuffer.put(by3);
                    byteBuffer.put(by4);
                }
            }
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setIcon(ByteBuffer[] byteBufferArray) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer;
            block10: {
                int n2;
                LinuxDisplay.incDisplay();
                try {
                    byteBuffer = LinuxDisplay.convertIcons(byteBufferArray);
                    if (byteBuffer != null) break block10;
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    try {
                        LinuxDisplay.decDisplay();
                        throw throwable;
                    }
                    catch (LWJGLException lWJGLException) {
                        LWJGLUtil.log("Failed to set display icon: " + lWJGLException);
                        int n3 = 0;
                        return n3;
                    }
                }
                LinuxDisplay.decDisplay();
                return n2;
            }
            LinuxDisplay.nSetWindowIcon(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), byteBuffer, byteBuffer.capacity());
            int n4 = byteBufferArray.length;
            LinuxDisplay.decDisplay();
            return n4;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetWindowIcon(long var0, long var2, ByteBuffer var4, int var5);

    public int getX() {
        return this.window_x;
    }

    public int getY() {
        return this.window_y;
    }

    public int getWidth() {
        return this.window_width;
    }

    public int getHeight() {
        return this.window_height;
    }

    public boolean isInsideWindow() {
        return this.mouseInside;
    }

    public void setResizable(boolean bl2) {
        if (this.resizable == bl2) {
            return;
        }
        this.resizable = bl2;
        LinuxDisplay.nSetWindowSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), this.window_width, this.window_height, bl2);
    }

    public boolean wasResized() {
        if (this.resized) {
            this.resized = false;
            return true;
        }
        return false;
    }

    public float getPixelScaleFactor() {
        return 1.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Compiz {
        private static boolean applyFix;
        private static Provider provider;

        private Compiz() {
        }

        static void init() {
            if (Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.nocompiz_lfs")) {
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    try {
                        if (!Compiz.isProcessActive("compiz")) {
                            Object var1_1 = null;
                            return var1_1;
                        }
                        Compiz.provider = null;
                        String string = null;
                        if (Compiz.isProcessActive("dbus-daemon")) {
                            string = "Dbus";
                            Compiz.provider = new Provider(){
                                private static final String KEY = "/org/freedesktop/compiz/workarounds/allscreens/legacy_fullscreen";

                                public boolean hasLegacyFullscreenSupport() {
                                    List list = Compiz.run(new String[]{"dbus-send", "--print-reply", "--type=method_call", "--dest=org.freedesktop.compiz", KEY, "org.freedesktop.compiz.get"});
                                    if (list == null || list.size() < 2) {
                                        throw new LWJGLException("Invalid Dbus reply.");
                                    }
                                    String string = (String)list.get(0);
                                    if (!string.startsWith("method return")) {
                                        throw new LWJGLException("Invalid Dbus reply.");
                                    }
                                    string = ((String)list.get(1)).trim();
                                    if (!string.startsWith("boolean") || string.length() < 12) {
                                        throw new LWJGLException("Invalid Dbus reply.");
                                    }
                                    return "true".equalsIgnoreCase(string.substring("boolean".length() + 1));
                                }

                                public void setLegacyFullscreenSupport(boolean bl2) {
                                    if (Compiz.run(new String[]{"dbus-send", "--type=method_call", "--dest=org.freedesktop.compiz", KEY, "org.freedesktop.compiz.set", "boolean:" + Boolean.toString(bl2)}) == null) {
                                        throw new LWJGLException("Failed to apply Compiz LFS workaround.");
                                    }
                                }
                            };
                        } else {
                            try {
                                Runtime.getRuntime().exec("gconftool");
                                string = "gconftool";
                                Compiz.provider = new Provider(){
                                    private static final String KEY = "/apps/compiz/plugins/workarounds/allscreens/options/legacy_fullscreen";

                                    public boolean hasLegacyFullscreenSupport() {
                                        List list = Compiz.run(new String[]{"gconftool", "-g", KEY});
                                        if (list == null || list.size() == 0) {
                                            throw new LWJGLException("Invalid gconftool reply.");
                                        }
                                        return Boolean.parseBoolean(((String)list.get(0)).trim());
                                    }

                                    public void setLegacyFullscreenSupport(boolean bl2) {
                                        if (Compiz.run(new String[]{"gconftool", "-s", KEY, "-s", Boolean.toString(bl2), "-t", "bool"}) == null) {
                                            throw new LWJGLException("Failed to apply Compiz LFS workaround.");
                                        }
                                        if (bl2) {
                                            try {
                                                Thread.sleep(200L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                interruptedException.printStackTrace();
                                            }
                                        }
                                    }
                                };
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (provider != null) {
                            if (!provider.hasLegacyFullscreenSupport()) {
                                applyFix = true;
                                LWJGLUtil.log("Using " + string + " to apply Compiz LFS workaround.");
                            }
                        }
                    }
                    catch (LWJGLException lWJGLException) {}
                    finally {
                        return null;
                    }
                }
            });
        }

        static void setLegacyFullscreenSupport(final boolean bl2) {
            if (!applyFix) {
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        provider.setLegacyFullscreenSupport(bl2);
                    }
                    catch (LWJGLException lWJGLException) {
                        LWJGLUtil.log("Failed to change Compiz Legacy Fullscreen Support. Reason: " + lWJGLException.getMessage());
                    }
                    return null;
                }
            });
        }

        private static List<String> run(String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string;
                Process process = Runtime.getRuntime().exec(stringArray);
                try {
                    int n2 = process.waitFor();
                    if (n2 != 0) {
                        return null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new LWJGLException("Process interrupted.", interruptedException);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new LWJGLException("Process failed.", iOException);
            }
            return arrayList;
        }

        private static boolean isProcessActive(String string) {
            List<String> list = Compiz.run("ps", "-C", string);
            if (list == null) {
                return false;
            }
            for (String string2 : list) {
                if (!string2.contains(string)) continue;
                return true;
            }
            return false;
        }

        static interface Provider {
            public boolean hasLegacyFullscreenSupport();

            public void setLegacyFullscreenSupport(boolean var1);
        }
    }
}

