/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.ContextImplementation;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.PeerInfo;

final class LinuxContextImplementation
implements ContextImplementation {
    LinuxContextImplementation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer create(PeerInfo peerInfo, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer2 = peerInfo.lockAndGetHandle();
            try {
                ByteBuffer byteBuffer3 = LinuxContextImplementation.nCreate(byteBuffer2, intBuffer, byteBuffer);
                peerInfo.unlock();
                return byteBuffer3;
            }
            catch (Throwable throwable) {
                peerInfo.unlock();
                throw throwable;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nCreate(ByteBuffer var0, IntBuffer var1, ByteBuffer var2);

    native long getGLXContext(ByteBuffer var1);

    native long getDisplay(ByteBuffer var1);

    public void releaseDrawable(ByteBuffer byteBuffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nSwapBuffers(byteBuffer);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nSwapBuffers(ByteBuffer var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCurrentContext() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nReleaseCurrentContext(byteBuffer);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nReleaseCurrentContext(ByteBuffer var0);

    public void update(ByteBuffer byteBuffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCurrent(PeerInfo peerInfo, ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer2 = peerInfo.lockAndGetHandle();
            try {
                LinuxContextImplementation.nMakeCurrent(byteBuffer2, byteBuffer);
            }
            finally {
                peerInfo.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nMakeCurrent(ByteBuffer var0, ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrent(ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            boolean bl2;
            boolean bl3 = bl2 = LinuxContextImplementation.nIsCurrent(byteBuffer);
            return bl3;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsCurrent(ByteBuffer var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSwapInterval(int n2) {
        ContextGL contextGL = ContextGL.getCurrentContext();
        PeerInfo peerInfo = contextGL.getPeerInfo();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nSetSwapInterval(byteBuffer, contextGL.getHandle(), n2);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nSetSwapInterval(ByteBuffer var0, ByteBuffer var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(PeerInfo peerInfo, ByteBuffer byteBuffer) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer2 = peerInfo.lockAndGetHandle();
            try {
                LinuxContextImplementation.nDestroy(byteBuffer2, byteBuffer);
            }
            finally {
                peerInfo.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nDestroy(ByteBuffer var0, ByteBuffer var1);
}

