/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;

    private INTELMapTexture() {
    }

    public static ByteBuffer glMapTexture2DINTEL(int n2, int n3, long l2, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMapTexture2DINTEL;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(intBuffer, 1);
        BufferChecks.checkBuffer(intBuffer2, 1);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = INTELMapTexture.nglMapTexture2DINTEL(n2, n3, l2, n4, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer2), byteBuffer, l3);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapTexture2DINTEL(int var0, int var1, long var2, int var4, long var5, long var7, ByteBuffer var9, long var10);

    public static void glUnmapTexture2DINTEL(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUnmapTexture2DINTEL;
        BufferChecks.checkFunctionAddress(l2);
        INTELMapTexture.nglUnmapTexture2DINTEL(n2, n3, l2);
    }

    static native void nglUnmapTexture2DINTEL(int var0, int var1, long var2);

    public static void glSyncTextureINTEL(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glSyncTextureINTEL;
        BufferChecks.checkFunctionAddress(l2);
        INTELMapTexture.nglSyncTextureINTEL(n2, l2);
    }

    static native void nglSyncTextureINTEL(int var0, long var1);
}

