/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class GL45 {
    public static final int GL_NEGATIVE_ONE_TO_ONE = 37726;
    public static final int GL_ZERO_TO_ONE = 37727;
    public static final int GL_CLIP_ORIGIN = 37724;
    public static final int GL_CLIP_DEPTH_MODE = 37725;
    public static final int GL_QUERY_WAIT_INVERTED = 36375;
    public static final int GL_QUERY_NO_WAIT_INVERTED = 36376;
    public static final int GL_QUERY_BY_REGION_WAIT_INVERTED = 36377;
    public static final int GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 36378;
    public static final int GL_MAX_CULL_DISTANCES = 33529;
    public static final int GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 33530;
    public static final int GL_TEXTURE_TARGET = 4102;
    public static final int GL_QUERY_TARGET = 33514;
    public static final int GL_TEXTURE_BINDING = 33515;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR = 33531;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 33532;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;

    private GL45() {
    }

    public static void glClipControl(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClipControl;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglClipControl(n2, n3, l2);
    }

    static native void nglClipControl(int var0, int var1, long var2);

    public static void glCreateTransformFeedbacks(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateTransformFeedbacks(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateTransformFeedbacks(int var0, long var1, long var3);

    public static int glCreateTransformFeedbacks() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateTransformFeedbacks(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glTransformFeedbackBufferBase(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTransformFeedbackBufferBase;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTransformFeedbackBufferBase(n2, n3, n4, l2);
    }

    static native void nglTransformFeedbackBufferBase(int var0, int var1, int var2, long var3);

    public static void glTransformFeedbackBufferRange(int n2, int n3, int n4, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glTransformFeedbackBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        GL45.nglTransformFeedbackBufferRange(n2, n3, n4, l2, l3, l4);
    }

    static native void nglTransformFeedbackBufferRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glGetTransformFeedback(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbackiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTransformFeedbackiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTransformFeedbackiv(int var0, int var1, long var2, long var4);

    public static int glGetTransformFeedbacki(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbackiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTransformFeedbackiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTransformFeedback(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbacki_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTransformFeedbacki_v(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTransformFeedbacki_v(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTransformFeedbacki(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbacki_v;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTransformFeedbacki_v(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTransformFeedback(int n2, int n3, int n4, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbacki64_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        GL45.nglGetTransformFeedbacki64_v(n2, n3, n4, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetTransformFeedbacki64_v(int var0, int var1, int var2, long var3, long var5);

    public static long glGetTransformFeedbacki64(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbacki64_v;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL45.nglGetTransformFeedbacki64_v(n2, n3, n4, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glCreateBuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateBuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateBuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateBuffers(int var0, long var1, long var3);

    public static int glCreateBuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateBuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateBuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glNamedBufferStorage(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglNamedBufferStorage(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glNamedBufferStorage(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglNamedBufferStorage(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glNamedBufferStorage(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglNamedBufferStorage(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glNamedBufferStorage(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglNamedBufferStorage(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glNamedBufferStorage(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglNamedBufferStorage(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    public static void glNamedBufferStorage(int n2, LongBuffer longBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        GL45.nglNamedBufferStorage(n2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), n3, l2);
    }

    static native void nglNamedBufferStorage(int var0, long var1, long var3, int var5, long var6);

    public static void glNamedBufferStorage(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferStorage;
        BufferChecks.checkFunctionAddress(l3);
        GL45.nglNamedBufferStorage(n2, l2, 0L, n3, l3);
    }

    public static void glNamedBufferData(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l3);
        GL45.nglNamedBufferData(n2, l2, 0L, n3, l3);
    }

    public static void glNamedBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglNamedBufferData(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glNamedBufferData(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglNamedBufferData(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glNamedBufferData(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglNamedBufferData(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glNamedBufferData(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglNamedBufferData(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glNamedBufferData(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglNamedBufferData(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    static native void nglNamedBufferData(int var0, long var1, long var3, int var5, long var6);

    public static void glNamedBufferSubData(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglNamedBufferSubData(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glNamedBufferSubData(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglNamedBufferSubData(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glNamedBufferSubData(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglNamedBufferSubData(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glNamedBufferSubData(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglNamedBufferSubData(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glNamedBufferSubData(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglNamedBufferSubData(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglNamedBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void glCopyNamedBufferSubData(int n2, int n3, long l2, long l3, long l4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l5 = contextCapabilities.glCopyNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l5);
        GL45.nglCopyNamedBufferSubData(n2, n3, l2, l3, l4, l5);
    }

    static native void nglCopyNamedBufferSubData(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void glClearNamedBufferData(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearNamedBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 1);
        GL45.nglClearNamedBufferData(n2, n3, n4, n5, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglClearNamedBufferData(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glClearNamedBufferSubData(int n2, int n3, long l2, long l3, int n4, int n5, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glClearNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(byteBuffer, 1);
        GL45.nglClearNamedBufferSubData(n2, n3, l2, l3, n4, n5, MemoryUtil.getAddress(byteBuffer), l4);
    }

    static native void nglClearNamedBufferSubData(int var0, int var1, long var2, long var4, int var6, int var7, long var8, long var10);

    public static ByteBuffer glMapNamedBuffer(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMapNamedBuffer;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL45.nglMapNamedBuffer(n2, n3, GL45.glGetNamedBufferParameteri(n2, 34660), byteBuffer, l2);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapNamedBuffer(int n2, int n3, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMapNamedBuffer;
        BufferChecks.checkFunctionAddress(l3);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL45.nglMapNamedBuffer(n2, n3, l2, byteBuffer, l3);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBuffer(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static ByteBuffer glMapNamedBufferRange(int n2, long l2, long l3, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glMapNamedBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL45.nglMapNamedBufferRange(n2, l2, l3, n3, byteBuffer, l4);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBufferRange(int var0, long var1, long var3, int var5, ByteBuffer var6, long var7);

    public static boolean glUnmapNamedBuffer(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUnmapNamedBuffer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL45.nglUnmapNamedBuffer(n2, l2);
        return bl2;
    }

    static native boolean nglUnmapNamedBuffer(int var0, long var1);

    public static void glFlushMappedNamedBufferRange(int n2, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glFlushMappedNamedBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        GL45.nglFlushMappedNamedBufferRange(n2, l2, l3, l4);
    }

    static native void nglFlushMappedNamedBufferRange(int var0, long var1, long var3, long var5);

    public static void glGetNamedBufferParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetNamedBufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedBufferParameteriv(int var0, int var1, long var2, long var4);

    public static int glGetNamedBufferParameteri(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetNamedBufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetNamedBufferParameter(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        GL45.nglGetNamedBufferParameteri64v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetNamedBufferParameteri64v(int var0, int var1, long var2, long var4);

    public static long glGetNamedBufferParameteri64(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL45.nglGetNamedBufferParameteri64v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static ByteBuffer glGetNamedBufferPointer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferPointerv;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = GL45.nglGetNamedBufferPointerv(n2, n3, GL45.glGetNamedBufferParameteri(n2, 34660), l2);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetNamedBufferPointerv(int var0, int var1, long var2, long var4);

    public static void glGetNamedBufferSubData(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglGetNamedBufferSubData(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glGetNamedBufferSubData(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglGetNamedBufferSubData(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glGetNamedBufferSubData(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglGetNamedBufferSubData(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glGetNamedBufferSubData(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetNamedBufferSubData(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glGetNamedBufferSubData(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglGetNamedBufferSubData(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglGetNamedBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void glCreateFramebuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateFramebuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateFramebuffers(int var0, long var1, long var3);

    public static int glCreateFramebuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateFramebuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glNamedFramebufferRenderbuffer(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferRenderbuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferRenderbuffer(n2, n3, n4, n5, l2);
    }

    static native void nglNamedFramebufferRenderbuffer(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferParameteri(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferParameteri;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferParameteri(n2, n3, n4, l2);
    }

    static native void nglNamedFramebufferParameteri(int var0, int var1, int var2, long var3);

    public static void glNamedFramebufferTexture(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTexture;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferTexture(n2, n3, n4, n5, l2);
    }

    static native void nglNamedFramebufferTexture(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferTextureLayer(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTextureLayer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferTextureLayer(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferDrawBuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferDrawBuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferDrawBuffer(n2, n3, l2);
    }

    static native void nglNamedFramebufferDrawBuffer(int var0, int var1, long var2);

    public static void glNamedFramebufferDrawBuffers(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferDrawBuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglNamedFramebufferDrawBuffers(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglNamedFramebufferDrawBuffers(int var0, int var1, long var2, long var4);

    public static void glNamedFramebufferReadBuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferReadBuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedFramebufferReadBuffer(n2, n3, l2);
    }

    static native void nglNamedFramebufferReadBuffer(int var0, int var1, long var2);

    public static void glInvalidateNamedFramebufferData(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glInvalidateNamedFramebufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglInvalidateNamedFramebufferData(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglInvalidateNamedFramebufferData(int var0, int var1, long var2, long var4);

    public static void glInvalidateNamedFramebufferSubData(int n2, IntBuffer intBuffer, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glInvalidateNamedFramebufferSubData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglInvalidateNamedFramebufferSubData(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), n3, n4, n5, n6, l2);
    }

    static native void nglInvalidateNamedFramebufferSubData(int var0, int var1, long var2, int var4, int var5, int var6, int var7, long var8);

    public static void glClearNamedFramebuffer(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearNamedFramebufferiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglClearNamedFramebufferiv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglClearNamedFramebufferiv(int var0, int var1, int var2, long var3, long var5);

    public static void glClearNamedFramebufferu(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearNamedFramebufferuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL45.nglClearNamedFramebufferuiv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglClearNamedFramebufferuiv(int var0, int var1, int var2, long var3, long var5);

    public static void glClearNamedFramebuffer(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearNamedFramebufferfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 1);
        GL45.nglClearNamedFramebufferfv(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglClearNamedFramebufferfv(int var0, int var1, int var2, long var3, long var5);

    public static void glClearNamedFramebufferfi(int n2, int n3, float f2, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearNamedFramebufferfi;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglClearNamedFramebufferfi(n2, n3, f2, n4, l2);
    }

    static native void nglClearNamedFramebufferfi(int var0, int var1, float var2, int var3, long var4);

    public static void glBlitNamedFramebuffer(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBlitNamedFramebuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglBlitNamedFramebuffer(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, l2);
    }

    static native void nglBlitNamedFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12);

    public static int glCheckNamedFramebufferStatus(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCheckNamedFramebufferStatus;
        BufferChecks.checkFunctionAddress(l2);
        int n4 = GL45.nglCheckNamedFramebufferStatus(n2, n3, l2);
        return n4;
    }

    static native int nglCheckNamedFramebufferStatus(int var0, int var1, long var2);

    public static void glGetNamedFramebufferParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetNamedFramebufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedFramebufferParameteriv(int var0, int var1, long var2, long var4);

    public static int glGetNamedFramebufferParameter(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetNamedFramebufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetNamedFramebufferAttachmentParameter(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferAttachmentParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetNamedFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3, long var5);

    public static int glGetNamedFramebufferAttachmentParameter(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferAttachmentParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetNamedFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glCreateRenderbuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateRenderbuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateRenderbuffers(int var0, long var1, long var3);

    public static int glCreateRenderbuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateRenderbuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glNamedRenderbufferStorage(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedRenderbufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedRenderbufferStorage(n2, n3, n4, n5, l2);
    }

    static native void nglNamedRenderbufferStorage(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedRenderbufferStorageMultisample(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedRenderbufferStorageMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglNamedRenderbufferStorageMultisample(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetNamedRenderbufferParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedRenderbufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetNamedRenderbufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedRenderbufferParameteriv(int var0, int var1, long var2, long var4);

    public static int glGetNamedRenderbufferParameter(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedRenderbufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetNamedRenderbufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glCreateTextures(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateTextures;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateTextures(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateTextures(int var0, int var1, long var2, long var4);

    public static int glCreateTextures(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateTextures;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateTextures(n2, 1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glTextureBuffer(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureBuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureBuffer(n2, n3, n4, l2);
    }

    static native void nglTextureBuffer(int var0, int var1, int var2, long var3);

    public static void glTextureBufferRange(int n2, int n3, int n4, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glTextureBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        GL45.nglTextureBufferRange(n2, n3, n4, l2, l3, l4);
    }

    static native void nglTextureBufferRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glTextureStorage1D(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureStorage1D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureStorage1D(n2, n3, n4, n5, l2);
    }

    static native void nglTextureStorage1D(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureStorage2D(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureStorage2D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureStorage2D(n2, n3, n4, n5, n6, l2);
    }

    static native void nglTextureStorage2D(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTextureStorage3D(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureStorage3D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureStorage3D(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglTextureStorage3D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glTextureStorage2DMultisample(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureStorage2DMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureStorage2DMultisample(n2, n3, n4, n5, n6, bl2, l2);
    }

    static native void nglTextureStorage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    public static void glTextureStorage3DMultisample(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureStorage3DMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureStorage3DMultisample(n2, n3, n4, n5, n6, n7, bl2, l2);
    }

    static native void nglTextureStorage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, long var7);

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n6, n7, n5, 1, 1));
        GL45.nglTextureSubImage1D(n2, n3, n4, n5, n6, n7, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n6, n7, n5, 1, 1));
        GL45.nglTextureSubImage1D(n2, n3, n4, n5, n6, n7, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n6, n7, n5, 1, 1));
        GL45.nglTextureSubImage1D(n2, n3, n4, n5, n6, n7, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n6, n7, n5, 1, 1));
        GL45.nglTextureSubImage1D(n2, n3, n4, n5, n6, n7, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n6, n7, n5, 1, 1));
        GL45.nglTextureSubImage1D(n2, n3, n4, n5, n6, n7, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglTextureSubImage1DBO(n2, n3, n4, n5, n6, n7, l2, l3);
    }

    static native void nglTextureSubImage1DBO(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n8, n9, n6, n7, 1));
        GL45.nglTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n8, n9, n6, n7, 1));
        GL45.nglTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n8, n9, n6, n7, 1));
        GL45.nglTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n8, n9, n6, n7, 1));
        GL45.nglTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n8, n9, n6, n7, 1));
        GL45.nglTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglTextureSubImage2DBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglTextureSubImage2DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n10, n11, n7, n8, n9));
        GL45.nglTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n10, n11, n7, n8, n9));
        GL45.nglTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n10, n11, n7, n8, n9));
        GL45.nglTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n10, n11, n7, n8, n9));
        GL45.nglTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n10, n11, n7, n8, n9));
        GL45.nglTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglTextureSubImage3DBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2, l3);
    }

    static native void nglTextureSubImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glCompressedTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglCompressedTextureSubImage1D(n2, n3, n4, n5, n6, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glCompressedTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglCompressedTextureSubImage1DBO(n2, n3, n4, n5, n6, n7, l2, l3);
    }

    static native void nglCompressedTextureSubImage1DBO(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glCompressedTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglCompressedTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglCompressedTextureSubImage2DBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglCompressedTextureSubImage2DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglCompressedTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glCompressedTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        GL45.nglCompressedTextureSubImage3DBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2, l3);
    }

    static native void nglCompressedTextureSubImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glCopyTextureSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage1D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglCopyTextureSubImage1D(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglCopyTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glCopyTextureSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage2D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglCopyTextureSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    static native void nglCopyTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyTextureSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage3D;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglCopyTextureSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
    }

    static native void nglCopyTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glTextureParameterf(int n2, int n3, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterf;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureParameterf(n2, n3, f2, l2);
    }

    static native void nglTextureParameterf(int var0, int var1, float var2, long var3);

    public static void glTextureParameter(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        GL45.nglTextureParameterfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglTextureParameterfv(int var0, int var1, long var2, long var4);

    public static void glTextureParameteri(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameteri;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureParameteri(n2, n3, n4, l2);
    }

    static native void nglTextureParameteri(int var0, int var1, int var2, long var3);

    public static void glTextureParameterI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglTextureParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameterIiv(int var0, int var1, long var2, long var4);

    public static void glTextureParameterIu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglTextureParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameterIuiv(int var0, int var1, long var2, long var4);

    public static void glTextureParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL45.nglTextureParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameteriv(int var0, int var1, long var2, long var4);

    public static void glGenerateTextureMipmap(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenerateTextureMipmap;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglGenerateTextureMipmap(n2, l2);
    }

    static native void nglGenerateTextureMipmap(int var0, long var1);

    public static void glBindTextureUnit(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindTextureUnit;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglBindTextureUnit(n2, n3, l2);
    }

    static native void nglBindTextureUnit(int var0, int var1, long var2);

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglGetTextureImage(n2, n3, n4, n5, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglGetTextureImage(n2, n3, n4, n5, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglGetTextureImage(n2, n3, n4, n5, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetTextureImage(n2, n3, n4, n5, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglGetTextureImage(n2, n3, n4, n5, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetTextureImage(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetTextureImage(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetTextureImage;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        GL45.nglGetTextureImageBO(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglGetTextureImageBO(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetCompressedTextureImage(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglGetCompressedTextureImage(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetCompressedTextureImage(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetCompressedTextureImage(n2, n3, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetCompressedTextureImage(int n2, int n3, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglGetCompressedTextureImage(n2, n3, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetCompressedTextureImage(int var0, int var1, int var2, long var3, long var5);

    public static void glGetCompressedTextureImage(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetCompressedTextureImage;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        GL45.nglGetCompressedTextureImageBO(n2, n3, n4, l2, l3);
    }

    static native void nglGetCompressedTextureImageBO(int var0, int var1, int var2, long var3, long var5);

    public static void glGetTextureLevelParameter(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 1);
        GL45.nglGetTextureLevelParameterfv(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetTextureLevelParameterfv(int var0, int var1, int var2, long var3, long var5);

    public static float glGetTextureLevelParameterf(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterfv;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        GL45.nglGetTextureLevelParameterfv(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetTextureLevelParameter(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTextureLevelParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureLevelParameteriv(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureLevelParameteri(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTextureLevelParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTextureParameter(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 1);
        GL45.nglGetTextureParameterfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetTextureParameterfv(int var0, int var1, long var2, long var4);

    public static float glGetTextureParameterf(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterfv;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        GL45.nglGetTextureParameterfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetTextureParameterI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTextureParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameterIiv(int var0, int var1, long var2, long var4);

    public static int glGetTextureParameterIi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTextureParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTextureParameterIu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTextureParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameterIuiv(int var0, int var1, long var2, long var4);

    public static int glGetTextureParameterIui(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTextureParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTextureParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetTextureParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameteriv(int var0, int var1, long var2, long var4);

    public static int glGetTextureParameteri(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetTextureParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glCreateVertexArrays(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateVertexArrays(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateVertexArrays(int var0, long var1, long var3);

    public static int glCreateVertexArrays() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateVertexArrays(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glDisableVertexArrayAttrib(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableVertexArrayAttrib;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglDisableVertexArrayAttrib(n2, n3, l2);
    }

    static native void nglDisableVertexArrayAttrib(int var0, int var1, long var2);

    public static void glEnableVertexArrayAttrib(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableVertexArrayAttrib;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglEnableVertexArrayAttrib(n2, n3, l2);
    }

    static native void nglEnableVertexArrayAttrib(int var0, int var1, long var2);

    public static void glVertexArrayElementBuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayElementBuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayElementBuffer(n2, n3, l2);
    }

    static native void nglVertexArrayElementBuffer(int var0, int var1, long var2);

    public static void glVertexArrayVertexBuffer(int n2, int n3, int n4, long l2, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayVertexBuffer;
        BufferChecks.checkFunctionAddress(l3);
        GL45.nglVertexArrayVertexBuffer(n2, n3, n4, l2, n5, l3);
    }

    static native void nglVertexArrayVertexBuffer(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glVertexArrayVertexBuffers(int n2, int n3, int n4, IntBuffer intBuffer, PointerBuffer pointerBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayVertexBuffers;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, n4);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, n4);
        }
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, n4);
        }
        GL45.nglVertexArrayVertexBuffers(n2, n3, n4, MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2);
    }

    static native void nglVertexArrayVertexBuffers(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glVertexArrayAttribFormat(int n2, int n3, int n4, int n5, boolean bl2, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayAttribFormat;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayAttribFormat(n2, n3, n4, n5, bl2, n6, l2);
    }

    static native void nglVertexArrayAttribFormat(int var0, int var1, int var2, int var3, boolean var4, int var5, long var6);

    public static void glVertexArrayAttribIFormat(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayAttribIFormat;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayAttribIFormat(n2, n3, n4, n5, n6, l2);
    }

    static native void nglVertexArrayAttribIFormat(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexArrayAttribLFormat(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayAttribLFormat;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayAttribLFormat(n2, n3, n4, n5, n6, l2);
    }

    static native void nglVertexArrayAttribLFormat(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexArrayAttribBinding(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayAttribBinding;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayAttribBinding(n2, n3, n4, l2);
    }

    static native void nglVertexArrayAttribBinding(int var0, int var1, int var2, long var3);

    public static void glVertexArrayBindingDivisor(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexArrayBindingDivisor;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglVertexArrayBindingDivisor(n2, n3, n4, l2);
    }

    static native void nglVertexArrayBindingDivisor(int var0, int var1, int var2, long var3);

    public static void glGetVertexArray(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetVertexArrayiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexArrayiv(int var0, int var1, long var2, long var4);

    public static int glGetVertexArray(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetVertexArrayiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetVertexArrayIndexed(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIndexediv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL45.nglGetVertexArrayIndexediv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexArrayIndexediv(int var0, int var1, int var2, long var3, long var5);

    public static int glGetVertexArrayIndexed(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIndexediv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglGetVertexArrayIndexediv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetVertexArrayIndexed64i(int n2, int n3, int n4, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIndexed64iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        GL45.nglGetVertexArrayIndexed64iv(n2, n3, n4, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetVertexArrayIndexed64iv(int var0, int var1, int var2, long var3, long var5);

    public static long glGetVertexArrayIndexed64i(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIndexed64iv;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL45.nglGetVertexArrayIndexed64iv(n2, n3, n4, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glCreateSamplers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateSamplers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateSamplers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateSamplers(int var0, long var1, long var3);

    public static int glCreateSamplers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateSamplers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateSamplers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glCreateProgramPipelines(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateProgramPipelines(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateProgramPipelines(int var0, long var1, long var3);

    public static int glCreateProgramPipelines() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateProgramPipelines(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glCreateQueries(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateQueries;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglCreateQueries(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglCreateQueries(int var0, int var1, long var2, long var4);

    public static int glCreateQueries(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateQueries;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL45.nglCreateQueries(n2, 1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glMemoryBarrierByRegion(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMemoryBarrierByRegion;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglMemoryBarrierByRegion(n2, l2);
    }

    static native void nglMemoryBarrierByRegion(int var0, long var1);

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglGetTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglGetTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglGetTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglGetTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glGetTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetTextureSubImage;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        GL45.nglGetTextureSubImageBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, l2, l3);
    }

    static native void nglGetTextureSubImageBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglGetCompressedTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglGetCompressedTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglGetCompressedTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetCompressedTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglGetCompressedTextureSubImage(n2, n3, n4, n5, n6, n7, n8, n9, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetCompressedTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glGetCompressedTextureSubImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetCompressedTextureSubImage;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        GL45.nglGetCompressedTextureSubImageBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglGetCompressedTextureSubImageBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureBarrier() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureBarrier;
        BufferChecks.checkFunctionAddress(l2);
        GL45.nglTextureBarrier(l2);
    }

    static native void nglTextureBarrier(long var0);

    public static int glGetGraphicsResetStatus() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetGraphicsResetStatus;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = GL45.nglGetGraphicsResetStatus(l2);
        return n2;
    }

    static native int nglGetGraphicsResetStatus(long var0);

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL45.nglReadnPixels(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        GL45.nglReadnPixels(n2, n3, n4, n5, n6, n7, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglReadnPixels(n2, n3, n4, n5, n6, n7, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglReadnPixels(n2, n3, n4, n5, n6, n7, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL45.nglReadnPixels(n2, n3, n4, n5, n6, n7, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglReadnPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glReadnPixels(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glReadnPixels;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        GL45.nglReadnPixelsBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglReadnPixelsBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glGetnUniform(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetnUniformfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL45.nglGetnUniformfv(n2, n3, floatBuffer.remaining(), MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetnUniformfv(int var0, int var1, int var2, long var3, long var5);

    public static void glGetnUniform(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetnUniformiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetnUniformiv(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetnUniformiv(int var0, int var1, int var2, long var3, long var5);

    public static void glGetnUniformu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetnUniformuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL45.nglGetnUniformuiv(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetnUniformuiv(int var0, int var1, int var2, long var3, long var5);
}

