/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL41 {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;

    private GL41() {
    }

    public static void glReleaseShaderCompiler() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glReleaseShaderCompiler;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglReleaseShaderCompiler(l2);
    }

    static native void nglReleaseShaderCompiler(long var0);

    public static void glShaderBinary(IntBuffer intBuffer, int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderBinary;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        BufferChecks.checkDirect(byteBuffer);
        GL41.nglShaderBinary(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), n2, MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), l2);
    }

    static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void glGetShaderPrecisionFormat(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderPrecisionFormat;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        BufferChecks.checkBuffer(intBuffer2, 1);
        GL41.nglGetShaderPrecisionFormat(n2, n3, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer2), l2);
    }

    static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4, long var6);

    public static void glDepthRangef(float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDepthRangef;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglDepthRangef(f2, f3, l2);
    }

    static native void nglDepthRangef(float var0, float var1, long var2);

    public static void glClearDepthf(float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearDepthf;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglClearDepthf(f2, l2);
    }

    static native void nglClearDepthf(float var0, long var1);

    public static void glGetProgramBinary(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramBinary;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkBuffer(intBuffer2, 1);
        BufferChecks.checkDirect(byteBuffer);
        GL41.nglGetProgramBinary(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetProgramBinary(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void glProgramBinary(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramBinary;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        GL41.nglProgramBinary(n2, n3, MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), l2);
    }

    static native void nglProgramBinary(int var0, int var1, long var2, int var4, long var5);

    public static void glProgramParameteri(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramParameteri;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramParameteri(n2, n3, n4, l2);
    }

    static native void nglProgramParameteri(int var0, int var1, int var2, long var3);

    public static void glUseProgramStages(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUseProgramStages;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglUseProgramStages(n2, n3, n4, l2);
    }

    static native void nglUseProgramStages(int var0, int var1, int var2, long var3);

    public static void glActiveShaderProgram(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glActiveShaderProgram;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglActiveShaderProgram(n2, n3, l2);
    }

    static native void nglActiveShaderProgram(int var0, int var1, long var2);

    public static int glCreateShaderProgram(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderProgramv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = GL41.nglCreateShaderProgramv(n2, 1, MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    static native int nglCreateShaderProgramv(int var0, int var1, long var2, long var4);

    public static int glCreateShaderProgram(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderProgramv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer, n3);
        int n4 = GL41.nglCreateShaderProgramv2(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
        return n4;
    }

    static native int nglCreateShaderProgramv2(int var0, int var1, long var2, long var4);

    public static int glCreateShaderProgram(int n2, ByteBuffer[] byteBufferArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderProgramv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(byteBufferArray, 1);
        int n3 = GL41.nglCreateShaderProgramv3(n2, byteBufferArray.length, byteBufferArray, l2);
        return n3;
    }

    static native int nglCreateShaderProgramv3(int var0, int var1, ByteBuffer[] var2, long var3);

    public static int glCreateShaderProgram(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderProgramv;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL41.nglCreateShaderProgramv(n2, 1, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
        return n3;
    }

    public static int glCreateShaderProgram(int n2, CharSequence[] charSequenceArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderProgramv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(charSequenceArray);
        int n3 = GL41.nglCreateShaderProgramv2(n2, charSequenceArray.length, APIUtil.getBufferNT(contextCapabilities, charSequenceArray), l2);
        return n3;
    }

    public static void glBindProgramPipeline(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindProgramPipeline;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglBindProgramPipeline(n2, l2);
    }

    static native void nglBindProgramPipeline(int var0, long var1);

    public static void glDeleteProgramPipelines(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglDeleteProgramPipelines(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteProgramPipelines(int var0, long var1, long var3);

    public static void glDeleteProgramPipelines(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglDeleteProgramPipelines(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenProgramPipelines(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglGenProgramPipelines(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenProgramPipelines(int var0, long var1, long var3);

    public static int glGenProgramPipelines() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenProgramPipelines;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL41.nglGenProgramPipelines(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static boolean glIsProgramPipeline(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsProgramPipeline;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL41.nglIsProgramPipeline(n2, l2);
        return bl2;
    }

    static native boolean nglIsProgramPipeline(int var0, long var1);

    public static void glGetProgramPipeline(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramPipelineiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL41.nglGetProgramPipelineiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetProgramPipelineiv(int var0, int var1, long var2, long var4);

    public static int glGetProgramPipelinei(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramPipelineiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL41.nglGetProgramPipelineiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glProgramUniform1i(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1i;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform1i(n2, n3, n4, l2);
    }

    static native void nglProgramUniform1i(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2i(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2i;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform2i(n2, n3, n4, n5, l2);
    }

    static native void nglProgramUniform2i(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3i(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3i;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform3i(n2, n3, n4, n5, n6, l2);
    }

    static native void nglProgramUniform3i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4i(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4i;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform4i(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglProgramUniform4i(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1f(int n2, int n3, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1f;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform1f(n2, n3, f2, l2);
    }

    static native void nglProgramUniform1f(int var0, int var1, float var2, long var3);

    public static void glProgramUniform2f(int n2, int n3, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2f;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform2f(n2, n3, f2, f3, l2);
    }

    static native void nglProgramUniform2f(int var0, int var1, float var2, float var3, long var4);

    public static void glProgramUniform3f(int n2, int n3, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3f;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform3f(n2, n3, f2, f3, f4, l2);
    }

    static native void nglProgramUniform3f(int var0, int var1, float var2, float var3, float var4, long var5);

    public static void glProgramUniform4f(int n2, int n3, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4f;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform4f(n2, n3, f2, f3, f4, f5, l2);
    }

    static native void nglProgramUniform4f(int var0, int var1, float var2, float var3, float var4, float var5, long var6);

    public static void glProgramUniform1d(int n2, int n3, double d2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform1d(n2, n3, d2, l2);
    }

    static native void nglProgramUniform1d(int var0, int var1, double var2, long var4);

    public static void glProgramUniform2d(int n2, int n3, double d2, double d3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform2d(n2, n3, d2, d3, l2);
    }

    static native void nglProgramUniform2d(int var0, int var1, double var2, double var4, long var6);

    public static void glProgramUniform3d(int n2, int n3, double d2, double d3, double d4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform3d(n2, n3, d2, d3, d4, l2);
    }

    static native void nglProgramUniform3d(int var0, int var1, double var2, double var4, double var6, long var8);

    public static void glProgramUniform4d(int n2, int n3, double d2, double d3, double d4, double d5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform4d(n2, n3, d2, d3, d4, d5, l2);
    }

    static native void nglProgramUniform4d(int var0, int var1, double var2, double var4, double var6, double var8, long var10);

    public static void glProgramUniform1(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform1iv(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform1iv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform2iv(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform2iv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform3iv(n2, n3, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform3iv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform4iv(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform4iv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform1(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniform1fv(n2, n3, floatBuffer.remaining(), MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform1fv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniform2fv(n2, n3, floatBuffer.remaining() >> 1, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform2fv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniform3fv(n2, n3, floatBuffer.remaining() / 3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform3fv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniform4fv(n2, n3, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform4fv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform1(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniform1dv(n2, n3, doubleBuffer.remaining(), MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniform1dv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniform2dv(n2, n3, doubleBuffer.remaining() >> 1, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniform2dv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniform3dv(n2, n3, doubleBuffer.remaining() / 3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniform3dv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniform4dv(n2, n3, doubleBuffer.remaining() >> 2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniform4dv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform1ui(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1ui;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform1ui(n2, n3, n4, l2);
    }

    static native void nglProgramUniform1ui(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2ui(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2ui;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform2ui(n2, n3, n4, n5, l2);
    }

    static native void nglProgramUniform2ui(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3ui(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3ui;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform3ui(n2, n3, n4, n5, n6, l2);
    }

    static native void nglProgramUniform3ui(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4ui(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4ui;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglProgramUniform4ui(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglProgramUniform4ui(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1u(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform1uiv(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform1uiv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2u(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform2uiv(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform2uiv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3u(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform3uiv(n2, n3, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform3uiv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4u(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglProgramUniform4uiv(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform4uiv(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniformMatrix2(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix2fv(n2, n3, floatBuffer.remaining() >> 2, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix3fv(n2, n3, floatBuffer.remaining() / 9, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix4fv(n2, n3, floatBuffer.remaining() >> 4, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix2dv(n2, n3, doubleBuffer.remaining() >> 2, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix3dv(n2, n3, doubleBuffer.remaining() / 9, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix4dv(n2, n3, doubleBuffer.remaining() >> 4, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x3(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix2x3fv(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x2(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix3x2fv(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x4(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix2x4fv(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x2(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix4x2fv(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x4(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix3x4fv(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x3(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglProgramUniformMatrix4x3fv(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x3(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x3dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix2x3dv(n2, n3, doubleBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x2(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x2dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix3x2dv(n2, n3, doubleBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x4(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x4dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix2x4dv(n2, n3, doubleBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x2(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x2dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix4x2dv(n2, n3, doubleBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x4(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x4dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix3x4dv(n2, n3, doubleBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x3(int n2, int n3, boolean bl2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x3dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglProgramUniformMatrix4x3dv(n2, n3, doubleBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glValidateProgramPipeline(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glValidateProgramPipeline;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglValidateProgramPipeline(n2, l2);
    }

    static native void nglValidateProgramPipeline(int var0, long var1);

    public static void glGetProgramPipelineInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramPipelineInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        GL41.nglGetProgramPipelineInfoLog(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetProgramPipelineInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static String glGetProgramPipelineInfoLog(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramPipelineInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        GL41.nglGetProgramPipelineInfoLog(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glVertexAttribL1d(int n2, double d2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL1d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglVertexAttribL1d(n2, d2, l2);
    }

    static native void nglVertexAttribL1d(int var0, double var1, long var3);

    public static void glVertexAttribL2d(int n2, double d2, double d3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL2d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglVertexAttribL2d(n2, d2, d3, l2);
    }

    static native void nglVertexAttribL2d(int var0, double var1, double var3, long var5);

    public static void glVertexAttribL3d(int n2, double d2, double d3, double d4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL3d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglVertexAttribL3d(n2, d2, d3, d4, l2);
    }

    static native void nglVertexAttribL3d(int var0, double var1, double var3, double var5, long var7);

    public static void glVertexAttribL4d(int n2, double d2, double d3, double d4, double d5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL4d;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglVertexAttribL4d(n2, d2, d3, d4, d5, l2);
    }

    static native void nglVertexAttribL4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glVertexAttribL1(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL1dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 1);
        GL41.nglVertexAttribL1dv(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglVertexAttribL1dv(int var0, long var1, long var3);

    public static void glVertexAttribL2(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL2dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 2);
        GL41.nglVertexAttribL2dv(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglVertexAttribL2dv(int var0, long var1, long var3);

    public static void glVertexAttribL3(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL3dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 3);
        GL41.nglVertexAttribL3dv(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglVertexAttribL3dv(int var0, long var1, long var3);

    public static void glVertexAttribL4(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribL4dv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        GL41.nglVertexAttribL4dv(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglVertexAttribL4dv(int var0, long var1, long var3);

    public static void glVertexAttribLPointer(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribLPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = doubleBuffer;
        }
        GL41.nglVertexAttribLPointer(n2, n3, 5130, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglVertexAttribLPointer(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexAttribLPointer(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexAttribLPointer;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL41.nglVertexAttribLPointerBO(n2, n3, 5130, n4, l2, l3);
    }

    static native void nglVertexAttribLPointerBO(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetVertexAttribL(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribLdv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        GL41.nglGetVertexAttribLdv(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetVertexAttribLdv(int var0, int var1, long var2, long var4);

    public static void glViewportArray(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glViewportArrayv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglViewportArrayv(n2, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglViewportArrayv(int var0, int var1, long var2, long var4);

    public static void glViewportIndexedf(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glViewportIndexedf;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglViewportIndexedf(n2, f2, f3, f4, f5, l2);
    }

    static native void nglViewportIndexedf(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glViewportIndexed(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glViewportIndexedfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        GL41.nglViewportIndexedfv(n2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglViewportIndexedfv(int var0, long var1, long var3);

    public static void glScissorArray(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glScissorArrayv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL41.nglScissorArrayv(n2, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglScissorArrayv(int var0, int var1, long var2, long var4);

    public static void glScissorIndexed(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glScissorIndexed;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglScissorIndexed(n2, n3, n4, n5, n6, l2);
    }

    static native void nglScissorIndexed(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glScissorIndexed(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glScissorIndexedv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL41.nglScissorIndexedv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglScissorIndexedv(int var0, long var1, long var3);

    public static void glDepthRangeArray(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDepthRangeArrayv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglDepthRangeArrayv(n2, doubleBuffer.remaining() >> 1, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglDepthRangeArrayv(int var0, int var1, long var2, long var4);

    public static void glDepthRangeIndexed(int n2, double d2, double d3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDepthRangeIndexed;
        BufferChecks.checkFunctionAddress(l2);
        GL41.nglDepthRangeIndexed(n2, d2, d3, l2);
    }

    static native void nglDepthRangeIndexed(int var0, double var1, double var3, long var5);

    public static void glGetFloat(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloati_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL41.nglGetFloati_v(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetFloati_v(int var0, int var1, long var2, long var4);

    public static float glGetFloat(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloati_v;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        GL41.nglGetFloati_v(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetDouble(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoublei_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL41.nglGetDoublei_v(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetDoublei_v(int var0, int var1, long var2, long var4);

    public static double glGetDouble(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoublei_v;
        BufferChecks.checkFunctionAddress(l2);
        DoubleBuffer doubleBuffer = APIUtil.getBufferDouble(contextCapabilities);
        GL41.nglGetDoublei_v(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
        return doubleBuffer.get(0);
    }
}

