/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;

public final class GL32 {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    private GL32() {
    }

    public static void glGetBufferParameter(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 4);
        GL32.nglGetBufferParameteri64v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetBufferParameteri64v(int var0, int var1, long var2, long var4);

    @Deprecated
    public static long glGetBufferParameter(int n2, int n3) {
        return GL32.glGetBufferParameteri64(n2, n3);
    }

    public static long glGetBufferParameteri64(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetBufferParameteri64v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glDrawElementsBaseVertex(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL32.nglDrawElementsBaseVertex(n2, byteBuffer.remaining(), 5121, MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glDrawElementsBaseVertex(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL32.nglDrawElementsBaseVertex(n2, intBuffer.remaining(), 5125, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glDrawElementsBaseVertex(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL32.nglDrawElementsBaseVertex(n2, shortBuffer.remaining(), 5123, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glDrawElementsBaseVertex(int n2, int n3, int n4, long l2, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawElementsBaseVertexBO(n2, n3, n4, l2, n5, l3);
    }

    static native void nglDrawElementsBaseVertexBO(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL32.nglDrawRangeElementsBaseVertex(n2, n3, n4, byteBuffer.remaining(), 5121, MemoryUtil.getAddress(byteBuffer), n5, l2);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, IntBuffer intBuffer, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL32.nglDrawRangeElementsBaseVertex(n2, n3, n4, intBuffer.remaining(), 5125, MemoryUtil.getAddress(intBuffer), n5, l2);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, ShortBuffer shortBuffer, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL32.nglDrawRangeElementsBaseVertex(n2, n3, n4, shortBuffer.remaining(), 5123, MemoryUtil.getAddress(shortBuffer), n5, l2);
    }

    static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, int n5, int n6, long l2, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawRangeElementsBaseVertexBO(n2, n3, n4, n5, n6, l2, n7, l3);
    }

    static native void nglDrawRangeElementsBaseVertexBO(int var0, int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    public static void glDrawElementsInstancedBaseVertex(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        GL32.nglDrawElementsInstancedBaseVertex(n2, byteBuffer.remaining(), 5121, MemoryUtil.getAddress(byteBuffer), n3, n4, l2);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, IntBuffer intBuffer, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        GL32.nglDrawElementsInstancedBaseVertex(n2, intBuffer.remaining(), 5125, MemoryUtil.getAddress(intBuffer), n3, n4, l2);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, ShortBuffer shortBuffer, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        GL32.nglDrawElementsInstancedBaseVertex(n2, shortBuffer.remaining(), 5123, MemoryUtil.getAddress(shortBuffer), n3, n4, l2);
    }

    static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6, long var7);

    public static void glDrawElementsInstancedBaseVertex(int n2, int n3, int n4, long l2, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawElementsInstancedBaseVertexBO(n2, n3, n4, l2, n5, n6, l3);
    }

    static native void nglDrawElementsInstancedBaseVertexBO(int var0, int var1, int var2, long var3, int var5, int var6, long var7);

    public static void glProvokingVertex(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProvokingVertex;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglProvokingVertex(n2, l2);
    }

    static native void nglProvokingVertex(int var0, long var1);

    public static void glTexImage2DMultisample(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexImage2DMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglTexImage2DMultisample(n2, n3, n4, n5, n6, bl2, l2);
    }

    static native void nglTexImage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    public static void glTexImage3DMultisample(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexImage3DMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglTexImage3DMultisample(n2, n3, n4, n5, n6, n7, bl2, l2);
    }

    static native void nglTexImage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, long var7);

    public static void glGetMultisample(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultisamplefv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 2);
        GL32.nglGetMultisamplefv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetMultisamplefv(int var0, int var1, long var2, long var4);

    public static void glSampleMaski(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glSampleMaski;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglSampleMaski(n2, n3, l2);
    }

    static native void nglSampleMaski(int var0, int var1, long var2);

    public static void glFramebufferTexture(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferTexture;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglFramebufferTexture(n2, n3, n4, n5, l2);
    }

    static native void nglFramebufferTexture(int var0, int var1, int var2, int var3, long var4);

    public static GLSync glFenceSync(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFenceSync;
        BufferChecks.checkFunctionAddress(l2);
        GLSync gLSync = new GLSync(GL32.nglFenceSync(n2, n3, l2));
        return gLSync;
    }

    static native long nglFenceSync(int var0, int var1, long var2);

    public static boolean glIsSync(GLSync gLSync) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsSync;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL32.nglIsSync(gLSync.getPointer(), l2);
        return bl2;
    }

    static native boolean nglIsSync(long var0, long var2);

    public static void glDeleteSync(GLSync gLSync) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteSync;
        BufferChecks.checkFunctionAddress(l2);
        GL32.nglDeleteSync(gLSync.getPointer(), l2);
    }

    static native void nglDeleteSync(long var0, long var2);

    public static int glClientWaitSync(GLSync gLSync, int n2, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glClientWaitSync;
        BufferChecks.checkFunctionAddress(l3);
        int n3 = GL32.nglClientWaitSync(gLSync.getPointer(), n2, l2, l3);
        return n3;
    }

    static native int nglClientWaitSync(long var0, int var2, long var3, long var5);

    public static void glWaitSync(GLSync gLSync, int n2, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glWaitSync;
        BufferChecks.checkFunctionAddress(l3);
        GL32.nglWaitSync(gLSync.getPointer(), n2, l2, l3);
    }

    static native void nglWaitSync(long var0, int var2, long var3, long var5);

    public static void glGetInteger64(int n2, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInteger64v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 1);
        GL32.nglGetInteger64v(n2, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetInteger64v(int var0, long var1, long var3);

    public static long glGetInteger64(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInteger64v;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetInteger64v(n2, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glGetInteger64(int n2, int n3, LongBuffer longBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInteger64i_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(longBuffer, 4);
        GL32.nglGetInteger64i_v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
    }

    static native void nglGetInteger64i_v(int var0, int var1, long var2, long var4);

    public static long glGetInteger64(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInteger64i_v;
        BufferChecks.checkFunctionAddress(l2);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetInteger64i_v(n2, n3, MemoryUtil.getAddress(longBuffer), l2);
        return longBuffer.get(0);
    }

    public static void glGetSync(GLSync gLSync, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetSynciv;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(intBuffer2);
        GL32.nglGetSynciv(gLSync.getPointer(), n2, intBuffer2.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), l2);
    }

    static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6, long var8);

    @Deprecated
    public static int glGetSync(GLSync gLSync, int n2) {
        return GL32.glGetSynci(gLSync, n2);
    }

    public static int glGetSynci(GLSync gLSync, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetSynciv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL32.nglGetSynciv(gLSync.getPointer(), n2, 1, 0L, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }
}

