/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL30 {
    public static final int GL_MAJOR_VERSION = 33307;
    public static final int GL_MINOR_VERSION = 33308;
    public static final int GL_NUM_EXTENSIONS = 33309;
    public static final int GL_CONTEXT_FLAGS = 33310;
    public static final int GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 1;
    public static final int GL_DEPTH_BUFFER = 33315;
    public static final int GL_STENCIL_BUFFER = 33316;
    public static final int GL_COMPRESSED_RED = 33317;
    public static final int GL_COMPRESSED_RG = 33318;
    public static final int GL_COMPARE_REF_TO_TEXTURE = 34894;
    public static final int GL_CLIP_DISTANCE0 = 12288;
    public static final int GL_CLIP_DISTANCE1 = 12289;
    public static final int GL_CLIP_DISTANCE2 = 12290;
    public static final int GL_CLIP_DISTANCE3 = 12291;
    public static final int GL_CLIP_DISTANCE4 = 12292;
    public static final int GL_CLIP_DISTANCE5 = 12293;
    public static final int GL_CLIP_DISTANCE6 = 12294;
    public static final int GL_CLIP_DISTANCE7 = 12295;
    public static final int GL_MAX_CLIP_DISTANCES = 3378;
    public static final int GL_MAX_VARYING_COMPONENTS = 35659;
    public static final int GL_BUFFER_ACCESS_FLAGS = 37151;
    public static final int GL_BUFFER_MAP_LENGTH = 37152;
    public static final int GL_BUFFER_MAP_OFFSET = 37153;
    public static final int GL_VERTEX_ATTRIB_ARRAY_INTEGER = 35069;
    public static final int GL_SAMPLER_BUFFER = 36290;
    public static final int GL_SAMPLER_CUBE_SHADOW = 36293;
    public static final int GL_UNSIGNED_INT_VEC2 = 36294;
    public static final int GL_UNSIGNED_INT_VEC3 = 36295;
    public static final int GL_UNSIGNED_INT_VEC4 = 36296;
    public static final int GL_INT_SAMPLER_1D = 36297;
    public static final int GL_INT_SAMPLER_2D = 36298;
    public static final int GL_INT_SAMPLER_3D = 36299;
    public static final int GL_INT_SAMPLER_CUBE = 36300;
    public static final int GL_INT_SAMPLER_2D_RECT = 36301;
    public static final int GL_INT_SAMPLER_1D_ARRAY = 36302;
    public static final int GL_INT_SAMPLER_2D_ARRAY = 36303;
    public static final int GL_INT_SAMPLER_BUFFER = 36304;
    public static final int GL_UNSIGNED_INT_SAMPLER_1D = 36305;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D = 36306;
    public static final int GL_UNSIGNED_INT_SAMPLER_3D = 36307;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE = 36308;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_RECT = 36309;
    public static final int GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 36310;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER = 36312;
    public static final int GL_MIN_PROGRAM_TEXEL_OFFSET = 35076;
    public static final int GL_MAX_PROGRAM_TEXEL_OFFSET = 35077;
    public static final int GL_QUERY_WAIT = 36371;
    public static final int GL_QUERY_NO_WAIT = 36372;
    public static final int GL_QUERY_BY_REGION_WAIT = 36373;
    public static final int GL_QUERY_BY_REGION_NO_WAIT = 36374;
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public static final int GL_CLAMP_VERTEX_COLOR = 35098;
    public static final int GL_CLAMP_FRAGMENT_COLOR = 35099;
    public static final int GL_CLAMP_READ_COLOR = 35100;
    public static final int GL_FIXED_ONLY = 35101;
    public static final int GL_DEPTH_COMPONENT32F = 36012;
    public static final int GL_DEPTH32F_STENCIL8 = 36013;
    public static final int GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;
    public static final int GL_TEXTURE_RED_TYPE = 35856;
    public static final int GL_TEXTURE_GREEN_TYPE = 35857;
    public static final int GL_TEXTURE_BLUE_TYPE = 35858;
    public static final int GL_TEXTURE_ALPHA_TYPE = 35859;
    public static final int GL_TEXTURE_LUMINANCE_TYPE = 35860;
    public static final int GL_TEXTURE_INTENSITY_TYPE = 35861;
    public static final int GL_TEXTURE_DEPTH_TYPE = 35862;
    public static final int GL_UNSIGNED_NORMALIZED = 35863;
    public static final int GL_RGBA32F = 34836;
    public static final int GL_RGB32F = 34837;
    public static final int GL_ALPHA32F = 34838;
    public static final int GL_RGBA16F = 34842;
    public static final int GL_RGB16F = 34843;
    public static final int GL_ALPHA16F = 34844;
    public static final int GL_R11F_G11F_B10F = 35898;
    public static final int GL_UNSIGNED_INT_10F_11F_11F_REV = 35899;
    public static final int GL_RGB9_E5 = 35901;
    public static final int GL_UNSIGNED_INT_5_9_9_9_REV = 35902;
    public static final int GL_TEXTURE_SHARED_SIZE = 35903;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_STENCIL_INDEX1 = 36166;
    public static final int GL_STENCIL_INDEX4 = 36167;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_STENCIL_INDEX16 = 36169;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public static final int GL_FRAMEBUFFER_DEFAULT = 33304;
    public static final int GL_INDEX = 33314;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_COLOR_ATTACHMENT4 = 36068;
    public static final int GL_COLOR_ATTACHMENT5 = 36069;
    public static final int GL_COLOR_ATTACHMENT6 = 36070;
    public static final int GL_COLOR_ATTACHMENT7 = 36071;
    public static final int GL_COLOR_ATTACHMENT8 = 36072;
    public static final int GL_COLOR_ATTACHMENT9 = 36073;
    public static final int GL_COLOR_ATTACHMENT10 = 36074;
    public static final int GL_COLOR_ATTACHMENT11 = 36075;
    public static final int GL_COLOR_ATTACHMENT12 = 36076;
    public static final int GL_COLOR_ATTACHMENT13 = 36077;
    public static final int GL_COLOR_ATTACHMENT14 = 36078;
    public static final int GL_COLOR_ATTACHMENT15 = 36079;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_DEPTH_STENCIL_ATTACHMENT = 33306;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_UNDEFINED = 33305;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_COLOR_ATTACHMENTS = 36063;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;
    public static final int GL_HALF_FLOAT = 5131;
    public static final int GL_RENDERBUFFER_SAMPLES = 36011;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_DRAW_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL_RGBA_INTEGER_MODE = 36254;
    public static final int GL_RGBA32UI = 36208;
    public static final int GL_RGB32UI = 36209;
    public static final int GL_ALPHA32UI = 36210;
    public static final int GL_RGBA16UI = 36214;
    public static final int GL_RGB16UI = 36215;
    public static final int GL_ALPHA16UI = 36216;
    public static final int GL_RGBA8UI = 36220;
    public static final int GL_RGB8UI = 36221;
    public static final int GL_ALPHA8UI = 36222;
    public static final int GL_RGBA32I = 36226;
    public static final int GL_RGB32I = 36227;
    public static final int GL_ALPHA32I = 36228;
    public static final int GL_RGBA16I = 36232;
    public static final int GL_RGB16I = 36233;
    public static final int GL_ALPHA16I = 36234;
    public static final int GL_RGBA8I = 36238;
    public static final int GL_RGB8I = 36239;
    public static final int GL_ALPHA8I = 36240;
    public static final int GL_RED_INTEGER = 36244;
    public static final int GL_GREEN_INTEGER = 36245;
    public static final int GL_BLUE_INTEGER = 36246;
    public static final int GL_ALPHA_INTEGER = 36247;
    public static final int GL_RGB_INTEGER = 36248;
    public static final int GL_RGBA_INTEGER = 36249;
    public static final int GL_BGR_INTEGER = 36250;
    public static final int GL_BGRA_INTEGER = 36251;
    public static final int GL_TEXTURE_1D_ARRAY = 35864;
    public static final int GL_TEXTURE_2D_ARRAY = 35866;
    public static final int GL_PROXY_TEXTURE_2D_ARRAY = 35867;
    public static final int GL_PROXY_TEXTURE_1D_ARRAY = 35865;
    public static final int GL_TEXTURE_BINDING_1D_ARRAY = 35868;
    public static final int GL_TEXTURE_BINDING_2D_ARRAY = 35869;
    public static final int GL_MAX_ARRAY_TEXTURE_LAYERS = 35071;
    public static final int GL_COMPARE_REF_DEPTH_TO_TEXTURE = 34894;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_SAMPLER_1D_ARRAY = 36288;
    public static final int GL_SAMPLER_2D_ARRAY = 36289;
    public static final int GL_SAMPLER_1D_ARRAY_SHADOW = 36291;
    public static final int GL_SAMPLER_2D_ARRAY_SHADOW = 36292;
    public static final int GL_DEPTH_STENCIL = 34041;
    public static final int GL_UNSIGNED_INT_24_8 = 34042;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_TEXTURE_STENCIL_SIZE = 35057;
    public static final int GL_COMPRESSED_RED_RGTC1 = 36283;
    public static final int GL_COMPRESSED_SIGNED_RED_RGTC1 = 36284;
    public static final int GL_COMPRESSED_RG_RGTC2 = 36285;
    public static final int GL_COMPRESSED_SIGNED_RG_RGTC2 = 36286;
    public static final int GL_R8 = 33321;
    public static final int GL_R16 = 33322;
    public static final int GL_RG8 = 33323;
    public static final int GL_RG16 = 33324;
    public static final int GL_R16F = 33325;
    public static final int GL_R32F = 33326;
    public static final int GL_RG16F = 33327;
    public static final int GL_RG32F = 33328;
    public static final int GL_R8I = 33329;
    public static final int GL_R8UI = 33330;
    public static final int GL_R16I = 33331;
    public static final int GL_R16UI = 33332;
    public static final int GL_R32I = 33333;
    public static final int GL_R32UI = 33334;
    public static final int GL_RG8I = 33335;
    public static final int GL_RG8UI = 33336;
    public static final int GL_RG16I = 33337;
    public static final int GL_RG16UI = 33338;
    public static final int GL_RG32I = 33339;
    public static final int GL_RG32UI = 33340;
    public static final int GL_RG = 33319;
    public static final int GL_RG_INTEGER = 33320;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS = 35980;
    public static final int GL_SEPARATE_ATTRIBS = 35981;
    public static final int GL_PRIMITIVES_GENERATED = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;
    public static final int GL_RASTERIZER_DISCARD = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 35958;
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;
    public static final int GL_FRAMEBUFFER_SRGB = 36281;
    public static final int GL_FRAMEBUFFER_SRGB_CAPABLE = 36282;

    private GL30() {
    }

    public static String glGetStringi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetStringi;
        BufferChecks.checkFunctionAddress(l2);
        String string = GL30.nglGetStringi(n2, n3, l2);
        return string;
    }

    static native String nglGetStringi(int var0, int var1, long var2);

    public static void glClearBuffer(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearBufferfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        GL30.nglClearBufferfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglClearBufferfv(int var0, int var1, long var2, long var4);

    public static void glClearBuffer(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearBufferiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglClearBufferiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglClearBufferiv(int var0, int var1, long var2, long var4);

    public static void glClearBufferu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearBufferuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglClearBufferuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglClearBufferuiv(int var0, int var1, long var2, long var4);

    public static void glClearBufferfi(int n2, int n3, float f2, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClearBufferfi;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglClearBufferfi(n2, n3, f2, n4, l2);
    }

    static native void nglClearBufferfi(int var0, int var1, float var2, int var3, long var4);

    public static void glVertexAttribI1i(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI1i;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI1i(n2, n3, l2);
    }

    static native void nglVertexAttribI1i(int var0, int var1, long var2);

    public static void glVertexAttribI2i(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI2i;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI2i(n2, n3, n4, l2);
    }

    static native void nglVertexAttribI2i(int var0, int var1, int var2, long var3);

    public static void glVertexAttribI3i(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI3i;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI3i(n2, n3, n4, n5, l2);
    }

    static native void nglVertexAttribI3i(int var0, int var1, int var2, int var3, long var4);

    public static void glVertexAttribI4i(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4i;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI4i(n2, n3, n4, n5, n6, l2);
    }

    static native void nglVertexAttribI4i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexAttribI1ui(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI1ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI1ui(n2, n3, l2);
    }

    static native void nglVertexAttribI1ui(int var0, int var1, long var2);

    public static void glVertexAttribI2ui(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI2ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI2ui(n2, n3, n4, l2);
    }

    static native void nglVertexAttribI2ui(int var0, int var1, int var2, long var3);

    public static void glVertexAttribI3ui(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI3ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI3ui(n2, n3, n4, n5, l2);
    }

    static native void nglVertexAttribI3ui(int var0, int var1, int var2, int var3, long var4);

    public static void glVertexAttribI4ui(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglVertexAttribI4ui(n2, n3, n4, n5, n6, l2);
    }

    static native void nglVertexAttribI4ui(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexAttribI1(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI1iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL30.nglVertexAttribI1iv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI1iv(int var0, long var1, long var3);

    public static void glVertexAttribI2(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI2iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        GL30.nglVertexAttribI2iv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI2iv(int var0, long var1, long var3);

    public static void glVertexAttribI3(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI3iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 3);
        GL30.nglVertexAttribI3iv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI3iv(int var0, long var1, long var3);

    public static void glVertexAttribI4(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglVertexAttribI4iv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI4iv(int var0, long var1, long var3);

    public static void glVertexAttribI1u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI1uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL30.nglVertexAttribI1uiv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI1uiv(int var0, long var1, long var3);

    public static void glVertexAttribI2u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI2uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        GL30.nglVertexAttribI2uiv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI2uiv(int var0, long var1, long var3);

    public static void glVertexAttribI3u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI3uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 3);
        GL30.nglVertexAttribI3uiv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI3uiv(int var0, long var1, long var3);

    public static void glVertexAttribI4u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglVertexAttribI4uiv(n2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglVertexAttribI4uiv(int var0, long var1, long var3);

    public static void glVertexAttribI4(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4bv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 4);
        GL30.nglVertexAttribI4bv(n2, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglVertexAttribI4bv(int var0, long var1, long var3);

    public static void glVertexAttribI4(int n2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4sv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(shortBuffer, 4);
        GL30.nglVertexAttribI4sv(n2, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglVertexAttribI4sv(int var0, long var1, long var3);

    public static void glVertexAttribI4u(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4ubv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 4);
        GL30.nglVertexAttribI4ubv(n2, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglVertexAttribI4ubv(int var0, long var1, long var3);

    public static void glVertexAttribI4u(int n2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribI4usv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(shortBuffer, 4);
        GL30.nglVertexAttribI4usv(n2, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglVertexAttribI4usv(int var0, long var1, long var3);

    public static void glVertexAttribIPointer(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribIPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = byteBuffer;
        }
        GL30.nglVertexAttribIPointer(n2, n3, n4, n5, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glVertexAttribIPointer(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribIPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = intBuffer;
        }
        GL30.nglVertexAttribIPointer(n2, n3, n4, n5, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glVertexAttribIPointer(int n2, int n3, int n4, int n5, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribIPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = shortBuffer;
        }
        GL30.nglVertexAttribIPointer(n2, n3, n4, n5, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglVertexAttribIPointer(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexAttribIPointer(int n2, int n3, int n4, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexAttribIPointer;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL30.nglVertexAttribIPointerBO(n2, n3, n4, n5, l2, l3);
    }

    static native void nglVertexAttribIPointerBO(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetVertexAttribI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribIiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetVertexAttribIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexAttribIiv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttribIu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribIuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetVertexAttribIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexAttribIuiv(int var0, int var1, long var2, long var4);

    public static void glUniform1ui(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglUniform1ui(n2, n3, l2);
    }

    static native void nglUniform1ui(int var0, int var1, long var2);

    public static void glUniform2ui(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglUniform2ui(n2, n3, n4, l2);
    }

    static native void nglUniform2ui(int var0, int var1, int var2, long var3);

    public static void glUniform3ui(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglUniform3ui(n2, n3, n4, n5, l2);
    }

    static native void nglUniform3ui(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4ui(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4ui;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglUniform4ui(n2, n3, n4, n5, n6, l2);
    }

    static native void nglUniform4ui(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglUniform1uiv(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform1uiv(int var0, int var1, long var2, long var4);

    public static void glUniform2u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglUniform2uiv(n2, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform2uiv(int var0, int var1, long var2, long var4);

    public static void glUniform3u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglUniform3uiv(n2, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform3uiv(int var0, int var1, long var2, long var4);

    public static void glUniform4u(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4uiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglUniform4uiv(n2, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform4uiv(int var0, int var1, long var2, long var4);

    public static void glGetUniformu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglGetUniformuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetUniformuiv(int var0, int var1, long var2, long var4);

    public static void glBindFragDataLocation(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindFragDataLocation;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        GL30.nglBindFragDataLocation(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglBindFragDataLocation(int var0, int var1, long var2, long var4);

    public static void glBindFragDataLocation(int n2, int n3, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindFragDataLocation;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBindFragDataLocation(n2, n3, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
    }

    public static int glGetFragDataLocation(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFragDataLocation;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = GL30.nglGetFragDataLocation(n2, MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    static native int nglGetFragDataLocation(int var0, long var1, long var3);

    public static int glGetFragDataLocation(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFragDataLocation;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL30.nglGetFragDataLocation(n2, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
        return n3;
    }

    public static void glBeginConditionalRender(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBeginConditionalRender;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBeginConditionalRender(n2, n3, l2);
    }

    static native void nglBeginConditionalRender(int var0, int var1, long var2);

    public static void glEndConditionalRender() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEndConditionalRender;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglEndConditionalRender(l2);
    }

    static native void nglEndConditionalRender(long var0);

    public static ByteBuffer glMapBufferRange(int n2, long l2, long l3, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glMapBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL30.nglMapBufferRange(n2, l2, l3, n3, byteBuffer, l4);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapBufferRange(int var0, long var1, long var3, int var5, ByteBuffer var6, long var7);

    public static void glFlushMappedBufferRange(int n2, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glFlushMappedBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        GL30.nglFlushMappedBufferRange(n2, l2, l3, l4);
    }

    static native void nglFlushMappedBufferRange(int var0, long var1, long var3, long var5);

    public static void glClampColor(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClampColor;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglClampColor(n2, n3, l2);
    }

    static native void nglClampColor(int var0, int var1, long var2);

    public static boolean glIsRenderbuffer(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsRenderbuffer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL30.nglIsRenderbuffer(n2, l2);
        return bl2;
    }

    static native boolean nglIsRenderbuffer(int var0, long var1);

    public static void glBindRenderbuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindRenderbuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBindRenderbuffer(n2, n3, l2);
    }

    static native void nglBindRenderbuffer(int var0, int var1, long var2);

    public static void glDeleteRenderbuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglDeleteRenderbuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteRenderbuffers(int var0, long var1, long var3);

    public static void glDeleteRenderbuffers(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglDeleteRenderbuffers(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenRenderbuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglGenRenderbuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenRenderbuffers(int var0, long var1, long var3);

    public static int glGenRenderbuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenRenderbuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGenRenderbuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glRenderbufferStorage(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glRenderbufferStorage;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglRenderbufferStorage(n2, n3, n4, n5, l2);
    }

    static native void nglRenderbufferStorage(int var0, int var1, int var2, int var3, long var4);

    public static void glGetRenderbufferParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetRenderbufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetRenderbufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetRenderbufferParameteriv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetRenderbufferParameter(int n2, int n3) {
        return GL30.glGetRenderbufferParameteri(n2, n3);
    }

    public static int glGetRenderbufferParameteri(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetRenderbufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGetRenderbufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static boolean glIsFramebuffer(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsFramebuffer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL30.nglIsFramebuffer(n2, l2);
        return bl2;
    }

    static native boolean nglIsFramebuffer(int var0, long var1);

    public static void glBindFramebuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindFramebuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBindFramebuffer(n2, n3, l2);
    }

    static native void nglBindFramebuffer(int var0, int var1, long var2);

    public static void glDeleteFramebuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglDeleteFramebuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteFramebuffers(int var0, long var1, long var3);

    public static void glDeleteFramebuffers(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglDeleteFramebuffers(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenFramebuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglGenFramebuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenFramebuffers(int var0, long var1, long var3);

    public static int glGenFramebuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenFramebuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGenFramebuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static int glCheckFramebufferStatus(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCheckFramebufferStatus;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL30.nglCheckFramebufferStatus(n2, l2);
        return n3;
    }

    static native int nglCheckFramebufferStatus(int var0, long var1);

    public static void glFramebufferTexture1D(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferTexture1D;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglFramebufferTexture1D(n2, n3, n4, n5, n6, l2);
    }

    static native void nglFramebufferTexture1D(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glFramebufferTexture2D(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferTexture2D;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglFramebufferTexture2D(n2, n3, n4, n5, n6, l2);
    }

    static native void nglFramebufferTexture2D(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glFramebufferTexture3D(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferTexture3D;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglFramebufferTexture3D(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglFramebufferTexture3D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glFramebufferRenderbuffer(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferRenderbuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglFramebufferRenderbuffer(n2, n3, n4, n5, l2);
    }

    static native void nglFramebufferRenderbuffer(int var0, int var1, int var2, int var3, long var4);

    public static void glGetFramebufferAttachmentParameter(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFramebufferAttachmentParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3, long var5);

    @Deprecated
    public static int glGetFramebufferAttachmentParameter(int n2, int n3, int n4) {
        return GL30.glGetFramebufferAttachmentParameteri(n2, n3, n4);
    }

    public static int glGetFramebufferAttachmentParameteri(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFramebufferAttachmentParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGetFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGenerateMipmap(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenerateMipmap;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglGenerateMipmap(n2, l2);
    }

    static native void nglGenerateMipmap(int var0, long var1);

    public static void glRenderbufferStorageMultisample(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glRenderbufferStorageMultisample;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglRenderbufferStorageMultisample(n2, n3, n4, n5, n6, l2);
    }

    static native void nglRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glBlitFramebuffer(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBlitFramebuffer;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBlitFramebuffer(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2);
    }

    static native void nglBlitFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glTexParameterI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglTexParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTexParameterIiv(int var0, int var1, long var2, long var4);

    public static void glTexParameterIi(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglTexParameterIiv(n2, n3, APIUtil.getInt(contextCapabilities, n4), l2);
    }

    public static void glTexParameterIu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglTexParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTexParameterIuiv(int var0, int var1, long var2, long var4);

    public static void glTexParameterIui(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTexParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglTexParameterIuiv(n2, n3, APIUtil.getInt(contextCapabilities, n4), l2);
    }

    public static void glGetTexParameterI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTexParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetTexParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTexParameterIiv(int var0, int var1, long var2, long var4);

    public static int glGetTexParameterIi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTexParameterIiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGetTexParameterIiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTexParameterIu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTexParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetTexParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTexParameterIuiv(int var0, int var1, long var2, long var4);

    public static int glGetTexParameterIui(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTexParameterIuiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGetTexParameterIuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glFramebufferTextureLayer(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferTextureLayer;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglFramebufferTextureLayer(n2, n3, n4, n5, n6, l2);
    }

    static native void nglFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glColorMaski(int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glColorMaski;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglColorMaski(n2, bl2, bl3, bl4, bl5, l2);
    }

    static native void nglColorMaski(int var0, boolean var1, boolean var2, boolean var3, boolean var4, long var5);

    public static void glGetBoolean(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBooleani_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 4);
        GL30.nglGetBooleani_v(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetBooleani_v(int var0, int var1, long var2, long var4);

    public static boolean glGetBoolean(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBooleani_v;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, 1);
        GL30.nglGetBooleani_v(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
        return byteBuffer.get(0) == 1;
    }

    public static void glGetInteger(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetIntegeri_v;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL30.nglGetIntegeri_v(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetIntegeri_v(int var0, int var1, long var2, long var4);

    public static int glGetInteger(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetIntegeri_v;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGetIntegeri_v(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glEnablei(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnablei;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglEnablei(n2, n3, l2);
    }

    static native void nglEnablei(int var0, int var1, long var2);

    public static void glDisablei(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisablei;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglDisablei(n2, n3, l2);
    }

    static native void nglDisablei(int var0, int var1, long var2);

    public static boolean glIsEnabledi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsEnabledi;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL30.nglIsEnabledi(n2, n3, l2);
        return bl2;
    }

    static native boolean nglIsEnabledi(int var0, int var1, long var2);

    public static void glBindBufferRange(int n2, int n3, int n4, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glBindBufferRange;
        BufferChecks.checkFunctionAddress(l4);
        GL30.nglBindBufferRange(n2, n3, n4, l2, l3, l4);
    }

    static native void nglBindBufferRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBufferBase(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindBufferBase;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBindBufferBase(n2, n3, n4, l2);
    }

    static native void nglBindBufferBase(int var0, int var1, int var2, long var3);

    public static void glBeginTransformFeedback(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBeginTransformFeedback;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglBeginTransformFeedback(n2, l2);
    }

    static native void nglBeginTransformFeedback(int var0, long var1);

    public static void glEndTransformFeedback() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEndTransformFeedback;
        BufferChecks.checkFunctionAddress(l2);
        GL30.nglEndTransformFeedback(l2);
    }

    static native void nglEndTransformFeedback(long var0);

    public static void glTransformFeedbackVaryings(int n2, int n3, ByteBuffer byteBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTransformFeedbackVaryings;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer, n3);
        GL30.nglTransformFeedbackVaryings(n2, n3, MemoryUtil.getAddress(byteBuffer), n4, l2);
    }

    static native void nglTransformFeedbackVaryings(int var0, int var1, long var2, int var4, long var5);

    public static void glTransformFeedbackVaryings(int n2, CharSequence[] charSequenceArray, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTransformFeedbackVaryings;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(charSequenceArray);
        GL30.nglTransformFeedbackVaryings(n2, charSequenceArray.length, APIUtil.getBufferNT(contextCapabilities, charSequenceArray), n3, l2);
    }

    public static void glGetTransformFeedbackVarying(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbackVarying;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkBuffer(intBuffer2, 1);
        BufferChecks.checkBuffer(intBuffer3, 1);
        BufferChecks.checkDirect(byteBuffer);
        GL30.nglGetTransformFeedbackVarying(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(intBuffer3), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetTransformFeedbackVarying(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetTransformFeedbackVarying(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTransformFeedbackVarying;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        BufferChecks.checkBuffer(intBuffer2, 1);
        IntBuffer intBuffer3 = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        GL30.nglGetTransformFeedbackVarying(n2, n3, n4, MemoryUtil.getAddress0(intBuffer3), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer3.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glBindVertexArray(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindVertexArray;
        BufferChecks.checkFunctionAddress(l2);
        StateTracker.bindVAO(contextCapabilities, n2);
        GL30.nglBindVertexArray(n2, l2);
    }

    static native void nglBindVertexArray(int var0, long var1);

    public static void glDeleteVertexArrays(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        StateTracker.deleteVAO(contextCapabilities, intBuffer);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglDeleteVertexArrays(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteVertexArrays(int var0, long var1, long var3);

    public static void glDeleteVertexArrays(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        StateTracker.deleteVAO(contextCapabilities, n2);
        GL30.nglDeleteVertexArrays(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenVertexArrays(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL30.nglGenVertexArrays(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenVertexArrays(int var0, long var1, long var3);

    public static int glGenVertexArrays() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenVertexArrays;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL30.nglGenVertexArrays(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static boolean glIsVertexArray(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsVertexArray;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL30.nglIsVertexArray(n2, l2);
        return bl2;
    }

    static native boolean nglIsVertexArray(int var0, long var1);
}

