/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_OBJECT = 35656;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;

    private GL20() {
    }

    public static void glShaderSource(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglShaderSource(n2, 1, MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), l2);
    }

    static native void nglShaderSource(int var0, int var1, long var2, int var4, long var5);

    public static void glShaderSource(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglShaderSource(n2, 1, APIUtil.getBuffer(contextCapabilities, charSequence), charSequence.length(), l2);
    }

    public static void glShaderSource(int n2, CharSequence[] charSequenceArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(charSequenceArray);
        GL20.nglShaderSource3(n2, charSequenceArray.length, APIUtil.getBuffer(contextCapabilities, charSequenceArray), APIUtil.getLengths(contextCapabilities, charSequenceArray), l2);
    }

    static native void nglShaderSource3(int var0, int var1, long var2, long var4, long var6);

    public static int glCreateShader(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShader;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL20.nglCreateShader(n2, l2);
        return n3;
    }

    static native int nglCreateShader(int var0, long var1);

    public static boolean glIsShader(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsShader;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL20.nglIsShader(n2, l2);
        return bl2;
    }

    static native boolean nglIsShader(int var0, long var1);

    public static void glCompileShader(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompileShader;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglCompileShader(n2, l2);
    }

    static native void nglCompileShader(int var0, long var1);

    public static void glDeleteShader(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteShader;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglDeleteShader(n2, l2);
    }

    static native void nglDeleteShader(int var0, long var1);

    public static int glCreateProgram() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateProgram;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = GL20.nglCreateProgram(l2);
        return n2;
    }

    static native int nglCreateProgram(long var0);

    public static boolean glIsProgram(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsProgram;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL20.nglIsProgram(n2, l2);
        return bl2;
    }

    static native boolean nglIsProgram(int var0, long var1);

    public static void glAttachShader(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glAttachShader;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglAttachShader(n2, n3, l2);
    }

    static native void nglAttachShader(int var0, int var1, long var2);

    public static void glDetachShader(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDetachShader;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglDetachShader(n2, n3, l2);
    }

    static native void nglDetachShader(int var0, int var1, long var2);

    public static void glLinkProgram(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glLinkProgram;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglLinkProgram(n2, l2);
    }

    static native void nglLinkProgram(int var0, long var1);

    public static void glUseProgram(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUseProgram;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUseProgram(n2, l2);
    }

    static native void nglUseProgram(int var0, long var1);

    public static void glValidateProgram(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glValidateProgram;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglValidateProgram(n2, l2);
    }

    static native void nglValidateProgram(int var0, long var1);

    public static void glDeleteProgram(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteProgram;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglDeleteProgram(n2, l2);
    }

    static native void nglDeleteProgram(int var0, long var1);

    public static void glUniform1f(int n2, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform1f(n2, f2, l2);
    }

    static native void nglUniform1f(int var0, float var1, long var2);

    public static void glUniform2f(int n2, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform2f(n2, f2, f3, l2);
    }

    static native void nglUniform2f(int var0, float var1, float var2, long var3);

    public static void glUniform3f(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform3f(n2, f2, f3, f4, l2);
    }

    static native void nglUniform3f(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform4f(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform4f(n2, f2, f3, f4, f5, l2);
    }

    static native void nglUniform4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform1i(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1i;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform1i(n2, n3, l2);
    }

    static native void nglUniform1i(int var0, int var1, long var2);

    public static void glUniform2i(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2i;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform2i(n2, n3, n4, l2);
    }

    static native void nglUniform2i(int var0, int var1, int var2, long var3);

    public static void glUniform3i(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3i;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform3i(n2, n3, n4, n5, l2);
    }

    static native void nglUniform3i(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4i(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4i;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglUniform4i(n2, n3, n4, n5, n6, l2);
    }

    static native void nglUniform4i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniform1fv(n2, floatBuffer.remaining(), MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform1fv(int var0, int var1, long var2, long var4);

    public static void glUniform2(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniform2fv(n2, floatBuffer.remaining() >> 1, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform2fv(int var0, int var1, long var2, long var4);

    public static void glUniform3(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniform3fv(n2, floatBuffer.remaining() / 3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform3fv(int var0, int var1, long var2, long var4);

    public static void glUniform4(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniform4fv(n2, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform4fv(int var0, int var1, long var2, long var4);

    public static void glUniform1(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglUniform1iv(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform1iv(int var0, int var1, long var2, long var4);

    public static void glUniform2(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglUniform2iv(n2, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform2iv(int var0, int var1, long var2, long var4);

    public static void glUniform3(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglUniform3iv(n2, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform3iv(int var0, int var1, long var2, long var4);

    public static void glUniform4(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4iv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglUniform4iv(n2, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform4iv(int var0, int var1, long var2, long var4);

    public static void glUniformMatrix2(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix2fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniformMatrix2fv(n2, floatBuffer.remaining() >> 2, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix3fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniformMatrix3fv(n2, floatBuffer.remaining() / 9, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix4fv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglUniformMatrix4fv(n2, floatBuffer.remaining() >> 4, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetShader(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglGetShaderiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetShaderiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetShader(int n2, int n3) {
        return GL20.glGetShaderi(n2, n3);
    }

    public static int glGetShaderi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetShaderiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetProgram(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglGetProgramiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetProgramiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetProgram(int n2, int n3) {
        return GL20.glGetProgrami(n2, n3);
    }

    public static int glGetProgrami(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetProgramiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetShaderInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglGetShaderInfoLog(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderInfoLog(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        GL20.nglGetShaderInfoLog(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetProgramInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglGetProgramInfoLog(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static String glGetProgramInfoLog(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetProgramInfoLog;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        GL20.nglGetProgramInfoLog(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetAttachedShaders(int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetAttachedShaders;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(intBuffer2);
        GL20.nglGetAttachedShaders(n2, intBuffer2.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), l2);
    }

    static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4, long var6);

    public static int glGetUniformLocation(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformLocation;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 1);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = GL20.nglGetUniformLocation(n2, MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    static native int nglGetUniformLocation(int var0, long var1, long var3);

    public static int glGetUniformLocation(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformLocation;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL20.nglGetUniformLocation(n2, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
        return n3;
    }

    public static void glGetActiveUniform(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkBuffer(intBuffer2, 1);
        BufferChecks.checkBuffer(intBuffer3, 1);
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglGetActiveUniform(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(intBuffer3), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveUniform(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        IntBuffer intBuffer2 = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        GL20.nglGetActiveUniform(n2, n3, n4, MemoryUtil.getAddress0(intBuffer2), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, intBuffer.position() + 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer2.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveUniform(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        GL20.nglGetActiveUniform(n2, n3, n4, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveUniformSize(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveUniform(n2, n3, 1, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static int glGetActiveUniformType(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveUniform(n2, n3, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static void glGetUniform(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL20.nglGetUniformfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetUniformfv(int var0, int var1, long var2, long var4);

    public static void glGetUniform(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglGetUniformiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetUniformiv(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderSource;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglGetShaderSource(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetShaderSource(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderSource(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderSource;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        GL20.nglGetShaderSource(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glVertexAttrib1s(int n2, short s2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib1s;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib1s(n2, s2, l2);
    }

    static native void nglVertexAttrib1s(int var0, short var1, long var2);

    public static void glVertexAttrib1f(int n2, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib1f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib1f(n2, f2, l2);
    }

    static native void nglVertexAttrib1f(int var0, float var1, long var2);

    public static void glVertexAttrib1d(int n2, double d2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib1d;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib1d(n2, d2, l2);
    }

    static native void nglVertexAttrib1d(int var0, double var1, long var3);

    public static void glVertexAttrib2s(int n2, short s2, short s3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib2s;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib2s(n2, s2, s3, l2);
    }

    static native void nglVertexAttrib2s(int var0, short var1, short var2, long var3);

    public static void glVertexAttrib2f(int n2, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib2f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib2f(n2, f2, f3, l2);
    }

    static native void nglVertexAttrib2f(int var0, float var1, float var2, long var3);

    public static void glVertexAttrib2d(int n2, double d2, double d3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib2d;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib2d(n2, d2, d3, l2);
    }

    static native void nglVertexAttrib2d(int var0, double var1, double var3, long var5);

    public static void glVertexAttrib3s(int n2, short s2, short s3, short s4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib3s;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib3s(n2, s2, s3, s4, l2);
    }

    static native void nglVertexAttrib3s(int var0, short var1, short var2, short var3, long var4);

    public static void glVertexAttrib3f(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib3f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib3f(n2, f2, f3, f4, l2);
    }

    static native void nglVertexAttrib3f(int var0, float var1, float var2, float var3, long var4);

    public static void glVertexAttrib3d(int n2, double d2, double d3, double d4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib3d;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib3d(n2, d2, d3, d4, l2);
    }

    static native void nglVertexAttrib3d(int var0, double var1, double var3, double var5, long var7);

    public static void glVertexAttrib4s(int n2, short s2, short s3, short s4, short s5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib4s;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib4s(n2, s2, s3, s4, s5, l2);
    }

    static native void nglVertexAttrib4s(int var0, short var1, short var2, short var3, short var4, long var5);

    public static void glVertexAttrib4f(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib4f;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib4f(n2, f2, f3, f4, f5, l2);
    }

    static native void nglVertexAttrib4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glVertexAttrib4d(int n2, double d2, double d3, double d4, double d5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib4d;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib4d(n2, d2, d3, d4, d5, l2);
    }

    static native void nglVertexAttrib4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glVertexAttrib4Nub(int n2, byte by2, byte by3, byte by4, byte by5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttrib4Nub;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglVertexAttrib4Nub(n2, by2, by3, by4, by5, l2);
    }

    static native void nglVertexAttrib4Nub(int var0, byte var1, byte var2, byte var3, byte var4, long var5);

    public static void glVertexAttribPointer(int n2, int n3, boolean bl2, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = doubleBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, 5130, bl2, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, boolean bl2, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = floatBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, 5126, bl2, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, boolean bl2, boolean bl3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = byteBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, bl2 ? 5121 : 5120, bl3, n4, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, boolean bl2, boolean bl3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = intBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, bl2 ? 5125 : 5124, bl3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, boolean bl2, boolean bl3, int n4, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = shortBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, bl2 ? 5123 : 5122, bl3, n4, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL20.nglVertexAttribPointerBO(n2, n3, n4, bl2, n5, l2, l3);
    }

    static native void nglVertexAttribPointerBO(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[n2] = byteBuffer;
        }
        GL20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glEnableVertexAttribArray(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableVertexAttribArray;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglEnableVertexAttribArray(n2, l2);
    }

    static native void nglEnableVertexAttribArray(int var0, long var1);

    public static void glDisableVertexAttribArray(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableVertexAttribArray;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglDisableVertexAttribArray(n2, l2);
    }

    static native void nglDisableVertexAttribArray(int var0, long var1);

    public static void glGetVertexAttrib(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribfv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        GL20.nglGetVertexAttribfv(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetVertexAttribfv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttrib(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribdv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        GL20.nglGetVertexAttribdv(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetVertexAttribdv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttrib(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL20.nglGetVertexAttribiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexAttribiv(int var0, int var1, long var2, long var4);

    public static ByteBuffer glGetVertexAttribPointer(int n2, int n3, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetVertexAttribPointerv;
        BufferChecks.checkFunctionAddress(l3);
        ByteBuffer byteBuffer = GL20.nglGetVertexAttribPointerv(n2, n3, l2, l3);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexAttribPointerv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttribPointer(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexAttribPointerv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, PointerBuffer.getPointerSize());
        GL20.nglGetVertexAttribPointerv2(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetVertexAttribPointerv2(int var0, int var1, long var2, long var4);

    public static void glBindAttribLocation(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindAttribLocation;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        GL20.nglBindAttribLocation(n2, n3, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglBindAttribLocation(int var0, int var1, long var2, long var4);

    public static void glBindAttribLocation(int n2, int n3, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindAttribLocation;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglBindAttribLocation(n2, n3, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
    }

    public static void glGetActiveAttrib(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkBuffer(intBuffer2, 1);
        BufferChecks.checkBuffer(intBuffer3, 1);
        BufferChecks.checkDirect(byteBuffer);
        GL20.nglGetActiveAttrib(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(intBuffer3), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveAttrib(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        IntBuffer intBuffer2 = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        GL20.nglGetActiveAttrib(n2, n3, n4, MemoryUtil.getAddress0(intBuffer2), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, intBuffer.position() + 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer2.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveAttrib(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        GL20.nglGetActiveAttrib(n2, n3, n4, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveAttribSize(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveAttrib(n2, n3, 0, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static int glGetActiveAttribType(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveAttrib(n2, n3, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static int glGetAttribLocation(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetAttribLocation;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = GL20.nglGetAttribLocation(n2, MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    static native int nglGetAttribLocation(int var0, long var1, long var3);

    public static int glGetAttribLocation(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetAttribLocation;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = GL20.nglGetAttribLocation(n2, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
        return n3;
    }

    public static void glDrawBuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawBuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL20.nglDrawBuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDrawBuffers(int var0, long var1, long var3);

    public static void glDrawBuffers(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawBuffers;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglDrawBuffers(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glStencilOpSeparate(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glStencilOpSeparate;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglStencilOpSeparate(n2, n3, n4, n5, l2);
    }

    static native void nglStencilOpSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilFuncSeparate(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glStencilFuncSeparate;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglStencilFuncSeparate(n2, n3, n4, n5, l2);
    }

    static native void nglStencilFuncSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilMaskSeparate(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glStencilMaskSeparate;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglStencilMaskSeparate(n2, n3, l2);
    }

    static native void nglStencilMaskSeparate(int var0, int var1, long var2);

    public static void glBlendEquationSeparate(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBlendEquationSeparate;
        BufferChecks.checkFunctionAddress(l2);
        GL20.nglBlendEquationSeparate(n2, n3, l2);
    }

    static native void nglBlendEquationSeparate(int var0, int var1, long var2);
}

