/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL15 {
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_BUFFER_ACCESS = 35003;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_FOG_COORD_SRC = 33872;
    public static final int GL_FOG_COORD = 33873;
    public static final int GL_CURRENT_FOG_COORD = 33875;
    public static final int GL_FOG_COORD_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORD_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORD_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORD_ARRAY = 33879;
    public static final int GL_FOG_COORD_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_SRC0_RGB = 34176;
    public static final int GL_SRC1_RGB = 34177;
    public static final int GL_SRC2_RGB = 34178;
    public static final int GL_SRC0_ALPHA = 34184;
    public static final int GL_SRC1_ALPHA = 34185;
    public static final int GL_SRC2_ALPHA = 34186;
    public static final int GL_SAMPLES_PASSED = 35092;
    public static final int GL_QUERY_COUNTER_BITS = 34916;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;

    private GL15() {
    }

    public static void glBindBuffer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindBuffer;
        BufferChecks.checkFunctionAddress(l2);
        StateTracker.bindBuffer(contextCapabilities, n2, n3);
        GL15.nglBindBuffer(n2, n3, l2);
    }

    static native void nglBindBuffer(int var0, int var1, long var2);

    public static void glDeleteBuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteBuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglDeleteBuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteBuffers(int var0, long var1, long var3);

    public static void glDeleteBuffers(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteBuffers;
        BufferChecks.checkFunctionAddress(l2);
        GL15.nglDeleteBuffers(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenBuffers(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenBuffers;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglGenBuffers(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenBuffers(int var0, long var1, long var3);

    public static int glGenBuffers() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenBuffers;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGenBuffers(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static boolean glIsBuffer(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsBuffer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL15.nglIsBuffer(n2, l2);
        return bl2;
    }

    static native boolean nglIsBuffer(int var0, long var1);

    public static void glBufferData(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l3);
        GL15.nglBufferData(n2, l2, 0L, n3, l3);
    }

    public static void glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        GL15.nglBufferData(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glBufferData(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        GL15.nglBufferData(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glBufferData(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        GL15.nglBufferData(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glBufferData(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglBufferData(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glBufferData(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferData;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        GL15.nglBufferData(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    static native void nglBufferData(int var0, long var1, long var3, int var5, long var6);

    public static void glBufferSubData(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        GL15.nglBufferSubData(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glBufferSubData(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        GL15.nglBufferSubData(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glBufferSubData(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        GL15.nglBufferSubData(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glBufferSubData(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglBufferSubData(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glBufferSubData(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        GL15.nglBufferSubData(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void glGetBufferSubData(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        GL15.nglGetBufferSubData(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glGetBufferSubData(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        GL15.nglGetBufferSubData(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glGetBufferSubData(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        GL15.nglGetBufferSubData(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glGetBufferSubData(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglGetBufferSubData(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glGetBufferSubData(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubData;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        GL15.nglGetBufferSubData(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglGetBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static ByteBuffer glMapBuffer(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMapBuffer;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL15.nglMapBuffer(n2, n3, GL15.glGetBufferParameteri(n2, 34660), byteBuffer, l2);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapBuffer(int n2, int n3, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMapBuffer;
        BufferChecks.checkFunctionAddress(l3);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = GL15.nglMapBuffer(n2, n3, l2, byteBuffer, l3);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapBuffer(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static boolean glUnmapBuffer(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUnmapBuffer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL15.nglUnmapBuffer(n2, l2);
        return bl2;
    }

    static native boolean nglUnmapBuffer(int var0, long var1);

    public static void glGetBufferParameter(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        GL15.nglGetBufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetBufferParameteriv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetBufferParameter(int n2, int n3) {
        return GL15.glGetBufferParameteri(n2, n3);
    }

    public static int glGetBufferParameteri(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameteriv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGetBufferParameteriv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetBufferPointer(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferPointerv;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = GL15.nglGetBufferPointerv(n2, n3, GL15.glGetBufferParameteri(n2, 34660), l2);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetBufferPointerv(int var0, int var1, long var2, long var4);

    public static void glGenQueries(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenQueries;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglGenQueries(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenQueries(int var0, long var1, long var3);

    public static int glGenQueries() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenQueries;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGenQueries(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glDeleteQueries(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteQueries;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        GL15.nglDeleteQueries(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteQueries(int var0, long var1, long var3);

    public static void glDeleteQueries(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteQueries;
        BufferChecks.checkFunctionAddress(l2);
        GL15.nglDeleteQueries(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static boolean glIsQuery(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsQuery;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = GL15.nglIsQuery(n2, l2);
        return bl2;
    }

    static native boolean nglIsQuery(int var0, long var1);

    public static void glBeginQuery(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBeginQuery;
        BufferChecks.checkFunctionAddress(l2);
        GL15.nglBeginQuery(n2, n3, l2);
    }

    static native void nglBeginQuery(int var0, int var1, long var2);

    public static void glEndQuery(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEndQuery;
        BufferChecks.checkFunctionAddress(l2);
        GL15.nglEndQuery(n2, l2);
    }

    static native void nglEndQuery(int var0, long var1);

    public static void glGetQuery(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL15.nglGetQueryiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetQueryiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetQuery(int n2, int n3) {
        return GL15.glGetQueryi(n2, n3);
    }

    public static int glGetQueryi(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGetQueryiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetQueryObject(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryObjectiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL15.nglGetQueryObjectiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetQueryObjectiv(int var0, int var1, long var2, long var4);

    public static int glGetQueryObjecti(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryObjectiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGetQueryObjectiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetQueryObjectu(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryObjectuiv;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        GL15.nglGetQueryObjectuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetQueryObjectuiv(int var0, int var1, long var2, long var4);

    public static int glGetQueryObjectui(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetQueryObjectuiv;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL15.nglGetQueryObjectuiv(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }
}

