/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FastIntMap<V>
implements Iterable<Entry<V>> {
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    FastIntMap() {
        this(16, 0.75f);
    }

    FastIntMap(int n2) {
        this(n2, 0.75f);
    }

    FastIntMap(int n2, float f2) {
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n2) {
            this.capacity <<= 1;
        }
        this.threshold = (int)((float)this.capacity * f2);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private int index(int n2) {
        return FastIntMap.index(n2, this.mask);
    }

    private static int index(int n2, int n3) {
        return n2 & n3;
    }

    public V put(int n2, V v2) {
        Entry[] entryArray = this.table;
        int n3 = this.index(n2);
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                Object t2 = entry.value;
                entry.value = v2;
                return (V)t2;
            }
            entry = entry.next;
        }
        entryArray[n3] = new Entry<V>(n2, v2, entryArray[n3]);
        if (this.size++ >= this.threshold) {
            this.rehash(entryArray);
        }
        return null;
    }

    private void rehash(Entry<V>[] entryArray) {
        int n2 = 2 * this.capacity;
        int n3 = n2 - 1;
        Entry[] entryArray2 = new Entry[n2];
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry;
            Entry<Object> entry2 = entryArray[i2];
            if (entry2 == null) continue;
            do {
                entry = entry2.next;
                int n4 = FastIntMap.index(entry2.key, n3);
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            } while ((entry2 = entry) != null);
        }
        this.table = entryArray2;
        this.capacity = n2;
        this.mask = n3;
        this.threshold *= 2;
    }

    public V get(int n2) {
        int n3 = this.index(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n2) {
        int n3 = this.index(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public V remove(int n2) {
        Entry entry;
        int n3 = this.index(n2);
        Entry entry2 = entry = this.table[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n2) {
                --this.size;
                if (entry == entry2) {
                    this.table[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return (V)entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            entryArray[i2] = null;
        }
        this.size = 0;
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<T> {
        final int key;
        T value;
        Entry<T> next;

        Entry(int n2, T t2, Entry<T> entry) {
            this.key = n2;
            this.value = t2;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryIterator
    implements Iterator<Entry<V>> {
        private int nextIndex;
        private Entry<V> current;

        EntryIterator() {
            this.reset();
        }

        public void reset() {
            int n2;
            this.current = null;
            Entry[] entryArray = FastIntMap.this.table;
            for (n2 = entryArray.length - 1; n2 >= 0 && entryArray[n2] == null; --n2) {
            }
            this.nextIndex = n2;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex >= 0) {
                return true;
            }
            Entry entry = this.current;
            return entry != null && entry.next != null;
        }

        @Override
        public Entry<V> next() {
            Entry entry = this.current;
            if (entry != null && (entry = entry.next) != null) {
                this.current = entry;
                return entry;
            }
            Entry[] entryArray = FastIntMap.this.table;
            int n2 = this.nextIndex;
            entry = this.current = entryArray[n2];
            while (--n2 >= 0 && entryArray[n2] == null) {
            }
            this.nextIndex = n2;
            return entry;
        }

        @Override
        public void remove() {
            FastIntMap.this.remove(this.current.key);
        }
    }
}

