/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTDrawBuffers2;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class EXTDirectStateAccess {
    public static final int GL_PROGRAM_MATRIX_EXT = 36397;
    public static final int GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 36398;
    public static final int GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 36399;

    private EXTDirectStateAccess() {
    }

    public static void glClientAttribDefaultEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glClientAttribDefaultEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglClientAttribDefaultEXT(n2, l2);
    }

    static native void nglClientAttribDefaultEXT(int var0, long var1);

    public static void glPushClientAttribDefaultEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glPushClientAttribDefaultEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglPushClientAttribDefaultEXT(n2, l2);
    }

    static native void nglPushClientAttribDefaultEXT(int var0, long var1);

    public static void glMatrixLoadEXT(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixLoadfEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglMatrixLoadfEXT(n2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMatrixLoadfEXT(int var0, long var1, long var3);

    public static void glMatrixLoadEXT(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixLoaddEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglMatrixLoaddEXT(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglMatrixLoaddEXT(int var0, long var1, long var3);

    public static void glMatrixMultEXT(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixMultfEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglMatrixMultfEXT(n2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMatrixMultfEXT(int var0, long var1, long var3);

    public static void glMatrixMultEXT(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixMultdEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglMatrixMultdEXT(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglMatrixMultdEXT(int var0, long var1, long var3);

    public static void glMatrixLoadIdentityEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixLoadIdentityEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixLoadIdentityEXT(n2, l2);
    }

    static native void nglMatrixLoadIdentityEXT(int var0, long var1);

    public static void glMatrixRotatefEXT(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixRotatefEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixRotatefEXT(n2, f2, f3, f4, f5, l2);
    }

    static native void nglMatrixRotatefEXT(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glMatrixRotatedEXT(int n2, double d2, double d3, double d4, double d5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixRotatedEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixRotatedEXT(n2, d2, d3, d4, d5, l2);
    }

    static native void nglMatrixRotatedEXT(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glMatrixScalefEXT(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixScalefEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixScalefEXT(n2, f2, f3, f4, l2);
    }

    static native void nglMatrixScalefEXT(int var0, float var1, float var2, float var3, long var4);

    public static void glMatrixScaledEXT(int n2, double d2, double d3, double d4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixScaledEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixScaledEXT(n2, d2, d3, d4, l2);
    }

    static native void nglMatrixScaledEXT(int var0, double var1, double var3, double var5, long var7);

    public static void glMatrixTranslatefEXT(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixTranslatefEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixTranslatefEXT(n2, f2, f3, f4, l2);
    }

    static native void nglMatrixTranslatefEXT(int var0, float var1, float var2, float var3, long var4);

    public static void glMatrixTranslatedEXT(int n2, double d2, double d3, double d4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixTranslatedEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixTranslatedEXT(n2, d2, d3, d4, l2);
    }

    static native void nglMatrixTranslatedEXT(int var0, double var1, double var3, double var5, long var7);

    public static void glMatrixOrthoEXT(int n2, double d2, double d3, double d4, double d5, double d6, double d7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixOrthoEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixOrthoEXT(n2, d2, d3, d4, d5, d6, d7, l2);
    }

    static native void nglMatrixOrthoEXT(int var0, double var1, double var3, double var5, double var7, double var9, double var11, long var13);

    public static void glMatrixFrustumEXT(int n2, double d2, double d3, double d4, double d5, double d6, double d7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixFrustumEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixFrustumEXT(n2, d2, d3, d4, d5, d6, d7, l2);
    }

    static native void nglMatrixFrustumEXT(int var0, double var1, double var3, double var5, double var7, double var9, double var11, long var13);

    public static void glMatrixPushEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixPushEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixPushEXT(n2, l2);
    }

    static native void nglMatrixPushEXT(int var0, long var1);

    public static void glMatrixPopEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixPopEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMatrixPopEXT(n2, l2);
    }

    static native void nglMatrixPopEXT(int var0, long var1);

    public static void glTextureParameteriEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameteriEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureParameteriEXT(n2, n3, n4, n5, l2);
    }

    static native void nglTextureParameteriEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureParameterEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglTextureParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterfEXT(int n2, int n3, int n4, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterfEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureParameterfEXT(n2, n3, n4, f2, l2);
    }

    static native void nglTextureParameterfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glTextureParameterEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglTextureParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglTextureParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage1DStorage(byteBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage1DStorage(doubleBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage1DStorage(floatBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage1DStorage(intBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage1DStorage(shortBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglTextureImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage2DStorage(byteBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage2DStorage(doubleBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage2DStorage(floatBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage2DStorage(intBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage2DStorage(shortBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglTextureImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglTextureSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglTextureSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCopyTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyTextureImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    static native void nglCopyTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
    }

    static native void nglCopyTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    static native void nglCopyTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCopyTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
    }

    static native void nglCopyTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetTextureImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetTextureImageEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetTextureImageEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetTextureImageEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureImageEXTBO(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglGetTextureImageEXTBO(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetTextureParameterEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetTextureParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetTextureParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static float glGetTextureParameterfEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetTextureParameterEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetTextureParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameteriEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTextureLevelParameterEXT(int n2, int n3, int n4, int n5, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(n2, n3, n4, n5, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetTextureLevelParameterfvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static float glGetTextureLevelParameterfEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(n2, n3, n4, n5, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetTextureLevelParameterEXT(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(n2, n3, n4, n5, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureLevelParameterivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int glGetTextureLevelParameteriEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(n2, n3, n4, n5, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage3DStorage(byteBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage3DStorage(doubleBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage3DStorage(floatBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage3DStorage(intBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage3DStorage(shortBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglTextureImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2, l3);
    }

    static native void nglTextureImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglTextureSubImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, l2, l3);
    }

    static native void nglTextureSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCopyTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2);
    }

    static native void nglCopyTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glBindMultiTextureEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindMultiTextureEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglBindMultiTextureEXT(n2, n3, n4, l2);
    }

    static native void nglBindMultiTextureEXT(int var0, int var1, int var2, long var3);

    public static void glMultiTexCoordPointerEXT(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(doubleBuffer);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(n2, n3, 5130, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glMultiTexCoordPointerEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(n2, n3, 5126, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMultiTexCoordPointerEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glMultiTexCoordPointerEXT(int n2, int n3, int n4, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexCoordPointerEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexCoordPointerEXTBO(n2, n3, n4, n5, l2, l3);
    }

    static native void nglMultiTexCoordPointerEXTBO(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glMultiTexEnvfEXT(int n2, int n3, int n4, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexEnvfEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexEnvfEXT(n2, n3, n4, f2, l2);
    }

    static native void nglMultiTexEnvfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexEnvEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexEnvfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglMultiTexEnvfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMultiTexEnvfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexEnviEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexEnviEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexEnviEXT(n2, n3, n4, n5, l2);
    }

    static native void nglMultiTexEnviEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexEnvEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexEnvivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglMultiTexEnvivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglMultiTexEnvivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGendEXT(int n2, int n3, int n4, double d2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGendEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexGendEXT(n2, n3, n4, d2, l2);
    }

    static native void nglMultiTexGendEXT(int var0, int var1, int var2, double var3, long var5);

    public static void glMultiTexGenEXT(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGendvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        EXTDirectStateAccess.nglMultiTexGendvEXT(n2, n3, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglMultiTexGendvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGenfEXT(int n2, int n3, int n4, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGenfEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexGenfEXT(n2, n3, n4, f2, l2);
    }

    static native void nglMultiTexGenfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexGenEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGenfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglMultiTexGenfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMultiTexGenfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexGeniEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGeniEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexGeniEXT(n2, n3, n4, n5, l2);
    }

    static native void nglMultiTexGeniEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexGenEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexGenivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglMultiTexGenivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglMultiTexGenivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexEnvEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexEnvfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexEnvfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetMultiTexEnvfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexEnvEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexEnvivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexEnvivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexEnvivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexGendvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexGendvEXT(n2, n3, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetMultiTexGendvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexGenfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexGenfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetMultiTexGenfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetMultiTexGenEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexGenivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexGenivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexGenivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameteriEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameteriEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexParameteriEXT(n2, n3, n4, n5, l2);
    }

    static native void nglMultiTexParameteriEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexParameterEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglMultiTexParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglMultiTexParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterfEXT(int n2, int n3, int n4, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterfEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexParameterfEXT(n2, n3, n4, f2, l2);
    }

    static native void nglMultiTexParameterfEXT(int var0, int var1, int var2, float var3, long var4);

    public static void glMultiTexParameterEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglMultiTexParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMultiTexParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage1DStorage(byteBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage1DStorage(doubleBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage1DStorage(floatBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage1DStorage(intBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage1DStorage(shortBuffer, n8, n9, n6));
        }
        EXTDirectStateAccess.nglMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglMultiTexImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage2DStorage(byteBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage2DStorage(doubleBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage2DStorage(floatBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage2DStorage(intBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage2DStorage(shortBuffer, n9, n10, n6, n7));
        }
        EXTDirectStateAccess.nglMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglMultiTexImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n7, n8, n6, 1, 1));
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglMultiTexSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n9, n10, n7, n8, 1));
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglMultiTexSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCopyMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    static native void nglCopyMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
    }

    static native void nglCopyMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    static native void nglCopyMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCopyMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
    }

    static native void nglCopyMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n5, n6, 1, 1, 1));
        EXTDirectStateAccess.nglGetMultiTexImageEXT(n2, n3, n4, n5, n6, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetMultiTexImageEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetMultiTexImageEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexImageEXTBO(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglGetMultiTexImageEXTBO(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glGetMultiTexParameterEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetMultiTexParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static float glGetMultiTexParameterfEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetMultiTexParameterEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameteriEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetMultiTexLevelParameterEXT(int n2, int n3, int n4, int n5, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(n2, n3, n4, n5, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetMultiTexLevelParameterfvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static float glGetMultiTexLevelParameterfEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexLevelParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(n2, n3, n4, n5, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetMultiTexLevelParameterEXT(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(n2, n3, n4, n5, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexLevelParameterivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int glGetMultiTexLevelParameteriEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexLevelParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(n2, n3, n4, n5, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (byteBuffer != null) {
            BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateTexImage3DStorage(byteBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (doubleBuffer != null) {
            BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateTexImage3DStorage(doubleBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(doubleBuffer), l2);
    }

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateTexImage3DStorage(floatBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(floatBuffer), l2);
    }

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, GLChecks.calculateTexImage3DStorage(intBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(intBuffer), l2);
    }

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateTexImage3DStorage(shortBuffer, n10, n11, n6, n7, n8));
        }
        EXTDirectStateAccess.nglMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, MemoryUtil.getAddressSafe(shortBuffer), l2);
    }

    static native void nglMultiTexImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2, l3);
    }

    static native void nglMultiTexImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, GLChecks.calculateImageStorage(byteBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(doubleBuffer, GLChecks.calculateImageStorage(doubleBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(floatBuffer, GLChecks.calculateImageStorage(floatBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(floatBuffer), l2);
    }

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, GLChecks.calculateImageStorage(intBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(shortBuffer, GLChecks.calculateImageStorage(shortBuffer, n11, n12, n8, n9, n10));
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglMultiTexSubImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, l2, l3);
    }

    static native void nglMultiTexSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCopyMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCopyMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglCopyMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2);
    }

    static native void nglCopyMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glEnableClientStateIndexedEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableClientStateIndexedEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglEnableClientStateIndexedEXT(n2, n3, l2);
    }

    static native void nglEnableClientStateIndexedEXT(int var0, int var1, long var2);

    public static void glDisableClientStateIndexedEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableClientStateIndexedEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglDisableClientStateIndexedEXT(n2, n3, l2);
    }

    static native void nglDisableClientStateIndexedEXT(int var0, int var1, long var2);

    public static void glEnableClientStateiEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableClientStateiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglEnableClientStateiEXT(n2, n3, l2);
    }

    static native void nglEnableClientStateiEXT(int var0, int var1, long var2);

    public static void glDisableClientStateiEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableClientStateiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglDisableClientStateiEXT(n2, n3, l2);
    }

    static native void nglDisableClientStateiEXT(int var0, int var1, long var2);

    public static void glGetFloatIndexedEXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloatIndexedvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglGetFloatIndexedvEXT(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetFloatIndexedvEXT(int var0, int var1, long var2, long var4);

    public static float glGetFloatIndexedEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloatIndexedvEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetFloatIndexedvEXT(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetDoubleIndexedEXT(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoubleIndexedvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglGetDoubleIndexedvEXT(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetDoubleIndexedvEXT(int var0, int var1, long var2, long var4);

    public static double glGetDoubleIndexedEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoubleIndexedvEXT;
        BufferChecks.checkFunctionAddress(l2);
        DoubleBuffer doubleBuffer = APIUtil.getBufferDouble(contextCapabilities);
        EXTDirectStateAccess.nglGetDoubleIndexedvEXT(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
        return doubleBuffer.get(0);
    }

    public static ByteBuffer glGetPointerIndexedEXT(int n2, int n3, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetPointerIndexedvEXT;
        BufferChecks.checkFunctionAddress(l3);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetPointerIndexedvEXT(n2, n3, l2, l3);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetPointerIndexedvEXT(int var0, int var1, long var2, long var4);

    public static void glGetFloatEXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloati_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglGetFloati_vEXT(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetFloati_vEXT(int var0, int var1, long var2, long var4);

    public static float glGetFloatEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFloati_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        EXTDirectStateAccess.nglGetFloati_vEXT(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetDoubleEXT(int n2, int n3, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoublei_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglGetDoublei_vEXT(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetDoublei_vEXT(int var0, int var1, long var2, long var4);

    public static double glGetDoubleEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetDoublei_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        DoubleBuffer doubleBuffer = APIUtil.getBufferDouble(contextCapabilities);
        EXTDirectStateAccess.nglGetDoublei_vEXT(n2, n3, MemoryUtil.getAddress(doubleBuffer), l2);
        return doubleBuffer.get(0);
    }

    public static ByteBuffer glGetPointerEXT(int n2, int n3, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetPointeri_vEXT;
        BufferChecks.checkFunctionAddress(l3);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetPointeri_vEXT(n2, n3, l2, l3);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetPointeri_vEXT(int var0, int var1, long var2, long var4);

    public static void glEnableIndexedEXT(int n2, int n3) {
        EXTDrawBuffers2.glEnableIndexedEXT(n2, n3);
    }

    public static void glDisableIndexedEXT(int n2, int n3) {
        EXTDrawBuffers2.glDisableIndexedEXT(n2, n3);
    }

    public static boolean glIsEnabledIndexedEXT(int n2, int n3) {
        return EXTDrawBuffers2.glIsEnabledIndexedEXT(n2, n3);
    }

    public static void glGetIntegerIndexedEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTDrawBuffers2.glGetIntegerIndexedEXT(n2, n3, intBuffer);
    }

    public static int glGetIntegerIndexedEXT(int n2, int n3) {
        return EXTDrawBuffers2.glGetIntegerIndexedEXT(n2, n3);
    }

    public static void glGetBooleanIndexedEXT(int n2, int n3, ByteBuffer byteBuffer) {
        EXTDrawBuffers2.glGetBooleanIndexedEXT(n2, n3, byteBuffer);
    }

    public static boolean glGetBooleanIndexedEXT(int n2, int n3) {
        return EXTDrawBuffers2.glGetBooleanIndexedEXT(n2, n3);
    }

    public static void glNamedProgramStringEXT(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglNamedProgramStringEXT(n2, n3, n4, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglNamedProgramStringEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramStringEXT(int n2, int n3, int n4, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedProgramStringEXT(n2, n3, n4, charSequence.length(), APIUtil.getBuffer(contextCapabilities, charSequence), l2);
    }

    public static void glNamedProgramLocalParameter4dEXT(int n2, int n3, int n4, double d2, double d3, double d4, double d5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameter4dEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4dEXT(n2, n3, n4, d2, d3, d4, d5, l2);
    }

    static native void nglNamedProgramLocalParameter4dEXT(int var0, int var1, int var2, double var3, double var5, double var7, double var9, long var11);

    public static void glNamedProgramLocalParameter4EXT(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameter4dvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4dvEXT(n2, n3, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglNamedProgramLocalParameter4dvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParameter4fEXT(int n2, int n3, int n4, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameter4fEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4fEXT(n2, n3, n4, f2, f3, f4, f5, l2);
    }

    static native void nglNamedProgramLocalParameter4fEXT(int var0, int var1, int var2, float var3, float var4, float var5, float var6, long var7);

    public static void glNamedProgramLocalParameter4EXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameter4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameter4fvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglNamedProgramLocalParameter4fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterEXT(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramLocalParameterdvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterdvEXT(n2, n3, n4, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglGetNamedProgramLocalParameterdvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramLocalParameterfvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterfvEXT(n2, n3, n4, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetNamedProgramLocalParameterfvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedProgramivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedProgramivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetNamedProgramEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedProgramivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetNamedProgramStringEXT(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglGetNamedProgramStringEXT(n2, n3, n4, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetNamedProgramStringEXT(int var0, int var1, int var2, long var3, long var5);

    public static String glGetNamedProgramStringEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramStringEXT;
        BufferChecks.checkFunctionAddress(l2);
        int n5 = EXTDirectStateAccess.glGetNamedProgramEXT(n2, n3, 34343);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n5);
        EXTDirectStateAccess.nglGetNamedProgramStringEXT(n2, n3, n4, MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(n5);
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glCompressedTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglCompressedTextureImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureImage2DEXT(n2, n3, n4, n5, n6, n7, n8, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglCompressedTextureImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureImage1DEXT(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglCompressedTextureImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedTextureSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, l2, l3);
    }

    static native void nglCompressedTextureSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglCompressedTextureSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXT(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedTextureSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedTextureSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedTextureSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglCompressedTextureSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glGetCompressedTextureImageEXT(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(n2, n3, n4, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetCompressedTextureImageEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetCompressedTextureImageEXT(int n2, int n3, int n4, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(n2, n3, n4, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetCompressedTextureImageEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetCompressedTextureImageEXT(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetCompressedTextureImageEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetCompressedTextureImageEXTBO(n2, n3, n4, l2, l3);
    }

    static native void nglGetCompressedTextureImageEXTBO(int var0, int var1, int var2, long var3, long var5);

    public static void glCompressedMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglCompressedMultiTexImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXT(n2, n3, n4, n5, n6, n7, n8, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedMultiTexImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, l2, l3);
    }

    static native void nglCompressedMultiTexImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glCompressedMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXT(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglCompressedMultiTexImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexSubImage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedMultiTexSubImage3DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexSubImage3DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, l2, l3);
    }

    static native void nglCompressedMultiTexSubImage3DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void glCompressedMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXT(n2, n3, n4, n5, n6, n7, n8, n9, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexSubImage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexSubImage2DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexSubImage2DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXTBO(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2, l3);
    }

    static native void nglCompressedMultiTexSubImage2DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void glCompressedMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompressedMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensureUnpackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXT(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglCompressedMultiTexSubImage1DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glCompressedMultiTexSubImage1DEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glCompressedMultiTexSubImage1DEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureUnpackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXTBO(n2, n3, n4, n5, n6, n7, n8, l2, l3);
    }

    static native void nglCompressedMultiTexSubImage1DEXTBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void glGetCompressedMultiTexImageEXT(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(n2, n3, n4, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glGetCompressedMultiTexImageEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glGetCompressedMultiTexImageEXT(int n2, int n3, int n4, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l2);
        GLChecks.ensurePackPBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(shortBuffer);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(n2, n3, n4, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglGetCompressedMultiTexImageEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetCompressedMultiTexImageEXT(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetCompressedMultiTexImageEXT;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensurePackPBOenabled(contextCapabilities);
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXTBO(n2, n3, n4, l2, l3);
    }

    static native void nglGetCompressedMultiTexImageEXTBO(int var0, int var1, int var2, long var3, long var5);

    public static void glMatrixLoadTransposeEXT(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixLoadTransposefEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglMatrixLoadTransposefEXT(n2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMatrixLoadTransposefEXT(int var0, long var1, long var3);

    public static void glMatrixLoadTransposeEXT(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixLoadTransposedEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglMatrixLoadTransposedEXT(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglMatrixLoadTransposedEXT(int var0, long var1, long var3);

    public static void glMatrixMultTransposeEXT(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixMultTransposefEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(floatBuffer, 16);
        EXTDirectStateAccess.nglMatrixMultTransposefEXT(n2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglMatrixMultTransposefEXT(int var0, long var1, long var3);

    public static void glMatrixMultTransposeEXT(int n2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMatrixMultTransposedEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(doubleBuffer, 16);
        EXTDirectStateAccess.nglMatrixMultTransposedEXT(n2, MemoryUtil.getAddress(doubleBuffer), l2);
    }

    static native void nglMatrixMultTransposedEXT(int var0, long var1, long var3);

    public static void glNamedBufferDataEXT(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, l2, 0L, n3, l3);
    }

    public static void glNamedBufferDataEXT(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glNamedBufferDataEXT(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glNamedBufferDataEXT(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glNamedBufferDataEXT(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glNamedBufferDataEXT(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferDataEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        EXTDirectStateAccess.nglNamedBufferDataEXT(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    static native void nglNamedBufferDataEXT(int var0, long var1, long var3, int var5, long var6);

    public static void glNamedBufferSubDataEXT(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glNamedBufferSubDataEXT(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glNamedBufferSubDataEXT(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glNamedBufferSubDataEXT(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glNamedBufferSubDataEXT(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglNamedBufferSubDataEXT(int var0, long var1, long var3, long var5, long var7);

    public static ByteBuffer glMapNamedBufferEXT(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = EXTDirectStateAccess.nglMapNamedBufferEXT(n2, n3, EXTDirectStateAccess.glGetNamedBufferParameterEXT(n2, 34660), byteBuffer, l2);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapNamedBufferEXT(int n2, int n3, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l3);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = EXTDirectStateAccess.nglMapNamedBufferEXT(n2, n3, l2, byteBuffer, l3);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBufferEXT(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static boolean glUnmapNamedBufferEXT(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUnmapNamedBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = EXTDirectStateAccess.nglUnmapNamedBufferEXT(n2, l2);
        return bl2;
    }

    static native boolean nglUnmapNamedBufferEXT(int var0, long var1);

    public static void glGetNamedBufferParameterEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedBufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetNamedBufferParameterEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetNamedBufferPointerEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedBufferPointervEXT;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetNamedBufferPointervEXT(n2, n3, EXTDirectStateAccess.glGetNamedBufferParameterEXT(n2, 34660), l2);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetNamedBufferPointervEXT(int var0, int var1, long var2, long var4);

    public static void glGetNamedBufferSubDataEXT(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glGetNamedBufferSubDataEXT(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glGetNamedBufferSubDataEXT(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glGetNamedBufferSubDataEXT(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glGetNamedBufferSubDataEXT(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetNamedBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglGetNamedBufferSubDataEXT(int var0, long var1, long var3, long var5, long var7);

    public static void glProgramUniform1fEXT(int n2, int n3, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1fEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform1fEXT(n2, n3, f2, l2);
    }

    static native void nglProgramUniform1fEXT(int var0, int var1, float var2, long var3);

    public static void glProgramUniform2fEXT(int n2, int n3, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2fEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform2fEXT(n2, n3, f2, f3, l2);
    }

    static native void nglProgramUniform2fEXT(int var0, int var1, float var2, float var3, long var4);

    public static void glProgramUniform3fEXT(int n2, int n3, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3fEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform3fEXT(n2, n3, f2, f3, f4, l2);
    }

    static native void nglProgramUniform3fEXT(int var0, int var1, float var2, float var3, float var4, long var5);

    public static void glProgramUniform4fEXT(int n2, int n3, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4fEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform4fEXT(n2, n3, f2, f3, f4, f5, l2);
    }

    static native void nglProgramUniform4fEXT(int var0, int var1, float var2, float var3, float var4, float var5, long var6);

    public static void glProgramUniform1iEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1iEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform1iEXT(n2, n3, n4, l2);
    }

    static native void nglProgramUniform1iEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2iEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2iEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform2iEXT(n2, n3, n4, n5, l2);
    }

    static native void nglProgramUniform2iEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3iEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3iEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform3iEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglProgramUniform3iEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4iEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4iEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform4iEXT(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglProgramUniform4iEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1EXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniform1fvEXT(n2, n3, floatBuffer.remaining(), MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform1fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2EXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniform2fvEXT(n2, n3, floatBuffer.remaining() >> 1, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform2fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3EXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniform3fvEXT(n2, n3, floatBuffer.remaining() / 3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform3fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4EXT(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniform4fvEXT(n2, n3, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniform4fvEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform1EXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform1ivEXT(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform1ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2EXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform2ivEXT(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform2ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3EXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform3ivEXT(n2, n3, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform3ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4EXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform4ivEXT(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform4ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniformMatrix2EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix2fvEXT(n2, n3, floatBuffer.remaining() >> 2, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix3fvEXT(n2, n3, floatBuffer.remaining() / 9, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix4fvEXT(n2, n3, floatBuffer.remaining() >> 4, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x3EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x3fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix2x3fvEXT(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x2EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x2fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix3x2fvEXT(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix2x4EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix2x4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix2x4fvEXT(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix2x4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x2EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x2fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix4x2fvEXT(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x2fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix3x4EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix3x4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix3x4fvEXT(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix3x4fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glProgramUniformMatrix4x3EXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniformMatrix4x3fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglProgramUniformMatrix4x3fvEXT(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglProgramUniformMatrix4x3fvEXT(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void glTextureBufferEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureBufferEXT(n2, n3, n4, n5, l2);
    }

    static native void nglTextureBufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glMultiTexBufferEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexBufferEXT(n2, n3, n4, n5, l2);
    }

    static native void nglMultiTexBufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureParameterIEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglTextureParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterIEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureParameterIivEXT(n2, n3, n4, APIUtil.getInt(contextCapabilities, n5), l2);
    }

    public static void glTextureParameterIuEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglTextureParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglTextureParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glTextureParameterIuEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureParameterIuivEXT(n2, n3, n4, APIUtil.getInt(contextCapabilities, n5), l2);
    }

    public static void glGetTextureParameterIEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetTextureParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameterIiEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetTextureParameterIuEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetTextureParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetTextureParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetTextureParameterIuiEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetTextureParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetTextureParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glMultiTexParameterIEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglMultiTexParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglMultiTexParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterIEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexParameterIivEXT(n2, n3, n4, APIUtil.getInt(contextCapabilities, n5), l2);
    }

    public static void glMultiTexParameterIuEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglMultiTexParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglMultiTexParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glMultiTexParameterIuEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexParameterIuivEXT(n2, n3, n4, APIUtil.getInt(contextCapabilities, n5), l2);
    }

    public static void glGetMultiTexParameterIEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameterIiEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetMultiTexParameterIuEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetMultiTexParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetMultiTexParameterIuiEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetMultiTexParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glProgramUniform1uiEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1uiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform1uiEXT(n2, n3, n4, l2);
    }

    static native void nglProgramUniform1uiEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uiEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2uiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform2uiEXT(n2, n3, n4, n5, l2);
    }

    static native void nglProgramUniform2uiEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform3uiEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3uiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform3uiEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglProgramUniform3uiEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform4uiEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4uiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglProgramUniform4uiEXT(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglProgramUniform4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform1uEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform1uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform1uivEXT(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform1uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform2uEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform2uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform2uivEXT(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform2uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform3uEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform3uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform3uivEXT(n2, n3, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform3uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glProgramUniform4uEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glProgramUniform4uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglProgramUniform4uivEXT(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglProgramUniform4uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParameters4EXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameters4fvEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        EXTDirectStateAccess.nglNamedProgramLocalParameters4fvEXT(n2, n3, n4, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglNamedProgramLocalParameters4fvEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramLocalParameterI4iEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameterI4iEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4iEXT(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    static native void nglNamedProgramLocalParameterI4iEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glNamedProgramLocalParameterI4EXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameterI4ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4ivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglNamedProgramLocalParameterI4ivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParametersI4EXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParametersI4ivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4ivEXT(n2, n3, n4, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglNamedProgramLocalParametersI4ivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glNamedProgramLocalParameterI4uiEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameterI4uiEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4uiEXT(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    static native void nglNamedProgramLocalParameterI4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glNamedProgramLocalParameterI4uEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParameterI4uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4uivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglNamedProgramLocalParameterI4uivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedProgramLocalParametersI4uEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedProgramLocalParametersI4uivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4uivEXT(n2, n3, n4, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglNamedProgramLocalParametersI4uivEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetNamedProgramLocalParameterIEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramLocalParameterIivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedProgramLocalParameterIivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetNamedProgramLocalParameterIuEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedProgramLocalParameterIuivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIuivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedProgramLocalParameterIuivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glNamedRenderbufferStorageEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedRenderbufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedRenderbufferStorageEXT(n2, n3, n4, n5, l2);
    }

    static native void nglNamedRenderbufferStorageEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glGetNamedRenderbufferParameterEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedRenderbufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedRenderbufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetNamedRenderbufferParameterEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedRenderbufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glNamedRenderbufferStorageMultisampleEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedRenderbufferStorageMultisampleEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedRenderbufferStorageMultisampleEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedRenderbufferStorageMultisampleEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedRenderbufferStorageMultisampleCoverageEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedRenderbufferStorageMultisampleCoverageEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedRenderbufferStorageMultisampleCoverageEXT(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglNamedRenderbufferStorageMultisampleCoverageEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static int glCheckNamedFramebufferStatusEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCheckNamedFramebufferStatusEXT;
        BufferChecks.checkFunctionAddress(l2);
        int n4 = EXTDirectStateAccess.nglCheckNamedFramebufferStatusEXT(n2, n3, l2);
        return n4;
    }

    static native int nglCheckNamedFramebufferStatusEXT(int var0, int var1, long var2);

    public static void glNamedFramebufferTexture1DEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTexture1DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTexture1DEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedFramebufferTexture1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTexture2DEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTexture2DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTexture2DEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedFramebufferTexture2DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTexture3DEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTexture3DEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTexture3DEXT(n2, n3, n4, n5, n6, n7, l2);
    }

    static native void nglNamedFramebufferTexture3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glNamedFramebufferRenderbufferEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferRenderbufferEXT(n2, n3, n4, n5, l2);
    }

    static native void nglNamedFramebufferRenderbufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glGetNamedFramebufferAttachmentParameterEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferAttachmentParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetNamedFramebufferAttachmentParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetNamedFramebufferAttachmentParameterEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetNamedFramebufferAttachmentParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGenerateTextureMipmapEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenerateTextureMipmapEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglGenerateTextureMipmapEXT(n2, n3, l2);
    }

    static native void nglGenerateTextureMipmapEXT(int var0, int var1, long var2);

    public static void glGenerateMultiTexMipmapEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenerateMultiTexMipmapEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglGenerateMultiTexMipmapEXT(n2, n3, l2);
    }

    static native void nglGenerateMultiTexMipmapEXT(int var0, int var1, long var2);

    public static void glFramebufferDrawBufferEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferDrawBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglFramebufferDrawBufferEXT(n2, n3, l2);
    }

    static native void nglFramebufferDrawBufferEXT(int var0, int var1, long var2);

    public static void glFramebufferDrawBuffersEXT(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferDrawBuffersEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        EXTDirectStateAccess.nglFramebufferDrawBuffersEXT(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglFramebufferDrawBuffersEXT(int var0, int var1, long var2, long var4);

    public static void glFramebufferReadBufferEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glFramebufferReadBufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglFramebufferReadBufferEXT(n2, n3, l2);
    }

    static native void nglFramebufferReadBufferEXT(int var0, int var1, long var2);

    public static void glGetFramebufferParameterEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFramebufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        EXTDirectStateAccess.nglGetFramebufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetFramebufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static int glGetFramebufferParameterEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetFramebufferParameterivEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetFramebufferParameterivEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glNamedCopyBufferSubDataEXT(int n2, int n3, long l2, long l3, long l4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l5 = contextCapabilities.glNamedCopyBufferSubDataEXT;
        BufferChecks.checkFunctionAddress(l5);
        EXTDirectStateAccess.nglNamedCopyBufferSubDataEXT(n2, n3, l2, l3, l4, l5);
    }

    static native void nglNamedCopyBufferSubDataEXT(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void glNamedFramebufferTextureEXT(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTextureEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTextureEXT(n2, n3, n4, n5, l2);
    }

    static native void nglNamedFramebufferTextureEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferTextureLayerEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTextureLayerEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTextureLayerEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedFramebufferTextureLayerEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTextureFaceEXT(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedFramebufferTextureFaceEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglNamedFramebufferTextureFaceEXT(n2, n3, n4, n5, n6, l2);
    }

    static native void nglNamedFramebufferTextureFaceEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTextureRenderbufferEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glTextureRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglTextureRenderbufferEXT(n2, n3, n4, l2);
    }

    static native void nglTextureRenderbufferEXT(int var0, int var1, int var2, long var3);

    public static void glMultiTexRenderbufferEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMultiTexRenderbufferEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglMultiTexRenderbufferEXT(n2, n3, n4, l2);
    }

    static native void nglMultiTexRenderbufferEXT(int var0, int var1, int var2, long var3);

    public static void glVertexArrayVertexOffsetEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayVertexOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayVertexOffsetEXT(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglVertexArrayVertexOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayColorOffsetEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayColorOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayColorOffsetEXT(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglVertexArrayColorOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayEdgeFlagOffsetEXT(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayEdgeFlagOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayEdgeFlagOffsetEXT(n2, n3, n4, l2, l3);
    }

    static native void nglVertexArrayEdgeFlagOffsetEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glVertexArrayIndexOffsetEXT(int n2, int n3, int n4, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayIndexOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayIndexOffsetEXT(n2, n3, n4, n5, l2, l3);
    }

    static native void nglVertexArrayIndexOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArrayNormalOffsetEXT(int n2, int n3, int n4, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayNormalOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayNormalOffsetEXT(n2, n3, n4, n5, l2, l3);
    }

    static native void nglVertexArrayNormalOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArrayTexCoordOffsetEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayTexCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayTexCoordOffsetEXT(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglVertexArrayTexCoordOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayMultiTexCoordOffsetEXT(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayMultiTexCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayMultiTexCoordOffsetEXT(n2, n3, n4, n5, n6, n7, l2, l3);
    }

    static native void nglVertexArrayMultiTexCoordOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glVertexArrayFogCoordOffsetEXT(int n2, int n3, int n4, int n5, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayFogCoordOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayFogCoordOffsetEXT(n2, n3, n4, n5, l2, l3);
    }

    static native void nglVertexArrayFogCoordOffsetEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glVertexArraySecondaryColorOffsetEXT(int n2, int n3, int n4, int n5, int n6, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArraySecondaryColorOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArraySecondaryColorOffsetEXT(n2, n3, n4, n5, n6, l2, l3);
    }

    static native void nglVertexArraySecondaryColorOffsetEXT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void glVertexArrayVertexAttribOffsetEXT(int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayVertexAttribOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayVertexAttribOffsetEXT(n2, n3, n4, n5, n6, bl2, n7, l2, l3);
    }

    static native void nglVertexArrayVertexAttribOffsetEXT(int var0, int var1, int var2, int var3, int var4, boolean var5, int var6, long var7, long var9);

    public static void glVertexArrayVertexAttribIOffsetEXT(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glVertexArrayVertexAttribIOffsetEXT;
        BufferChecks.checkFunctionAddress(l3);
        EXTDirectStateAccess.nglVertexArrayVertexAttribIOffsetEXT(n2, n3, n4, n5, n6, n7, l2, l3);
    }

    static native void nglVertexArrayVertexAttribIOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glEnableVertexArrayEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableVertexArrayEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglEnableVertexArrayEXT(n2, n3, l2);
    }

    static native void nglEnableVertexArrayEXT(int var0, int var1, long var2);

    public static void glDisableVertexArrayEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableVertexArrayEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglDisableVertexArrayEXT(n2, n3, l2);
    }

    static native void nglDisableVertexArrayEXT(int var0, int var1, long var2);

    public static void glEnableVertexArrayAttribEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEnableVertexArrayAttribEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglEnableVertexArrayAttribEXT(n2, n3, l2);
    }

    static native void nglEnableVertexArrayAttribEXT(int var0, int var1, long var2);

    public static void glDisableVertexArrayAttribEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDisableVertexArrayAttribEXT;
        BufferChecks.checkFunctionAddress(l2);
        EXTDirectStateAccess.nglDisableVertexArrayAttribEXT(n2, n3, l2);
    }

    static native void nglDisableVertexArrayAttribEXT(int var0, int var1, long var2);

    public static void glGetVertexArrayIntegerEXT(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIntegervEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 16);
        EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexArrayIntegervEXT(int var0, int var1, long var2, long var4);

    public static int glGetVertexArrayIntegerEXT(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIntegervEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetVertexArrayPointerEXT(int n2, int n3, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetVertexArrayPointervEXT;
        BufferChecks.checkFunctionAddress(l3);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetVertexArrayPointervEXT(n2, n3, l2, l3);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexArrayPointervEXT(int var0, int var1, long var2, long var4);

    public static void glGetVertexArrayIntegerEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIntegeri_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 16);
        EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetVertexArrayIntegeri_vEXT(int var0, int var1, int var2, long var3, long var5);

    public static int glGetVertexArrayIntegeriEXT(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetVertexArrayIntegeri_vEXT;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(n2, n3, n4, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetVertexArrayPointerEXT(int n2, int n3, int n4, long l2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetVertexArrayPointeri_vEXT;
        BufferChecks.checkFunctionAddress(l3);
        ByteBuffer byteBuffer = EXTDirectStateAccess.nglGetVertexArrayPointeri_vEXT(n2, n3, n4, l2, l3);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexArrayPointeri_vEXT(int var0, int var1, int var2, long var3, long var5);

    public static ByteBuffer glMapNamedBufferRangeEXT(int n2, long l2, long l3, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glMapNamedBufferRangeEXT;
        BufferChecks.checkFunctionAddress(l4);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = EXTDirectStateAccess.nglMapNamedBufferRangeEXT(n2, l2, l3, n3, byteBuffer, l4);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapNamedBufferRangeEXT(int var0, long var1, long var3, int var5, ByteBuffer var6, long var7);

    public static void glFlushMappedNamedBufferRangeEXT(int n2, long l2, long l3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glFlushMappedNamedBufferRangeEXT;
        BufferChecks.checkFunctionAddress(l4);
        EXTDirectStateAccess.nglFlushMappedNamedBufferRangeEXT(n2, l2, l3, l4);
    }

    static native void nglFlushMappedNamedBufferRangeEXT(int var0, long var1, long var3, long var5);
}

