/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.DrawableGLES;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengles.ContextAttribs;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLContext;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.GLContext;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.PowerManagementEventException;

final class ContextGLES
implements Context {
    private static final ThreadLocal<ContextGLES> current_context_local = new ThreadLocal();
    private final DrawableGLES drawable;
    private final EGLContext eglContext;
    private final ContextAttribs contextAttribs;
    private boolean destroyed;
    private boolean destroy_requested;
    private Thread thread;

    public EGLContext getEGLContext() {
        return this.eglContext;
    }

    ContextAttribs getContextAttribs() {
        return this.contextAttribs;
    }

    static ContextGLES getCurrentContext() {
        return current_context_local.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContextGLES(DrawableGLES drawableGLES, ContextAttribs contextAttribs, ContextGLES contextGLES) {
        ContextGLES contextGLES2;
        if (drawableGLES == null) {
            throw new IllegalArgumentException();
        }
        ContextGLES contextGLES3 = contextGLES2 = contextGLES != null ? contextGLES : this;
        synchronized (contextGLES3) {
            if (contextGLES != null && contextGLES.destroyed) {
                throw new IllegalArgumentException("Shared context is destroyed");
            }
            this.drawable = drawableGLES;
            this.contextAttribs = contextAttribs;
            this.eglContext = drawableGLES.getEGLDisplay().createContext(drawableGLES.getEGLConfig(), contextGLES == null ? null : contextGLES.eglContext, contextAttribs == null ? new ContextAttribs(2).getAttribList() : contextAttribs.getAttribList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCurrent() {
        EGL.eglReleaseCurrent((EGLDisplay)this.drawable.getEGLDisplay());
        GLContext.useContext(null);
        current_context_local.set(null);
        ContextGLES contextGLES = this;
        synchronized (contextGLES) {
            this.thread = null;
            this.checkDestroy();
        }
    }

    public static void swapBuffers() {
        ContextGLES contextGLES = ContextGLES.getCurrentContext();
        if (contextGLES != null) {
            contextGLES.drawable.getEGLSurface().swapBuffers();
        }
    }

    private boolean canAccess() {
        return this.thread == null || Thread.currentThread() == this.thread;
    }

    private void checkAccess() {
        if (!this.canAccess()) {
            throw new IllegalStateException("From thread " + Thread.currentThread() + ": " + this.thread + " already has the context current");
        }
    }

    public synchronized void makeCurrent() {
        this.checkAccess();
        if (this.destroyed) {
            throw new IllegalStateException("Context is destroyed");
        }
        this.thread = Thread.currentThread();
        current_context_local.set(this);
        this.eglContext.makeCurrent(this.drawable.getEGLSurface());
        GLContext.useContext((Object)this);
    }

    public synchronized boolean isCurrent() {
        if (this.destroyed) {
            throw new IllegalStateException("Context is destroyed");
        }
        return EGL.eglIsCurrentContext((EGLContext)this.eglContext);
    }

    private void checkDestroy() {
        if (!this.destroyed && this.destroy_requested) {
            try {
                this.eglContext.destroy();
                this.destroyed = true;
                this.thread = null;
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Exception occurred while destroying context: " + lWJGLException);
            }
        }
    }

    public static void setSwapInterval(int n2) {
        ContextGLES contextGLES = ContextGLES.getCurrentContext();
        if (contextGLES != null) {
            try {
                contextGLES.drawable.getEGLDisplay().setSwapInterval(n2);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to set swap interval. Reason: " + lWJGLException.getMessage());
            }
        }
    }

    public synchronized void forceDestroy() {
        this.checkAccess();
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroy_requested = true;
        boolean bl2 = this.isCurrent();
        int n2 = 0;
        if (bl2) {
            if (GLContext.getCapabilities() != null && GLContext.getCapabilities().OpenGLES20) {
                n2 = GLES20.glGetError();
            }
            try {
                this.releaseCurrent();
            }
            catch (PowerManagementEventException powerManagementEventException) {
                // empty catch block
            }
        }
        this.checkDestroy();
        if (bl2 && n2 != 0) {
            throw new OpenGLException(n2);
        }
    }

    public void releaseDrawable() {
    }

    static {
        Sys.initialize();
    }
}

