/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;

public final class ContextAttribs {
    public static final int CONTEXT_MAJOR_VERSION_ARB = 8337;
    public static final int CONTEXT_MINOR_VERSION_ARB = 8338;
    public static final int CONTEXT_PROFILE_MASK_ARB = 37158;
    public static final int CONTEXT_CORE_PROFILE_BIT_ARB = 1;
    public static final int CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB = 2;
    public static final int CONTEXT_ES2_PROFILE_BIT_EXT = 4;
    public static final int CONTEXT_FLAGS_ARB = 8340;
    public static final int CONTEXT_DEBUG_BIT_ARB = 1;
    public static final int CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 2;
    public static final int CONTEXT_ROBUST_ACCESS_BIT_ARB = 4;
    public static final int CONTEXT_RESET_ISOLATION_BIT_ARB = 8;
    public static final int CONTEXT_RESET_NOTIFICATION_STRATEGY_ARB = 33366;
    public static final int NO_RESET_NOTIFICATION_ARB = 33377;
    public static final int LOSE_CONTEXT_ON_RESET_ARB = 33362;
    public static final int CONTEXT_RELEASE_BEHABIOR_ARB = 8343;
    public static final int CONTEXT_RELEASE_BEHAVIOR_NONE_ARB = 0;
    public static final int CONTEXT_RELEASE_BEHAVIOR_FLUSH_ARB = 8344;
    public static final int CONTEXT_LAYER_PLANE_ARB = 8339;
    private int majorVersion;
    private int minorVersion;
    private int profileMask;
    private int contextFlags;
    private int contextResetNotificationStrategy = 33377;
    private int contextReleaseBehavior = 8344;
    private int layerPlane;

    public ContextAttribs() {
        this(1, 0);
    }

    public ContextAttribs(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public ContextAttribs(int n2, int n3, int n4) {
        this(n2, n3, 0, n4);
    }

    public ContextAttribs(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || 4 < n2 || n3 < 0 || n2 == 4 && 5 < n3 || n2 == 3 && 3 < n3 || n2 == 2 && 1 < n3 || n2 == 1 && 5 < n3) {
            throw new IllegalArgumentException("Invalid OpenGL version specified: " + n2 + '.' + n3);
        }
        if (LWJGLUtil.CHECKS) {
            if (1 < Integer.bitCount(n4) || 4 < n4) {
                throw new IllegalArgumentException("Invalid profile mask specified: " + Integer.toBinaryString(n4));
            }
            if (15 < n5) {
                throw new IllegalArgumentException("Invalid context flags specified: " + Integer.toBinaryString(n4));
            }
        }
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.profileMask = n4;
        this.contextFlags = n5;
    }

    private ContextAttribs(ContextAttribs contextAttribs) {
        this.majorVersion = contextAttribs.majorVersion;
        this.minorVersion = contextAttribs.minorVersion;
        this.profileMask = contextAttribs.profileMask;
        this.contextFlags = contextAttribs.contextFlags;
        this.contextResetNotificationStrategy = contextAttribs.contextResetNotificationStrategy;
        this.contextReleaseBehavior = contextAttribs.contextReleaseBehavior;
        this.layerPlane = contextAttribs.layerPlane;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getProfileMask() {
        return this.profileMask;
    }

    private boolean hasMask(int n2) {
        return this.profileMask == n2;
    }

    public boolean isProfileCore() {
        return this.hasMask(1);
    }

    public boolean isProfileCompatibility() {
        return this.hasMask(2);
    }

    public boolean isProfileES() {
        return this.hasMask(4);
    }

    public int getContextFlags() {
        return this.contextFlags;
    }

    private boolean hasFlag(int n2) {
        return (this.contextFlags & n2) != 0;
    }

    public boolean isDebug() {
        return this.hasFlag(1);
    }

    public boolean isForwardCompatible() {
        return this.hasFlag(2);
    }

    public boolean isRobustAccess() {
        return this.hasFlag(4);
    }

    public boolean isContextResetIsolation() {
        return this.hasFlag(8);
    }

    public int getContextResetNotificationStrategy() {
        return this.contextResetNotificationStrategy;
    }

    public boolean isLoseContextOnReset() {
        return this.contextResetNotificationStrategy == 33362;
    }

    public int getContextReleaseBehavior() {
        return this.contextReleaseBehavior;
    }

    public int getLayerPlane() {
        return this.layerPlane;
    }

    private ContextAttribs toggleMask(int n2, boolean bl2) {
        if (bl2 == this.hasMask(n2)) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.profileMask = bl2 ? n2 : 0;
        return contextAttribs;
    }

    public ContextAttribs withProfileCore(boolean bl2) {
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new IllegalArgumentException("Profiles are only supported on OpenGL version 3.2 or higher.");
        }
        return this.toggleMask(1, bl2);
    }

    public ContextAttribs withProfileCompatibility(boolean bl2) {
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new IllegalArgumentException("Profiles are only supported on OpenGL version 3.2 or higher.");
        }
        return this.toggleMask(2, bl2);
    }

    public ContextAttribs withProfileES(boolean bl2) {
        if (this.majorVersion != 2 || this.minorVersion != 0) {
            throw new IllegalArgumentException("The OpenGL ES profile is only supported on OpenGL version 2.0.");
        }
        return this.toggleMask(4, bl2);
    }

    private ContextAttribs toggleFlag(int n2, boolean bl2) {
        if (bl2 == this.hasFlag(n2)) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.contextFlags ^= n2;
        return contextAttribs;
    }

    public ContextAttribs withDebug(boolean bl2) {
        return this.toggleFlag(1, bl2);
    }

    public ContextAttribs withForwardCompatible(boolean bl2) {
        return this.toggleFlag(2, bl2);
    }

    public ContextAttribs withRobustAccess(boolean bl2) {
        return this.toggleFlag(4, bl2);
    }

    public ContextAttribs withContextResetIsolation(boolean bl2) {
        return this.toggleFlag(8, bl2);
    }

    public ContextAttribs withResetNotificationStrategy(int n2) {
        if (n2 == this.contextResetNotificationStrategy) {
            return this;
        }
        if (LWJGLUtil.CHECKS && n2 != 33377 && n2 != 33362) {
            throw new IllegalArgumentException("Invalid context reset notification strategy specified: 0x" + LWJGLUtil.toHexString(n2));
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.contextResetNotificationStrategy = n2;
        return contextAttribs;
    }

    public ContextAttribs withLoseContextOnReset(boolean bl2) {
        return this.withResetNotificationStrategy(bl2 ? 33362 : 33377);
    }

    public ContextAttribs withContextReleaseBehavior(int n2) {
        if (n2 == this.contextReleaseBehavior) {
            return this;
        }
        if (LWJGLUtil.CHECKS && n2 != 8344 && n2 != 0) {
            throw new IllegalArgumentException("Invalid context release behavior specified: 0x" + LWJGLUtil.toHexString(n2));
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.contextReleaseBehavior = n2;
        return contextAttribs;
    }

    public ContextAttribs withLayer(int n2) {
        if (LWJGLUtil.getPlatform() != 3) {
            throw new IllegalArgumentException("The CONTEXT_LAYER_PLANE_ARB attribute is supported only on the Windows platform.");
        }
        if (n2 == this.layerPlane) {
            return this;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid layer plane specified: " + n2);
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.layerPlane = n2;
        return contextAttribs;
    }

    IntBuffer getAttribList() {
        if (LWJGLUtil.getPlatform() == 2) {
            return null;
        }
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>(8);
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            linkedHashMap.put(8337, this.majorVersion);
            linkedHashMap.put(8338, this.minorVersion);
        }
        if (this.contextFlags != 0) {
            linkedHashMap.put(8340, this.contextFlags);
        }
        if (this.profileMask != 0) {
            linkedHashMap.put(37158, this.profileMask);
        }
        if (this.contextResetNotificationStrategy != 33377) {
            linkedHashMap.put(33366, this.contextResetNotificationStrategy);
        }
        if (this.contextReleaseBehavior != 8344) {
            linkedHashMap.put(8343, this.contextReleaseBehavior);
        }
        if (this.layerPlane != 0) {
            linkedHashMap.put(8339, this.layerPlane);
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(linkedHashMap.size() * 2 + 1);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            intBuffer.put((Integer)entry.getKey()).put((Integer)entry.getValue());
        }
        intBuffer.put(0);
        intBuffer.rewind();
        return intBuffer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("ContextAttribs:");
        stringBuilder.append(" Version=").append(this.majorVersion).append('.').append(this.minorVersion);
        if (this.profileMask != 0) {
            stringBuilder.append(", Profile=");
            if (this.hasMask(1)) {
                stringBuilder.append("CORE");
            } else if (this.hasMask(2)) {
                stringBuilder.append("COMPATIBLITY");
            } else if (this.hasMask(4)) {
                stringBuilder.append("ES2");
            } else {
                stringBuilder.append("*unknown*");
            }
        }
        if (this.contextFlags != 0) {
            if (this.hasFlag(1)) {
                stringBuilder.append(", DEBUG");
            }
            if (this.hasFlag(2)) {
                stringBuilder.append(", FORWARD_COMPATIBLE");
            }
            if (this.hasFlag(4)) {
                stringBuilder.append(", ROBUST_ACCESS");
            }
            if (this.hasFlag(8)) {
                stringBuilder.append(", RESET_ISOLATION");
            }
        }
        if (this.contextResetNotificationStrategy != 33377) {
            stringBuilder.append(", LOSE_CONTEXT_ON_RESET");
        }
        if (this.contextReleaseBehavior != 8344) {
            stringBuilder.append(", RELEASE_BEHAVIOR_NONE");
        }
        if (this.layerPlane != 0) {
            stringBuilder.append(", Layer=").append(this.layerPlane);
        }
        return stringBuilder.toString();
    }
}

