/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CallbackUtil {
    private static final Map<ContextCapabilities, Long> contextUserParamsARB = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsAMD = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsKHR = new HashMap<ContextCapabilities, Long>();

    private CallbackUtil() {
    }

    static long createGlobalRef(Object object) {
        return object == null ? 0L : CallbackUtil.ncreateGlobalRef(object);
    }

    private static native long ncreateGlobalRef(Object var0);

    private static native void deleteGlobalRef(long var0);

    private static void registerContextCallback(long l2, Map<ContextCapabilities, Long> map) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        if (contextCapabilities == null) {
            CallbackUtil.deleteGlobalRef(l2);
            throw new IllegalStateException("No context is current.");
        }
        Long l3 = map.remove(contextCapabilities);
        if (l3 != null) {
            CallbackUtil.deleteGlobalRef(l3);
        }
        if (l2 != 0L) {
            map.put(contextCapabilities, l2);
        }
    }

    static void unregisterCallbacks(Object object) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities(object);
        Long l2 = contextUserParamsARB.remove(contextCapabilities);
        if (l2 != null) {
            CallbackUtil.deleteGlobalRef(l2);
        }
        if ((l2 = contextUserParamsAMD.remove(contextCapabilities)) != null) {
            CallbackUtil.deleteGlobalRef(l2);
        }
        if ((l2 = contextUserParamsKHR.remove(contextCapabilities)) != null) {
            CallbackUtil.deleteGlobalRef(l2);
        }
    }

    static native long getDebugOutputCallbackARB();

    static void registerContextCallbackARB(long l2) {
        CallbackUtil.registerContextCallback(l2, contextUserParamsARB);
    }

    static native long getDebugOutputCallbackAMD();

    static void registerContextCallbackAMD(long l2) {
        CallbackUtil.registerContextCallback(l2, contextUserParamsAMD);
    }

    static native long getDebugCallbackKHR();

    static void registerContextCallbackKHR(long l2) {
        CallbackUtil.registerContextCallback(l2, contextUserParamsKHR);
    }
}

