/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.IllegalComponentStateException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.lwjgl.LWJGLUtil;

final class AWTUtil {
    AWTUtil() {
    }

    public static boolean hasWheel() {
        return true;
    }

    public static int getButtonCount() {
        return 3;
    }

    public static int getNativeCursorCapabilities() {
        if (LWJGLUtil.getPlatform() != 2 || LWJGLUtil.isMacOSXEqualsOrBetterThan(10, 4)) {
            int n2 = Toolkit.getDefaultToolkit().getMaximumCursorColors();
            boolean bl2 = n2 >= Short.MAX_VALUE && AWTUtil.getMaxCursorSize() > 0;
            int n3 = bl2 ? 3 : 4;
            return n3;
        }
        return 0;
    }

    public static Robot createRobot(final Component component) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Robot>(){

                @Override
                public Robot run() {
                    return new Robot(component.getGraphicsConfiguration().getDevice());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            LWJGLUtil.log("Got exception while creating robot: " + privilegedActionException.getCause());
            return null;
        }
    }

    private static int transformY(Component component, int n2) {
        return component.getHeight() - 1 - n2;
    }

    private static Point getPointerLocation(Component component) {
        try {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (graphicsConfiguration != null) {
                PointerInfo pointerInfo = AccessController.doPrivileged(new PrivilegedExceptionAction<PointerInfo>(){

                    @Override
                    public PointerInfo run() {
                        return MouseInfo.getPointerInfo();
                    }
                });
                GraphicsDevice graphicsDevice = pointerInfo.getDevice();
                if (graphicsDevice == graphicsConfiguration.getDevice()) {
                    return pointerInfo.getLocation();
                }
                return null;
            }
        }
        catch (Exception exception) {
            LWJGLUtil.log("Failed to query pointer location: " + exception.getCause());
        }
        return null;
    }

    public static Point getCursorPosition(Component component) {
        try {
            Point point = AWTUtil.getPointerLocation(component);
            if (point != null) {
                Point point2 = component.getLocationOnScreen();
                point.translate(-point2.x, -point2.y);
                point.move(point.x, AWTUtil.transformY(component, point.y));
                return point;
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            LWJGLUtil.log("Failed to set cursor position: " + illegalComponentStateException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LWJGLUtil.log("Failed to query cursor position: " + noClassDefFoundError);
        }
        return null;
    }

    public static void setCursorPosition(Component component, Robot robot, int n2, int n3) {
        if (robot != null) {
            try {
                Point point = component.getLocationOnScreen();
                int n4 = point.x + n2;
                int n5 = point.y + AWTUtil.transformY(component, n3);
                robot.mouseMove(n4, n5);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                LWJGLUtil.log("Failed to set cursor position: " + illegalComponentStateException);
            }
        }
    }

    public static int getMinCursorSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(0, 0);
        return Math.max(dimension.width, dimension.height);
    }

    public static int getMaxCursorSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(10000, 10000);
        return Math.min(dimension.width, dimension.height);
    }

    public static Cursor createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        int[] nArray = new int[intBuffer.remaining()];
        int n7 = intBuffer.position();
        intBuffer.get(nArray);
        intBuffer.position(n7);
        bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(n4, n5), "LWJGL Custom cursor");
    }
}

