/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.opengl.AWTCanvasImplementation;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.LinuxCanvasImplementation;
import org.lwjgl.opengl.MacOSXCanvasImplementation;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.PixelFormatLWJGL;
import org.lwjgl.opengl.Util;
import org.lwjgl.opengl.WindowsCanvasImplementation;

public class AWTGLCanvas
extends Canvas
implements ComponentListener,
HierarchyListener,
DrawableLWJGL {
    private static final long serialVersionUID = 1L;
    private static final AWTCanvasImplementation implementation;
    private boolean update_context;
    private Object SYNC_LOCK = new Object();
    private final PixelFormat pixel_format;
    private final Drawable drawable;
    private final ContextAttribs attribs;
    private PeerInfo peer_info;
    private ContextGL context;
    private int reentry_count;
    private boolean first_run;

    static AWTCanvasImplementation createImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxCanvasImplementation();
            }
            case 3: {
                return new WindowsCanvasImplementation();
            }
            case 2: {
                return new MacOSXCanvasImplementation();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdate() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            this.update_context = true;
        }
    }

    public void setPixelFormat(PixelFormatLWJGL pixelFormatLWJGL) {
        throw new UnsupportedOperationException();
    }

    public void setPixelFormat(PixelFormatLWJGL pixelFormatLWJGL, ContextAttribs contextAttribs) {
        throw new UnsupportedOperationException();
    }

    public PixelFormatLWJGL getPixelFormat() {
        return this.pixel_format;
    }

    public ContextGL getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextGL createSharedContext() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            return new ContextGL(this.peer_info, this.context.getContextAttribs(), this.context);
        }
    }

    public void checkGLError() {
        Util.checkGLError();
    }

    public void initContext(float f2, float f3, float f4) {
        GL11.glClearColor(f2, f3, f4, 0.0f);
        GL11.glClear(16384);
    }

    public AWTGLCanvas() {
        this(new PixelFormat());
    }

    public AWTGLCanvas(PixelFormat pixelFormat) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), pixelFormat);
    }

    public AWTGLCanvas(GraphicsDevice graphicsDevice, PixelFormat pixelFormat) {
        this(graphicsDevice, pixelFormat, null);
    }

    public AWTGLCanvas(GraphicsDevice graphicsDevice, PixelFormat pixelFormat, Drawable drawable) {
        this(graphicsDevice, pixelFormat, drawable, null);
    }

    public AWTGLCanvas(GraphicsDevice graphicsDevice, PixelFormat pixelFormat, Drawable drawable, ContextAttribs contextAttribs) {
        super(implementation.findConfiguration(graphicsDevice, pixelFormat));
        if (pixelFormat == null) {
            throw new NullPointerException("Pixel format must be non-null");
        }
        this.addHierarchyListener(this);
        this.addComponentListener(this);
        this.drawable = drawable;
        this.pixel_format = pixelFormat;
        this.attribs = contextAttribs;
    }

    public void addNotify() {
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            this.destroy();
            super.removeNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSwapInterval(int n2) {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            ContextGL.setSwapInterval(n2);
        }
    }

    public void setVSyncEnabled(boolean bl2) {
        this.setSwapInterval(bl2 ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            ContextGL.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrent() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            return this.context.isCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCurrent() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            this.context.makeCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseContext() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            if (this.context.isCurrent()) {
                this.context.releaseCurrent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            try {
                if (this.context != null) {
                    this.context.forceDestroy();
                    this.context = null;
                    this.reentry_count = 0;
                    this.peer_info.destroy();
                    this.peer_info = null;
                }
            }
            catch (LWJGLException lWJGLException) {
                throw new RuntimeException(lWJGLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCLSharingProperties(PointerBuffer pointerBuffer) {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            this.context.setCLSharingProperties(pointerBuffer);
        }
    }

    protected void initGL() {
    }

    protected void paintGL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics) {
        LWJGLException lWJGLException = null;
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (!this.isDisplayable()) {
                return;
            }
            try {
                if (this.peer_info == null) {
                    this.peer_info = implementation.createPeerInfo(this, this.pixel_format, this.attribs);
                }
                this.peer_info.lockAndGetHandle();
                try {
                    if (this.context == null) {
                        this.context = new ContextGL(this.peer_info, this.attribs, this.drawable != null ? (ContextGL)((DrawableLWJGL)this.drawable).getContext() : null);
                        this.first_run = true;
                    }
                    if (this.reentry_count == 0) {
                        this.context.makeCurrent();
                    }
                    ++this.reentry_count;
                    try {
                        if (this.update_context) {
                            this.context.update();
                            this.update_context = false;
                        }
                        if (this.first_run) {
                            this.first_run = false;
                            this.initGL();
                        }
                        this.paintGL();
                    }
                    finally {
                        --this.reentry_count;
                        if (this.reentry_count == 0) {
                            this.context.releaseCurrent();
                        }
                    }
                }
                finally {
                    this.peer_info.unlock();
                }
            }
            catch (LWJGLException lWJGLException2) {
                lWJGLException = lWJGLException2;
            }
        }
        if (lWJGLException != null) {
            this.exceptionOccurred(lWJGLException);
        }
    }

    protected void exceptionOccurred(LWJGLException lWJGLException) {
        LWJGLUtil.log("Unhandled exception occurred, skipping paint(): " + lWJGLException);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setUpdate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.setUpdate();
    }

    public void setLocation(int n2, int n3) {
        super.setLocation(n2, n3);
        this.setUpdate();
    }

    public void setLocation(Point point) {
        super.setLocation(point);
        this.setUpdate();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.setUpdate();
    }

    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        this.setUpdate();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.setUpdate();
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.setUpdate();
    }

    static {
        Sys.initialize();
        implementation = AWTGLCanvas.createImplementation();
    }
}

