/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ATIElementArray {
    public static final int GL_ELEMENT_ARRAY_ATI = 34664;
    public static final int GL_ELEMENT_ARRAY_TYPE_ATI = 34665;
    public static final int GL_ELEMENT_ARRAY_POINTER_ATI = 34666;

    private ATIElementArray() {
    }

    public static void glElementPointerATI(ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glElementPointerATI;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        ATIElementArray.nglElementPointerATI(5121, MemoryUtil.getAddress(byteBuffer), l2);
    }

    public static void glElementPointerATI(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glElementPointerATI;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ATIElementArray.nglElementPointerATI(5125, MemoryUtil.getAddress(intBuffer), l2);
    }

    public static void glElementPointerATI(ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glElementPointerATI;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        ATIElementArray.nglElementPointerATI(5123, MemoryUtil.getAddress(shortBuffer), l2);
    }

    static native void nglElementPointerATI(int var0, long var1, long var3);

    public static void glDrawElementArrayATI(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawElementArrayATI;
        BufferChecks.checkFunctionAddress(l2);
        ATIElementArray.nglDrawElementArrayATI(n2, n3, l2);
    }

    static native void nglDrawElementArrayATI(int var0, int var1, long var2);

    public static void glDrawRangeElementArrayATI(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDrawRangeElementArrayATI;
        BufferChecks.checkFunctionAddress(l2);
        ATIElementArray.nglDrawRangeElementArrayATI(n2, n3, n4, n5, l2);
    }

    static native void nglDrawRangeElementArrayATI(int var0, int var1, int var2, int var3, long var4);
}

