/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    private ARBShaderObjects() {
    }

    public static void glDeleteObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglDeleteObjectARB(n2, l2);
    }

    static native void nglDeleteObjectARB(int var0, long var1);

    public static int glGetHandleARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetHandleARB;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = ARBShaderObjects.nglGetHandleARB(n2, l2);
        return n3;
    }

    static native int nglGetHandleARB(int var0, long var1);

    public static void glDetachObjectARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDetachObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglDetachObjectARB(n2, n3, l2);
    }

    static native void nglDetachObjectARB(int var0, int var1, long var2);

    public static int glCreateShaderObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateShaderObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = ARBShaderObjects.nglCreateShaderObjectARB(n2, l2);
        return n3;
    }

    static native int nglCreateShaderObjectARB(int var0, long var1);

    public static void glShaderSourceARB(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        ARBShaderObjects.nglShaderSourceARB(n2, 1, MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), l2);
    }

    static native void nglShaderSourceARB(int var0, int var1, long var2, int var4, long var5);

    public static void glShaderSourceARB(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglShaderSourceARB(n2, 1, APIUtil.getBuffer(contextCapabilities, charSequence), charSequence.length(), l2);
    }

    public static void glShaderSourceARB(int n2, CharSequence[] charSequenceArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(charSequenceArray);
        ARBShaderObjects.nglShaderSourceARB3(n2, charSequenceArray.length, APIUtil.getBuffer(contextCapabilities, charSequenceArray), APIUtil.getLengths(contextCapabilities, charSequenceArray), l2);
    }

    static native void nglShaderSourceARB3(int var0, int var1, long var2, long var4, long var6);

    public static void glCompileShaderARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCompileShaderARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglCompileShaderARB(n2, l2);
    }

    static native void nglCompileShaderARB(int var0, long var1);

    public static int glCreateProgramObjectARB() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glCreateProgramObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = ARBShaderObjects.nglCreateProgramObjectARB(l2);
        return n2;
    }

    static native int nglCreateProgramObjectARB(long var0);

    public static void glAttachObjectARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glAttachObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglAttachObjectARB(n2, n3, l2);
    }

    static native void nglAttachObjectARB(int var0, int var1, long var2);

    public static void glLinkProgramARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glLinkProgramARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglLinkProgramARB(n2, l2);
    }

    static native void nglLinkProgramARB(int var0, long var1);

    public static void glUseProgramObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUseProgramObjectARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUseProgramObjectARB(n2, l2);
    }

    static native void nglUseProgramObjectARB(int var0, long var1);

    public static void glValidateProgramARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glValidateProgramARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglValidateProgramARB(n2, l2);
    }

    static native void nglValidateProgramARB(int var0, long var1);

    public static void glUniform1fARB(int n2, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1fARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform1fARB(n2, f2, l2);
    }

    static native void nglUniform1fARB(int var0, float var1, long var2);

    public static void glUniform2fARB(int n2, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2fARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform2fARB(n2, f2, f3, l2);
    }

    static native void nglUniform2fARB(int var0, float var1, float var2, long var3);

    public static void glUniform3fARB(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3fARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform3fARB(n2, f2, f3, f4, l2);
    }

    static native void nglUniform3fARB(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform4fARB(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4fARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform4fARB(n2, f2, f3, f4, f5, l2);
    }

    static native void nglUniform4fARB(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform1iARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1iARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform1iARB(n2, n3, l2);
    }

    static native void nglUniform1iARB(int var0, int var1, long var2);

    public static void glUniform2iARB(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2iARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform2iARB(n2, n3, n4, l2);
    }

    static native void nglUniform2iARB(int var0, int var1, int var2, long var3);

    public static void glUniform3iARB(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3iARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform3iARB(n2, n3, n4, n5, l2);
    }

    static native void nglUniform3iARB(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4iARB(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4iARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform4iARB(n2, n3, n4, n5, n6, l2);
    }

    static native void nglUniform4iARB(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniform1fvARB(n2, floatBuffer.remaining(), MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform1fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform2ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniform2fvARB(n2, floatBuffer.remaining() >> 1, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform2fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform3ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniform3fvARB(n2, floatBuffer.remaining() / 3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform3fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform4ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniform4fvARB(n2, floatBuffer.remaining() >> 2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniform4fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform1ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform1ivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglUniform1ivARB(n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform1ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform2ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform2ivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglUniform2ivARB(n2, intBuffer.remaining() >> 1, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform2ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform3ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform3ivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglUniform3ivARB(n2, intBuffer.remaining() / 3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform3ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform4ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniform4ivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglUniform4ivARB(n2, intBuffer.remaining() >> 2, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglUniform4ivARB(int var0, int var1, long var2, long var4);

    public static void glUniformMatrix2ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix2fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix2fvARB(n2, floatBuffer.remaining() >> 2, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix3fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix3fvARB(n2, floatBuffer.remaining() / 9, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUniformMatrix4fvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix4fvARB(n2, floatBuffer.remaining() >> 4, bl2, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetObjectParameterARB(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetObjectParameterfvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglGetObjectParameterfvARB(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetObjectParameterfvARB(int var0, int var1, long var2, long var4);

    public static float glGetObjectParameterfARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetObjectParameterfvARB;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        ARBShaderObjects.nglGetObjectParameterfvARB(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
        return floatBuffer.get(0);
    }

    public static void glGetObjectParameterARB(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetObjectParameterivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglGetObjectParameterivARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetObjectParameterivARB(int var0, int var1, long var2, long var4);

    public static int glGetObjectParameteriARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetObjectParameterivARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetObjectParameterivARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glGetInfoLogARB(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInfoLogARB;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        ARBShaderObjects.nglGetInfoLogARB(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetInfoLogARB(int var0, int var1, long var2, long var4, long var6);

    public static String glGetInfoLogARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetInfoLogARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        ARBShaderObjects.nglGetInfoLogARB(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetAttachedObjectsARB(int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetAttachedObjectsARB;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(intBuffer2);
        ARBShaderObjects.nglGetAttachedObjectsARB(n2, intBuffer2.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), l2);
    }

    static native void nglGetAttachedObjectsARB(int var0, int var1, long var2, long var4, long var6);

    public static int glGetUniformLocationARB(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformLocationARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = ARBShaderObjects.nglGetUniformLocationARB(n2, MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    static native int nglGetUniformLocationARB(int var0, long var1, long var3);

    public static int glGetUniformLocationARB(int n2, CharSequence charSequence) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformLocationARB;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = ARBShaderObjects.nglGetUniformLocationARB(n2, APIUtil.getBufferNT(contextCapabilities, charSequence), l2);
        return n3;
    }

    public static void glGetActiveUniformARB(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkBuffer(intBuffer2, 1);
        BufferChecks.checkBuffer(intBuffer3, 1);
        BufferChecks.checkDirect(byteBuffer);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(intBuffer2), MemoryUtil.getAddress(intBuffer3), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetActiveUniformARB(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveUniformARB(int n2, int n3, int n4, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 2);
        IntBuffer intBuffer2 = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, n4, MemoryUtil.getAddress0(intBuffer2), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, intBuffer.position() + 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer2.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveUniformARB(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, n4, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveUniformSizeARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, 0, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static int glGetActiveUniformTypeARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l2);
        return intBuffer.get(0);
    }

    public static void glGetUniformARB(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformfvARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBShaderObjects.nglGetUniformfvARB(n2, n3, MemoryUtil.getAddress(floatBuffer), l2);
    }

    static native void nglGetUniformfvARB(int var0, int var1, long var2, long var4);

    public static void glGetUniformARB(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetUniformivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBShaderObjects.nglGetUniformivARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetUniformivARB(int var0, int var1, long var2, long var4);

    public static void glGetShaderSourceARB(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderSourceARB;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(byteBuffer);
        ARBShaderObjects.nglGetShaderSourceARB(n2, byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetShaderSourceARB(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderSourceARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetShaderSourceARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        ARBShaderObjects.nglGetShaderSourceARB(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }
}

