/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class ARBIndirectParameters {
    public static final int GL_PARAMETER_BUFFER_ARB = 33006;
    public static final int GL_PARAMETER_BUFFER_BINDING_ARB = 33007;

    private ARBIndirectParameters() {
    }

    public static void glMultiDrawArraysIndirectCountARB(int n2, ByteBuffer byteBuffer, long l2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiDrawArraysIndirectCountARB;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, (n4 == 0 ? 16 : n4) * n3);
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(n2, MemoryUtil.getAddress(byteBuffer), l2, n3, n4, l3);
    }

    static native void nglMultiDrawArraysIndirectCountARB(int var0, long var1, long var3, int var5, int var6, long var7);

    public static void glMultiDrawArraysIndirectCountARB(int n2, long l2, long l3, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glMultiDrawArraysIndirectCountARB;
        BufferChecks.checkFunctionAddress(l4);
        GLChecks.ensureIndirectBOenabled(contextCapabilities);
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARBBO(n2, l2, l3, n3, n4, l4);
    }

    static native void nglMultiDrawArraysIndirectCountARBBO(int var0, long var1, long var3, int var5, int var6, long var7);

    public static void glMultiDrawArraysIndirectCountARB(int n2, IntBuffer intBuffer, long l2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiDrawArraysIndirectCountARB;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, (n4 == 0 ? 4 : n4 >> 2) * n3);
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(n2, MemoryUtil.getAddress(intBuffer), l2, n3, n4, l3);
    }

    public static void glMultiDrawElementsIndirectCountARB(int n2, int n3, ByteBuffer byteBuffer, long l2, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiDrawElementsIndirectCountARB;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(byteBuffer, (n5 == 0 ? 20 : n5) * n4);
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(n2, n3, MemoryUtil.getAddress(byteBuffer), l2, n4, n5, l3);
    }

    static native void nglMultiDrawElementsIndirectCountARB(int var0, int var1, long var2, long var4, int var6, int var7, long var8);

    public static void glMultiDrawElementsIndirectCountARB(int n2, int n3, long l2, long l3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l4 = contextCapabilities.glMultiDrawElementsIndirectCountARB;
        BufferChecks.checkFunctionAddress(l4);
        GLChecks.ensureIndirectBOenabled(contextCapabilities);
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARBBO(n2, n3, l2, l3, n4, n5, l4);
    }

    static native void nglMultiDrawElementsIndirectCountARBBO(int var0, int var1, long var2, long var4, int var6, int var7, long var8);

    public static void glMultiDrawElementsIndirectCountARB(int n2, int n3, IntBuffer intBuffer, long l2, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMultiDrawElementsIndirectCountARB;
        BufferChecks.checkFunctionAddress(l3);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(intBuffer, (n5 == 0 ? 5 : n5 >> 2) * n4);
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2, n4, n5, l3);
    }
}

