/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL44;
import org.lwjgl.opengl.GLContext;

public final class ARBBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;

    private ARBBufferStorage() {
    }

    public static void glBufferStorage(int n2, ByteBuffer byteBuffer, int n3) {
        GL44.glBufferStorage(n2, byteBuffer, n3);
    }

    public static void glBufferStorage(int n2, DoubleBuffer doubleBuffer, int n3) {
        GL44.glBufferStorage(n2, doubleBuffer, n3);
    }

    public static void glBufferStorage(int n2, FloatBuffer floatBuffer, int n3) {
        GL44.glBufferStorage(n2, floatBuffer, n3);
    }

    public static void glBufferStorage(int n2, IntBuffer intBuffer, int n3) {
        GL44.glBufferStorage(n2, intBuffer, n3);
    }

    public static void glBufferStorage(int n2, ShortBuffer shortBuffer, int n3) {
        GL44.glBufferStorage(n2, shortBuffer, n3);
    }

    public static void glBufferStorage(int n2, LongBuffer longBuffer, int n3) {
        GL44.glBufferStorage(n2, longBuffer, n3);
    }

    public static void glBufferStorage(int n2, long l2, int n3) {
        GL44.glBufferStorage(n2, l2, n3);
    }

    public static void glNamedBufferStorageEXT(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, LongBuffer longBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), n3, l2);
    }

    static native void nglNamedBufferStorageEXT(int var0, long var1, long var3, int var5, long var6);

    public static void glNamedBufferStorageEXT(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glNamedBufferStorageEXT;
        BufferChecks.checkFunctionAddress(l3);
        ARBBufferStorage.nglNamedBufferStorageEXT(n2, l2, 0L, n3, l3);
    }
}

