/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public class ARBBufferObject {
    public static final int GL_STREAM_DRAW_ARB = 35040;
    public static final int GL_STREAM_READ_ARB = 35041;
    public static final int GL_STREAM_COPY_ARB = 35042;
    public static final int GL_STATIC_DRAW_ARB = 35044;
    public static final int GL_STATIC_READ_ARB = 35045;
    public static final int GL_STATIC_COPY_ARB = 35046;
    public static final int GL_DYNAMIC_DRAW_ARB = 35048;
    public static final int GL_DYNAMIC_READ_ARB = 35049;
    public static final int GL_DYNAMIC_COPY_ARB = 35050;
    public static final int GL_READ_ONLY_ARB = 35000;
    public static final int GL_WRITE_ONLY_ARB = 35001;
    public static final int GL_READ_WRITE_ARB = 35002;
    public static final int GL_BUFFER_SIZE_ARB = 34660;
    public static final int GL_BUFFER_USAGE_ARB = 34661;
    public static final int GL_BUFFER_ACCESS_ARB = 35003;
    public static final int GL_BUFFER_MAPPED_ARB = 35004;
    public static final int GL_BUFFER_MAP_POINTER_ARB = 35005;

    public static void glBindBufferARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBindBufferARB;
        BufferChecks.checkFunctionAddress(l2);
        StateTracker.bindBuffer(contextCapabilities, n2, n3);
        ARBBufferObject.nglBindBufferARB(n2, n3, l2);
    }

    static native void nglBindBufferARB(int var0, int var1, long var2);

    public static void glDeleteBuffersARB(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteBuffersARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferObject.nglDeleteBuffersARB(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeleteBuffersARB(int var0, long var1, long var3);

    public static void glDeleteBuffersARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeleteBuffersARB;
        BufferChecks.checkFunctionAddress(l2);
        ARBBufferObject.nglDeleteBuffersARB(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glGenBuffersARB(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenBuffersARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferObject.nglGenBuffersARB(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenBuffersARB(int var0, long var1, long var3);

    public static int glGenBuffersARB() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenBuffersARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBBufferObject.nglGenBuffersARB(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static boolean glIsBufferARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glIsBufferARB;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = ARBBufferObject.nglIsBufferARB(n2, l2);
        return bl2;
    }

    static native boolean nglIsBufferARB(int var0, long var1);

    public static void glBufferDataARB(int n2, long l2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l3);
        ARBBufferObject.nglBufferDataARB(n2, l2, 0L, n3, l3);
    }

    public static void glBufferDataARB(int n2, ByteBuffer byteBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        ARBBufferObject.nglBufferDataARB(n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), n3, l2);
    }

    public static void glBufferDataARB(int n2, DoubleBuffer doubleBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        ARBBufferObject.nglBufferDataARB(n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), n3, l2);
    }

    public static void glBufferDataARB(int n2, FloatBuffer floatBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        ARBBufferObject.nglBufferDataARB(n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), n3, l2);
    }

    public static void glBufferDataARB(int n2, IntBuffer intBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferObject.nglBufferDataARB(n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), n3, l2);
    }

    public static void glBufferDataARB(int n2, ShortBuffer shortBuffer, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        ARBBufferObject.nglBufferDataARB(n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), n3, l2);
    }

    static native void nglBufferDataARB(int var0, long var1, long var3, int var5, long var6);

    public static void glBufferSubDataARB(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        ARBBufferObject.nglBufferSubDataARB(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glBufferSubDataARB(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        ARBBufferObject.nglBufferSubDataARB(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glBufferSubDataARB(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        ARBBufferObject.nglBufferSubDataARB(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glBufferSubDataARB(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferObject.nglBufferSubDataARB(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glBufferSubDataARB(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        ARBBufferObject.nglBufferSubDataARB(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglBufferSubDataARB(int var0, long var1, long var3, long var5, long var7);

    public static void glGetBufferSubDataARB(int n2, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        ARBBufferObject.nglGetBufferSubDataARB(n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l3);
    }

    public static void glGetBufferSubDataARB(int n2, long l2, DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        ARBBufferObject.nglGetBufferSubDataARB(n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l3);
    }

    public static void glGetBufferSubDataARB(int n2, long l2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        ARBBufferObject.nglGetBufferSubDataARB(n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l3);
    }

    public static void glGetBufferSubDataARB(int n2, long l2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        ARBBufferObject.nglGetBufferSubDataARB(n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l3);
    }

    public static void glGetBufferSubDataARB(int n2, long l2, ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        ARBBufferObject.nglGetBufferSubDataARB(n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l3);
    }

    static native void nglGetBufferSubDataARB(int var0, long var1, long var3, long var5, long var7);

    public static ByteBuffer glMapBufferARB(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glMapBufferARB;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ARBBufferObject.nglMapBufferARB(n2, n3, ARBBufferObject.glGetBufferParameteriARB(n2, 34660), byteBuffer, l2);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapBufferARB(int n2, int n3, long l2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l3 = contextCapabilities.glMapBufferARB;
        BufferChecks.checkFunctionAddress(l3);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ARBBufferObject.nglMapBufferARB(n2, n3, l2, byteBuffer, l3);
        return LWJGLUtil.CHECKS && byteBuffer2 == null ? null : byteBuffer2.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapBufferARB(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static boolean glUnmapBufferARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glUnmapBufferARB;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = ARBBufferObject.nglUnmapBufferARB(n2, l2);
        return bl2;
    }

    static native boolean nglUnmapBufferARB(int var0, long var1);

    public static void glGetBufferParameterARB(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameterivARB;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 4);
        ARBBufferObject.nglGetBufferParameterivARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGetBufferParameterivARB(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetBufferParameterARB(int n2, int n3) {
        return ARBBufferObject.glGetBufferParameteriARB(n2, n3);
    }

    public static int glGetBufferParameteriARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferParameterivARB;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBBufferObject.nglGetBufferParameterivARB(n2, n3, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetBufferPointerARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetBufferPointervARB;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = ARBBufferObject.nglGetBufferPointervARB(n2, n3, ARBBufferObject.glGetBufferParameteriARB(n2, 34660), l2);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetBufferPointervARB(int var0, int var1, long var2, long var4);
}

