/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;

final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private char[] array = new char[256];
    private ByteBuffer buffer = BufferUtils.createByteBuffer(256);
    private IntBuffer lengths = BufferUtils.createIntBuffer(4);
    private final IntBuffer ints = BufferUtils.createIntBuffer(32);
    private final LongBuffer longs = BufferUtils.createLongBuffer(32);
    private final FloatBuffer floats = BufferUtils.createFloatBuffer(32);
    private final DoubleBuffer doubles = BufferUtils.createDoubleBuffer(32);

    APIUtil() {
    }

    private static char[] getArray(ContextCapabilities contextCapabilities, int n2) {
        char[] cArray = contextCapabilities.util.array;
        if (cArray.length < n2) {
            for (int i2 = cArray.length << 1; i2 < n2; i2 <<= 1) {
            }
            contextCapabilities.util.array = cArray = new char[n2];
        }
        return cArray;
    }

    static ByteBuffer getBufferByte(ContextCapabilities contextCapabilities, int n2) {
        ByteBuffer byteBuffer = contextCapabilities.util.buffer;
        if (byteBuffer.capacity() < n2) {
            for (int i2 = byteBuffer.capacity() << 1; i2 < n2; i2 <<= 1) {
            }
            contextCapabilities.util.buffer = byteBuffer = BufferUtils.createByteBuffer(n2);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private static ByteBuffer getBufferByteOffset(ContextCapabilities contextCapabilities, int n2) {
        ByteBuffer byteBuffer = contextCapabilities.util.buffer;
        if (byteBuffer.capacity() < n2) {
            for (int i2 = byteBuffer.capacity() << 1; i2 < n2; i2 <<= 1) {
            }
            ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(n2);
            byteBuffer2.put(byteBuffer);
            contextCapabilities.util.buffer = byteBuffer = byteBuffer2;
        } else {
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(byteBuffer.capacity());
        }
        return byteBuffer;
    }

    static IntBuffer getBufferInt(ContextCapabilities contextCapabilities) {
        return contextCapabilities.util.ints;
    }

    static LongBuffer getBufferLong(ContextCapabilities contextCapabilities) {
        return contextCapabilities.util.longs;
    }

    static FloatBuffer getBufferFloat(ContextCapabilities contextCapabilities) {
        return contextCapabilities.util.floats;
    }

    static DoubleBuffer getBufferDouble(ContextCapabilities contextCapabilities) {
        return contextCapabilities.util.doubles;
    }

    static IntBuffer getLengths(ContextCapabilities contextCapabilities) {
        return APIUtil.getLengths(contextCapabilities, 1);
    }

    static IntBuffer getLengths(ContextCapabilities contextCapabilities, int n2) {
        IntBuffer intBuffer = contextCapabilities.util.lengths;
        if (intBuffer.capacity() < n2) {
            for (int i2 = intBuffer.capacity(); i2 < n2; i2 <<= 1) {
            }
            contextCapabilities.util.lengths = intBuffer = BufferUtils.createIntBuffer(n2);
        } else {
            intBuffer.clear();
        }
        return intBuffer;
    }

    private static ByteBuffer encode(ByteBuffer byteBuffer, CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (LWJGLUtil.DEBUG && '\u0080' <= c2) {
                byteBuffer.put((byte)26);
                continue;
            }
            byteBuffer.put((byte)c2);
        }
        return byteBuffer;
    }

    static String getString(ContextCapabilities contextCapabilities, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        char[] cArray = APIUtil.getArray(contextCapabilities, n2);
        for (int i2 = byteBuffer.position(); i2 < byteBuffer.limit(); ++i2) {
            cArray[i2 - byteBuffer.position()] = (char)byteBuffer.get(i2);
        }
        return new String(cArray, 0, n2);
    }

    static long getBuffer(ContextCapabilities contextCapabilities, CharSequence charSequence) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(contextCapabilities, charSequence.length()), charSequence);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBuffer(ContextCapabilities contextCapabilities, CharSequence charSequence, int n2) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByteOffset(contextCapabilities, n2 + charSequence.length()), charSequence);
        byteBuffer.flip();
        return MemoryUtil.getAddress(byteBuffer);
    }

    static long getBufferNT(ContextCapabilities contextCapabilities, CharSequence charSequence) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(contextCapabilities, charSequence.length() + 1), charSequence);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static int getTotalLength(CharSequence[] charSequenceArray) {
        int n2 = 0;
        for (CharSequence charSequence : charSequenceArray) {
            n2 += charSequence.length();
        }
        return n2;
    }

    static long getBuffer(ContextCapabilities contextCapabilities, CharSequence[] charSequenceArray) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, APIUtil.getTotalLength(charSequenceArray));
        for (CharSequence charSequence : charSequenceArray) {
            APIUtil.encode(byteBuffer, charSequence);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBufferNT(ContextCapabilities contextCapabilities, CharSequence[] charSequenceArray) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, APIUtil.getTotalLength(charSequenceArray) + charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            APIUtil.encode(byteBuffer, charSequence);
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getLengths(ContextCapabilities contextCapabilities, CharSequence[] charSequenceArray) {
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities, charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            intBuffer.put(charSequence.length());
        }
        intBuffer.flip();
        return MemoryUtil.getAddress0(intBuffer);
    }

    static long getInt(ContextCapabilities contextCapabilities, int n2) {
        return MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities).put(0, n2));
    }

    static long getBufferByte0(ContextCapabilities contextCapabilities) {
        return MemoryUtil.getAddress0(APIUtil.getBufferByte(contextCapabilities, 0));
    }
}

