/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    private AMDPerformanceMonitor() {
    }

    public static void glGetPerfMonitorGroupsAMD(IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorGroupsAMD;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        BufferChecks.checkDirect(intBuffer2);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.getAddressSafe(intBuffer), intBuffer2.remaining(), MemoryUtil.getAddress(intBuffer2), l2);
    }

    static native void nglGetPerfMonitorGroupsAMD(long var0, int var2, long var3, long var5);

    public static void glGetPerfMonitorCountersAMD(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(intBuffer, 1);
        BufferChecks.checkBuffer(intBuffer2, 1);
        if (intBuffer3 != null) {
            BufferChecks.checkDirect(intBuffer3);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(n2, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer2), intBuffer3 == null ? 0 : intBuffer3.remaining(), MemoryUtil.getAddressSafe(intBuffer3), l2);
    }

    static native void nglGetPerfMonitorCountersAMD(int var0, long var1, long var3, int var5, long var6, long var8);

    public static void glGetPerfMonitorGroupStringAMD(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorGroupStringAMD;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    static native void nglGetPerfMonitorGroupStringAMD(int var0, int var1, long var2, long var4, long var6);

    public static String glGetPerfMonitorGroupStringAMD(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorGroupStringAMD;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n3);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(n2, n3, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetPerfMonitorCounterStringAMD(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCounterStringAMD;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(n2, n3, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(byteBuffer), l2);
    }

    static native void nglGetPerfMonitorCounterStringAMD(int var0, int var1, int var2, long var3, long var5, long var7);

    public static String glGetPerfMonitorCounterStringAMD(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCounterStringAMD;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n4);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(n2, n3, n4, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l2);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCounterInfoAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 16);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(n2, n3, n4, MemoryUtil.getAddress(byteBuffer), l2);
    }

    static native void nglGetPerfMonitorCounterInfoAMD(int var0, int var1, int var2, long var3, long var5);

    public static void glGenPerfMonitorsAMD(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenPerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglGenPerfMonitorsAMD(int var0, long var1, long var3);

    public static int glGenPerfMonitorsAMD() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGenPerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.getAddress(intBuffer), l2);
        return intBuffer.get(0);
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeletePerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglDeletePerfMonitorsAMD(int var0, long var1, long var3);

    public static void glDeletePerfMonitorsAMD(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glDeletePerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l2);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, APIUtil.getInt(contextCapabilities, n2), l2);
    }

    public static void glSelectPerfMonitorCountersAMD(int n2, boolean bl2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glSelectPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(n2, bl2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), l2);
    }

    static native void nglSelectPerfMonitorCountersAMD(int var0, boolean var1, int var2, int var3, long var4, long var6);

    public static void glSelectPerfMonitorCountersAMD(int n2, boolean bl2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glSelectPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l2);
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(n2, bl2, n3, 1, APIUtil.getInt(contextCapabilities, n4), l2);
    }

    public static void glBeginPerfMonitorAMD(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glBeginPerfMonitorAMD;
        BufferChecks.checkFunctionAddress(l2);
        AMDPerformanceMonitor.nglBeginPerfMonitorAMD(n2, l2);
    }

    static native void nglBeginPerfMonitorAMD(int var0, long var1);

    public static void glEndPerfMonitorAMD(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glEndPerfMonitorAMD;
        BufferChecks.checkFunctionAddress(l2);
        AMDPerformanceMonitor.nglEndPerfMonitorAMD(n2, l2);
    }

    static native void nglEndPerfMonitorAMD(int var0, long var1);

    public static void glGetPerfMonitorCounterDataAMD(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCounterDataAMD;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(n2, n3, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2);
    }

    static native void nglGetPerfMonitorCounterDataAMD(int var0, int var1, int var2, long var3, long var5, long var7);

    public static int glGetPerfMonitorCounterDataAMD(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.glGetPerfMonitorCounterDataAMD;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(n2, n3, 4, MemoryUtil.getAddress(intBuffer), 0L, l2);
        return intBuffer.get(0);
    }
}

