/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;

public final class KHRGLSharing {
    public static final int CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR = -1000;
    public static final int CL_CURRENT_DEVICE_FOR_GL_CONTEXT_KHR = 8198;
    public static final int CL_DEVICES_FOR_GL_CONTEXT_KHR = 8199;
    public static final int CL_GL_CONTEXT_KHR = 8200;
    public static final int CL_EGL_DISPLAY_KHR = 8201;
    public static final int CL_GLX_DISPLAY_KHR = 8202;
    public static final int CL_WGL_HDC_KHR = 8203;
    public static final int CL_CGL_SHAREGROUP_KHR = 8204;

    private KHRGLSharing() {
    }

    public static int clGetGLContextInfoKHR(PointerBuffer pointerBuffer, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l2 = CLCapabilities.clGetGLContextInfoKHR;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(pointerBuffer);
        BufferChecks.checkNullTerminated(pointerBuffer);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if (pointerBuffer2 == null && APIUtil.isDevicesParam(n2)) {
            pointerBuffer2 = APIUtil.getBufferPointer();
        }
        if ((n3 = KHRGLSharing.nclGetGLContextInfoKHR(MemoryUtil.getAddress(pointerBuffer), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2)) == 0 && byteBuffer != null && APIUtil.isDevicesParam(n2)) {
            APIUtil.getCLPlatform(pointerBuffer).registerCLDevices(byteBuffer, pointerBuffer2);
        }
        return n3;
    }

    static native int nclGetGLContextInfoKHR(long var0, int var2, long var3, long var5, long var7, long var9);
}

