/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLChecks;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.CallbackUtil;
import org.lwjgl.opencl.InfoUtil;
import org.lwjgl.opencl.InfoUtilAbstract;
import org.lwjgl.opencl.Util;
import org.lwjgl.opencl.api.CLBufferRegion;
import org.lwjgl.opencl.api.CLImageFormat;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.Drawable;

final class InfoUtilFactory {
    static final InfoUtil<CLCommandQueue> CL_COMMAND_QUEUE_UTIL = new InfoUtilAbstract<CLCommandQueue>(){

        @Override
        protected int getInfo(CLCommandQueue cLCommandQueue, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetCommandQueueInfo(cLCommandQueue, n2, byteBuffer, null);
        }
    };
    static final CLContext.CLContextUtil CL_CONTEXT_UTIL = new CLContextUtil();
    static final InfoUtil<CLDevice> CL_DEVICE_UTIL = new CLDeviceUtil();
    static final CLEvent.CLEventUtil CL_EVENT_UTIL = new CLEventUtil();
    static final CLKernel.CLKernelUtil CL_KERNEL_UTIL = new CLKernelUtil();
    static final CLMem.CLMemUtil CL_MEM_UTIL = new CLMemUtil();
    static final CLPlatform.CLPlatformUtil CL_PLATFORM_UTIL = new CLPlatformUtil();
    static final CLProgram.CLProgramUtil CL_PROGRAM_UTIL = new CLProgramUtil();
    static final InfoUtil<CLSampler> CL_SAMPLER_UTIL = new InfoUtilAbstract<CLSampler>(){

        @Override
        protected int getInfo(CLSampler cLSampler, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetSamplerInfo(cLSampler, n2, byteBuffer, pointerBuffer);
        }
    };

    private InfoUtilFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLProgramUtil
    extends InfoUtilAbstract<CLProgram>
    implements CLProgram.CLProgramUtil {
        private CLProgramUtil() {
        }

        @Override
        protected int getInfo(CLProgram cLProgram, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetProgramInfo(cLProgram, n2, byteBuffer, pointerBuffer);
        }

        @Override
        protected int getInfoSizeArraySize(CLProgram cLProgram, int n2) {
            switch (n2) {
                case 4453: {
                    return this.getInfoInt(cLProgram, 4450);
                }
            }
            throw new IllegalArgumentException("Unsupported parameter: " + LWJGLUtil.toHexString(n2));
        }

        @Override
        public CLKernel[] createKernelsInProgram(CLProgram cLProgram) {
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10.clCreateKernelsInProgram(cLProgram, null, intBuffer);
            int n2 = intBuffer.get(0);
            if (n2 == 0) {
                return null;
            }
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n2);
            CL10.clCreateKernelsInProgram(cLProgram, pointerBuffer, null);
            CLKernel[] cLKernelArray = new CLKernel[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                cLKernelArray[i2] = cLProgram.getCLKernel(pointerBuffer.get(i2));
            }
            return cLKernelArray;
        }

        @Override
        public CLDevice[] getInfoDevices(CLProgram cLProgram) {
            cLProgram.checkValid();
            int n2 = this.getInfoInt(cLProgram, 4450);
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n2);
            CL10.clGetProgramInfo(cLProgram, 4451, pointerBuffer.getBuffer(), null);
            CLPlatform cLPlatform = (CLPlatform)((CLContext)cLProgram.getParent()).getParent();
            CLDevice[] cLDeviceArray = new CLDevice[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                cLDeviceArray[i2] = cLPlatform.getCLDevice(pointerBuffer.get(i2));
            }
            return cLDeviceArray;
        }

        @Override
        public ByteBuffer getInfoBinaries(CLProgram cLProgram, ByteBuffer byteBuffer) {
            cLProgram.checkValid();
            PointerBuffer pointerBuffer = this.getSizesBuffer(cLProgram, 4453);
            int n2 = 0;
            for (int i2 = 0; i2 < pointerBuffer.limit(); ++i2) {
                n2 = (int)((long)n2 + pointerBuffer.get(i2));
            }
            if (byteBuffer == null) {
                byteBuffer = BufferUtils.createByteBuffer(n2);
            } else if (LWJGLUtil.DEBUG) {
                BufferChecks.checkBuffer(byteBuffer, n2);
            }
            CL10.clGetProgramInfo(cLProgram, pointerBuffer, byteBuffer, null);
            return byteBuffer;
        }

        @Override
        public ByteBuffer[] getInfoBinaries(CLProgram cLProgram, ByteBuffer[] byteBufferArray) {
            cLProgram.checkValid();
            if (byteBufferArray == null) {
                PointerBuffer pointerBuffer = this.getSizesBuffer(cLProgram, 4453);
                byteBufferArray = new ByteBuffer[pointerBuffer.remaining()];
                for (int i2 = 0; i2 < pointerBuffer.remaining(); ++i2) {
                    byteBufferArray[i2] = BufferUtils.createByteBuffer((int)pointerBuffer.get(i2));
                }
            } else if (LWJGLUtil.DEBUG) {
                PointerBuffer pointerBuffer = this.getSizesBuffer(cLProgram, 4453);
                if (byteBufferArray.length < pointerBuffer.remaining()) {
                    throw new IllegalArgumentException("The target array is not big enough: " + pointerBuffer.remaining() + " buffers are required.");
                }
                for (int i3 = 0; i3 < byteBufferArray.length; ++i3) {
                    BufferChecks.checkBuffer(byteBufferArray[i3], (int)pointerBuffer.get(i3));
                }
            }
            CL10.clGetProgramInfo(cLProgram, byteBufferArray, null);
            return byteBufferArray;
        }

        @Override
        public String getBuildInfoString(CLProgram cLProgram, CLDevice cLDevice, int n2) {
            cLProgram.checkValid();
            int n3 = CLProgramUtil.getBuildSizeRet(cLProgram, cLDevice, n2);
            if (n3 <= 1) {
                return null;
            }
            ByteBuffer byteBuffer = APIUtil.getBufferByte(n3);
            CL10.clGetProgramBuildInfo(cLProgram, cLDevice, n2, byteBuffer, null);
            byteBuffer.limit(n3 - 1);
            return APIUtil.getString(byteBuffer);
        }

        @Override
        public int getBuildInfoInt(CLProgram cLProgram, CLDevice cLDevice, int n2) {
            cLProgram.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
            CL10.clGetProgramBuildInfo(cLProgram, cLDevice, n2, byteBuffer, null);
            return byteBuffer.getInt(0);
        }

        private static int getBuildSizeRet(CLProgram cLProgram, CLDevice cLDevice, int n2) {
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
            int n3 = CL10.clGetProgramBuildInfo(cLProgram, cLDevice, n2, null, pointerBuffer);
            if (n3 != 0) {
                throw new IllegalArgumentException("Invalid parameter specified: " + LWJGLUtil.toHexString(n2));
            }
            return (int)pointerBuffer.get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLPlatformUtil
    extends InfoUtilAbstract<CLPlatform>
    implements CLPlatform.CLPlatformUtil {
        private CLPlatformUtil() {
        }

        @Override
        protected int getInfo(CLPlatform cLPlatform, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetPlatformInfo(cLPlatform, n2, byteBuffer, pointerBuffer);
        }

        @Override
        public List<CLPlatform> getPlatforms(Filter<CLPlatform> filter) {
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10.clGetPlatformIDs(null, intBuffer);
            int n2 = intBuffer.get(0);
            if (n2 == 0) {
                return null;
            }
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n2);
            CL10.clGetPlatformIDs(pointerBuffer, null);
            ArrayList<CLPlatform> arrayList = new ArrayList<CLPlatform>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                CLPlatform cLPlatform = CLPlatform.getCLPlatform(pointerBuffer.get(i2));
                if (filter != null && !filter.accept(cLPlatform)) continue;
                arrayList.add(cLPlatform);
            }
            return arrayList.size() == 0 ? null : arrayList;
        }

        @Override
        public List<CLDevice> getDevices(CLPlatform cLPlatform, int n2, Filter<CLDevice> filter) {
            cLPlatform.checkValid();
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10.clGetDeviceIDs(cLPlatform, n2, null, intBuffer);
            int n3 = intBuffer.get(0);
            if (n3 == 0) {
                return null;
            }
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n3);
            CL10.clGetDeviceIDs(cLPlatform, n2, pointerBuffer, null);
            ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                CLDevice cLDevice = cLPlatform.getCLDevice(pointerBuffer.get(i2));
                if (filter != null && !filter.accept(cLDevice)) continue;
                arrayList.add(cLDevice);
            }
            return arrayList.size() == 0 ? null : arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLMemUtil
    extends InfoUtilAbstract<CLMem>
    implements CLMem.CLMemUtil {
        private CLMemUtil() {
        }

        @Override
        protected int getInfo(CLMem cLMem, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetMemObjectInfo(cLMem, n2, byteBuffer, pointerBuffer);
        }

        @Override
        public CLMem createImage2D(CLContext cLContext, long l2, CLImageFormat cLImageFormat, long l3, long l4, long l5, Buffer buffer, IntBuffer intBuffer) {
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            byteBuffer.putInt(0, cLImageFormat.getChannelOrder());
            byteBuffer.putInt(4, cLImageFormat.getChannelType());
            long l6 = CLCapabilities.clCreateImage2D;
            BufferChecks.checkFunctionAddress(l6);
            if (intBuffer != null) {
                BufferChecks.checkBuffer(intBuffer, 1);
            } else if (LWJGLUtil.DEBUG) {
                intBuffer = APIUtil.getBufferInt();
            }
            CLMem cLMem = new CLMem(CL10.nclCreateImage2D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer, 0), l3, l4, l5, MemoryUtil.getAddress0Safe(buffer) + (long)(buffer != null ? BufferChecks.checkBuffer(buffer, CLChecks.calculateImage2DSize(byteBuffer, l3, l4, l5)) : 0), MemoryUtil.getAddressSafe(intBuffer), l6), cLContext);
            if (LWJGLUtil.DEBUG) {
                Util.checkCLError(intBuffer.get(0));
            }
            return cLMem;
        }

        @Override
        public CLMem createImage3D(CLContext cLContext, long l2, CLImageFormat cLImageFormat, long l3, long l4, long l5, long l6, long l7, Buffer buffer, IntBuffer intBuffer) {
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            byteBuffer.putInt(0, cLImageFormat.getChannelOrder());
            byteBuffer.putInt(4, cLImageFormat.getChannelType());
            long l8 = CLCapabilities.clCreateImage3D;
            BufferChecks.checkFunctionAddress(l8);
            if (intBuffer != null) {
                BufferChecks.checkBuffer(intBuffer, 1);
            } else if (LWJGLUtil.DEBUG) {
                intBuffer = APIUtil.getBufferInt();
            }
            CLMem cLMem = new CLMem(CL10.nclCreateImage3D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer, 0), l3, l4, l5, l6, l7, MemoryUtil.getAddress0Safe(buffer) + (long)(buffer != null ? BufferChecks.checkBuffer(buffer, CLChecks.calculateImage3DSize(byteBuffer, l3, l4, l5, l6, l7)) : 0), MemoryUtil.getAddressSafe(intBuffer), l8), cLContext);
            if (LWJGLUtil.DEBUG) {
                Util.checkCLError(intBuffer.get(0));
            }
            return cLMem;
        }

        @Override
        public CLMem createSubBuffer(CLMem cLMem, long l2, int n2, CLBufferRegion cLBufferRegion, IntBuffer intBuffer) {
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(2);
            pointerBuffer.put(cLBufferRegion.getOrigin());
            pointerBuffer.put(cLBufferRegion.getSize());
            return CL11.clCreateSubBuffer(cLMem, l2, n2, pointerBuffer.getBuffer(), intBuffer);
        }

        @Override
        public ByteBuffer getInfoHostBuffer(CLMem cLMem) {
            long l2;
            cLMem.checkValid();
            if (LWJGLUtil.DEBUG && ((l2 = this.getInfoLong(cLMem, 4353)) & 8L) != 8L) {
                throw new IllegalArgumentException("The specified CLMem object does not use host memory.");
            }
            l2 = this.getInfoSize(cLMem, 4354);
            if (l2 == 0L) {
                return null;
            }
            long l3 = this.getInfoSize(cLMem, 4355);
            return CL.getHostBuffer(l3, (int)l2);
        }

        @Override
        public long getImageInfoSize(CLMem cLMem, int n2) {
            cLMem.checkValid();
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
            CL10.clGetImageInfo(cLMem, n2, pointerBuffer.getBuffer(), null);
            return pointerBuffer.get(0);
        }

        @Override
        public CLImageFormat getImageInfoFormat(CLMem cLMem) {
            cLMem.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            CL10.clGetImageInfo(cLMem, 4368, byteBuffer, null);
            return new CLImageFormat(byteBuffer.getInt(0), byteBuffer.getInt(4));
        }

        @Override
        public int getImageInfoFormat(CLMem cLMem, int n2) {
            cLMem.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            CL10.clGetImageInfo(cLMem, 4368, byteBuffer, null);
            return byteBuffer.getInt(n2 << 2);
        }

        @Override
        public int getGLObjectType(CLMem cLMem) {
            cLMem.checkValid();
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10GL.clGetGLObjectInfo(cLMem, intBuffer, null);
            return intBuffer.get(0);
        }

        @Override
        public int getGLObjectName(CLMem cLMem) {
            cLMem.checkValid();
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10GL.clGetGLObjectInfo(cLMem, null, intBuffer);
            return intBuffer.get(0);
        }

        @Override
        public int getGLTextureInfoInt(CLMem cLMem, int n2) {
            cLMem.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
            CL10GL.clGetGLTextureInfo(cLMem, n2, byteBuffer, null);
            return byteBuffer.getInt(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLKernelUtil
    extends InfoUtilAbstract<CLKernel>
    implements CLKernel.CLKernelUtil {
        private CLKernelUtil() {
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, byte by2) {
            CL10.clSetKernelArg(cLKernel, n2, 1L, APIUtil.getBufferByte(1).put(0, by2));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, short s2) {
            CL10.clSetKernelArg(cLKernel, n2, 2L, APIUtil.getBufferShort().put(0, s2));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, int n3) {
            CL10.clSetKernelArg(cLKernel, n2, 4L, APIUtil.getBufferInt().put(0, n3));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, long l2) {
            CL10.clSetKernelArg(cLKernel, n2, 8L, APIUtil.getBufferLong().put(0, l2));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, float f2) {
            CL10.clSetKernelArg(cLKernel, n2, 4L, APIUtil.getBufferFloat().put(0, f2));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, double d2) {
            CL10.clSetKernelArg(cLKernel, n2, 8L, APIUtil.getBufferDouble().put(0, d2));
        }

        @Override
        public void setArg(CLKernel cLKernel, int n2, CLObject cLObject) {
            CL10.clSetKernelArg(cLKernel, n2, cLObject);
        }

        @Override
        public void setArgSize(CLKernel cLKernel, int n2, long l2) {
            CL10.clSetKernelArg(cLKernel, n2, l2);
        }

        @Override
        protected int getInfo(CLKernel cLKernel, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetKernelInfo(cLKernel, n2, byteBuffer, pointerBuffer);
        }

        @Override
        public long getWorkGroupInfoSize(CLKernel cLKernel, CLDevice cLDevice, int n2) {
            cLDevice.checkValid();
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
            CL10.clGetKernelWorkGroupInfo(cLKernel, cLDevice, n2, pointerBuffer.getBuffer(), null);
            return pointerBuffer.get(0);
        }

        @Override
        public long[] getWorkGroupInfoSizeArray(CLKernel cLKernel, CLDevice cLDevice, int n2) {
            int n3;
            cLDevice.checkValid();
            switch (n2) {
                case 4529: {
                    n3 = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter: " + LWJGLUtil.toHexString(n2));
                }
            }
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n3);
            CL10.clGetKernelWorkGroupInfo(cLKernel, cLDevice, n2, pointerBuffer.getBuffer(), null);
            long[] lArray = new long[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                lArray[i2] = pointerBuffer.get(i2);
            }
            return lArray;
        }

        @Override
        public long getWorkGroupInfoLong(CLKernel cLKernel, CLDevice cLDevice, int n2) {
            cLDevice.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            CL10.clGetKernelWorkGroupInfo(cLKernel, cLDevice, n2, byteBuffer, null);
            return byteBuffer.getLong(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLEventUtil
    extends InfoUtilAbstract<CLEvent>
    implements CLEvent.CLEventUtil {
        private CLEventUtil() {
        }

        @Override
        protected int getInfo(CLEvent cLEvent, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetEventInfo(cLEvent, n2, byteBuffer, pointerBuffer);
        }

        @Override
        public long getProfilingInfoLong(CLEvent cLEvent, int n2) {
            cLEvent.checkValid();
            ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
            CL10.clGetEventProfilingInfo(cLEvent, n2, byteBuffer, null);
            return byteBuffer.getLong(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLDeviceUtil
    extends InfoUtilAbstract<CLDevice> {
        private CLDeviceUtil() {
        }

        @Override
        protected int getInfo(CLDevice cLDevice, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetDeviceInfo(cLDevice, n2, byteBuffer, pointerBuffer);
        }

        @Override
        protected int getInfoSizeArraySize(CLDevice cLDevice, int n2) {
            switch (n2) {
                case 4101: {
                    return this.getInfoInt(cLDevice, 4099);
                }
            }
            throw new IllegalArgumentException("Unsupported parameter: " + LWJGLUtil.toHexString(n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CLContextUtil
    extends InfoUtilAbstract<CLContext>
    implements CLContext.CLContextUtil {
        private CLContextUtil() {
        }

        @Override
        protected int getInfo(CLContext cLContext, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
            return CL10.clGetContextInfo(cLContext, n2, byteBuffer, pointerBuffer);
        }

        @Override
        public List<CLDevice> getInfoDevices(CLContext cLContext) {
            PointerBuffer pointerBuffer;
            int n2;
            cLContext.checkValid();
            if (CLCapabilities.getPlatformCapabilities((CLPlatform)((CLPlatform)cLContext.getParent())).OpenCL11) {
                n2 = this.getInfoInt(cLContext, 4227);
            } else {
                pointerBuffer = APIUtil.getBufferPointer();
                CL10.clGetContextInfo(cLContext, 4225, null, pointerBuffer);
                n2 = (int)(pointerBuffer.get(0) / (long)PointerBuffer.getPointerSize());
            }
            pointerBuffer = APIUtil.getBufferPointer(n2);
            CL10.clGetContextInfo(cLContext, 4225, pointerBuffer.getBuffer(), null);
            ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(((CLPlatform)cLContext.getParent()).getCLDevice(pointerBuffer.get(i2)));
            }
            return arrayList.size() == 0 ? null : arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CLContext create(CLPlatform cLPlatform, List<CLDevice> list, CLContextCallback cLContextCallback, Drawable drawable, IntBuffer intBuffer) {
            int n2 = 2 + (drawable == null ? 0 : 4) + 1;
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n2 + list.size());
            pointerBuffer.put(4228L).put(cLPlatform);
            if (drawable != null) {
                drawable.setCLSharingProperties(pointerBuffer);
            }
            pointerBuffer.put(0L);
            pointerBuffer.position(n2);
            for (CLDevice cLDevice : list) {
                pointerBuffer.put(cLDevice);
            }
            long l2 = CLCapabilities.clCreateContext;
            BufferChecks.checkFunctionAddress(l2);
            if (intBuffer != null) {
                BufferChecks.checkBuffer(intBuffer, 1);
            } else if (LWJGLUtil.DEBUG) {
                intBuffer = APIUtil.getBufferInt();
            }
            long l3 = cLContextCallback == null || cLContextCallback.isCustom() ? 0L : CallbackUtil.createGlobalRef(cLContextCallback);
            CLContext cLContext = null;
            try {
                cLContext = new CLContext(CL10.nclCreateContext(MemoryUtil.getAddress0(pointerBuffer.getBuffer()), list.size(), MemoryUtil.getAddress(pointerBuffer, n2), cLContextCallback == null ? 0L : cLContextCallback.getPointer(), l3, MemoryUtil.getAddressSafe(intBuffer), l2), cLPlatform);
                if (LWJGLUtil.DEBUG) {
                    Util.checkCLError(intBuffer.get(0));
                }
                CLContext cLContext2 = cLContext;
                return cLContext2;
            }
            finally {
                if (cLContext != null) {
                    cLContext.setContextCallback(l3);
                }
            }
        }

        @Override
        public CLContext createFromType(CLPlatform cLPlatform, long l2, CLContextCallback cLContextCallback, Drawable drawable, IntBuffer intBuffer) {
            int n2 = 2 + (drawable == null ? 0 : 4) + 1;
            PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n2);
            pointerBuffer.put(4228L).put(cLPlatform);
            if (drawable != null) {
                drawable.setCLSharingProperties(pointerBuffer);
            }
            pointerBuffer.put(0L);
            pointerBuffer.flip();
            return CL10.clCreateContextFromType(pointerBuffer, l2, cLContextCallback, intBuffer);
        }

        @Override
        public List<CLImageFormat> getSupportedImageFormats(CLContext cLContext, long l2, int n2, Filter<CLImageFormat> filter) {
            IntBuffer intBuffer = APIUtil.getBufferInt();
            CL10.clGetSupportedImageFormats(cLContext, l2, n2, null, intBuffer);
            int n3 = intBuffer.get(0);
            if (n3 == 0) {
                return null;
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n3 * 8);
            CL10.clGetSupportedImageFormats(cLContext, l2, n2, byteBuffer, null);
            ArrayList<CLImageFormat> arrayList = new ArrayList<CLImageFormat>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = n3 * 8;
                CLImageFormat cLImageFormat = new CLImageFormat(byteBuffer.getInt(n4), byteBuffer.getInt(n4 + 4));
                if (filter != null && !filter.accept(cLImageFormat)) continue;
                arrayList.add(cLImageFormat);
            }
            return arrayList.size() == 0 ? null : arrayList;
        }
    }
}

