/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.InfoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InfoUtilAbstract<T extends CLObject>
implements InfoUtil<T> {
    protected InfoUtilAbstract() {
    }

    protected abstract int getInfo(T var1, int var2, ByteBuffer var3, PointerBuffer var4);

    protected int getInfoSizeArraySize(T t2, int n2) {
        throw new UnsupportedOperationException();
    }

    protected PointerBuffer getSizesBuffer(T t2, int n2) {
        int n3 = this.getInfoSizeArraySize(t2, n2);
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n3);
        pointerBuffer.limit(n3);
        this.getInfo(t2, n2, pointerBuffer.getBuffer(), null);
        return pointerBuffer;
    }

    @Override
    public int getInfoInt(T t2, int n2) {
        ((PointerWrapperAbstract)t2).checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
        this.getInfo(t2, n2, byteBuffer, null);
        return byteBuffer.getInt(0);
    }

    @Override
    public long getInfoSize(T t2, int n2) {
        ((PointerWrapperAbstract)t2).checkValid();
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        this.getInfo(t2, n2, pointerBuffer.getBuffer(), null);
        return pointerBuffer.get(0);
    }

    @Override
    public long[] getInfoSizeArray(T t2, int n2) {
        ((PointerWrapperAbstract)t2).checkValid();
        int n3 = this.getInfoSizeArraySize(t2, n2);
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n3);
        this.getInfo(t2, n2, pointerBuffer.getBuffer(), null);
        long[] lArray = new long[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray[i2] = pointerBuffer.get(i2);
        }
        return lArray;
    }

    @Override
    public long getInfoLong(T t2, int n2) {
        ((PointerWrapperAbstract)t2).checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        this.getInfo(t2, n2, byteBuffer, null);
        return byteBuffer.getLong(0);
    }

    @Override
    public String getInfoString(T t2, int n2) {
        ((PointerWrapperAbstract)t2).checkValid();
        int n3 = this.getSizeRet(t2, n2);
        if (n3 <= 1) {
            return null;
        }
        ByteBuffer byteBuffer = APIUtil.getBufferByte(n3);
        this.getInfo(t2, n2, byteBuffer, null);
        byteBuffer.limit(n3 - 1);
        return APIUtil.getString(byteBuffer);
    }

    protected final int getSizeRet(T t2, int n2) {
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        int n3 = this.getInfo(t2, n2, null, pointerBuffer);
        if (n3 != 0) {
            throw new IllegalArgumentException("Invalid parameter specified: " + LWJGLUtil.toHexString(n2));
        }
        return (int)pointerBuffer.get(0);
    }
}

