/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLObjectChild;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.InfoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLProgram
extends CLObjectChild<CLContext> {
    private static final CLProgramUtil util = (CLProgramUtil)CLPlatform.getInfoUtilInstance(CLProgram.class, "CL_PROGRAM_UTIL");
    private final CLObjectRegistry<CLKernel> clKernels;

    CLProgram(long l2, CLContext cLContext) {
        super(l2, cLContext);
        if (this.isValid()) {
            cLContext.getCLProgramRegistry().registerObject(this);
            this.clKernels = new CLObjectRegistry();
        } else {
            this.clKernels = null;
        }
    }

    public CLKernel getCLKernel(long l2) {
        return this.clKernels.getObject(l2);
    }

    public CLKernel[] createKernelsInProgram() {
        return util.createKernelsInProgram(this);
    }

    public String getInfoString(int n2) {
        return util.getInfoString(this, n2);
    }

    public int getInfoInt(int n2) {
        return util.getInfoInt(this, n2);
    }

    public long[] getInfoSizeArray(int n2) {
        return util.getInfoSizeArray(this, n2);
    }

    public CLDevice[] getInfoDevices() {
        return util.getInfoDevices(this);
    }

    public ByteBuffer getInfoBinaries(ByteBuffer byteBuffer) {
        return util.getInfoBinaries(this, byteBuffer);
    }

    public ByteBuffer[] getInfoBinaries(ByteBuffer[] byteBufferArray) {
        return util.getInfoBinaries(this, byteBufferArray);
    }

    public String getBuildInfoString(CLDevice cLDevice, int n2) {
        return util.getBuildInfoString(this, cLDevice, n2);
    }

    public int getBuildInfoInt(CLDevice cLDevice, int n2) {
        return util.getBuildInfoInt(this, cLDevice, n2);
    }

    CLObjectRegistry<CLKernel> getCLKernelRegistry() {
        return this.clKernels;
    }

    void registerCLKernels(PointerBuffer pointerBuffer) {
        for (int i2 = pointerBuffer.position(); i2 < pointerBuffer.limit(); ++i2) {
            long l2 = pointerBuffer.get(i2);
            if (l2 == 0L) continue;
            new CLKernel(l2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int release() {
        try {
            int n2 = super.release();
            return n2;
        }
        finally {
            if (!this.isValid()) {
                ((CLContext)this.getParent()).getCLProgramRegistry().unregisterObject(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface CLProgramUtil
    extends InfoUtil<CLProgram> {
        public CLKernel[] createKernelsInProgram(CLProgram var1);

        public CLDevice[] getInfoDevices(CLProgram var1);

        public ByteBuffer getInfoBinaries(CLProgram var1, ByteBuffer var2);

        public ByteBuffer[] getInfoBinaries(CLProgram var1, ByteBuffer[] var2);

        public String getBuildInfoString(CLProgram var1, CLDevice var2, int var3);

        public int getBuildInfoInt(CLProgram var1, CLDevice var2, int var3);
    }
}

