/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.StringTokenizer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLPlatform;

public class CLPlatformCapabilities {
    public final int majorVersion;
    public final int minorVersion;
    public final boolean OpenCL11;
    public final boolean OpenCL12;
    final boolean CL_APPLE_ContextLoggingFunctions;
    public final boolean CL_APPLE_SetMemObjectDestructor;
    public final boolean CL_APPLE_gl_sharing;
    public final boolean CL_KHR_d3d10_sharing;
    public final boolean CL_KHR_gl_event;
    public final boolean CL_KHR_gl_sharing;
    public final boolean CL_KHR_icd;

    public CLPlatformCapabilities(CLPlatform cLPlatform) {
        Object object;
        String string = cLPlatform.getInfoString(2308);
        String string2 = cLPlatform.getInfoString(2305);
        if (!string2.startsWith("OpenCL ")) {
            throw new RuntimeException("Invalid OpenCL version string: " + string2);
        }
        try {
            object = new StringTokenizer(string2.substring(7), ". ");
            this.majorVersion = Integer.parseInt(((StringTokenizer)object).nextToken());
            this.minorVersion = Integer.parseInt(((StringTokenizer)object).nextToken());
            this.OpenCL11 = 1 < this.majorVersion || 1 == this.majorVersion && 1 <= this.minorVersion;
            this.OpenCL12 = 1 < this.majorVersion || 1 == this.majorVersion && 2 <= this.minorVersion;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("The major and/or minor OpenCL version \"" + string2 + "\" is malformed: " + runtimeException.getMessage());
        }
        object = APIUtil.getExtensions(string);
        this.CL_APPLE_ContextLoggingFunctions = object.contains("cl_APPLE_ContextLoggingFunctions") && CLCapabilities.CL_APPLE_ContextLoggingFunctions;
        this.CL_APPLE_SetMemObjectDestructor = object.contains("cl_APPLE_SetMemObjectDestructor") && CLCapabilities.CL_APPLE_SetMemObjectDestructor;
        this.CL_APPLE_gl_sharing = object.contains("cl_APPLE_gl_sharing") && CLCapabilities.CL_APPLE_gl_sharing;
        this.CL_KHR_d3d10_sharing = object.contains("cl_khr_d3d10_sharing");
        this.CL_KHR_gl_event = object.contains("cl_khr_gl_event") && CLCapabilities.CL_KHR_gl_event;
        this.CL_KHR_gl_sharing = object.contains("cl_khr_gl_sharing") && CLCapabilities.CL_KHR_gl_sharing;
        this.CL_KHR_icd = object.contains("cl_khr_icd") && CLCapabilities.CL_KHR_icd;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenCL ").append(this.majorVersion).append('.').append(this.minorVersion);
        stringBuilder.append(" - Extensions: ");
        if (this.CL_APPLE_ContextLoggingFunctions) {
            stringBuilder.append("cl_apple_contextloggingfunctions ");
        }
        if (this.CL_APPLE_SetMemObjectDestructor) {
            stringBuilder.append("cl_apple_setmemobjectdestructor ");
        }
        if (this.CL_APPLE_gl_sharing) {
            stringBuilder.append("cl_apple_gl_sharing ");
        }
        if (this.CL_KHR_d3d10_sharing) {
            stringBuilder.append("cl_khr_d3d10_sharing ");
        }
        if (this.CL_KHR_gl_event) {
            stringBuilder.append("cl_khr_gl_event ");
        }
        if (this.CL_KHR_gl_sharing) {
            stringBuilder.append("cl_khr_gl_sharing ");
        }
        if (this.CL_KHR_icd) {
            stringBuilder.append("cl_khr_icd ");
        }
        return stringBuilder.toString();
    }
}

