/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.FastLongMap;
import org.lwjgl.opencl.InfoUtil;
import org.lwjgl.opencl.api.Filter;

public final class CLPlatform
extends CLObject {
    private static final CLPlatformUtil util = (CLPlatformUtil)CLPlatform.getInfoUtilInstance(CLPlatform.class, "CL_PLATFORM_UTIL");
    private static final FastLongMap<CLPlatform> clPlatforms = new FastLongMap();
    private final CLObjectRegistry<CLDevice> clDevices;
    private Object caps;

    CLPlatform(long l2) {
        super(l2);
        if (this.isValid()) {
            clPlatforms.put(l2, this);
            this.clDevices = new CLObjectRegistry();
        } else {
            this.clDevices = null;
        }
    }

    public static CLPlatform getCLPlatform(long l2) {
        return clPlatforms.get(l2);
    }

    public CLDevice getCLDevice(long l2) {
        return this.clDevices.getObject(l2);
    }

    static <T extends CLObject> InfoUtil<T> getInfoUtilInstance(Class<T> clazz, String string) {
        InfoUtil infoUtil = null;
        try {
            Class<?> clazz2 = Class.forName("org.lwjgl.opencl.InfoUtilFactory");
            infoUtil = (InfoUtil)clazz2.getDeclaredField(string).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return infoUtil;
    }

    public static List<CLPlatform> getPlatforms() {
        return CLPlatform.getPlatforms(null);
    }

    public static List<CLPlatform> getPlatforms(Filter<CLPlatform> filter) {
        return util.getPlatforms(filter);
    }

    public String getInfoString(int n2) {
        return util.getInfoString(this, n2);
    }

    public List<CLDevice> getDevices(int n2) {
        return this.getDevices(n2, null);
    }

    public List<CLDevice> getDevices(int n2, Filter<CLDevice> filter) {
        return util.getDevices(this, n2, filter);
    }

    void setCapabilities(Object object) {
        this.caps = object;
    }

    Object getCapabilities() {
        return this.caps;
    }

    static void registerCLPlatforms(PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (pointerBuffer == null) {
            return;
        }
        int n2 = pointerBuffer.position();
        int n3 = Math.min(intBuffer.get(0), pointerBuffer.remaining());
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = pointerBuffer.get(n2 + i2);
            if (clPlatforms.containsKey(l2)) continue;
            new CLPlatform(l2);
        }
    }

    CLObjectRegistry<CLDevice> getCLDeviceRegistry() {
        return this.clDevices;
    }

    void registerCLDevices(PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        int n2 = pointerBuffer.position();
        int n3 = Math.min(intBuffer.get(intBuffer.position()), pointerBuffer.remaining());
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = pointerBuffer.get(n2 + i2);
            if (this.clDevices.hasObject(l2)) continue;
            new CLDevice(l2, this);
        }
    }

    void registerCLDevices(ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        int n2 = byteBuffer.position();
        int n3 = Math.min((int)pointerBuffer.get(pointerBuffer.position()), byteBuffer.remaining()) / PointerBuffer.getPointerSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2;
            int n4 = n2 + i2 * PointerBuffer.getPointerSize();
            long l3 = l2 = PointerBuffer.is64Bit() ? byteBuffer.getLong(n4) : (long)byteBuffer.getInt(n4);
            if (this.clDevices.hasObject(l2)) continue;
            new CLDevice(l2, this);
        }
    }

    static interface CLPlatformUtil
    extends InfoUtil<CLPlatform> {
        public List<CLPlatform> getPlatforms(Filter<CLPlatform> var1);

        public List<CLDevice> getDevices(CLPlatform var1, int var2, Filter<CLDevice> var3);
    }
}

