/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CLObjectChild;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.InfoUtil;

public final class CLDevice
extends CLObjectChild<CLDevice> {
    private static final InfoUtil<CLDevice> util = CLPlatform.getInfoUtilInstance(CLDevice.class, "CL_DEVICE_UTIL");
    private final CLPlatform platform;
    private final CLObjectRegistry<CLDevice> subCLDevices;
    private Object caps;

    CLDevice(long l2, CLPlatform cLPlatform) {
        this(l2, null, cLPlatform);
    }

    CLDevice(long l2, CLDevice cLDevice) {
        this(l2, cLDevice, cLDevice.getPlatform());
    }

    CLDevice(long l2, CLDevice cLDevice, CLPlatform cLPlatform) {
        super(l2, cLDevice);
        if (this.isValid()) {
            this.platform = cLPlatform;
            cLPlatform.getCLDeviceRegistry().registerObject(this);
            this.subCLDevices = new CLObjectRegistry();
            if (cLDevice != null) {
                cLDevice.subCLDevices.registerObject(this);
            }
        } else {
            this.platform = null;
            this.subCLDevices = null;
        }
    }

    public CLPlatform getPlatform() {
        return this.platform;
    }

    public CLDevice getSubCLDevice(long l2) {
        return this.subCLDevices.getObject(l2);
    }

    public String getInfoString(int n2) {
        return util.getInfoString(this, n2);
    }

    public int getInfoInt(int n2) {
        return util.getInfoInt(this, n2);
    }

    public boolean getInfoBoolean(int n2) {
        return util.getInfoInt(this, n2) != 0;
    }

    public long getInfoSize(int n2) {
        return util.getInfoSize(this, n2);
    }

    public long[] getInfoSizeArray(int n2) {
        return util.getInfoSizeArray(this, n2);
    }

    public long getInfoLong(int n2) {
        return util.getInfoLong(this, n2);
    }

    void setCapabilities(Object object) {
        this.caps = object;
    }

    Object getCapabilities() {
        return this.caps;
    }

    @Override
    int retain() {
        if (this.getParent() == null) {
            return this.getReferenceCount();
        }
        return super.retain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int release() {
        if (this.getParent() == null) {
            return this.getReferenceCount();
        }
        try {
            int n2 = super.release();
            return n2;
        }
        finally {
            if (!this.isValid()) {
                ((CLDevice)this.getParent()).subCLDevices.unregisterObject(this);
            }
        }
    }

    CLObjectRegistry<CLDevice> getSubCLDeviceRegistry() {
        return this.subCLDevices;
    }

    void registerSubCLDevices(PointerBuffer pointerBuffer) {
        for (int i2 = pointerBuffer.position(); i2 < pointerBuffer.limit(); ++i2) {
            long l2 = pointerBuffer.get(i2);
            if (l2 == 0L) continue;
            new CLDevice(l2, this);
        }
    }
}

