/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObjectChild;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.CallbackUtil;
import org.lwjgl.opencl.InfoUtil;
import org.lwjgl.opencl.api.CLImageFormat;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.Drawable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLContext
extends CLObjectChild<CLPlatform> {
    private static final CLContextUtil util = (CLContextUtil)CLPlatform.getInfoUtilInstance(CLContext.class, "CL_CONTEXT_UTIL");
    private final CLObjectRegistry<CLCommandQueue> clCommandQueues;
    private final CLObjectRegistry<CLMem> clMems;
    private final CLObjectRegistry<CLSampler> clSamplers;
    private final CLObjectRegistry<CLProgram> clPrograms;
    private final CLObjectRegistry<CLEvent> clEvents;
    private long contextCallback;
    private long printfCallback;

    CLContext(long l2, CLPlatform cLPlatform) {
        super(l2, cLPlatform);
        if (this.isValid()) {
            this.clCommandQueues = new CLObjectRegistry();
            this.clMems = new CLObjectRegistry();
            this.clSamplers = new CLObjectRegistry();
            this.clPrograms = new CLObjectRegistry();
            this.clEvents = new CLObjectRegistry();
        } else {
            this.clCommandQueues = null;
            this.clMems = null;
            this.clSamplers = null;
            this.clPrograms = null;
            this.clEvents = null;
        }
    }

    public CLCommandQueue getCLCommandQueue(long l2) {
        return this.clCommandQueues.getObject(l2);
    }

    public CLMem getCLMem(long l2) {
        return this.clMems.getObject(l2);
    }

    public CLSampler getCLSampler(long l2) {
        return this.clSamplers.getObject(l2);
    }

    public CLProgram getCLProgram(long l2) {
        return this.clPrograms.getObject(l2);
    }

    public CLEvent getCLEvent(long l2) {
        return this.clEvents.getObject(l2);
    }

    public static CLContext create(CLPlatform cLPlatform, List<CLDevice> list, IntBuffer intBuffer) {
        return CLContext.create(cLPlatform, list, null, null, intBuffer);
    }

    public static CLContext create(CLPlatform cLPlatform, List<CLDevice> list, CLContextCallback cLContextCallback, IntBuffer intBuffer) {
        return CLContext.create(cLPlatform, list, cLContextCallback, null, intBuffer);
    }

    public static CLContext create(CLPlatform cLPlatform, List<CLDevice> list, CLContextCallback cLContextCallback, Drawable drawable, IntBuffer intBuffer) {
        return util.create(cLPlatform, list, cLContextCallback, drawable, intBuffer);
    }

    public static CLContext createFromType(CLPlatform cLPlatform, long l2, IntBuffer intBuffer) {
        return util.createFromType(cLPlatform, l2, null, null, intBuffer);
    }

    public static CLContext createFromType(CLPlatform cLPlatform, long l2, CLContextCallback cLContextCallback, IntBuffer intBuffer) {
        return util.createFromType(cLPlatform, l2, cLContextCallback, null, intBuffer);
    }

    public static CLContext createFromType(CLPlatform cLPlatform, long l2, CLContextCallback cLContextCallback, Drawable drawable, IntBuffer intBuffer) {
        return util.createFromType(cLPlatform, l2, cLContextCallback, drawable, intBuffer);
    }

    public int getInfoInt(int n2) {
        return util.getInfoInt(this, n2);
    }

    public List<CLDevice> getInfoDevices() {
        return util.getInfoDevices(this);
    }

    public List<CLImageFormat> getSupportedImageFormats(long l2, int n2) {
        return this.getSupportedImageFormats(l2, n2, null);
    }

    public List<CLImageFormat> getSupportedImageFormats(long l2, int n2, Filter<CLImageFormat> filter) {
        return util.getSupportedImageFormats(this, l2, n2, filter);
    }

    CLObjectRegistry<CLCommandQueue> getCLCommandQueueRegistry() {
        return this.clCommandQueues;
    }

    CLObjectRegistry<CLMem> getCLMemRegistry() {
        return this.clMems;
    }

    CLObjectRegistry<CLSampler> getCLSamplerRegistry() {
        return this.clSamplers;
    }

    CLObjectRegistry<CLProgram> getCLProgramRegistry() {
        return this.clPrograms;
    }

    CLObjectRegistry<CLEvent> getCLEventRegistry() {
        return this.clEvents;
    }

    private boolean checkCallback(long l2, int n2) {
        if (n2 == 0 && (l2 == 0L || this.isValid())) {
            return true;
        }
        if (l2 != 0L) {
            CallbackUtil.deleteGlobalRef(l2);
        }
        return false;
    }

    void setContextCallback(long l2) {
        if (this.checkCallback(l2, 0)) {
            this.contextCallback = l2;
        }
    }

    void setPrintfCallback(long l2, int n2) {
        if (this.checkCallback(l2, n2)) {
            this.printfCallback = l2;
        }
    }

    void releaseImpl() {
        if (this.release() > 0) {
            return;
        }
        if (this.contextCallback != 0L) {
            CallbackUtil.deleteGlobalRef(this.contextCallback);
        }
        if (this.printfCallback != 0L) {
            CallbackUtil.deleteGlobalRef(this.printfCallback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface CLContextUtil
    extends InfoUtil<CLContext> {
        public List<CLDevice> getInfoDevices(CLContext var1);

        public CLContext create(CLPlatform var1, List<CLDevice> var2, CLContextCallback var3, Drawable var4, IntBuffer var5);

        public CLContext createFromType(CLPlatform var1, long var2, CLContextCallback var4, Drawable var5, IntBuffer var6);

        public List<CLImageFormat> getSupportedImageFormats(CLContext var1, long var2, int var4, Filter<CLImageFormat> var5);
    }
}

