/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLCompileProgramCallback;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLFunctionAddress;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLLinkProgramCallback;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLPrintfCallback;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CallbackUtil;

public final class CL12 {
    public static final int CL_COMPILE_PROGRAM_FAILURE = -15;
    public static final int CL_LINKER_NOT_AVAILABLE = -16;
    public static final int CL_LINK_PROGRAM_FAILURE = -17;
    public static final int CL_DEVICE_PARTITION_FAILED = -18;
    public static final int CL_KERNEL_ARG_INFO_NOT_AVAILABLE = -19;
    public static final int CL_INVALID_IMAGE_DESCRIPTOR = -65;
    public static final int CL_INVALID_COMPILER_OPTIONS = -66;
    public static final int CL_INVALID_LINKER_OPTIONS = -67;
    public static final int CL_INVALID_DEVICE_PARTITION_COUNT = -68;
    public static final int CL_VERSION_1_2 = 1;
    public static final int CL_BLOCKING = 1;
    public static final int CL_NON_BLOCKING = 0;
    public static final int CL_DEVICE_TYPE_CUSTOM = 16;
    public static final int CL_DEVICE_DOUBLE_FP_CONFIG = 4146;
    public static final int CL_DEVICE_LINKER_AVAILABLE = 4158;
    public static final int CL_DEVICE_BUILT_IN_KERNELS = 4159;
    public static final int CL_DEVICE_IMAGE_MAX_BUFFER_SIZE = 4160;
    public static final int CL_DEVICE_IMAGE_MAX_ARRAY_SIZE = 4161;
    public static final int CL_DEVICE_PARENT_DEVICE = 4162;
    public static final int CL_DEVICE_PARTITION_MAX_SUB_DEVICES = 4163;
    public static final int CL_DEVICE_PARTITION_PROPERTIES = 4164;
    public static final int CL_DEVICE_PARTITION_AFFINITY_DOMAIN = 4165;
    public static final int CL_DEVICE_PARTITION_TYPE = 4166;
    public static final int CL_DEVICE_REFERENCE_COUNT = 4167;
    public static final int CL_DEVICE_PREFERRED_INTEROP_USER_SYNC = 4168;
    public static final int CL_DEVICE_PRINTF_BUFFER_SIZE = 4169;
    public static final int CL_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT = 128;
    public static final int CL_CONTEXT_INTEROP_USER_SYNC = 4229;
    public static final int CL_DEVICE_PARTITION_EQUALLY = 4230;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS = 4231;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS_LIST_END = 0;
    public static final int CL_DEVICE_PARTITION_BY_AFFINITY_DOMAIN = 4232;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NUMA = 1;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L4_CACHE = 2;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L3_CACHE = 4;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L2_CACHE = 8;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L1_CACHE = 16;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NEXT_PARTITIONABLE = 32;
    public static final int CL_MEM_HOST_WRITE_ONLY = 128;
    public static final int CL_MEM_HOST_READ_ONLY = 256;
    public static final int CL_MEM_HOST_NO_ACCESS = 512;
    public static final int CL_MIGRATE_MEM_OBJECT_HOST = 1;
    public static final int CL_MIGRATE_MEM_OBJECT_CONTENT_UNDEFINED = 2;
    public static final int CL_MEM_OBJECT_IMAGE2D_ARRAY = 4339;
    public static final int CL_MEM_OBJECT_IMAGE1D = 4340;
    public static final int CL_MEM_OBJECT_IMAGE1D_ARRAY = 4341;
    public static final int CL_MEM_OBJECT_IMAGE1D_BUFFER = 4342;
    public static final int CL_IMAGE_ARRAY_SIZE = 4375;
    public static final int CL_IMAGE_BUFFER = 4376;
    public static final int CL_IMAGE_NUM_MIP_LEVELS = 4377;
    public static final int CL_IMAGE_NUM_SAMPLES = 4378;
    public static final int CL_MAP_WRITE_INVALIDATE_REGION = 4;
    public static final int CL_PROGRAM_NUM_KERNELS = 4455;
    public static final int CL_PROGRAM_KERNEL_NAMES = 4456;
    public static final int CL_PROGRAM_BINARY_TYPE = 4484;
    public static final int CL_PROGRAM_BINARY_TYPE_NONE = 0;
    public static final int CL_PROGRAM_BINARY_TYPE_COMPILED_OBJECT = 1;
    public static final int CL_PROGRAM_BINARY_TYPE_LIBRARY = 2;
    public static final int CL_PROGRAM_BINARY_TYPE_EXECUTABLE = 4;
    public static final int CL_KERNEL_ATTRIBUTES = 4501;
    public static final int CL_KERNEL_ARG_ADDRESS_QUALIFIER = 4502;
    public static final int CL_KERNEL_ARG_ACCESS_QUALIFIER = 4503;
    public static final int CL_KERNEL_ARG_TYPE_NAME = 4504;
    public static final int CL_KERNEL_ARG_TYPE_QUALIFIER = 4505;
    public static final int CL_KERNEL_ARG_NAME = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_GLOBAL = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_LOCAL = 4507;
    public static final int CL_KERNEL_ARG_ADDRESS_CONSTANT = 4508;
    public static final int CL_KERNEL_ARG_ADDRESS_PRIVATE = 4509;
    public static final int CL_KERNEL_ARG_ACCESS_READ_ONLY = 4512;
    public static final int CL_KERNEL_ARG_ACCESS_WRITE_ONLY = 4513;
    public static final int CL_KERNEL_ARG_ACCESS_READ_WRITE = 4514;
    public static final int CL_KERNEL_ARG_ACCESS_NONE = 4515;
    public static final int CL_KERNEL_ARG_TYPE_NONE = 0;
    public static final int CL_KERNEL_ARG_TYPE_CONST = 1;
    public static final int CL_KERNEL_ARG_TYPE_RESTRICT = 2;
    public static final int CL_KERNEL_ARG_TYPE_VOLATILE = 4;
    public static final int CL_KERNEL_GLOBAL_WORK_SIZE = 4533;
    public static final int CL_COMMAND_BARRIER = 4613;
    public static final int CL_COMMAND_MIGRATE_MEM_OBJECTS = 4614;
    public static final int CL_COMMAND_FILL_BUFFER = 4615;
    public static final int CL_COMMAND_FILL_IMAGE = 4616;

    private CL12() {
    }

    public static int clRetainDevice(CLDevice cLDevice) {
        long l2 = CLCapabilities.clRetainDevice;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL12.nclRetainDevice(cLDevice.getPointer(), l2);
        if (n2 == 0) {
            cLDevice.retain();
        }
        return n2;
    }

    static native int nclRetainDevice(long var0, long var2);

    public static int clReleaseDevice(CLDevice cLDevice) {
        long l2 = CLCapabilities.clReleaseDevice;
        BufferChecks.checkFunctionAddress(l2);
        APIUtil.releaseObjects(cLDevice);
        int n2 = CL12.nclReleaseDevice(cLDevice.getPointer(), l2);
        if (n2 == 0) {
            cLDevice.release();
        }
        return n2;
    }

    static native int nclReleaseDevice(long var0, long var2);

    public static int clCreateSubDevices(CLDevice cLDevice, LongBuffer longBuffer, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        int n2;
        long l2 = CLCapabilities.clCreateSubDevices;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        BufferChecks.checkNullTerminated(longBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if ((n2 = CL12.nclCreateSubDevices(cLDevice.getPointer(), MemoryUtil.getAddress(longBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer), l2)) == 0 && pointerBuffer != null) {
            cLDevice.registerSubCLDevices(pointerBuffer);
        }
        return n2;
    }

    static native int nclCreateSubDevices(long var0, long var2, int var4, long var5, long var7, long var9);

    public static CLMem clCreateImage(CLContext cLContext, long l2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(byteBuffer, 8);
        BufferChecks.checkBuffer(byteBuffer2, 7 * PointerBuffer.getPointerSize() + 8 + PointerBuffer.getPointerSize());
        if (byteBuffer3 != null) {
            BufferChecks.checkDirect(byteBuffer3);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL12.nclCreateImage(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2), MemoryUtil.getAddressSafe(byteBuffer3), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage(CLContext cLContext, long l2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(byteBuffer, 8);
        BufferChecks.checkBuffer(byteBuffer2, 7 * PointerBuffer.getPointerSize() + 8 + PointerBuffer.getPointerSize());
        if (floatBuffer != null) {
            BufferChecks.checkDirect(floatBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL12.nclCreateImage(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2), MemoryUtil.getAddressSafe(floatBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage(CLContext cLContext, long l2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l3 = CLCapabilities.clCreateImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(byteBuffer, 8);
        BufferChecks.checkBuffer(byteBuffer2, 7 * PointerBuffer.getPointerSize() + 8 + PointerBuffer.getPointerSize());
        if (intBuffer != null) {
            BufferChecks.checkDirect(intBuffer);
        }
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLMem cLMem = new CLMem(CL12.nclCreateImage(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage(CLContext cLContext, long l2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ShortBuffer shortBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(byteBuffer, 8);
        BufferChecks.checkBuffer(byteBuffer2, 7 * PointerBuffer.getPointerSize() + 8 + PointerBuffer.getPointerSize());
        if (shortBuffer != null) {
            BufferChecks.checkDirect(shortBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL12.nclCreateImage(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2), MemoryUtil.getAddressSafe(shortBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateImage(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static CLProgram clCreateProgramWithBuiltInKernels(CLContext cLContext, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithBuiltInKernels;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        BufferChecks.checkDirect(byteBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL12.nclCreateProgramWithBuiltInKernels(cLContext.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithBuiltInKernels(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLProgram clCreateProgramWithBuiltInKernels(CLContext cLContext, PointerBuffer pointerBuffer, CharSequence charSequence, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithBuiltInKernels;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL12.nclCreateProgramWithBuiltInKernels(cLContext.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), APIUtil.getBuffer(charSequence), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clCompileProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2, ByteBuffer byteBuffer2, CLCompileProgramCallback cLCompileProgramCallback) {
        long l2 = CLCapabilities.clCompileProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        BufferChecks.checkBuffer(pointerBuffer2, 1);
        BufferChecks.checkDirect(byteBuffer2);
        BufferChecks.checkNullTerminated(byteBuffer2);
        long l3 = CallbackUtil.createGlobalRef(cLCompileProgramCallback);
        if (cLCompileProgramCallback != null) {
            cLCompileProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclCompileProgram(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddress(byteBuffer), 1, MemoryUtil.getAddress(pointerBuffer2), MemoryUtil.getAddress(byteBuffer2), cLCompileProgramCallback == null ? 0L : cLCompileProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    static native int nclCompileProgram(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12, long var14, long var16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clCompileProgramMulti(CLProgram cLProgram, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2, ByteBuffer byteBuffer2, CLCompileProgramCallback cLCompileProgramCallback) {
        long l2 = CLCapabilities.clCompileProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        BufferChecks.checkBuffer(pointerBuffer2, 1);
        BufferChecks.checkDirect(byteBuffer2);
        BufferChecks.checkNullTerminated(byteBuffer2, pointerBuffer2.remaining());
        long l3 = CallbackUtil.createGlobalRef(cLCompileProgramCallback);
        if (cLCompileProgramCallback != null) {
            cLCompileProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclCompileProgramMulti(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddress(byteBuffer), pointerBuffer2.remaining(), MemoryUtil.getAddress(pointerBuffer2), MemoryUtil.getAddress(byteBuffer2), cLCompileProgramCallback == null ? 0L : cLCompileProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    static native int nclCompileProgramMulti(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12, long var14, long var16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clCompileProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2, ByteBuffer[] byteBufferArray, CLCompileProgramCallback cLCompileProgramCallback) {
        long l2 = CLCapabilities.clCompileProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        BufferChecks.checkBuffer(pointerBuffer2, byteBufferArray.length);
        BufferChecks.checkArray(byteBufferArray, 1);
        long l3 = CallbackUtil.createGlobalRef(cLCompileProgramCallback);
        if (cLCompileProgramCallback != null) {
            cLCompileProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclCompileProgram3(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddress(byteBuffer), byteBufferArray.length, MemoryUtil.getAddress(pointerBuffer2), byteBufferArray, cLCompileProgramCallback == null ? 0L : cLCompileProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    static native int nclCompileProgram3(long var0, int var2, long var3, long var5, int var7, long var8, ByteBuffer[] var10, long var11, long var13, long var15);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clCompileProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, CharSequence charSequence, PointerBuffer pointerBuffer2, CharSequence charSequence2, CLCompileProgramCallback cLCompileProgramCallback) {
        long l2 = CLCapabilities.clCompileProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkBuffer(pointerBuffer2, 1);
        long l3 = CallbackUtil.createGlobalRef(cLCompileProgramCallback);
        if (cLCompileProgramCallback != null) {
            cLCompileProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclCompileProgram(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), APIUtil.getBufferNT(charSequence), 1, MemoryUtil.getAddress(pointerBuffer2), APIUtil.getBufferNT(charSequence2), cLCompileProgramCallback == null ? 0L : cLCompileProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clCompileProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, CharSequence charSequence, PointerBuffer pointerBuffer2, CharSequence[] charSequenceArray, CLCompileProgramCallback cLCompileProgramCallback) {
        long l2 = CLCapabilities.clCompileProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkBuffer(pointerBuffer2, 1);
        BufferChecks.checkArray(charSequenceArray);
        long l3 = CallbackUtil.createGlobalRef(cLCompileProgramCallback);
        if (cLCompileProgramCallback != null) {
            cLCompileProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclCompileProgramMulti(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), APIUtil.getBufferNT(charSequence), pointerBuffer2.remaining(), MemoryUtil.getAddress(pointerBuffer2), APIUtil.getBufferNT(charSequenceArray), cLCompileProgramCallback == null ? 0L : cLCompileProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLProgram clLinkProgram(CLContext cLContext, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2, CLLinkProgramCallback cLLinkProgramCallback, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clLinkProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        BufferChecks.checkDirect(pointerBuffer2);
        BufferChecks.checkBuffer(intBuffer, 1);
        long l3 = CallbackUtil.createGlobalRef(cLLinkProgramCallback);
        if (cLLinkProgramCallback != null) {
            cLLinkProgramCallback.setContext(cLContext);
        }
        CLProgram cLProgram = null;
        try {
            CLProgram cLProgram2 = cLProgram = new CLProgram(CL12.nclLinkProgram(cLContext.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddress(byteBuffer), pointerBuffer2.remaining(), MemoryUtil.getAddress(pointerBuffer2), cLLinkProgramCallback == null ? 0L : cLLinkProgramCallback.getPointer(), l3, MemoryUtil.getAddress(intBuffer), l2), cLContext);
            return cLProgram2;
        }
        finally {
            CallbackUtil.checkCallback(intBuffer.get(intBuffer.position()), l3);
        }
    }

    static native long nclLinkProgram(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12, long var14, long var16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLProgram clLinkProgram(CLContext cLContext, PointerBuffer pointerBuffer, CharSequence charSequence, PointerBuffer pointerBuffer2, CLLinkProgramCallback cLLinkProgramCallback, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clLinkProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(pointerBuffer2);
        BufferChecks.checkBuffer(intBuffer, 1);
        long l3 = CallbackUtil.createGlobalRef(cLLinkProgramCallback);
        if (cLLinkProgramCallback != null) {
            cLLinkProgramCallback.setContext(cLContext);
        }
        CLProgram cLProgram = null;
        try {
            CLProgram cLProgram2 = cLProgram = new CLProgram(CL12.nclLinkProgram(cLContext.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), APIUtil.getBufferNT(charSequence), pointerBuffer2.remaining(), MemoryUtil.getAddress(pointerBuffer2), cLLinkProgramCallback == null ? 0L : cLLinkProgramCallback.getPointer(), l3, MemoryUtil.getAddress(intBuffer), l2), cLContext);
            return cLProgram2;
        }
        finally {
            CallbackUtil.checkCallback(intBuffer.get(intBuffer.position()), l3);
        }
    }

    public static int clUnloadPlatformCompiler(CLPlatform cLPlatform) {
        long l2 = CLCapabilities.clUnloadPlatformCompiler;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL12.nclUnloadPlatformCompiler(cLPlatform.getPointer(), l2);
        return n2;
    }

    static native int nclUnloadPlatformCompiler(long var0, long var2);

    public static int clGetKernelArgInfo(CLKernel cLKernel, int n2, int n3, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetKernelArgInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n4 = CL12.nclGetKernelArgInfo(cLKernel.getPointer(), n2, n3, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n4;
    }

    static native int nclGetKernelArgInfo(long var0, int var2, int var3, long var4, long var6, long var8, long var10);

    public static int clEnqueueFillBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, ByteBuffer byteBuffer, long l2, long l3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        long l4 = CLCapabilities.clEnqueueFillBuffer;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkDirect(byteBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        int n2 = CL12.nclEnqueueFillBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), l2, l3, pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l4);
        return n2;
    }

    static native int nclEnqueueFillBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int clEnqueueFillImage(CLCommandQueue cLCommandQueue, CLMem cLMem, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        long l2 = CLCapabilities.clEnqueueFillImage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, 16);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        int n2 = CL12.nclEnqueueFillImage(cLCommandQueue.getPointer(), cLMem.getPointer(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l2);
        return n2;
    }

    static native int nclEnqueueFillImage(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13, long var15);

    public static int clEnqueueMigrateMemObjects(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer, long l2, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        long l3 = CLCapabilities.clEnqueueMigrateMemObjects;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(pointerBuffer);
        if (pointerBuffer2 != null) {
            BufferChecks.checkDirect(pointerBuffer2);
        }
        if (pointerBuffer3 != null) {
            BufferChecks.checkBuffer(pointerBuffer3, 1);
        }
        int n2 = CL12.nclEnqueueMigrateMemObjects(cLCommandQueue.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), l2, pointerBuffer2 == null ? 0 : pointerBuffer2.remaining(), MemoryUtil.getAddressSafe(pointerBuffer2), MemoryUtil.getAddressSafe(pointerBuffer3), l3);
        return n2;
    }

    static native int nclEnqueueMigrateMemObjects(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12);

    public static int clEnqueueMarkerWithWaitList(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        long l2 = CLCapabilities.clEnqueueMarkerWithWaitList;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        int n2 = CL12.nclEnqueueMarkerWithWaitList(cLCommandQueue.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2);
        return n2;
    }

    static native int nclEnqueueMarkerWithWaitList(long var0, int var2, long var3, long var5, long var7);

    public static int clEnqueueBarrierWithWaitList(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        long l2 = CLCapabilities.clEnqueueBarrierWithWaitList;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        int n2 = CL12.nclEnqueueBarrierWithWaitList(cLCommandQueue.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2);
        return n2;
    }

    static native int nclEnqueueBarrierWithWaitList(long var0, int var2, long var3, long var5, long var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clSetPrintfCallback(CLContext cLContext, CLPrintfCallback cLPrintfCallback) {
        long l2 = CLCapabilities.clSetPrintfCallback;
        BufferChecks.checkFunctionAddress(l2);
        long l3 = CallbackUtil.createGlobalRef(cLPrintfCallback);
        int n2 = 0;
        try {
            int n3 = n2 = CL12.nclSetPrintfCallback(cLContext.getPointer(), cLPrintfCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            cLContext.setPrintfCallback(l3, n2);
        }
    }

    static native int nclSetPrintfCallback(long var0, long var2, long var4, long var6);

    static CLFunctionAddress clGetExtensionFunctionAddressForPlatform(CLPlatform cLPlatform, ByteBuffer byteBuffer) {
        long l2 = CLCapabilities.clGetExtensionFunctionAddressForPlatform;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        CLFunctionAddress cLFunctionAddress = new CLFunctionAddress(CL12.nclGetExtensionFunctionAddressForPlatform(cLPlatform.getPointer(), MemoryUtil.getAddress(byteBuffer), l2));
        return cLFunctionAddress;
    }

    static native long nclGetExtensionFunctionAddressForPlatform(long var0, long var2, long var4);

    static CLFunctionAddress clGetExtensionFunctionAddressForPlatform(CLPlatform cLPlatform, CharSequence charSequence) {
        long l2 = CLCapabilities.clGetExtensionFunctionAddressForPlatform;
        BufferChecks.checkFunctionAddress(l2);
        CLFunctionAddress cLFunctionAddress = new CLFunctionAddress(CL12.nclGetExtensionFunctionAddressForPlatform(cLPlatform.getPointer(), APIUtil.getBufferNT(charSequence), l2));
        return cLFunctionAddress;
    }
}

