/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLMem;

public final class CL10GL {
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;

    private CL10GL() {
    }

    public static CLMem clCreateFromGLBuffer(CLContext cLContext, long l2, int n2, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateFromGLBuffer;
        BufferChecks.checkFunctionAddress(l3);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10GL.nclCreateFromGLBuffer(cLContext.getPointer(), l2, n2, MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateFromGLBuffer(long var0, long var2, int var4, long var5, long var7);

    public static CLMem clCreateFromGLTexture2D(CLContext cLContext, long l2, int n2, int n3, int n4, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateFromGLTexture2D;
        BufferChecks.checkFunctionAddress(l3);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10GL.nclCreateFromGLTexture2D(cLContext.getPointer(), l2, n2, n3, n4, MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateFromGLTexture2D(long var0, long var2, int var4, int var5, int var6, long var7, long var9);

    public static CLMem clCreateFromGLTexture3D(CLContext cLContext, long l2, int n2, int n3, int n4, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateFromGLTexture3D;
        BufferChecks.checkFunctionAddress(l3);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10GL.nclCreateFromGLTexture3D(cLContext.getPointer(), l2, n2, n3, n4, MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateFromGLTexture3D(long var0, long var2, int var4, int var5, int var6, long var7, long var9);

    public static CLMem clCreateFromGLRenderbuffer(CLContext cLContext, long l2, int n2, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateFromGLRenderbuffer;
        BufferChecks.checkFunctionAddress(l3);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10GL.nclCreateFromGLRenderbuffer(cLContext.getPointer(), l2, n2, MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateFromGLRenderbuffer(long var0, long var2, int var4, long var5, long var7);

    public static int clGetGLObjectInfo(CLMem cLMem, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l2 = CLCapabilities.clGetGLObjectInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        int n2 = CL10GL.nclGetGLObjectInfo(cLMem.getPointer(), MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2);
        return n2;
    }

    static native int nclGetGLObjectInfo(long var0, long var2, long var4, long var6);

    public static int clGetGLTextureInfo(CLMem cLMem, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetGLTextureInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10GL.nclGetGLTextureInfo(cLMem.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetGLTextureInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clEnqueueAcquireGLObjects(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        int n2;
        long l2 = CLCapabilities.clEnqueueAcquireGLObjects;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        if (pointerBuffer2 != null) {
            BufferChecks.checkDirect(pointerBuffer2);
        }
        if (pointerBuffer3 != null) {
            BufferChecks.checkBuffer(pointerBuffer3, 1);
        }
        if ((n2 = CL10GL.nclEnqueueAcquireGLObjects(cLCommandQueue.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), pointerBuffer2 == null ? 0 : pointerBuffer2.remaining(), MemoryUtil.getAddressSafe(pointerBuffer2), MemoryUtil.getAddressSafe(pointerBuffer3), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer3);
        }
        return n2;
    }

    static native int nclEnqueueAcquireGLObjects(long var0, int var2, long var3, int var5, long var6, long var8, long var10);

    public static int clEnqueueAcquireGLObjects(CLCommandQueue cLCommandQueue, CLMem cLMem, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n2;
        long l2 = CLCapabilities.clEnqueueAcquireGLObjects;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n2 = CL10GL.nclEnqueueAcquireGLObjects(cLCommandQueue.getPointer(), 1, APIUtil.getPointer(cLMem), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n2;
    }

    public static int clEnqueueReleaseGLObjects(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        int n2;
        long l2 = CLCapabilities.clEnqueueReleaseGLObjects;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        if (pointerBuffer2 != null) {
            BufferChecks.checkDirect(pointerBuffer2);
        }
        if (pointerBuffer3 != null) {
            BufferChecks.checkBuffer(pointerBuffer3, 1);
        }
        if ((n2 = CL10GL.nclEnqueueReleaseGLObjects(cLCommandQueue.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), pointerBuffer2 == null ? 0 : pointerBuffer2.remaining(), MemoryUtil.getAddressSafe(pointerBuffer2), MemoryUtil.getAddressSafe(pointerBuffer3), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer3);
        }
        return n2;
    }

    static native int nclEnqueueReleaseGLObjects(long var0, int var2, long var3, int var5, long var6, long var8, long var10);

    public static int clEnqueueReleaseGLObjects(CLCommandQueue cLCommandQueue, CLMem cLMem, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n2;
        long l2 = CLCapabilities.clEnqueueReleaseGLObjects;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n2 = CL10GL.nclEnqueueReleaseGLObjects(cLCommandQueue.getPointer(), 1, APIUtil.getPointer(cLMem), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n2;
    }
}

