/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLBuildProgramCallback;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLChecks;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLFunctionAddress;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLNativeKernel;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.CallbackUtil;

public final class CL10 {
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_FALSE = 0;
    public static final int CL_TRUE = 1;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final int CL_DEVICE_TYPE_DEFAULT = 1;
    public static final int CL_DEVICE_TYPE_CPU = 2;
    public static final int CL_DEVICE_TYPE_GPU = 4;
    public static final int CL_DEVICE_TYPE_ACCELERATOR = 8;
    public static final int CL_DEVICE_TYPE_ALL = -1;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_ = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final int CL_FP_DENORM = 1;
    public static final int CL_FP_INF_NAN = 2;
    public static final int CL_FP_ROUND_TO_NEAREST = 4;
    public static final int CL_FP_ROUND_TO_ZERO = 8;
    public static final int CL_FP_ROUND_TO_INF = 16;
    public static final int CL_FP_FMA = 32;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final int CL_EXEC_KERNEL = 1;
    public static final int CL_EXEC_NATIVE_KERNEL = 2;
    public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1;
    public static final int CL_QUEUE_PROFILING_ENABLE = 2;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final int CL_MEM_READ_WRITE = 1;
    public static final int CL_MEM_WRITE_ONLY = 2;
    public static final int CL_MEM_READ_ONLY = 4;
    public static final int CL_MEM_USE_HOST_PTR = 8;
    public static final int CL_MEM_ALLOC_HOST_PTR = 16;
    public static final int CL_MEM_COPY_HOST_PTR = 32;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final int CL_MAP_READ = 1;
    public static final int CL_MAP_WRITE = 2;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;

    private CL10() {
    }

    public static int clGetPlatformIDs(PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        int n2;
        long l2 = CLCapabilities.clGetPlatformIDs;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if (intBuffer == null) {
            intBuffer = APIUtil.getBufferInt();
        }
        if ((n2 = CL10.nclGetPlatformIDs(pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer), l2)) == 0 && pointerBuffer != null) {
            CLPlatform.registerCLPlatforms(pointerBuffer, intBuffer);
        }
        return n2;
    }

    static native int nclGetPlatformIDs(int var0, long var1, long var3, long var5);

    public static int clGetPlatformInfo(CLPlatform cLPlatform, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetPlatformInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetPlatformInfo(cLPlatform == null ? 0L : cLPlatform.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetPlatformInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clGetDeviceIDs(CLPlatform cLPlatform, long l2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clGetDeviceIDs;
        BufferChecks.checkFunctionAddress(l3);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        } else {
            intBuffer = APIUtil.getBufferInt();
        }
        int n2 = CL10.nclGetDeviceIDs(cLPlatform.getPointer(), l2, pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer), l3);
        if (n2 == 0 && pointerBuffer != null) {
            cLPlatform.registerCLDevices(pointerBuffer, intBuffer);
        }
        return n2;
    }

    static native int nclGetDeviceIDs(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int clGetDeviceInfo(CLDevice cLDevice, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetDeviceInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetDeviceInfo(cLDevice.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetDeviceInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLContext clCreateContext(PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, CLContextCallback cLContextCallback, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateContext;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkNullTerminated(pointerBuffer);
        BufferChecks.checkBuffer(pointerBuffer2, 1);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        long l3 = cLContextCallback == null || cLContextCallback.isCustom() ? 0L : CallbackUtil.createGlobalRef(cLContextCallback);
        CLContext cLContext = null;
        try {
            CLContext cLContext2 = cLContext = new CLContext(CL10.nclCreateContext(MemoryUtil.getAddress(pointerBuffer), pointerBuffer2.remaining(), MemoryUtil.getAddress(pointerBuffer2), cLContextCallback == null ? 0L : cLContextCallback.getPointer(), l3, MemoryUtil.getAddressSafe(intBuffer), l2), APIUtil.getCLPlatform(pointerBuffer));
            return cLContext2;
        }
        finally {
            if (cLContext != null) {
                cLContext.setContextCallback(l3);
            }
        }
    }

    static native long nclCreateContext(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLContext clCreateContext(PointerBuffer pointerBuffer, CLDevice cLDevice, CLContextCallback cLContextCallback, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateContext;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkNullTerminated(pointerBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        long l3 = cLContextCallback == null || cLContextCallback.isCustom() ? 0L : CallbackUtil.createGlobalRef(cLContextCallback);
        CLContext cLContext = null;
        try {
            CLContext cLContext2 = cLContext = new CLContext(CL10.nclCreateContext(MemoryUtil.getAddress(pointerBuffer), 1, APIUtil.getPointer(cLDevice), cLContextCallback == null ? 0L : cLContextCallback.getPointer(), l3, MemoryUtil.getAddressSafe(intBuffer), l2), APIUtil.getCLPlatform(pointerBuffer));
            return cLContext2;
        }
        finally {
            if (cLContext != null) {
                cLContext.setContextCallback(l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLContext clCreateContextFromType(PointerBuffer pointerBuffer, long l2, CLContextCallback cLContextCallback, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateContextFromType;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkNullTerminated(pointerBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        long l4 = cLContextCallback == null || cLContextCallback.isCustom() ? 0L : CallbackUtil.createGlobalRef(cLContextCallback);
        CLContext cLContext = null;
        try {
            CLContext cLContext2 = cLContext = new CLContext(CL10.nclCreateContextFromType(MemoryUtil.getAddress(pointerBuffer), l2, cLContextCallback == null ? 0L : cLContextCallback.getPointer(), l4, MemoryUtil.getAddressSafe(intBuffer), l3), APIUtil.getCLPlatform(pointerBuffer));
            return cLContext2;
        }
        finally {
            if (cLContext != null) {
                cLContext.setContextCallback(l4);
            }
        }
    }

    static native long nclCreateContextFromType(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int clRetainContext(CLContext cLContext) {
        long l2 = CLCapabilities.clRetainContext;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainContext(cLContext.getPointer(), l2);
        if (n2 == 0) {
            cLContext.retain();
        }
        return n2;
    }

    static native int nclRetainContext(long var0, long var2);

    public static int clReleaseContext(CLContext cLContext) {
        long l2 = CLCapabilities.clReleaseContext;
        BufferChecks.checkFunctionAddress(l2);
        APIUtil.releaseObjects(cLContext);
        int n2 = CL10.nclReleaseContext(cLContext.getPointer(), l2);
        if (n2 == 0) {
            cLContext.releaseImpl();
        }
        return n2;
    }

    static native int nclReleaseContext(long var0, long var2);

    public static int clGetContextInfo(CLContext cLContext, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        int n3;
        long l2 = CLCapabilities.clGetContextInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        if (pointerBuffer == null && APIUtil.isDevicesParam(n2)) {
            pointerBuffer = APIUtil.getBufferPointer();
        }
        if ((n3 = CL10.nclGetContextInfo(cLContext.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2)) == 0 && byteBuffer != null && APIUtil.isDevicesParam(n2)) {
            ((CLPlatform)cLContext.getParent()).registerCLDevices(byteBuffer, pointerBuffer);
        }
        return n3;
    }

    static native int nclGetContextInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLCommandQueue clCreateCommandQueue(CLContext cLContext, CLDevice cLDevice, long l2, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateCommandQueue;
        BufferChecks.checkFunctionAddress(l3);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLCommandQueue cLCommandQueue = new CLCommandQueue(CL10.nclCreateCommandQueue(cLContext.getPointer(), cLDevice.getPointer(), l2, MemoryUtil.getAddressSafe(intBuffer), l3), cLContext, cLDevice);
        return cLCommandQueue;
    }

    static native long nclCreateCommandQueue(long var0, long var2, long var4, long var6, long var8);

    public static int clRetainCommandQueue(CLCommandQueue cLCommandQueue) {
        long l2 = CLCapabilities.clRetainCommandQueue;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainCommandQueue(cLCommandQueue.getPointer(), l2);
        if (n2 == 0) {
            cLCommandQueue.retain();
        }
        return n2;
    }

    static native int nclRetainCommandQueue(long var0, long var2);

    public static int clReleaseCommandQueue(CLCommandQueue cLCommandQueue) {
        long l2 = CLCapabilities.clReleaseCommandQueue;
        BufferChecks.checkFunctionAddress(l2);
        APIUtil.releaseObjects(cLCommandQueue);
        int n2 = CL10.nclReleaseCommandQueue(cLCommandQueue.getPointer(), l2);
        if (n2 == 0) {
            cLCommandQueue.release();
        }
        return n2;
    }

    static native int nclReleaseCommandQueue(long var0, long var2);

    public static int clGetCommandQueueInfo(CLCommandQueue cLCommandQueue, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetCommandQueueInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetCommandQueueInfo(cLCommandQueue.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetCommandQueueInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, long l3, IntBuffer intBuffer) {
        long l4 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l4);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, l3, 0L, MemoryUtil.getAddressSafe(intBuffer), l4), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, DoubleBuffer doubleBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, LongBuffer longBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(longBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    public static CLMem clCreateBuffer(CLContext cLContext, long l2, ShortBuffer shortBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clCreateBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateBuffer(cLContext.getPointer(), l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), MemoryUtil.getAddressSafe(intBuffer), l3), cLContext);
        return cLMem;
    }

    static native long nclCreateBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, DoubleBuffer doubleBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, FloatBuffer floatBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, IntBuffer intBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, LongBuffer longBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(longBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueReadBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, ShortBuffer shortBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueReadBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueReadBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    static native int nclEnqueueReadBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(byteBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, DoubleBuffer doubleBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(doubleBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, FloatBuffer floatBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(floatBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, IntBuffer intBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(intBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, LongBuffer longBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(longBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    public static int clEnqueueWriteBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, ShortBuffer shortBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n3;
        long l3 = CLCapabilities.clEnqueueWriteBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkDirect(shortBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n3;
    }

    static native int nclEnqueueWriteBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int clEnqueueCopyBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, CLMem cLMem2, long l2, long l3, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n2;
        long l5 = CLCapabilities.clEnqueueCopyBuffer;
        BufferChecks.checkFunctionAddress(l5);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n2 = CL10.nclEnqueueCopyBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), cLMem2.getPointer(), l2, l3, l4, pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l5)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n2;
    }

    static native int nclEnqueueCopyBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static ByteBuffer clEnqueueMapBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, long l3, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, IntBuffer intBuffer) {
        ByteBuffer byteBuffer;
        long l5 = CLCapabilities.clEnqueueMapBuffer;
        BufferChecks.checkFunctionAddress(l5);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if ((byteBuffer = CL10.nclEnqueueMapBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, l3, l4, pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), MemoryUtil.getAddressSafe(intBuffer), l4, l5)) != null) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nclEnqueueMapBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16, long var18, long var20);

    public static CLMem clCreateImage2D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, ByteBuffer byteBuffer2, IntBuffer intBuffer) {
        long l6 = CLCapabilities.clCreateImage2D;
        BufferChecks.checkFunctionAddress(l6);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (byteBuffer2 != null) {
            BufferChecks.checkBuffer(byteBuffer2, CLChecks.calculateImage2DSize(byteBuffer, l3, l4, l5));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage2D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, MemoryUtil.getAddressSafe(byteBuffer2), MemoryUtil.getAddressSafe(intBuffer), l6), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage2D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        long l6 = CLCapabilities.clCreateImage2D;
        BufferChecks.checkFunctionAddress(l6);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, CLChecks.calculateImage2DSize(byteBuffer, l3, l4, l5));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage2D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, MemoryUtil.getAddressSafe(floatBuffer), MemoryUtil.getAddressSafe(intBuffer), l6), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage2D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l6 = CLCapabilities.clCreateImage2D;
        BufferChecks.checkFunctionAddress(l6);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, CLChecks.calculateImage2DSize(byteBuffer, l3, l4, l5));
        }
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage2D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l6), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage2D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, ShortBuffer shortBuffer, IntBuffer intBuffer) {
        long l6 = CLCapabilities.clCreateImage2D;
        BufferChecks.checkFunctionAddress(l6);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, CLChecks.calculateImage2DSize(byteBuffer, l3, l4, l5));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage2D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, MemoryUtil.getAddressSafe(shortBuffer), MemoryUtil.getAddressSafe(intBuffer), l6), cLContext);
        return cLMem;
    }

    static native long nclCreateImage2D(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static CLMem clCreateImage3D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, long l6, long l7, ByteBuffer byteBuffer2, IntBuffer intBuffer) {
        long l8 = CLCapabilities.clCreateImage3D;
        BufferChecks.checkFunctionAddress(l8);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (byteBuffer2 != null) {
            BufferChecks.checkBuffer(byteBuffer2, CLChecks.calculateImage3DSize(byteBuffer, l3, l4, l4, l6, l7));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage3D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, l6, l7, MemoryUtil.getAddressSafe(byteBuffer2), MemoryUtil.getAddressSafe(intBuffer), l8), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage3D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, long l6, long l7, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        long l8 = CLCapabilities.clCreateImage3D;
        BufferChecks.checkFunctionAddress(l8);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (floatBuffer != null) {
            BufferChecks.checkBuffer(floatBuffer, CLChecks.calculateImage3DSize(byteBuffer, l3, l4, l4, l6, l7));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage3D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, l6, l7, MemoryUtil.getAddressSafe(floatBuffer), MemoryUtil.getAddressSafe(intBuffer), l8), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage3D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, long l6, long l7, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l8 = CLCapabilities.clCreateImage3D;
        BufferChecks.checkFunctionAddress(l8);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, CLChecks.calculateImage3DSize(byteBuffer, l3, l4, l4, l6, l7));
        }
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage3D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, l6, l7, MemoryUtil.getAddressSafe(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l8), cLContext);
        return cLMem;
    }

    public static CLMem clCreateImage3D(CLContext cLContext, long l2, ByteBuffer byteBuffer, long l3, long l4, long l5, long l6, long l7, ShortBuffer shortBuffer, IntBuffer intBuffer) {
        long l8 = CLCapabilities.clCreateImage3D;
        BufferChecks.checkFunctionAddress(l8);
        BufferChecks.checkBuffer(byteBuffer, 8);
        if (shortBuffer != null) {
            BufferChecks.checkBuffer(shortBuffer, CLChecks.calculateImage3DSize(byteBuffer, l3, l4, l4, l6, l7));
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage3D(cLContext.getPointer(), l2, MemoryUtil.getAddress(byteBuffer), l3, l4, l5, l6, l7, MemoryUtil.getAddressSafe(shortBuffer), MemoryUtil.getAddressSafe(intBuffer), l8), cLContext);
        return cLMem;
    }

    static native long nclCreateImage3D(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20);

    public static int clGetSupportedImageFormats(CLContext cLContext, long l2, int n2, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        long l3 = CLCapabilities.clGetSupportedImageFormats;
        BufferChecks.checkFunctionAddress(l3);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        int n3 = CL10.nclGetSupportedImageFormats(cLContext.getPointer(), l2, n2, (byteBuffer == null ? 0 : byteBuffer.remaining()) / 8, MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(intBuffer), l3);
        return n3;
    }

    static native int nclGetSupportedImageFormats(long var0, long var2, int var4, int var5, long var6, long var8, long var10);

    public static int clEnqueueReadImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, ByteBuffer byteBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueReadImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(byteBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueReadImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(byteBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueReadImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, FloatBuffer floatBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueReadImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(floatBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueReadImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(floatBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueReadImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, IntBuffer intBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueReadImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(intBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueReadImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(intBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueReadImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, ShortBuffer shortBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueReadImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(shortBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueReadImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(shortBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    static native int nclEnqueueReadImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20);

    public static int clEnqueueWriteImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, ByteBuffer byteBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueWriteImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(byteBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(byteBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueWriteImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, FloatBuffer floatBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueWriteImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(floatBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(floatBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueWriteImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, IntBuffer intBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueWriteImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(intBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(intBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    public static int clEnqueueWriteImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, long l3, ShortBuffer shortBuffer, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n3;
        long l4 = CLCapabilities.clEnqueueWriteImage;
        BufferChecks.checkFunctionAddress(l4);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(shortBuffer, CLChecks.calculateImageSize(pointerBuffer2, l2, l3));
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n3 = CL10.nclEnqueueWriteImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, l3, MemoryUtil.getAddress(shortBuffer), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l4)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n3;
    }

    static native int nclEnqueueWriteImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20);

    public static int clEnqueueCopyImage(CLCommandQueue cLCommandQueue, CLMem cLMem, CLMem cLMem2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        int n2;
        long l2 = CLCapabilities.clEnqueueCopyImage;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(pointerBuffer3, 3);
        if (pointerBuffer4 != null) {
            BufferChecks.checkDirect(pointerBuffer4);
        }
        if (pointerBuffer5 != null) {
            BufferChecks.checkBuffer(pointerBuffer5, 1);
        }
        if ((n2 = CL10.nclEnqueueCopyImage(cLCommandQueue.getPointer(), cLMem.getPointer(), cLMem2.getPointer(), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), MemoryUtil.getAddress(pointerBuffer3), pointerBuffer4 == null ? 0 : pointerBuffer4.remaining(), MemoryUtil.getAddressSafe(pointerBuffer4), MemoryUtil.getAddressSafe(pointerBuffer5), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer5);
        }
        return n2;
    }

    static native int nclEnqueueCopyImage(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int clEnqueueCopyImageToBuffer(CLCommandQueue cLCommandQueue, CLMem cLMem, CLMem cLMem2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n2;
        long l3 = CLCapabilities.clEnqueueCopyImageToBuffer;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n2 = CL10.nclEnqueueCopyImageToBuffer(cLCommandQueue.getPointer(), cLMem.getPointer(), cLMem2.getPointer(), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), l2, pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n2;
    }

    static native int nclEnqueueCopyImageToBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int clEnqueueCopyBufferToImage(CLCommandQueue cLCommandQueue, CLMem cLMem, CLMem cLMem2, long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        int n2;
        long l3 = CLCapabilities.clEnqueueCopyBufferToImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        if (pointerBuffer3 != null) {
            BufferChecks.checkDirect(pointerBuffer3);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if ((n2 = CL10.nclEnqueueCopyBufferToImage(cLCommandQueue.getPointer(), cLMem.getPointer(), cLMem2.getPointer(), l2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), pointerBuffer3 == null ? 0 : pointerBuffer3.remaining(), MemoryUtil.getAddressSafe(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), l3)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer4);
        }
        return n2;
    }

    static native int nclEnqueueCopyBufferToImage(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static ByteBuffer clEnqueueMapImage(CLCommandQueue cLCommandQueue, CLMem cLMem, int n2, long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5, PointerBuffer pointerBuffer6, IntBuffer intBuffer) {
        ByteBuffer byteBuffer;
        long l3 = CLCapabilities.clEnqueueMapImage;
        BufferChecks.checkFunctionAddress(l3);
        BufferChecks.checkBuffer(pointerBuffer, 3);
        BufferChecks.checkBuffer(pointerBuffer2, 3);
        BufferChecks.checkBuffer(pointerBuffer3, 1);
        if (pointerBuffer4 != null) {
            BufferChecks.checkBuffer(pointerBuffer4, 1);
        }
        if (pointerBuffer5 != null) {
            BufferChecks.checkDirect(pointerBuffer5);
        }
        if (pointerBuffer6 != null) {
            BufferChecks.checkBuffer(pointerBuffer6, 1);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if ((byteBuffer = CL10.nclEnqueueMapImage(cLCommandQueue.getPointer(), cLMem.getPointer(), n2, l2, MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), MemoryUtil.getAddress(pointerBuffer3), MemoryUtil.getAddressSafe(pointerBuffer4), pointerBuffer5 == null ? 0 : pointerBuffer5.remaining(), MemoryUtil.getAddressSafe(pointerBuffer5), MemoryUtil.getAddressSafe(pointerBuffer6), MemoryUtil.getAddressSafe(intBuffer), l3)) != null) {
            cLCommandQueue.registerCLEvent(pointerBuffer6);
        }
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nclEnqueueMapImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20, long var22);

    public static int clGetImageInfo(CLMem cLMem, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetImageInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetImageInfo(cLMem.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetImageInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clRetainMemObject(CLMem cLMem) {
        long l2 = CLCapabilities.clRetainMemObject;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainMemObject(cLMem.getPointer(), l2);
        if (n2 == 0) {
            cLMem.retain();
        }
        return n2;
    }

    static native int nclRetainMemObject(long var0, long var2);

    public static int clReleaseMemObject(CLMem cLMem) {
        long l2 = CLCapabilities.clReleaseMemObject;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclReleaseMemObject(cLMem.getPointer(), l2);
        if (n2 == 0) {
            cLMem.release();
        }
        return n2;
    }

    static native int nclReleaseMemObject(long var0, long var2);

    public static int clEnqueueUnmapMemObject(CLCommandQueue cLCommandQueue, CLMem cLMem, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n2;
        long l2 = CLCapabilities.clEnqueueUnmapMemObject;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n2 = CL10.nclEnqueueUnmapMemObject(cLCommandQueue.getPointer(), cLMem.getPointer(), MemoryUtil.getAddress(byteBuffer), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n2;
    }

    static native int nclEnqueueUnmapMemObject(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static int clGetMemObjectInfo(CLMem cLMem, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetMemObjectInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetMemObjectInfo(cLMem.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetMemObjectInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLSampler clCreateSampler(CLContext cLContext, int n2, int n3, int n4, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateSampler;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLSampler cLSampler = new CLSampler(CL10.nclCreateSampler(cLContext.getPointer(), n2, n3, n4, MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLSampler;
    }

    static native long nclCreateSampler(long var0, int var2, int var3, int var4, long var5, long var7);

    public static int clRetainSampler(CLSampler cLSampler) {
        long l2 = CLCapabilities.clRetainSampler;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainSampler(cLSampler.getPointer(), l2);
        if (n2 == 0) {
            cLSampler.retain();
        }
        return n2;
    }

    static native int nclRetainSampler(long var0, long var2);

    public static int clReleaseSampler(CLSampler cLSampler) {
        long l2 = CLCapabilities.clReleaseSampler;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclReleaseSampler(cLSampler.getPointer(), l2);
        if (n2 == 0) {
            cLSampler.release();
        }
        return n2;
    }

    static native int nclReleaseSampler(long var0, long var2);

    public static int clGetSamplerInfo(CLSampler cLSampler, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetSamplerInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetSamplerInfo(cLSampler.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetSamplerInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLProgram clCreateProgramWithSource(CLContext cLContext, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithSource(cLContext.getPointer(), 1, MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithSource(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLProgram clCreateProgramWithSource(CLContext cLContext, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(byteBuffer, APIUtil.getSize(pointerBuffer));
        BufferChecks.checkBuffer(pointerBuffer, 1);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithSource2(cLContext.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithSource2(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLProgram clCreateProgramWithSource(CLContext cLContext, ByteBuffer[] byteBufferArray, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(byteBufferArray, 1);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithSource3(cLContext.getPointer(), byteBufferArray.length, byteBufferArray, APIUtil.getLengths(byteBufferArray), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithSource3(long var0, int var2, ByteBuffer[] var3, long var4, long var6, long var8);

    public static CLProgram clCreateProgramWithSource(CLContext cLContext, CharSequence charSequence, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithSource;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithSource(cLContext.getPointer(), 1, APIUtil.getBuffer(charSequence), charSequence.length(), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    public static CLProgram clCreateProgramWithSource(CLContext cLContext, CharSequence[] charSequenceArray, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateProgramWithSource;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(charSequenceArray);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithSource4(cLContext.getPointer(), charSequenceArray.length, APIUtil.getBuffer(charSequenceArray), APIUtil.getLengths(charSequenceArray), MemoryUtil.getAddressSafe(intBuffer), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithSource4(long var0, int var2, long var3, long var5, long var7, long var9);

    public static CLProgram clCreateProgramWithBinary(CLContext cLContext, CLDevice cLDevice, ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l2 = CLCapabilities.clCreateProgramWithBinary;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkBuffer(intBuffer, 1);
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithBinary(cLContext.getPointer(), 1, cLDevice.getPointer(), byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithBinary(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13);

    public static CLProgram clCreateProgramWithBinary(CLContext cLContext, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l2 = CLCapabilities.clCreateProgramWithBinary;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        BufferChecks.checkBuffer(pointerBuffer2, pointerBuffer.remaining());
        BufferChecks.checkBuffer(byteBuffer, APIUtil.getSize(pointerBuffer2));
        BufferChecks.checkBuffer(intBuffer, pointerBuffer.remaining());
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithBinary2(cLContext.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(pointerBuffer2), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithBinary2(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13);

    public static CLProgram clCreateProgramWithBinary(CLContext cLContext, PointerBuffer pointerBuffer, ByteBuffer[] byteBufferArray, IntBuffer intBuffer, IntBuffer intBuffer2) {
        long l2 = CLCapabilities.clCreateProgramWithBinary;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, byteBufferArray.length);
        BufferChecks.checkArray(byteBufferArray, 1);
        BufferChecks.checkBuffer(intBuffer, byteBufferArray.length);
        if (intBuffer2 != null) {
            BufferChecks.checkBuffer(intBuffer2, 1);
        }
        CLProgram cLProgram = new CLProgram(CL10.nclCreateProgramWithBinary3(cLContext.getPointer(), byteBufferArray.length, MemoryUtil.getAddress(pointerBuffer), APIUtil.getLengths(byteBufferArray), byteBufferArray, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddressSafe(intBuffer2), l2), cLContext);
        return cLProgram;
    }

    static native long nclCreateProgramWithBinary3(long var0, int var2, long var3, long var5, ByteBuffer[] var7, long var8, long var10, long var12);

    public static int clRetainProgram(CLProgram cLProgram) {
        long l2 = CLCapabilities.clRetainProgram;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainProgram(cLProgram.getPointer(), l2);
        if (n2 == 0) {
            cLProgram.retain();
        }
        return n2;
    }

    static native int nclRetainProgram(long var0, long var2);

    public static int clReleaseProgram(CLProgram cLProgram) {
        long l2 = CLCapabilities.clReleaseProgram;
        BufferChecks.checkFunctionAddress(l2);
        APIUtil.releaseObjects(cLProgram);
        int n2 = CL10.nclReleaseProgram(cLProgram.getPointer(), l2);
        if (n2 == 0) {
            cLProgram.release();
        }
        return n2;
    }

    static native int nclReleaseProgram(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clBuildProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, CLBuildProgramCallback cLBuildProgramCallback) {
        long l2 = CLCapabilities.clBuildProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        long l3 = CallbackUtil.createGlobalRef(cLBuildProgramCallback);
        if (cLBuildProgramCallback != null) {
            cLBuildProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL10.nclBuildProgram(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddress(byteBuffer), cLBuildProgramCallback == null ? 0L : cLBuildProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    static native int nclBuildProgram(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clBuildProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, CharSequence charSequence, CLBuildProgramCallback cLBuildProgramCallback) {
        long l2 = CLCapabilities.clBuildProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        long l3 = CallbackUtil.createGlobalRef(cLBuildProgramCallback);
        if (cLBuildProgramCallback != null) {
            cLBuildProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL10.nclBuildProgram(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), APIUtil.getBufferNT(charSequence), cLBuildProgramCallback == null ? 0L : cLBuildProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clBuildProgram(CLProgram cLProgram, CLDevice cLDevice, CharSequence charSequence, CLBuildProgramCallback cLBuildProgramCallback) {
        long l2 = CLCapabilities.clBuildProgram;
        BufferChecks.checkFunctionAddress(l2);
        long l3 = CallbackUtil.createGlobalRef(cLBuildProgramCallback);
        if (cLBuildProgramCallback != null) {
            cLBuildProgramCallback.setContext((CLContext)cLProgram.getParent());
        }
        int n2 = 0;
        try {
            int n3 = n2 = CL10.nclBuildProgram(cLProgram.getPointer(), 1, APIUtil.getPointer(cLDevice), APIUtil.getBufferNT(charSequence), cLBuildProgramCallback == null ? 0L : cLBuildProgramCallback.getPointer(), l3, l2);
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    public static int clUnloadCompiler() {
        long l2 = CLCapabilities.clUnloadCompiler;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclUnloadCompiler(l2);
        return n2;
    }

    static native int nclUnloadCompiler(long var0);

    public static int clGetProgramInfo(CLProgram cLProgram, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetProgramInfo(cLProgram.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetProgramInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clGetProgramInfo(CLProgram cLProgram, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2) {
        long l2 = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        BufferChecks.checkBuffer(byteBuffer, APIUtil.getSize(pointerBuffer));
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        int n2 = CL10.nclGetProgramInfo2(cLProgram.getPointer(), 4454, pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2);
        return n2;
    }

    static native int nclGetProgramInfo2(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    public static int clGetProgramInfo(CLProgram cLProgram, ByteBuffer[] byteBufferArray, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkArray(byteBufferArray);
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n2 = CL10.nclGetProgramInfo3(cLProgram.getPointer(), 4454, byteBufferArray.length, byteBufferArray, MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n2;
    }

    static native int nclGetProgramInfo3(long var0, int var2, long var3, ByteBuffer[] var5, long var6, long var8);

    public static int clGetProgramBuildInfo(CLProgram cLProgram, CLDevice cLDevice, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetProgramBuildInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetProgramBuildInfo(cLProgram.getPointer(), cLDevice.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetProgramBuildInfo(long var0, long var2, int var4, long var5, long var7, long var9, long var11);

    public static CLKernel clCreateKernel(CLProgram cLProgram, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateKernel;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLKernel cLKernel = new CLKernel(CL10.nclCreateKernel(cLProgram.getPointer(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddressSafe(intBuffer), l2), cLProgram);
        return cLKernel;
    }

    static native long nclCreateKernel(long var0, long var2, long var4, long var6);

    public static CLKernel clCreateKernel(CLProgram cLProgram, CharSequence charSequence, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clCreateKernel;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        CLKernel cLKernel = new CLKernel(CL10.nclCreateKernel(cLProgram.getPointer(), APIUtil.getBufferNT(charSequence), MemoryUtil.getAddressSafe(intBuffer), l2), cLProgram);
        return cLKernel;
    }

    public static int clCreateKernelsInProgram(CLProgram cLProgram, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        int n2;
        long l2 = CLCapabilities.clCreateKernelsInProgram;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (intBuffer != null) {
            BufferChecks.checkBuffer(intBuffer, 1);
        }
        if ((n2 = CL10.nclCreateKernelsInProgram(cLProgram.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(intBuffer), l2)) == 0 && pointerBuffer != null) {
            cLProgram.registerCLKernels(pointerBuffer);
        }
        return n2;
    }

    static native int nclCreateKernelsInProgram(long var0, int var2, long var3, long var5, long var7);

    public static int clRetainKernel(CLKernel cLKernel) {
        long l2 = CLCapabilities.clRetainKernel;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainKernel(cLKernel.getPointer(), l2);
        if (n2 == 0) {
            cLKernel.retain();
        }
        return n2;
    }

    static native int nclRetainKernel(long var0, long var2);

    public static int clReleaseKernel(CLKernel cLKernel) {
        long l2 = CLCapabilities.clReleaseKernel;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclReleaseKernel(cLKernel.getPointer(), l2);
        if (n2 == 0) {
            cLKernel.release();
        }
        return n2;
    }

    static native int nclReleaseKernel(long var0, long var2);

    public static int clSetKernelArg(CLKernel cLKernel, int n2, long l2) {
        long l3 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l3);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, l2, 0L, l3);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, ByteBuffer byteBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, byteBuffer.remaining(), MemoryUtil.getAddress(byteBuffer), l2);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, DoubleBuffer doubleBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(doubleBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, doubleBuffer.remaining() << 3, MemoryUtil.getAddress(doubleBuffer), l2);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, FloatBuffer floatBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(floatBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, floatBuffer.remaining() << 2, MemoryUtil.getAddress(floatBuffer), l2);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, IntBuffer intBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(intBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, intBuffer.remaining() << 2, MemoryUtil.getAddress(intBuffer), l2);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, LongBuffer longBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(longBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, longBuffer.remaining() << 3, MemoryUtil.getAddress(longBuffer), l2);
        return n3;
    }

    public static int clSetKernelArg(CLKernel cLKernel, int n2, ShortBuffer shortBuffer) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(shortBuffer);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, shortBuffer.remaining() << 1, MemoryUtil.getAddress(shortBuffer), l2);
        return n3;
    }

    static native int nclSetKernelArg(long var0, int var2, long var3, long var5, long var7);

    public static int clSetKernelArg(CLKernel cLKernel, int n2, CLObject cLObject) {
        long l2 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, PointerBuffer.getPointerSize(), APIUtil.getPointerSafe(cLObject), l2);
        return n3;
    }

    static int clSetKernelArg(CLKernel cLKernel, int n2, long l2, Buffer buffer) {
        long l3 = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(l3);
        int n3 = CL10.nclSetKernelArg(cLKernel.getPointer(), n2, l2, MemoryUtil.getAddress0(buffer), l3);
        return n3;
    }

    public static int clGetKernelInfo(CLKernel cLKernel, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetKernelInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetKernelInfo(cLKernel.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetKernelInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clGetKernelWorkGroupInfo(CLKernel cLKernel, CLDevice cLDevice, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetKernelWorkGroupInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetKernelWorkGroupInfo(cLKernel.getPointer(), cLDevice == null ? 0L : cLDevice.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetKernelWorkGroupInfo(long var0, long var2, int var4, long var5, long var7, long var9, long var11);

    public static int clEnqueueNDRangeKernel(CLCommandQueue cLCommandQueue, CLKernel cLKernel, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        int n3;
        long l2 = CLCapabilities.clEnqueueNDRangeKernel;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, n2);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, n2);
        }
        if (pointerBuffer3 != null) {
            BufferChecks.checkBuffer(pointerBuffer3, n2);
        }
        if (pointerBuffer4 != null) {
            BufferChecks.checkDirect(pointerBuffer4);
        }
        if (pointerBuffer5 != null) {
            BufferChecks.checkBuffer(pointerBuffer5, 1);
        }
        if ((n3 = CL10.nclEnqueueNDRangeKernel(cLCommandQueue.getPointer(), cLKernel.getPointer(), n2, MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), MemoryUtil.getAddressSafe(pointerBuffer3), pointerBuffer4 == null ? 0 : pointerBuffer4.remaining(), MemoryUtil.getAddressSafe(pointerBuffer4), MemoryUtil.getAddressSafe(pointerBuffer5), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer5);
        }
        return n3;
    }

    static native int nclEnqueueNDRangeKernel(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int clEnqueueTask(CLCommandQueue cLCommandQueue, CLKernel cLKernel, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        int n2;
        long l2 = CLCapabilities.clEnqueueTask;
        BufferChecks.checkFunctionAddress(l2);
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        if ((n2 = CL10.nclEnqueueTask(cLCommandQueue.getPointer(), cLKernel.getPointer(), pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2)) == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer2);
        }
        return n2;
    }

    static native int nclEnqueueTask(long var0, long var2, int var4, long var5, long var7, long var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clEnqueueNativeKernel(CLCommandQueue cLCommandQueue, CLNativeKernel cLNativeKernel, CLMem[] cLMemArray, long[] lArray, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        long l2 = CLCapabilities.clEnqueueNativeKernel;
        BufferChecks.checkFunctionAddress(l2);
        if (cLMemArray != null) {
            BufferChecks.checkArray(cLMemArray, 1);
        }
        if (lArray != null) {
            BufferChecks.checkArray(lArray, cLMemArray.length);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkDirect(pointerBuffer);
        }
        if (pointerBuffer2 != null) {
            BufferChecks.checkBuffer(pointerBuffer2, 1);
        }
        long l3 = CallbackUtil.createGlobalRef(cLNativeKernel);
        ByteBuffer byteBuffer = APIUtil.getNativeKernelArgs(l3, cLMemArray, lArray);
        int n2 = 0;
        try {
            n2 = CL10.nclEnqueueNativeKernel(cLCommandQueue.getPointer(), cLNativeKernel.getPointer(), MemoryUtil.getAddress0(byteBuffer), byteBuffer.remaining(), cLMemArray == null ? 0 : cLMemArray.length, cLMemArray, pointerBuffer == null ? 0 : pointerBuffer.remaining(), MemoryUtil.getAddressSafe(pointerBuffer), MemoryUtil.getAddressSafe(pointerBuffer2), l2);
            if (n2 == 0) {
                cLCommandQueue.registerCLEvent(pointerBuffer2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            CallbackUtil.checkCallback(n2, l3);
        }
    }

    static native int nclEnqueueNativeKernel(long var0, long var2, long var4, long var6, int var8, CLMem[] var9, int var10, long var11, long var13, long var15);

    public static int clWaitForEvents(PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clWaitForEvents;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        int n2 = CL10.nclWaitForEvents(pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), l2);
        return n2;
    }

    static native int nclWaitForEvents(int var0, long var1, long var3);

    public static int clWaitForEvents(CLEvent cLEvent) {
        long l2 = CLCapabilities.clWaitForEvents;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclWaitForEvents(1, APIUtil.getPointer(cLEvent), l2);
        return n2;
    }

    public static int clGetEventInfo(CLEvent cLEvent, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetEventInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetEventInfo(cLEvent.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetEventInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clRetainEvent(CLEvent cLEvent) {
        long l2 = CLCapabilities.clRetainEvent;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclRetainEvent(cLEvent.getPointer(), l2);
        if (n2 == 0) {
            cLEvent.retain();
        }
        return n2;
    }

    static native int nclRetainEvent(long var0, long var2);

    public static int clReleaseEvent(CLEvent cLEvent) {
        long l2 = CLCapabilities.clReleaseEvent;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclReleaseEvent(cLEvent.getPointer(), l2);
        if (n2 == 0) {
            cLEvent.release();
        }
        return n2;
    }

    static native int nclReleaseEvent(long var0, long var2);

    public static int clEnqueueMarker(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clEnqueueMarker;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        int n2 = CL10.nclEnqueueMarker(cLCommandQueue.getPointer(), MemoryUtil.getAddress(pointerBuffer), l2);
        if (n2 == 0) {
            cLCommandQueue.registerCLEvent(pointerBuffer);
        }
        return n2;
    }

    static native int nclEnqueueMarker(long var0, long var2, long var4);

    public static int clEnqueueBarrier(CLCommandQueue cLCommandQueue) {
        long l2 = CLCapabilities.clEnqueueBarrier;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclEnqueueBarrier(cLCommandQueue.getPointer(), l2);
        return n2;
    }

    static native int nclEnqueueBarrier(long var0, long var2);

    public static int clEnqueueWaitForEvents(CLCommandQueue cLCommandQueue, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clEnqueueWaitForEvents;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkBuffer(pointerBuffer, 1);
        int n2 = CL10.nclEnqueueWaitForEvents(cLCommandQueue.getPointer(), pointerBuffer.remaining(), MemoryUtil.getAddress(pointerBuffer), l2);
        return n2;
    }

    static native int nclEnqueueWaitForEvents(long var0, int var2, long var3, long var5);

    public static int clEnqueueWaitForEvents(CLCommandQueue cLCommandQueue, CLEvent cLEvent) {
        long l2 = CLCapabilities.clEnqueueWaitForEvents;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclEnqueueWaitForEvents(cLCommandQueue.getPointer(), 1, APIUtil.getPointer(cLEvent), l2);
        return n2;
    }

    public static int clGetEventProfilingInfo(CLEvent cLEvent, int n2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        long l2 = CLCapabilities.clGetEventProfilingInfo;
        BufferChecks.checkFunctionAddress(l2);
        if (byteBuffer != null) {
            BufferChecks.checkDirect(byteBuffer);
        }
        if (pointerBuffer != null) {
            BufferChecks.checkBuffer(pointerBuffer, 1);
        }
        int n3 = CL10.nclGetEventProfilingInfo(cLEvent.getPointer(), n2, byteBuffer == null ? 0 : byteBuffer.remaining(), MemoryUtil.getAddressSafe(byteBuffer), MemoryUtil.getAddressSafe(pointerBuffer), l2);
        return n3;
    }

    static native int nclGetEventProfilingInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int clFlush(CLCommandQueue cLCommandQueue) {
        long l2 = CLCapabilities.clFlush;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclFlush(cLCommandQueue.getPointer(), l2);
        return n2;
    }

    static native int nclFlush(long var0, long var2);

    public static int clFinish(CLCommandQueue cLCommandQueue) {
        long l2 = CLCapabilities.clFinish;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = CL10.nclFinish(cLCommandQueue.getPointer(), l2);
        return n2;
    }

    static native int nclFinish(long var0, long var2);

    static CLFunctionAddress clGetExtensionFunctionAddress(ByteBuffer byteBuffer) {
        long l2 = CLCapabilities.clGetExtensionFunctionAddress;
        BufferChecks.checkFunctionAddress(l2);
        BufferChecks.checkDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        CLFunctionAddress cLFunctionAddress = new CLFunctionAddress(CL10.nclGetExtensionFunctionAddress(MemoryUtil.getAddress(byteBuffer), l2));
        return cLFunctionAddress;
    }

    static native long nclGetExtensionFunctionAddress(long var0, long var2);

    static CLFunctionAddress clGetExtensionFunctionAddress(CharSequence charSequence) {
        long l2 = CLCapabilities.clGetExtensionFunctionAddress;
        BufferChecks.checkFunctionAddress(l2);
        CLFunctionAddress cLFunctionAddress = new CLFunctionAddress(CL10.nclGetExtensionFunctionAddress(APIUtil.getBufferNT(charSequence), l2));
        return cLFunctionAddress;
    }
}

