/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.Sys;
import org.lwjgl.opencl.CLCapabilities;

public final class CL {
    private static boolean created;

    private CL() {
    }

    private static native void nCreate(String var0);

    private static native void nCreateDefault();

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create() {
        String[] stringArray;
        String string;
        if (created) {
            return;
        }
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                string = "OpenCL";
                stringArray = new String[]{"OpenCL.dll"};
                break;
            }
            case 1: {
                string = "OpenCL";
                stringArray = new String[]{"libOpenCL64.so", "libOpenCL.so"};
                break;
            }
            case 2: {
                string = "OpenCL";
                stringArray = new String[]{"OpenCL.dylib"};
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] stringArray2 = LWJGLUtil.getLibraryPaths(string, stringArray, CL.class.getClassLoader());
        LWJGLUtil.log("Found " + stringArray2.length + " OpenCL paths");
        for (String string2 : stringArray2) {
            try {
                CL.nCreate(string2);
                created = true;
                break;
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to load " + string2 + ": " + lWJGLException.getMessage());
            }
        }
        if (!created && LWJGLUtil.getPlatform() == 2) {
            CL.nCreateDefault();
            created = true;
        }
        if (!created) {
            throw new LWJGLException("Could not locate OpenCL library.");
        }
        if (!CLCapabilities.OpenCL10) {
            throw new RuntimeException("OpenCL 1.0 not supported.");
        }
    }

    public static void destroy() {
    }

    static long getFunctionAddress(String[] stringArray) {
        for (String string : stringArray) {
            long l2 = CL.getFunctionAddress(string);
            if (l2 == 0L) continue;
            return l2;
        }
        return 0L;
    }

    static long getFunctionAddress(String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeASCII(string);
        return CL.ngetFunctionAddress(MemoryUtil.getAddress(byteBuffer));
    }

    private static native long ngetFunctionAddress(long var0);

    static native ByteBuffer getHostBuffer(long var0, int var2);

    private static native void resetNativeStubs(Class var0);

    static {
        Sys.initialize();
    }
}

