/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapper;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObjectChild;
import org.lwjgl.opencl.CLObjectRegistry;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.EXTDeviceFission;
import org.lwjgl.opencl.FastLongMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private static final ThreadLocal<char[]> arrayTL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };
    private static final ThreadLocal<ByteBuffer> bufferByteTL = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return BufferUtils.createByteBuffer(256);
        }
    };
    private static final ThreadLocal<PointerBuffer> bufferPointerTL = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return BufferUtils.createPointerBuffer(256);
        }
    };
    private static final ThreadLocal<PointerBuffer> lengthsTL = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return BufferUtils.createPointerBuffer(4);
        }
    };
    private static final ThreadLocal<Buffers> buffersTL = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };
    private static final ObjectDestructor<CLDevice> DESTRUCTOR_CLSubDevice = new ObjectDestructor<CLDevice>(){

        @Override
        public void release(CLDevice cLDevice) {
            EXTDeviceFission.clReleaseDeviceEXT(cLDevice);
        }
    };
    private static final ObjectDestructor<CLMem> DESTRUCTOR_CLMem = new ObjectDestructor<CLMem>(){

        @Override
        public void release(CLMem cLMem) {
            CL10.clReleaseMemObject(cLMem);
        }
    };
    private static final ObjectDestructor<CLCommandQueue> DESTRUCTOR_CLCommandQueue = new ObjectDestructor<CLCommandQueue>(){

        @Override
        public void release(CLCommandQueue cLCommandQueue) {
            CL10.clReleaseCommandQueue(cLCommandQueue);
        }
    };
    private static final ObjectDestructor<CLSampler> DESTRUCTOR_CLSampler = new ObjectDestructor<CLSampler>(){

        @Override
        public void release(CLSampler cLSampler) {
            CL10.clReleaseSampler(cLSampler);
        }
    };
    private static final ObjectDestructor<CLProgram> DESTRUCTOR_CLProgram = new ObjectDestructor<CLProgram>(){

        @Override
        public void release(CLProgram cLProgram) {
            CL10.clReleaseProgram(cLProgram);
        }
    };
    private static final ObjectDestructor<CLKernel> DESTRUCTOR_CLKernel = new ObjectDestructor<CLKernel>(){

        @Override
        public void release(CLKernel cLKernel) {
            CL10.clReleaseKernel(cLKernel);
        }
    };
    private static final ObjectDestructor<CLEvent> DESTRUCTOR_CLEvent = new ObjectDestructor<CLEvent>(){

        @Override
        public void release(CLEvent cLEvent) {
            CL10.clReleaseEvent(cLEvent);
        }
    };

    private APIUtil() {
    }

    private static char[] getArray(int n2) {
        char[] cArray = arrayTL.get();
        if (cArray.length < n2) {
            for (int i2 = cArray.length << 1; i2 < n2; i2 <<= 1) {
            }
            cArray = new char[n2];
            arrayTL.set(cArray);
        }
        return cArray;
    }

    static ByteBuffer getBufferByte(int n2) {
        ByteBuffer byteBuffer = bufferByteTL.get();
        if (byteBuffer.capacity() < n2) {
            for (int i2 = byteBuffer.capacity() << 1; i2 < n2; i2 <<= 1) {
            }
            byteBuffer = BufferUtils.createByteBuffer(n2);
            bufferByteTL.set(byteBuffer);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private static ByteBuffer getBufferByteOffset(int n2) {
        ByteBuffer byteBuffer = bufferByteTL.get();
        if (byteBuffer.capacity() < n2) {
            for (int i2 = byteBuffer.capacity() << 1; i2 < n2; i2 <<= 1) {
            }
            ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(n2);
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
            bufferByteTL.set(byteBuffer);
        } else {
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(byteBuffer.capacity());
        }
        return byteBuffer;
    }

    static PointerBuffer getBufferPointer(int n2) {
        PointerBuffer pointerBuffer = bufferPointerTL.get();
        if (pointerBuffer.capacity() < n2) {
            for (int i2 = pointerBuffer.capacity() << 1; i2 < n2; i2 <<= 1) {
            }
            pointerBuffer = BufferUtils.createPointerBuffer(n2);
            bufferPointerTL.set(pointerBuffer);
        } else {
            pointerBuffer.clear();
        }
        return pointerBuffer;
    }

    static ShortBuffer getBufferShort() {
        return APIUtil.buffersTL.get().shorts;
    }

    static IntBuffer getBufferInt() {
        return APIUtil.buffersTL.get().ints;
    }

    static IntBuffer getBufferIntDebug() {
        return APIUtil.buffersTL.get().intsDebug;
    }

    static LongBuffer getBufferLong() {
        return APIUtil.buffersTL.get().longs;
    }

    static FloatBuffer getBufferFloat() {
        return APIUtil.buffersTL.get().floats;
    }

    static DoubleBuffer getBufferDouble() {
        return APIUtil.buffersTL.get().doubles;
    }

    static PointerBuffer getBufferPointer() {
        return APIUtil.buffersTL.get().pointers;
    }

    static PointerBuffer getLengths() {
        return APIUtil.getLengths(1);
    }

    static PointerBuffer getLengths(int n2) {
        PointerBuffer pointerBuffer = lengthsTL.get();
        if (pointerBuffer.capacity() < n2) {
            for (int i2 = pointerBuffer.capacity(); i2 < n2; i2 <<= 1) {
            }
            pointerBuffer = BufferUtils.createPointerBuffer(n2);
            lengthsTL.set(pointerBuffer);
        } else {
            pointerBuffer.clear();
        }
        return pointerBuffer;
    }

    private static ByteBuffer encode(ByteBuffer byteBuffer, CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (LWJGLUtil.DEBUG && '\u0080' <= c2) {
                byteBuffer.put((byte)26);
                continue;
            }
            byteBuffer.put((byte)c2);
        }
        return byteBuffer;
    }

    static String getString(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        char[] cArray = APIUtil.getArray(n2);
        for (int i2 = byteBuffer.position(); i2 < byteBuffer.limit(); ++i2) {
            cArray[i2 - byteBuffer.position()] = (char)byteBuffer.get(i2);
        }
        return new String(cArray, 0, n2);
    }

    static long getBuffer(CharSequence charSequence) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(charSequence.length()), charSequence);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBuffer(CharSequence charSequence, int n2) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByteOffset(n2 + charSequence.length()), charSequence);
        byteBuffer.flip();
        return MemoryUtil.getAddress(byteBuffer);
    }

    static long getBufferNT(CharSequence charSequence) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(charSequence.length() + 1), charSequence);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static int getTotalLength(CharSequence[] charSequenceArray) {
        int n2 = 0;
        for (CharSequence charSequence : charSequenceArray) {
            n2 += charSequence.length();
        }
        return n2;
    }

    static long getBuffer(CharSequence[] charSequenceArray) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(APIUtil.getTotalLength(charSequenceArray));
        for (CharSequence charSequence : charSequenceArray) {
            APIUtil.encode(byteBuffer, charSequence);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBufferNT(CharSequence[] charSequenceArray) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(APIUtil.getTotalLength(charSequenceArray) + charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            APIUtil.encode(byteBuffer, charSequence);
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getLengths(CharSequence[] charSequenceArray) {
        PointerBuffer pointerBuffer = APIUtil.getLengths(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            pointerBuffer.put(charSequence.length());
        }
        pointerBuffer.flip();
        return MemoryUtil.getAddress0(pointerBuffer);
    }

    static long getLengths(ByteBuffer[] byteBufferArray) {
        PointerBuffer pointerBuffer = APIUtil.getLengths(byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            pointerBuffer.put(byteBuffer.remaining());
        }
        pointerBuffer.flip();
        return MemoryUtil.getAddress0(pointerBuffer);
    }

    static int getSize(PointerBuffer pointerBuffer) {
        long l2 = 0L;
        for (int i2 = pointerBuffer.position(); i2 < pointerBuffer.limit(); ++i2) {
            l2 += pointerBuffer.get(i2);
        }
        return (int)l2;
    }

    static long getPointer(PointerWrapper pointerWrapper) {
        return MemoryUtil.getAddress0(APIUtil.getBufferPointer().put(0, pointerWrapper));
    }

    static long getPointerSafe(PointerWrapper pointerWrapper) {
        return MemoryUtil.getAddress0(APIUtil.getBufferPointer().put(0, pointerWrapper == null ? 0L : pointerWrapper.getPointer()));
    }

    static Set<String> getExtensions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    static boolean isDevicesParam(int n2) {
        switch (n2) {
            case 4225: 
            case 8198: 
            case 8199: 
            case 0x10000002: 
            case 0x10000003: {
                return true;
            }
        }
        return false;
    }

    static CLPlatform getCLPlatform(PointerBuffer pointerBuffer) {
        long l2;
        long l3 = 0L;
        int n2 = pointerBuffer.remaining() / 2;
        for (int i2 = 0; i2 < n2 && (l2 = pointerBuffer.get(i2 << 1)) != 0L; ++i2) {
            if (l2 != 4228L) continue;
            l3 = pointerBuffer.get((i2 << 1) + 1);
            break;
        }
        if (l3 == 0L) {
            throw new IllegalArgumentException("Could not find CL_CONTEXT_PLATFORM in cl_context_properties.");
        }
        CLPlatform cLPlatform = CLPlatform.getCLPlatform(l3);
        if (cLPlatform == null) {
            throw new IllegalStateException("Could not find a valid CLPlatform. Make sure clGetPlatformIDs has been used before.");
        }
        return cLPlatform;
    }

    static ByteBuffer getNativeKernelArgs(long l2, CLMem[] cLMemArray, long[] lArray) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(12 + (cLMemArray == null ? 0 : cLMemArray.length * (4 + PointerBuffer.getPointerSize())));
        byteBuffer.putLong(0, l2);
        if (cLMemArray == null) {
            byteBuffer.putInt(8, 0);
        } else {
            byteBuffer.putInt(8, cLMemArray.length);
            int n2 = 12;
            for (int i2 = 0; i2 < cLMemArray.length; ++i2) {
                if (LWJGLUtil.DEBUG && !cLMemArray[i2].isValid()) {
                    throw new IllegalArgumentException("An invalid CLMem object was specified.");
                }
                byteBuffer.putInt(n2, (int)lArray[i2]);
                n2 += 4 + PointerBuffer.getPointerSize();
            }
        }
        return byteBuffer;
    }

    static void releaseObjects(CLDevice cLDevice) {
        if (!cLDevice.isValid() || cLDevice.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(cLDevice.getSubCLDeviceRegistry(), DESTRUCTOR_CLSubDevice);
    }

    static void releaseObjects(CLContext cLContext) {
        if (!cLContext.isValid() || cLContext.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(cLContext.getCLEventRegistry(), DESTRUCTOR_CLEvent);
        APIUtil.releaseObjects(cLContext.getCLProgramRegistry(), DESTRUCTOR_CLProgram);
        APIUtil.releaseObjects(cLContext.getCLSamplerRegistry(), DESTRUCTOR_CLSampler);
        APIUtil.releaseObjects(cLContext.getCLMemRegistry(), DESTRUCTOR_CLMem);
        APIUtil.releaseObjects(cLContext.getCLCommandQueueRegistry(), DESTRUCTOR_CLCommandQueue);
    }

    static void releaseObjects(CLProgram cLProgram) {
        if (!cLProgram.isValid() || cLProgram.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(cLProgram.getCLKernelRegistry(), DESTRUCTOR_CLKernel);
    }

    static void releaseObjects(CLCommandQueue cLCommandQueue) {
        if (!cLCommandQueue.isValid() || cLCommandQueue.getReferenceCount() > 1) {
            return;
        }
        APIUtil.releaseObjects(cLCommandQueue.getCLEventRegistry(), DESTRUCTOR_CLEvent);
    }

    private static <T extends CLObjectChild> void releaseObjects(CLObjectRegistry<T> cLObjectRegistry, ObjectDestructor<T> objectDestructor) {
        if (cLObjectRegistry.isEmpty()) {
            return;
        }
        for (FastLongMap.Entry<T> entry : cLObjectRegistry.getAll()) {
            CLObjectChild cLObjectChild = (CLObjectChild)entry.value;
            while (cLObjectChild.isValid()) {
                objectDestructor.release(cLObjectChild);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ObjectDestructor<T extends CLObjectChild> {
        public void release(T var1);
    }

    static class Buffers {
        final ShortBuffer shorts = BufferUtils.createShortBuffer(32);
        final IntBuffer ints = BufferUtils.createIntBuffer(32);
        final IntBuffer intsDebug = BufferUtils.createIntBuffer(1);
        final LongBuffer longs = BufferUtils.createLongBuffer(32);
        final FloatBuffer floats = BufferUtils.createFloatBuffer(32);
        final DoubleBuffer doubles = BufferUtils.createDoubleBuffer(32);
        final PointerBuffer pointers = BufferUtils.createPointerBuffer(32);

        Buffers() {
        }
    }
}

